/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.commonapi;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.commonapi.CommonAPITransportLayer;
import org.mpisws.p2p.transport.commonapi.IdFactory;
import org.mpisws.p2p.transport.commonapi.RawMessageDeserializer;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import org.mpisws.p2p.transport.priority.QueueOverflowException;
import org.mpisws.p2p.transport.util.DefaultCallback;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonAPITransportLayerImpl<Identifier>
implements CommonAPITransportLayer<Identifier>,
TransportLayerCallback<Identifier, ByteBuffer> {
    TransportLayer<Identifier, ByteBuffer> tl;
    TransportLayerCallback<Identifier, RawMessage> callback;
    ErrorHandler<Identifier> errorHandler;
    RawMessageDeserializer deserializer;
    IdFactory idFactory;
    Logger logger;

    public CommonAPITransportLayerImpl(TransportLayer<Identifier, ByteBuffer> tl, IdFactory idFactory, RawMessageDeserializer deserializer, ErrorHandler errorHandler, Environment env) {
        this.logger = env.getLogManager().getLogger(CommonAPITransportLayerImpl.class, null);
        this.tl = tl;
        this.deserializer = deserializer;
        if (tl == null) {
            throw new IllegalArgumentException("tl must be non-null");
        }
        if (idFactory == null) {
            throw new IllegalArgumentException("idFactroy must be non-null");
        }
        if (deserializer == null) {
            throw new IllegalArgumentException("deserializer must be non-null");
        }
        this.idFactory = idFactory;
        this.errorHandler = errorHandler;
        if (this.callback == null) {
            this.callback = new DefaultCallback<Identifier, RawMessage>(env);
        }
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler(this.logger);
        }
        tl.setCallback(this);
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    @Override
    public MessageRequestHandle<Identifier, RawMessage> sendMessage(final Identifier i, final RawMessage m, final MessageCallback<Identifier, RawMessage> deliverAckToMe, Map<String, Integer> options) {
        if (this.logger.level <= 500) {
            this.logger.log("sendMessage(" + i + "," + m + ")");
        }
        final MessageRequestHandleImpl<Identifier, RawMessage> handle = new MessageRequestHandleImpl<Identifier, RawMessage>(i, m, options);
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        try {
            this.deserializer.serialize(m, sob);
        }
        catch (IOException ioe2) {
            NodeIsFaultyException ioe2;
            if (ioe2 instanceof NodeIsFaultyException) {
                ioe2 = new NodeIsFaultyException(i, m, ioe2);
            }
            if (deliverAckToMe == null) {
                this.errorHandler.receivedException(i, ioe2);
            }
            deliverAckToMe.sendFailed(handle, ioe2);
        }
        ByteBuffer buf = ByteBuffer.wrap(sob.getBytes());
        handle.setSubCancellable(this.tl.sendMessage(i, buf, new MessageCallback<Identifier, ByteBuffer>(){

            @Override
            public void ack(MessageRequestHandle<Identifier, ByteBuffer> msg) {
                if (handle.getSubCancellable() != null && msg != handle.getSubCancellable()) {
                    throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + handle.getSubCancellable());
                }
                if (deliverAckToMe != null) {
                    deliverAckToMe.ack(handle);
                }
            }

            @Override
            public void sendFailed(MessageRequestHandle<Identifier, ByteBuffer> msg, IOException ex) {
                if (ex instanceof NodeIsFaultyException) {
                    ex = new NodeIsFaultyException(i, m, ex);
                }
                if (ex instanceof QueueOverflowException) {
                    ex = new QueueOverflowException(i, m, ex);
                }
                if (CommonAPITransportLayerImpl.this.logger.level <= 700) {
                    CommonAPITransportLayerImpl.this.logger.logException("sendFailed(" + i + "," + m + ")", ex);
                }
                if (handle.getSubCancellable() != null && msg != handle.getSubCancellable()) {
                    throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + handle.getSubCancellable());
                }
                if (deliverAckToMe == null) {
                    CommonAPITransportLayerImpl.this.errorHandler.receivedException(i, ex);
                } else {
                    deliverAckToMe.sendFailed(handle, ex);
                }
            }
        }, options));
        return handle;
    }

    @Override
    public void messageReceived(Identifier i, ByteBuffer m, Map<String, Integer> options) throws IOException {
        SimpleInputBuffer buf = new SimpleInputBuffer(m.array(), m.position());
        this.callback.messageReceived(i, this.deserializer.deserialize(buf), options);
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, RawMessage> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.errorHandler = handler;
    }

    @Override
    public void destroy() {
        this.tl.destroy();
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(Identifier i, SocketCallback<Identifier> deliverSocketToMe, Map<String, Integer> options) {
        if (deliverSocketToMe == null) {
            throw new IllegalArgumentException("deliverSocketToMe must be non-null!");
        }
        if (this.logger.level <= 500) {
            this.logger.log("openSocket(" + i + ")");
        }
        return this.tl.openSocket(i, deliverSocketToMe, options);
    }

    @Override
    public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("incomingSocket(" + s + ")");
        }
        this.callback.incomingSocket(s);
    }
}

