/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import rice.environment.Environment;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TLTest<Identifier> {
    static Environment env;
    static Logger logger;
    static Map<String, Integer> options;
    static TransportLayer alice;
    static TransportLayer bob;
    static final byte[] sentBytes;
    static final int START_PORT = 5009;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        env = new Environment();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        env.destroy();
    }

    public Identifier getIdentifier(TransportLayer<Identifier, ByteBuffer> a, TransportLayer<Identifier, ByteBuffer> b) {
        return b.getLocalIdentifier();
    }

    public abstract Identifier getBogusIdentifier(Identifier var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void openTCP() throws Exception {
        final ArrayList aliceSockets = new ArrayList();
        final ArrayList bobSockets = new ArrayList();
        final ArrayList exceptionList = new ArrayList(1);
        final ArrayList receivedList = new ArrayList(1);
        final ArrayList sentList = new ArrayList(1);
        final Object lock = new Object();
        bob.setCallback(new TransportLayerCallback<Identifier, ByteBuffer>(){

            @Override
            public void messageReceived(Identifier i, ByteBuffer m, Map<String, Integer> options) throws IOException {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
                Object object = lock;
                synchronized (object) {
                    bobSockets.add(s);
                    lock.notify();
                }
            }
        });
        alice.openSocket(this.getIdentifier(alice, bob), new SocketCallback<Identifier>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveResult(SocketRequestHandle<Identifier> s, P2PSocket<Identifier> result) {
                Object object = lock;
                synchronized (object) {
                    aliceSockets.add(result);
                    lock.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, IOException exception) {
                Object object = lock;
                synchronized (object) {
                    exceptionList.add(exception);
                    lock.notify();
                }
            }
        }, options);
        long timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object = lock;
        synchronized (object) {
            while (env.getTimeSource().currentTimeMillis() < timeout && exceptionList.isEmpty() && (aliceSockets.isEmpty() || bobSockets.isEmpty())) {
                lock.wait(1000L);
            }
        }
        Assert.assertTrue((aliceSockets.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((bobSockets.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)exceptionList.isEmpty());
        byte[] sentBytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
        final ByteBuffer sentBuffer = ByteBuffer.wrap(sentBytes);
        final ByteBuffer in = ByteBuffer.allocate(sentBytes.length);
        ((P2PSocket)bobSockets.get(0)).register(true, false, new P2PSocketReceiver<Identifier>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                socket.read(in);
                if (in.hasRemaining()) {
                    socket.register(true, false, this);
                } else {
                    Object object = lock;
                    synchronized (object) {
                        receivedList.add(in);
                        lock.notify();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveException(P2PSocket<Identifier> socket, IOException e) {
                Object object = lock;
                synchronized (object) {
                    exceptionList.add(e);
                    lock.notify();
                }
            }
        });
        ((P2PSocket)aliceSockets.get(0)).register(false, true, new P2PSocketReceiver<Identifier>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                socket.write(sentBuffer);
                if (sentBuffer.hasRemaining()) {
                    socket.register(false, true, this);
                } else {
                    Object object = lock;
                    synchronized (object) {
                        sentList.add(sentBuffer);
                        lock.notify();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveException(P2PSocket socket, IOException e) {
                Object object = lock;
                synchronized (object) {
                    exceptionList.add(e);
                    lock.notify();
                }
            }
        });
        timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object2 = lock;
        synchronized (object2) {
            while (env.getTimeSource().currentTimeMillis() < timeout && exceptionList.isEmpty() && (receivedList.isEmpty() || sentList.isEmpty())) {
                lock.wait(1000L);
            }
        }
        Assert.assertTrue((sentList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((receivedList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("recList.arr:" + ((ByteBuffer)receivedList.get(0)).array()[0] + "," + ((ByteBuffer)receivedList.get(0)).array()[1]), (boolean)Arrays.equals(((ByteBuffer)sentList.get(0)).array(), ((ByteBuffer)receivedList.get(0)).array()));
        Assert.assertTrue((boolean)exceptionList.isEmpty());
        final ArrayList closed = new ArrayList();
        ((P2PSocket)aliceSockets.get(0)).shutdownOutput();
        ((P2PSocket)bobSockets.get(0)).register(true, false, new P2PSocketReceiver<Identifier>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                ByteBuffer bogus = ByteBuffer.allocate(1);
                if (socket.read(bogus) == -1L) {
                    socket.close();
                    Object object = lock;
                    synchronized (object) {
                        closed.add(socket);
                        lock.notify();
                    }
                }
                Object object = lock;
                synchronized (object) {
                    receivedList.add(bogus);
                    lock.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveException(P2PSocket<Identifier> socket, IOException e) {
                Object object = lock;
                synchronized (object) {
                    exceptionList.add(e);
                    lock.notify();
                }
            }
        });
        ((P2PSocket)aliceSockets.get(0)).register(true, false, new P2PSocketReceiver<Identifier>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                ByteBuffer bogus = ByteBuffer.allocate(1);
                if (socket.read(bogus) == -1L) {
                    socket.close();
                    Object object = lock;
                    synchronized (object) {
                        closed.add(socket);
                        lock.notify();
                    }
                }
                Object object = lock;
                synchronized (object) {
                    receivedList.add(bogus);
                    lock.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveException(P2PSocket<Identifier> socket, IOException e) {
                Object object = lock;
                synchronized (object) {
                    exceptionList.add(e);
                    lock.notify();
                }
            }
        });
        timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object3 = lock;
        synchronized (object3) {
            while (env.getTimeSource().currentTimeMillis() < timeout && exceptionList.isEmpty() && receivedList.size() == 1 && closed.size() < 2) {
                lock.wait(1000L);
            }
        }
        bob.setCallback(null);
        Assert.assertTrue((boolean)exceptionList.isEmpty());
        Assert.assertTrue((String)("receivedList.size():" + receivedList.size()), (receivedList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((closed.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)closed.contains(aliceSockets.get(0)));
        Assert.assertTrue((boolean)closed.contains(bobSockets.get(0)));
    }

    public void testSocketThreadSafety() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendUDP() throws Exception {
        ByteBuffer sentBuffer = ByteBuffer.wrap(sentBytes);
        final ArrayList receivedList = new ArrayList(1);
        final ArrayList exceptionList = new ArrayList(1);
        final ArrayList sentList = new ArrayList(1);
        final Object lock = new Object();
        bob.setCallback(new TransportLayerCallback<Identifier, ByteBuffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageReceived(Identifier i, ByteBuffer buf, Map<String, Integer> options) throws IOException {
                Object object = lock;
                synchronized (object) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class Tupel<Identifier> {
                        Identifier i;
                        ByteBuffer buf;

                        public Tupel(Identifier i, ByteBuffer buf) {
                            this.i = i;
                            this.buf = buf;
                        }
                    }
                    receivedList.add(new Tupel(i, buf));
                    lock.notify();
                }
            }

            @Override
            public void incomingSocket(P2PSocket s) {
            }
        });
        MessageRequestHandle<Identifier, ByteBuffer> handle = alice.sendMessage(this.getIdentifier(alice, bob), sentBuffer, new MessageCallback<Identifier, ByteBuffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ack(MessageRequestHandle msg) {
                Object object = lock;
                synchronized (object) {
                    sentList.add(msg);
                    lock.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendFailed(MessageRequestHandle msg, IOException ex) {
                Object object = lock;
                synchronized (object) {
                    ex.printStackTrace();
                    exceptionList.add(ex);
                    lock.notify();
                }
            }
        }, options);
        long timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object = lock;
        synchronized (object) {
            while (env.getTimeSource().currentTimeMillis() < timeout && exceptionList.isEmpty() && (receivedList.isEmpty() || sentList.isEmpty())) {
                lock.wait(1000L);
            }
        }
        if (!exceptionList.isEmpty()) {
            throw (Exception)exceptionList.get(0);
        }
        Assert.assertTrue((String)("receivedList.size():" + receivedList.size()), (receivedList.size() == 1 ? 1 : 0) != 0);
        byte[] rec = new byte[((Tupel)receivedList.get((int)0)).buf.remaining()];
        ((Tupel)receivedList.get((int)0)).buf.get(rec);
        Assert.assertTrue((boolean)Arrays.equals(rec, sentBuffer.array()));
        Assert.assertTrue((String)("i:" + ((Tupel)receivedList.get((int)0)).i + " getI():" + this.getIdentifier(bob, alice)), (boolean)((Tupel)receivedList.get((int)0)).i.equals(this.getIdentifier(bob, alice)));
        Assert.assertTrue((String)("sentList.size():" + sentList.size()), (sentList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((sentList.get(0) == handle ? 1 : 0) != 0);
        Assert.assertTrue((String)("handle.getMessage():" + handle.getMessage() + " sentBuffer:" + sentBuffer), (handle.getMessage() == sentBuffer ? 1 : 0) != 0);
        bob.setCallback(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void messageTooBigUDP() throws Exception {
        byte[] sentBytes = new byte[1000000];
        ByteBuffer sentBuffer = ByteBuffer.wrap(sentBytes);
        final ArrayList failedList = new ArrayList(1);
        final ArrayList sentList = new ArrayList(1);
        final ArrayList exceptionList = new ArrayList(1);
        final Object lock = new Object();
        MessageRequestHandle<Identifier, ByteBuffer> cancellable = alice.sendMessage(this.getIdentifier(alice, bob), sentBuffer, new MessageCallback<Identifier, ByteBuffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ack(MessageRequestHandle msg) {
                Object object = lock;
                synchronized (object) {
                    sentList.add(msg);
                    lock.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendFailed(MessageRequestHandle msg, IOException exception) {
                Object object = lock;
                synchronized (object) {
                    failedList.add(msg);
                    exceptionList.add(exception);
                    lock.notify();
                }
            }
        }, options);
        long timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object = lock;
        synchronized (object) {
            while (env.getTimeSource().currentTimeMillis() < timeout && exceptionList.isEmpty() && sentList.isEmpty()) {
                lock.wait(1000L);
            }
        }
        Assert.assertTrue((boolean)sentList.isEmpty());
        Assert.assertTrue((String)("exceptionList.size():" + exceptionList.size()), (exceptionList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((failedList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((failedList.get(0) == cancellable ? 1 : 0) != 0);
        Assert.assertTrue((cancellable.getMessage() == sentBuffer ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void noCallbackTest() throws Exception {
        ByteBuffer sentBuffer = ByteBuffer.wrap(sentBytes);
        final ArrayList receivedList = new ArrayList(1);
        ArrayList exceptionList = new ArrayList(1);
        final Object lock = new Object();
        bob.setCallback(new TransportLayerCallback<Identifier, ByteBuffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageReceived(Identifier i, ByteBuffer buf, Map<String, Integer> options) throws IOException {
                Object object = lock;
                synchronized (object) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class Tupel<Identifier> {
                        Identifier i;
                        ByteBuffer buf;

                        public Tupel(Identifier i, ByteBuffer buf) {
                            this.i = i;
                            this.buf = buf;
                        }
                    }
                    receivedList.add(new Tupel(i, buf));
                    lock.notify();
                }
            }

            @Override
            public void incomingSocket(P2PSocket s) {
            }
        });
        alice.sendMessage(this.getIdentifier(alice, bob), sentBuffer, null, null);
        long timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object = lock;
        synchronized (object) {
            while (env.getTimeSource().currentTimeMillis() < timeout && exceptionList.isEmpty() && receivedList.isEmpty()) {
                lock.wait(1000L);
            }
        }
        if (!exceptionList.isEmpty()) {
            throw (Exception)exceptionList.get(0);
        }
        Assert.assertTrue((String)("receivedList.size():" + receivedList.size()), (receivedList.size() == 1 ? 1 : 0) != 0);
        byte[] rec = new byte[((Tupel)receivedList.get((int)0)).buf.remaining()];
        ((Tupel)receivedList.get((int)0)).buf.get(rec);
        Assert.assertTrue((boolean)Arrays.equals(rec, sentBuffer.array()));
        Assert.assertTrue((boolean)((Tupel)receivedList.get((int)0)).i.equals(this.getIdentifier(bob, alice)));
        bob.setCallback(null);
        alice.openSocket(this.getIdentifier(alice, bob), null, options);
    }

    static {
        options = new HashMap<String, Integer>();
        sentBytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
    }
}

