/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.mpisws.p2p.testing.transportlayer.WireTest;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.wire.WireTransportLayerImpl;
import org.mpisws.p2p.transport.wire.exception.StalledSocketException;
import org.mpisws.p2p.transport.wire.magicnumber.MagicNumberTransportLayer;
import rice.environment.Environment;

public class MagicNumberTest
extends WireTest {
    static TransportLayer<InetSocketAddress, ByteBuffer> carol;
    static TransportLayer<InetSocketAddress, ByteBuffer> dave;
    public static final byte[] GOOD_HDR;
    public static final byte[] BAD_HDR;
    public static final byte[] NO_HDR;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int startPort = 5009;
        env = new Environment();
        logger = env.getLogManager().getLogger(MagicNumberTest.class, null);
        InetAddress addr = InetAddress.getLocalHost();
        alice = new MagicNumberTransportLayer<InetSocketAddress>(new WireTransportLayerImpl(new InetSocketAddress(addr, startPort), env, null), env, null, GOOD_HDR, 2000);
        bob = new MagicNumberTransportLayer<InetSocketAddress>(new WireTransportLayerImpl(new InetSocketAddress(addr, startPort + 1), env, null), env, null, GOOD_HDR, 2000);
        carol = new MagicNumberTransportLayer<InetSocketAddress>(new WireTransportLayerImpl(new InetSocketAddress(addr, startPort + 2), env, null), env, null, BAD_HDR, 2000);
        dave = new MagicNumberTransportLayer<InetSocketAddress>(new WireTransportLayerImpl(new InetSocketAddress(addr, startPort + 3), env, null), env, null, NO_HDR, 2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void wrongHeaderTCP() throws Exception {
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        options.put("transport_type", 1);
        final ArrayList aliceSockets = new ArrayList();
        final ArrayList carolSockets = new ArrayList();
        final ArrayList exceptionList = new ArrayList(1);
        final ArrayList unexpectedData = new ArrayList(1);
        final Object lock = new Object();
        carol.setCallback(new TransportLayerCallback<InetSocketAddress, ByteBuffer>(){

            @Override
            public void messageReceived(InetSocketAddress i, ByteBuffer m, Map<String, Integer> options) throws IOException {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void incomingSocket(P2PSocket s) throws IOException {
                Object object = lock;
                synchronized (object) {
                    carolSockets.add(s);
                    lock.notify();
                }
            }
        });
        carol.setErrorHandler(new ErrorHandler<InetSocketAddress>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receivedException(InetSocketAddress i, Throwable error) {
                Object object = lock;
                synchronized (object) {
                    error.printStackTrace();
                    exceptionList.add(error);
                    lock.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receivedUnexpectedData(InetSocketAddress i, byte[] bytes, int pos, Map<String, Integer> options) {
                Object object = lock;
                synchronized (object) {
                    unexpectedData.add(bytes);
                    lock.notify();
                }
            }
        });
        alice.openSocket(carol.getLocalIdentifier(), new SocketCallback<InetSocketAddress>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveResult(SocketRequestHandle<InetSocketAddress> cancellable, P2PSocket<InetSocketAddress> result) {
                Object object = lock;
                synchronized (object) {
                    aliceSockets.add(result);
                    lock.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveException(SocketRequestHandle<InetSocketAddress> s, IOException exception) {
                Object object = lock;
                synchronized (object) {
                    exceptionList.add(exception);
                    lock.notify();
                }
            }
        }, options);
        long timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object = lock;
        synchronized (object) {
            while (env.getTimeSource().currentTimeMillis() < timeout && exceptionList.isEmpty() && (aliceSockets.isEmpty() || unexpectedData.isEmpty())) {
                lock.wait(1000L);
            }
        }
        carol.setCallback(null);
        carol.setErrorHandler(null);
        Assert.assertTrue((aliceSockets.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((carolSockets.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((unexpectedData.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)exceptionList.isEmpty());
        Assert.assertTrue((unexpectedData.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((byte[])unexpectedData.get(0)).length >= GOOD_HDR.length ? 1 : 0) != 0);
        byte[] hdrpart = new byte[GOOD_HDR.length];
        System.arraycopy(unexpectedData.get(0), 0, hdrpart, 0, GOOD_HDR.length);
        Assert.assertTrue((boolean)Arrays.equals(hdrpart, GOOD_HDR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void stallTCP() throws Exception {
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        options.put("transport_type", 1);
        final ArrayList aliceSockets = new ArrayList();
        final ArrayList daveSockets = new ArrayList();
        final ArrayList exceptionList = new ArrayList(1);
        ArrayList receivedList = new ArrayList(1);
        ArrayList sentList = new ArrayList(1);
        final Object lock = new Object();
        alice.setCallback(new TransportLayerCallback<InetSocketAddress, ByteBuffer>(){

            @Override
            public void messageReceived(InetSocketAddress i, ByteBuffer m, Map<String, Integer> options) throws IOException {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void incomingSocket(P2PSocket s) throws IOException {
                Object object = lock;
                synchronized (object) {
                    aliceSockets.add(s);
                    lock.notify();
                }
            }
        });
        alice.setErrorHandler(new ErrorHandler<InetSocketAddress>(){

            @Override
            public void receivedUnexpectedData(InetSocketAddress i, byte[] bytes, int pos, Map<String, Integer> options) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receivedException(InetSocketAddress i, Throwable error) {
                Object object = lock;
                synchronized (object) {
                    exceptionList.add(error);
                    lock.notify();
                }
            }
        });
        dave.openSocket((InetSocketAddress)alice.getLocalIdentifier(), new SocketCallback<InetSocketAddress>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveResult(SocketRequestHandle<InetSocketAddress> cancellable, P2PSocket<InetSocketAddress> result) {
                Object object = lock;
                synchronized (object) {
                    daveSockets.add(result);
                    lock.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveException(SocketRequestHandle<InetSocketAddress> s, IOException exception) {
                Object object = lock;
                synchronized (object) {
                    exceptionList.add(exception);
                    lock.notify();
                }
            }
        }, options);
        long timeout = env.getTimeSource().currentTimeMillis() + 34000L;
        Object object = lock;
        synchronized (object) {
            while (env.getTimeSource().currentTimeMillis() < timeout && (daveSockets.isEmpty() || exceptionList.isEmpty())) {
                lock.wait(1000L);
            }
        }
        alice.setCallback(null);
        alice.setErrorHandler(null);
        Assert.assertTrue((aliceSockets.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((daveSockets.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((exceptionList.size() == 1 ? 1 : 0) != 0);
        Throwable e = (Throwable)exceptionList.get(0);
        Assert.assertTrue((boolean)(e instanceof StalledSocketException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void wrongHeaderUDP() throws Throwable {
        byte[] sentBytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
        ByteBuffer sentBuffer = ByteBuffer.wrap(sentBytes);
        final ArrayList receivedList = new ArrayList(1);
        final ArrayList exceptionList = new ArrayList(1);
        final ArrayList sentList = new ArrayList(1);
        final ArrayList unexpectedData = new ArrayList(1);
        final Object lock = new Object();
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        options.put("transport_type", 0);
        carol.setCallback(new TransportLayerCallback<InetSocketAddress, ByteBuffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageReceived(InetSocketAddress i, ByteBuffer buf, Map<String, Integer> options) throws IOException {
                Object object = lock;
                synchronized (object) {
                    receivedList.add(buf);
                    lock.notify();
                }
            }

            @Override
            public void incomingSocket(P2PSocket<InetSocketAddress> s) {
            }
        });
        carol.setErrorHandler(new ErrorHandler<InetSocketAddress>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receivedException(InetSocketAddress i, Throwable error) {
                Object object = lock;
                synchronized (object) {
                    error.printStackTrace();
                    exceptionList.add(error);
                    lock.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receivedUnexpectedData(InetSocketAddress i, byte[] bytes, int pos, Map<String, Integer> options) {
                Object object = lock;
                synchronized (object) {
                    unexpectedData.add(bytes);
                    lock.notify();
                }
            }
        });
        MessageCallback<InetSocketAddress, ByteBuffer> ret = new MessageCallback<InetSocketAddress, ByteBuffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ack(MessageRequestHandle<InetSocketAddress, ByteBuffer> msg) {
                Object object = lock;
                synchronized (object) {
                    sentList.add(msg);
                    lock.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendFailed(MessageRequestHandle<InetSocketAddress, ByteBuffer> msg, IOException reason) {
                Object object = lock;
                synchronized (object) {
                    exceptionList.add(reason);
                    lock.notify();
                }
            }
        };
        MessageRequestHandle<InetSocketAddress, ByteBuffer> handle = alice.sendMessage(carol.getLocalIdentifier(), sentBuffer, ret, options);
        long timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object = lock;
        synchronized (object) {
            while (env.getTimeSource().currentTimeMillis() < timeout && exceptionList.isEmpty() && receivedList.isEmpty() && (sentList.isEmpty() || unexpectedData.isEmpty())) {
                lock.wait(1000L);
            }
        }
        carol.setCallback(null);
        carol.setErrorHandler(null);
        if (!exceptionList.isEmpty()) {
            throw (Throwable)exceptionList.get(0);
        }
        Assert.assertTrue((boolean)receivedList.isEmpty());
        Assert.assertTrue((sentList.size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((sentList.get(0) == handle ? 1 : 0) != 0);
        Assert.assertTrue((handle.getMessage() == sentBuffer ? 1 : 0) != 0);
        Assert.assertTrue((unexpectedData.size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((((byte[])unexpectedData.get(0)).length >= GOOD_HDR.length ? 1 : 0) != 0);
        byte[] hdrpart = new byte[GOOD_HDR.length];
        System.arraycopy(unexpectedData.get(0), 0, hdrpart, 0, GOOD_HDR.length);
        Assert.assertTrue((boolean)Arrays.equals(hdrpart, GOOD_HDR));
    }

    public static void main(String[] args) throws Exception {
        JUnitCore.main((String[])new String[]{"org.mpisws.p2p.testing.transportlayer.MagicNumberTest"});
    }

    static {
        GOOD_HDR = new byte[]{-34, -83, -66, -17};
        BAD_HDR = new byte[]{-34, -19, -66, -17};
        NO_HDR = new byte[0];
    }
}

