/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mpisws.p2p.testing.transportlayer.MagicNumberTest;
import org.mpisws.p2p.testing.transportlayer.SRTest;
import org.mpisws.p2p.testing.transportlayer.TLTest;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.liveness.LivenessTransportLayerImpl;
import org.mpisws.p2p.transport.liveness.PingListener;
import org.mpisws.p2p.transport.liveness.Pinger;
import org.mpisws.p2p.transport.multiaddress.MultiInetAddressTransportLayerImpl;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.proximity.MinRTTProximityProvider;
import org.mpisws.p2p.transport.proximity.ProximityProvider;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import org.mpisws.p2p.transport.sourceroute.SourceRouteFactory;
import org.mpisws.p2p.transport.sourceroute.SourceRouteTransportLayerImpl;
import org.mpisws.p2p.transport.sourceroute.factory.MultiAddressSourceRouteFactory;
import org.mpisws.p2p.transport.wire.WireTransportLayerImpl;
import org.mpisws.p2p.transport.wire.magicnumber.MagicNumberTransportLayer;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;
import rice.environment.params.Parameters;
import rice.selector.Timer;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LivenessTest
extends SRTest {
    static TransportLayer dave;
    static ProximityProvider<SourceRoute> bob_prox;
    static SourceRouteFactory<MultiInetSocketAddress> srFactory;
    static Timer timer;

    @Override
    public SourceRoute<MultiInetSocketAddress> getIdentifier(TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> a, TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> b) {
        SourceRoute<MultiInetSocketAddress> src = a.getLocalIdentifier();
        SourceRoute intermediate = (SourceRoute)carol_tap.getLocalIdentifier();
        SourceRoute<MultiInetSocketAddress> dest = b.getLocalIdentifier();
        if (a.equals(carol) || b.equals(carol)) {
            ArrayList<MultiInetSocketAddress> retArr = new ArrayList<MultiInetSocketAddress>(2);
            retArr.add(src.getFirstHop());
            retArr.add(dest.getFirstHop());
            return srFactory.getSourceRoute((MultiInetSocketAddress)((Object)retArr));
        }
        ArrayList<MultiInetSocketAddress> retArr = new ArrayList<MultiInetSocketAddress>(3);
        retArr.add(src.getFirstHop());
        retArr.add((MultiInetSocketAddress)intermediate.getFirstHop());
        retArr.add(dest.getFirstHop());
        return srFactory.getSourceRoute((MultiInetSocketAddress)((Object)retArr));
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        srFactory = new MultiAddressSourceRouteFactory();
        TLTest.setUpBeforeClass();
        int startPort = 5009;
        logger = env.getLogManager().getLogger(MagicNumberTest.class, null);
        InetAddress addr = InetAddress.getLocalHost();
        Parameters p = env.getParameters();
        timer = env.getSelectorManager().getTimer();
        p.setInt("pastry_socket_scm_num_ping_tries", 2);
        p.setInt("pastry_socket_srm_default_rto", 400);
        p.setInt("pastry_socket_srm_rto_ubound", 500);
        alice = LivenessTest.buildTL("alice", addr, startPort, env);
        bob = LivenessTest.buildTL("bob", addr, startPort + 1, env);
        carol = LivenessTest.buildTL("carol", addr, startPort + 2, env);
        dave = LivenessTest.buildTL("dave", addr, startPort + 3, env);
        bob_prox = new MinRTTProximityProvider<SourceRoute>((LivenessTransportLayerImpl)bob, env);
    }

    private static TransportLayer buildTL(String name, InetAddress addr, int port, Environment env) throws IOException {
        Environment env_a = new Environment(env.getSelectorManager(), env.getProcessor(), env.getRandomSource(), env.getTimeSource(), ((CloneableLogManager)env.getLogManager()).clone(name), env.getParameters(), env.getExceptionStrategy());
        env.addDestructable(env_a);
        InetSocketAddress addr_a = new InetSocketAddress(addr, port);
        SourceRouteTransportLayerImpl<MultiInetSocketAddress> srtl = new SourceRouteTransportLayerImpl<MultiInetSocketAddress>(srFactory, new MultiInetAddressTransportLayerImpl(new MultiInetSocketAddress(addr_a), new MagicNumberTransportLayer<InetSocketAddress>(new WireTransportLayerImpl(addr_a, env_a, null), env_a, null, GOOD_HDR, 2000), env_a, null, null), env_a, null);
        if (name.equals("carol")) {
            carol_tap = srtl;
        }
        return new TestLivenessTransportLayerImpl(srtl, env_a, null);
    }

    public static int getDelay(SourceRoute a, SourceRoute b) {
        TransportLayer bob = LivenessTest.bob;
        if (b.getLastHop().equals(((SourceRoute)bob.getLocalIdentifier()).getLastHop()) && a.equals(alice.getLocalIdentifier())) {
            return 150;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProximity() throws Exception {
        final HashMap pingResponse = new HashMap();
        final Object lock = new Object();
        PingListener<SourceRoute<MultiInetSocketAddress>> pl = new PingListener<SourceRoute<MultiInetSocketAddress>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pingResponse(SourceRoute<MultiInetSocketAddress> i, int rtt, Map<String, Integer> options) {
                Object object = lock;
                synchronized (object) {
                    pingResponse.put(i.getLastHop(), new Tupel(i, rtt));
                    lock.notify();
                }
            }

            @Override
            public void pingReceived(SourceRoute<MultiInetSocketAddress> i, Map<String, Integer> options) {
            }
        };
        ((Pinger)((Object)bob)).addPingListener(pl);
        bob_prox.proximity((SourceRoute)this.getIdentifier(bob, alice));
        bob_prox.proximity((SourceRoute)this.getIdentifier(bob, carol));
        long timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object = lock;
        synchronized (object) {
            while (!(env.getTimeSource().currentTimeMillis() >= timeout || pingResponse.containsKey(((SourceRoute)alice.getLocalIdentifier()).getLastHop()) && pingResponse.containsKey(((SourceRoute)carol.getLocalIdentifier()).getLastHop()))) {
                lock.wait(1000L);
            }
        }
        int aliceProx = bob_prox.proximity((SourceRoute)this.getIdentifier(bob, alice));
        int carolProx = bob_prox.proximity((SourceRoute)this.getIdentifier(bob, carol));
        Assert.assertTrue((String)("aliceProx:" + aliceProx + " carolProx:" + carolProx), (aliceProx > carolProx + 100 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLiveness() throws Exception {
        LivenessProvider alice = (LivenessProvider)((Object)LivenessTest.alice);
        Object aliceToDave = this.getIdentifier(LivenessTest.alice, dave);
        final ArrayList tupels = new ArrayList(3);
        final Object lock = new Object();
        alice.addLivenessListener(new LivenessListener<SourceRoute<MultiInetSocketAddress>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void livenessChanged(SourceRoute<MultiInetSocketAddress> i, int val, Map<String, Integer> options) {
                Object object = lock;
                synchronized (object) {
                    tupels.add(new Tupel(i, val));
                    lock.notify();
                }
            }
        });
        Assert.assertTrue((alice.getLiveness(aliceToDave, null) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)alice.checkLiveness(aliceToDave, null));
        long timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object = lock;
        synchronized (object) {
            while (env.getTimeSource().currentTimeMillis() < timeout && tupels.isEmpty()) {
                lock.wait(1000L);
            }
        }
        Assert.assertTrue((alice.getLiveness(aliceToDave, null) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((tupels.size() == 1 ? 1 : 0) != 0);
        dave.destroy();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ie) {
            return;
        }
        Assert.assertTrue((boolean)alice.checkLiveness(aliceToDave, null));
        timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        object = lock;
        synchronized (object) {
            while (env.getTimeSource().currentTimeMillis() < timeout && tupels.size() <= 2) {
                lock.wait(1000L);
            }
        }
        Assert.assertTrue((alice.getLiveness(aliceToDave, null) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((tupels.size() == 3 ? 1 : 0) != 0);
    }

    class Tupel {
        SourceRoute sr;
        int val;

        public Tupel(SourceRoute i, int val) {
            this.sr = i;
            this.val = val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestLivenessTransportLayerImpl
    extends LivenessTransportLayerImpl<SourceRoute> {
        public TestLivenessTransportLayerImpl(TransportLayer<SourceRoute, ByteBuffer> tl, Environment env, ErrorHandler<SourceRoute> errorHandler) {
            super(tl, env, errorHandler, 5000);
        }

        @Override
        public void pong(final SourceRoute i, final long senderTime) {
            this.timer.schedule(new TimerTask(){

                public void run() {
                    TestLivenessTransportLayerImpl.super.pong(i, senderTime);
                }
            }, LivenessTest.getDelay((SourceRoute)this.getLocalIdentifier(), i));
        }
    }
}

