/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class OIDTest
implements Test {
    byte[] req = Hex.decode("0603813403");

    public String getName() {
        return "OID";
    }

    public TestResult perform() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.req);
            DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
            DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier("2.100.3");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(dERObjectIdentifier);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length != this.req.length) {
                return new SimpleTestResult(false, this.getName() + ": failed length test");
            }
            int n = 0;
            while (n != this.req.length) {
                if (byArray[n] != this.req[n]) {
                    return new SimpleTestResult(false, this.getName() + ": failed comparison test");
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Exception - " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        OIDTest oIDTest = new OIDTest();
        TestResult testResult = oIDTest.perform();
        System.out.println(testResult);
    }
}

