/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.services;

import java.net.URI;
import java.text.DateFormat;
import java.util.Date;
import java.util.Set;
import net.sbbi.upnp.services.ServiceStateVariableTypes;
import net.sbbi.upnp.services.UPNPService;

public class ServiceStateVariable
implements ServiceStateVariableTypes {
    protected String name;
    protected boolean sendEvents;
    protected String dataType;
    protected String defaultValue;
    protected String minimumRangeValue;
    protected String maximumRangeValue;
    protected String stepRangeValue;
    protected Set allowedvalues;
    protected UPNPService parent;

    protected ServiceStateVariable() {
    }

    public String getName() {
        return this.name;
    }

    public UPNPService getParent() {
        return this.parent;
    }

    public boolean isSendEvents() {
        return this.sendEvents;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Class getDataTypeAsClass() {
        return ServiceStateVariable.getDataTypeClassMapping(this.dataType);
    }

    public Set getAllowedvalues() {
        return this.allowedvalues;
    }

    public String getMinimumRangeValue() {
        return this.minimumRangeValue;
    }

    public String getMaximumRangeValue() {
        return this.maximumRangeValue;
    }

    public String getStepRangeValue() {
        return this.stepRangeValue;
    }

    public static Class getDataTypeClassMapping(String dataType) {
        int hash = dataType.hashCode();
        if (hash == UI1_INT) {
            return Short.class;
        }
        if (hash == UI2_INT) {
            return Integer.class;
        }
        if (hash == UI4_INT) {
            return Long.class;
        }
        if (hash == I1_INT) {
            return Byte.class;
        }
        if (hash == I2_INT) {
            return Short.class;
        }
        if (hash == I4_INT) {
            return Integer.class;
        }
        if (hash == INT_INT) {
            return Integer.class;
        }
        if (hash == R4_INT) {
            return Float.class;
        }
        if (hash == R8_INT) {
            return Double.class;
        }
        if (hash == NUMBER_INT) {
            return Double.class;
        }
        if (hash == FIXED_14_4_INT) {
            return Double.class;
        }
        if (hash == FLOAT_INT) {
            return Float.class;
        }
        if (hash == CHAR_INT) {
            return Character.class;
        }
        if (hash == STRING_INT) {
            return String.class;
        }
        if (hash == DATE_INT) {
            return Date.class;
        }
        if (hash == DATETIME_INT) {
            return Date.class;
        }
        if (hash == DATETIME_TZ_INT) {
            return Date.class;
        }
        if (hash == TIME_INT) {
            return Date.class;
        }
        if (hash == TIME_TZ_INT) {
            return Date.class;
        }
        if (hash == BOOLEAN_INT) {
            return Boolean.class;
        }
        if (hash == BIN_BASE64_INT) {
            return String.class;
        }
        if (hash == BIN_HEX_INT) {
            return String.class;
        }
        if (hash == URI_INT) {
            return URI.class;
        }
        if (hash == UUID_INT) {
            return String.class;
        }
        return null;
    }

    public static String getUPNPDataTypeMapping(String className) {
        if (className.equals(Short.class.getName()) || className.equals("short")) {
            return "i2";
        }
        if (className.equals(Byte.class.getName()) || className.equals("byte")) {
            return "i1";
        }
        if (className.equals(Integer.class.getName()) || className.equals("int")) {
            return "int";
        }
        if (className.equals(Long.class.getName()) || className.equals("long")) {
            return "ui4";
        }
        if (className.equals(Float.class.getName()) || className.equals("float")) {
            return "float";
        }
        if (className.equals(Double.class.getName()) || className.equals("double")) {
            return "number";
        }
        if (className.equals(Character.class.getName()) || className.equals("char")) {
            return "char";
        }
        if (className.equals(String.class.getName()) || className.equals("string")) {
            return "string";
        }
        if (className.equals(Date.class.getName())) {
            return "dateTime";
        }
        if (className.equals(Boolean.class.getName()) || className.equals("boolean")) {
            return "boolean";
        }
        if (className.equals(URI.class.getName())) {
            return "uri";
        }
        return null;
    }

    public static Object getUPNPDataJavaObject(String dataType, String value) throws Throwable {
        if (value == null) {
            throw new Exception("null value");
        }
        if (dataType == null) {
            throw new Exception("null dataType");
        }
        int hash = dataType.hashCode();
        if (hash == UI1_INT) {
            return new Short(value);
        }
        if (hash == UI2_INT) {
            return new Integer(value);
        }
        if (hash == UI4_INT) {
            return new Long(value);
        }
        if (hash == I1_INT) {
            return new Byte(value);
        }
        if (hash == I2_INT) {
            return new Short(value);
        }
        if (hash == I4_INT) {
            return new Integer(value);
        }
        if (hash == INT_INT) {
            return new Integer(value);
        }
        if (hash == R4_INT) {
            return new Float(value);
        }
        if (hash == R8_INT) {
            return new Double(value);
        }
        if (hash == NUMBER_INT) {
            return new Double(value);
        }
        if (hash == FIXED_14_4_INT) {
            return new Double(value);
        }
        if (hash == FLOAT_INT) {
            return new Float(value);
        }
        if (hash == CHAR_INT) {
            return new Character(value.charAt(0));
        }
        if (hash == STRING_INT) {
            return value;
        }
        if (hash == DATE_INT) {
            return DateFormat.getDateInstance().parse(value);
        }
        if (hash == DATETIME_INT) {
            return DateFormat.getDateInstance().parse(value);
        }
        if (hash == DATETIME_TZ_INT) {
            return DateFormat.getDateInstance().parse(value);
        }
        if (hash == TIME_INT) {
            return DateFormat.getDateInstance().parse(value);
        }
        if (hash == TIME_TZ_INT) {
            return DateFormat.getDateInstance().parse(value);
        }
        if (hash == BOOLEAN_INT) {
            return new Boolean(value);
        }
        if (hash == BIN_BASE64_INT) {
            return value;
        }
        if (hash == BIN_HEX_INT) {
            return value;
        }
        if (hash == URI_INT) {
            return new URI(value);
        }
        if (hash == UUID_INT) {
            return value;
        }
        throw new Exception("UNhandled data type " + dataType);
    }
}

