/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;

public class SubjectKeyIdentifier
extends CMSObject {
    private ASN1OctetString id;

    public SubjectKeyIdentifier(byte[] byArray) {
        this.setId(byArray);
    }

    public SubjectKeyIdentifier(ASN1OctetString aSN1OctetString) {
        this.id = aSN1OctetString;
    }

    public SubjectKeyIdentifier(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.id = subjectKeyIdentifier.id;
    }

    public static SubjectKeyIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SubjectKeyIdentifier.getInstance(ASN1OctetString.getInstance(aSN1TaggedObject, bl));
    }

    public static SubjectKeyIdentifier getInstance(Object object) {
        if (object == null || object instanceof SubjectKeyIdentifier) {
            return (SubjectKeyIdentifier)object;
        }
        if (object instanceof ASN1OctetString) {
            return new SubjectKeyIdentifier((ASN1OctetString)object);
        }
        throw new IllegalArgumentException("Invalid SubjectKeyIdentifier: " + object.getClass().getName());
    }

    public byte[] getId() {
        return this.id.getOctets();
    }

    public DERObject getDERObject() {
        return this.id;
    }

    private void setId(byte[] byArray) {
        this.id = new BERConstructedOctetString(byArray);
    }
}

