/*************************************************************************

"FreePastry" Peer-to-Peer Application Development Substrate 

Copyright 2002, Rice University. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

- Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

- Neither  the name  of Rice  University (RICE) nor  the names  of its
contributors may be  used to endorse or promote  products derived from
this software without specific prior written permission.

This software is provided by RICE and the contributors on an "as is"
basis, without any representations or warranties of any kind, express
or implied including, but not limited to, representations or
warranties of non-infringement, merchantability or fitness for a
particular purpose. In no event shall RICE or contributors be liable
for any direct, indirect, incidental, special, exemplary, or
consequential damages (including, but not limited to, procurement of
substitute goods or services; loss of use, data, or profits; or
business interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software, even
if advised of the possibility of such damage.

********************************************************************************/
package rice.pastry.leafset;

import rice.p2p.commonapi.rawserialization.*;
import rice.pastry.*;
import rice.pastry.messaging.*;

import java.io.*;
import java.util.*;

/**
 * Request a leaf set from another node.
 *
 * @version $Id: RequestLeafSet.java 3310 2006-06-22 11:58:23Z jeffh $
 * @author Andrew Ladd
 */

public class RequestLeafSet extends PRawMessage implements Serializable {

  long timeStamp;
  /**
   * DESCRIBE THE FIELD
   */
  public static final short TYPE = 1;

  /**
   * Constructor.
   *
   * @param nh the return handle.
   * @param timeStamp DESCRIBE THE PARAMETER
   */

  public RequestLeafSet(NodeHandle nh, long timeStamp) {
    this(null, nh, timeStamp);
  }

  /**
   * Constructor.
   *
   * @param stamp the timestamp
   * @param nh the return handle
   * @param timeStamp DESCRIBE THE PARAMETER
   */

  public RequestLeafSet(Date stamp, NodeHandle nh, long timeStamp) {
    super(LeafSetProtocolAddress.getCode(), stamp);
    setSender(nh);
    this.timeStamp = timeStamp;
    setPriority(MAX_PRIORITY);
  }

  /**
   * Constructor for RequestLeafSet.
   *
   * @param sender DESCRIBE THE PARAMETER
   * @param buf DESCRIBE THE PARAMETER
   * @exception IOException DESCRIBE THE EXCEPTION
   */
  public RequestLeafSet(NodeHandle sender, InputBuffer buf) throws IOException {
    super(LeafSetProtocolAddress.getCode());

    setSender(sender);

    byte version = buf.readByte();
    switch (version) {
      case 0:
        timeStamp = buf.readLong();
        break;
      default:
        throw new IOException("Unknown Version: " + version);
    }
  }

  /**
   * Raw Serialization **************************************
   *
   * @return The Type value
   */
  public short getType() {
    return TYPE;
  }

  /**
   * Gets the TimeStamp attribute of the RequestLeafSet object
   *
   * @return The TimeStamp value
   */
  public long getTimeStamp() {
    return timeStamp;
  }

  /**
   * The return handle for the message
   *
   * @return the node handle
   */

  public NodeHandle returnHandle() {
    return getSender();
  }

  /**
   * Converts to a String representation of the object.
   *
   * @return A string representation of the object.
   */
  public String toString() {
    String s = "";

    s += "RequestLeafSet(by " + getSender().getNodeId() + ")";

    return s;
  }

  /**
   * DESCRIBE THE METHOD
   *
   * @param buf DESCRIBE THE PARAMETER
   * @exception IOException DESCRIBE THE EXCEPTION
   */
  public void serialize(OutputBuffer buf) throws IOException {
    buf.writeByte((byte) 0);
    // version
    buf.writeLong(timeStamp);
  }
}
