/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.RecipientKeyIdentifier;

public class KeyAgreeRecipientIdentifier
extends CMSObject {
    private DEREncodable id;

    public KeyAgreeRecipientIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.setId(issuerAndSerialNumber);
    }

    public KeyAgreeRecipientIdentifier(RecipientKeyIdentifier recipientKeyIdentifier) {
        this.setId(recipientKeyIdentifier);
    }

    public KeyAgreeRecipientIdentifier(DERObject dERObject) {
        this.id = dERObject instanceof ASN1TaggedObject ? RecipientKeyIdentifier.getInstance((ASN1TaggedObject)dERObject, false) : IssuerAndSerialNumber.getInstance(dERObject);
    }

    public KeyAgreeRecipientIdentifier(KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier) {
        this.id = keyAgreeRecipientIdentifier.id;
    }

    public static KeyAgreeRecipientIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return KeyAgreeRecipientIdentifier.getInstance(aSN1TaggedObject);
    }

    public static KeyAgreeRecipientIdentifier getInstance(Object object) {
        if (object == null || object instanceof KeyAgreeRecipientIdentifier) {
            return (KeyAgreeRecipientIdentifier)object;
        }
        if (object instanceof RecipientKeyIdentifier) {
            return new KeyAgreeRecipientIdentifier((RecipientKeyIdentifier)object);
        }
        if (object instanceof IssuerAndSerialNumber) {
            return new KeyAgreeRecipientIdentifier((IssuerAndSerialNumber)object);
        }
        if (object instanceof DERObject) {
            return new KeyAgreeRecipientIdentifier((DERObject)object);
        }
        throw new IllegalArgumentException("Invalid KeyAgreeRecipientIdentifier: " + object.getClass().getName());
    }

    public DEREncodable getId() {
        return this.id;
    }

    public DERObject getDERObject() {
        if (this.id instanceof IssuerAndSerialNumber) {
            return this.id.getDERObject();
        }
        return new BERTaggedObject(false, 0, this.id.getDERObject());
    }

    private void setId(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.id = issuerAndSerialNumber;
    }

    private void setId(RecipientKeyIdentifier recipientKeyIdentifier) {
        this.id = recipientKeyIdentifier;
    }
}

