/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.rawserialization;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;

public class MyMsg
implements RawMessage {
    Id from;
    Id to;
    protected static final short TYPE = 1;

    public MyMsg(Id from, Id to) {
        this.from = from;
        this.to = to;
    }

    public MyMsg(InputBuffer buf, Endpoint endpoint) throws IOException {
        this.from = endpoint.readId(buf, buf.readShort());
        this.to = endpoint.readId(buf, buf.readShort());
    }

    public byte getPriority() {
        return 25;
    }

    public short getType() {
        return 1;
    }

    public String toString() {
        return "MyMsg from " + this.from + " to " + this.to;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeShort(this.from.getType());
        this.from.serialize(buf);
        buf.writeShort(this.to.getType());
        this.to.serialize(buf);
    }
}

