/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.lesson6;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import rice.environment.Environment;
import rice.p2p.commonapi.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.tutorial.lesson6.MyScribeClient;

public class ScribeTutorial {
    Vector apps = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScribeTutorial(int bindport, InetSocketAddress bootaddress, int numNodes, Environment env) throws Exception {
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            PastryNode node;
            rice.pastry.NodeHandle bootHandle = factory.getNodeHandle(bootaddress);
            PastryNode pastryNode = node = ((PastryNodeFactory)factory).newNode(bootHandle);
            synchronized (pastryNode) {
                while (!node.isReady() && !node.joinFailed()) {
                    node.wait(500L);
                    if (!node.joinFailed()) continue;
                    throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
                }
            }
            System.out.println("Finished creating new node: " + node);
            MyScribeClient app = new MyScribeClient(node);
            this.apps.add(app);
        }
        Iterator i = this.apps.iterator();
        MyScribeClient app = (MyScribeClient)i.next();
        app.subscribe();
        app.startPublishTask();
        while (i.hasNext()) {
            app = (MyScribeClient)i.next();
            app.subscribe();
        }
        env.getTimeSource().sleep(5000L);
        ScribeTutorial.printTree(this.apps);
    }

    public static NodeHandle getRoot(NodeHandle seed, Hashtable appTable) {
        MyScribeClient app = (MyScribeClient)appTable.get(seed);
        if (app.isRoot()) {
            return seed;
        }
        NodeHandle nextSeed = app.getParent();
        return ScribeTutorial.getRoot(nextSeed, appTable);
    }

    public static void printTree(Vector apps) {
        Hashtable<NodeHandle, MyScribeClient> appTable = new Hashtable<NodeHandle, MyScribeClient>();
        for (MyScribeClient app : apps) {
            appTable.put(app.endpoint.getLocalNodeHandle(), app);
        }
        NodeHandle seed = ((MyScribeClient)apps.get((int)0)).endpoint.getLocalNodeHandle();
        NodeHandle root = ScribeTutorial.getRoot(seed, appTable);
        ScribeTutorial.recursivelyPrintChildren(root, 0, appTable);
    }

    public static void recursivelyPrintChildren(NodeHandle curNode, int recursionDepth, Hashtable appTable) {
        String s = "";
        for (int numTabs = 0; numTabs < recursionDepth; ++numTabs) {
            s = s + "  ";
        }
        s = s + curNode.getId().toString();
        System.out.println(s);
        MyScribeClient app = (MyScribeClient)appTable.get(curNode);
        NodeHandle[] children = app.getChildren();
        for (int curChild = 0; curChild < children.length; ++curChild) {
            ScribeTutorial.recursivelyPrintChildren(children[curChild], recursionDepth + 1, appTable);
        }
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        env.getParameters().setString("nat_search_policy", "never");
        try {
            int bindport = Integer.parseInt(args[0]);
            InetAddress bootaddr = InetAddress.getByName(args[1]);
            int bootport = Integer.parseInt(args[2]);
            InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
            int numNodes = Integer.parseInt(args[3]);
            ScribeTutorial dt = new ScribeTutorial(bindport, bootaddress, numNodes, env);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.lesson6.ScribeTutorial localbindport bootIP bootPort numNodes");
            System.out.println("example java rice.tutorial.DistTutorial 9001 pokey.cs.almamater.edu 9001 10");
            throw e;
        }
    }
}

