/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.appsocket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Vector;
import rice.environment.Environment;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.leafset.LeafSet;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.tutorial.appsocket.MyApp;

public class Tutorial {
    Vector apps = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tutorial(int bindport, InetSocketAddress bootaddress, int numNodes, Environment env, boolean useDirect) throws Exception {
        PastryNodeFactory factory;
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        if (useDirect) {
            EuclideanNetwork sim = new EuclideanNetwork(env);
            factory = new DirectPastryNodeFactory(nidFactory, sim, env);
        } else {
            factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        }
        PastryIdFactory idFactory = new PastryIdFactory(env);
        NodeHandle bootHandle = null;
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            PastryNode node = factory.newNode(bootHandle);
            if (bootHandle == null) {
                bootHandle = useDirect ? node.getLocalHandle() : ((SocketPastryNodeFactory)factory).getNodeHandle(bootaddress);
            }
            PastryNode pastryNode = node;
            synchronized (pastryNode) {
                while (!node.isReady() && !node.joinFailed()) {
                    node.wait(500L);
                    if (!node.joinFailed()) continue;
                    throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
                }
            }
            System.out.println("Finished creating new node " + node);
            MyApp app = new MyApp(node, idFactory);
            this.apps.add(app);
        }
        env.getTimeSource().sleep(10000L);
        for (MyApp app : this.apps) {
            PastryNode node = (PastryNode)app.getNode();
            LeafSet leafSet = node.getLeafSet();
            for (int i = -leafSet.ccwSize(); i <= leafSet.cwSize(); ++i) {
                NodeHandle nh = leafSet.get(i);
                app.sendMyMsgDirect(nh);
                env.getTimeSource().sleep(100L);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            Environment env;
            boolean useDirect = args[0].equalsIgnoreCase("-direct");
            if (useDirect) {
                env = Environment.directEnvironment();
            } else {
                env = new Environment();
                env.getParameters().setString("nat_search_policy", "never");
            }
            int bindport = 0;
            InetSocketAddress bootaddress = null;
            int numNodes = Integer.parseInt(args[args.length - 1]);
            if (!useDirect) {
                bindport = Integer.parseInt(args[0]);
                InetAddress bootaddr = InetAddress.getByName(args[1]);
                int bootport = Integer.parseInt(args[2]);
                bootaddress = new InetSocketAddress(bootaddr, bootport);
            }
            Tutorial dt = new Tutorial(bindport, bootaddress, numNodes, env, useDirect);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.appsocket.Tutorial localbindport bootIP bootPort numNodes");
            System.out.println("  or");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.appsocket.Tutorial -direct numNodes");
            System.out.println();
            System.out.println("example java rice.tutorial.DistTutorial 9001 pokey.cs.almamater.edu 9001 10");
            System.out.println("example java rice.tutorial.DistTutorial -direct 10");
            throw e;
        }
    }
}

