/*
 * Decompiled with CFR 0.152.
 */
package rice.selector;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import rice.Destructable;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.time.TimeSource;
import rice.selector.LoopObserver;
import rice.selector.SelectionKeyHandler;
import rice.selector.Timer;
import rice.selector.TimerTask;

public class SelectorManager
extends Thread
implements Destructable,
Timer {
    protected Selector selector;
    protected LinkedList invocations;
    protected HashSet modifyKeys;
    protected HashSet cancelledKeys;
    protected TreeSet timerQueue = new TreeSet();
    protected long wakeupTime = 0L;
    protected TimeSource timeSource;
    long lastTime = 0L;
    protected Logger logger;
    protected String instance;
    protected boolean running = true;
    ArrayList loopObservers = new ArrayList();
    public static int TIMEOUT = 500;

    public SelectorManager(String instance, TimeSource timeSource, LogManager log) {
        super(instance == null ? "Selector Thread" : "Selector Thread -- " + instance);
        this.instance = instance;
        this.logger = log.getLogger(this.getClass(), instance);
        this.invocations = new LinkedList();
        this.modifyKeys = new HashSet();
        this.cancelledKeys = new HashSet();
        this.timeSource = timeSource;
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            System.out.println("SEVERE ERROR (SelectorManager): Error creating selector " + e);
        }
        this.lastTime = timeSource.currentTimeMillis();
        this.start();
    }

    public SelectionKey getKey(SelectableChannel channel) {
        return channel.keyFor(this.selector);
    }

    public int getNumInvocations() {
        return this.invocations.size();
    }

    protected synchronized Runnable getInvocation() {
        if (this.invocations.size() > 0) {
            return (Runnable)this.invocations.removeFirst();
        }
        return null;
    }

    protected synchronized SelectionKey getModifyKey() {
        if (this.modifyKeys.size() > 0) {
            Object result = this.modifyKeys.iterator().next();
            this.modifyKeys.remove(result);
            return (SelectionKey)result;
        }
        return null;
    }

    public boolean isSelectorThread() {
        return Thread.currentThread() == this;
    }

    public long getNextTaskExecutionTime() {
        if (this.timerQueue.size() > 0) {
            TimerTask next = (TimerTask)this.timerQueue.first();
            return next.nextExecutionTime;
        }
        return 0L;
    }

    public Timer getTimer() {
        return this;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void cancel(SelectionKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.cancelledKeys.add(key);
    }

    public SelectionKey register(SelectableChannel channel, SelectionKeyHandler handler, int ops) throws IOException {
        if (channel == null || handler == null) {
            throw new NullPointerException();
        }
        SelectionKey key = channel.register(this.selector, ops, handler);
        if (this.cancelledKeys != null) {
            this.cancelledKeys.remove(key);
        }
        return key;
    }

    public synchronized void invoke(Runnable d) {
        if (d == null) {
            throw new NullPointerException();
        }
        this.invocations.add(d);
        this.selector.wakeup();
    }

    public synchronized void modifyKey(SelectionKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.modifyKeys.add(key);
        this.selector.wakeup();
    }

    protected void onLoop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            if (this.logger.level <= 800) {
                this.logger.log("SelectorManager -- " + this.instance + " starting...");
            }
            this.lastTime = this.timeSource.currentTimeMillis();
            while (this.running) {
                this.notifyLoopListeners();
                Thread.yield();
                this.executeDueTasks();
                this.onLoop();
                this.doInvocations();
                this.doSelections();
                Selector selector = this.selector;
                synchronized (selector) {
                    int selectTime = TIMEOUT;
                    if (this.timerQueue.size() > 0) {
                        TimerTask first = (TimerTask)this.timerQueue.first();
                        selectTime = (int)(first.nextExecutionTime - this.timeSource.currentTimeMillis());
                    }
                    this.select(selectTime);
                    if (this.cancelledKeys.size() > 0) {
                        Iterator i = this.cancelledKeys.iterator();
                        while (i.hasNext()) {
                            ((SelectionKey)i.next()).cancel();
                        }
                        this.cancelledKeys.clear();
                        this.selector.selectNow();
                    }
                }
            }
        }
        catch (Throwable t) {
            if (this.logger.level <= 1000) {
                this.logger.logException("ERROR (SelectorManager.run): ", t);
            }
            System.exit(-1);
        }
        this.invocations.clear();
        this.loopObservers.clear();
        this.cancelledKeys.clear();
        this.timerQueue.clear();
        this.invocations = null;
        this.loopObservers = null;
        this.cancelledKeys = null;
        this.timerQueue = null;
        if (this.logger.level <= 800) {
            this.logger.log("Selector " + this.instance + " shutting down.");
        }
    }

    public void destroy() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLoopListeners() {
        long now = this.timeSource.currentTimeMillis();
        long diff = now - this.lastTime;
        ArrayList arrayList = this.loopObservers;
        synchronized (arrayList) {
            for (LoopObserver lo : this.loopObservers) {
                if ((long)lo.delayInterest() > diff) continue;
                lo.loopTime((int)diff);
            }
        }
        this.lastTime = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoopObserver(LoopObserver lo) {
        ArrayList arrayList = this.loopObservers;
        synchronized (arrayList) {
            this.loopObservers.add(lo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoopObserver(LoopObserver lo) {
        ArrayList arrayList = this.loopObservers;
        synchronized (arrayList) {
            this.loopObservers.remove(lo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSelections() throws IOException {
        SelectionKey[] keys = this.selectedKeys();
        if (keys.length > 1000 && this.logger.level <= 500) {
            this.logger.log("lots of selection keys!");
            HashMap<String, Integer> histo = new HashMap<String, Integer>();
            for (int i = 0; i < keys.length; ++i) {
                String keyclass = keys[i].getClass().getName();
                if (histo.containsKey(keyclass)) {
                    histo.put(keyclass, new Integer((Integer)histo.get(keyclass) + 1));
                    continue;
                }
                histo.put(keyclass, new Integer(1));
            }
            this.logger.log("begin selection keys by class");
            for (String name : histo.keySet()) {
                this.logger.log("Selection Key: " + name + ": " + histo.get(name));
            }
            this.logger.log("end selection keys by class");
        }
        for (int i = 0; i < keys.length; ++i) {
            this.selector.selectedKeys().remove(keys[i]);
            SelectionKey selectionKey = keys[i];
            synchronized (selectionKey) {
                SelectionKeyHandler skh = (SelectionKeyHandler)keys[i].attachment();
                if (skh != null) {
                    if (keys[i].isValid() && keys[i].isAcceptable()) {
                        skh.accept(keys[i]);
                    }
                    if (keys[i].isValid() && keys[i].isConnectable()) {
                        skh.connect(keys[i]);
                    }
                    if (keys[i].isValid() && keys[i].isReadable()) {
                        skh.read(keys[i]);
                    }
                    if (keys[i].isValid() && keys[i].isWritable()) {
                        skh.write(keys[i]);
                    }
                } else {
                    keys[i].channel().close();
                    keys[i].cancel();
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvocations() {
        Runnable run;
        Iterator i;
        SelectorManager selectorManager = this;
        synchronized (selectorManager) {
            i = new ArrayList(this.invocations).iterator();
            this.invocations.clear();
        }
        while (i.hasNext()) {
            run = (Runnable)i.next();
            try {
                run.run();
            }
            catch (Exception e) {
                if (this.logger.level > 1000) continue;
                this.logger.logException("Invoking runnable caused exception " + e + " - continuing", e);
            }
        }
        run = this;
        synchronized (run) {
            i = new ArrayList(this.modifyKeys).iterator();
            this.modifyKeys.clear();
        }
        while (i.hasNext()) {
            SelectionKey key = (SelectionKey)i.next();
            if (!key.isValid() || key.attachment() == null) continue;
            ((SelectionKeyHandler)key.attachment()).modifyKey(key);
        }
    }

    int select(int time) throws IOException {
        if (time > TIMEOUT) {
            time = TIMEOUT;
        }
        try {
            if (time <= 0 || this.invocations.size() > 0 || this.modifyKeys.size() > 0) {
                return this.selector.selectNow();
            }
            this.wakeupTime = this.timeSource.currentTimeMillis() + (long)time;
            return this.selector.select(time);
        }
        catch (CancelledKeyException cce) {
            if (this.logger.level <= 900) {
                this.logger.logException("CCE: cause:", cce.getCause());
            }
            throw cce;
        }
        catch (IOException e) {
            if (e.getMessage().indexOf("Interrupted system call") >= 0) {
                if (this.logger.level <= 900) {
                    this.logger.log("Got interrupted system call, continuing anyway...");
                }
                return 1;
            }
            throw e;
        }
    }

    private SelectionKey[] keys() throws IOException {
        return this.selector.keys().toArray(new SelectionKey[0]);
    }

    protected SelectionKey[] selectedKeys() throws IOException {
        return this.selector.selectedKeys().toArray(new SelectionKey[0]);
    }

    public void schedule(TimerTask task) {
        this.addTask(task);
    }

    public void schedule(TimerTask task, long delay) {
        task.nextExecutionTime = this.timeSource.currentTimeMillis() + delay;
        this.addTask(task);
    }

    public void schedule(TimerTask task, long delay, long period) {
        task.nextExecutionTime = this.timeSource.currentTimeMillis() + delay;
        task.period = (int)period;
        this.addTask(task);
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        task.nextExecutionTime = this.timeSource.currentTimeMillis() + delay;
        task.period = (int)period;
        task.fixedRate = true;
        this.addTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(TimerTask task) {
        Selector selector = this.selector;
        synchronized (selector) {
            if (!this.timerQueue.add(task)) {
                System.out.println("ERROR: Got false while enqueueing task " + task + "!");
                Thread.dumpStack();
            }
        }
        if (this.wakeupTime >= task.scheduledExecutionTime()) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeDueTasks() {
        long now = this.timeSource.currentTimeMillis();
        ArrayList<TimerTask> executeNow = new ArrayList<TimerTask>();
        Selector selector = this.selector;
        synchronized (selector) {
            boolean done = false;
            while (!done) {
                if (this.timerQueue.size() > 0) {
                    TimerTask next = (TimerTask)this.timerQueue.first();
                    if (next.nextExecutionTime <= now) {
                        executeNow.add(next);
                        this.timerQueue.remove(next);
                        continue;
                    }
                    done = true;
                    continue;
                }
                done = true;
            }
        }
        ArrayList<TimerTask> addBack = new ArrayList<TimerTask>();
        for (TimerTask next : executeNow) {
            try {
                if (!next.execute(this.timeSource)) continue;
                addBack.add(next);
            }
            catch (Exception e) {
                if (this.logger.level > 1000) continue;
                this.logger.logException("", e);
            }
        }
        Selector selector2 = this.selector;
        synchronized (selector2) {
            for (TimerTask tt : addBack) {
                this.timerQueue.add(tt);
            }
        }
    }
}

