/*
 * Decompiled with CFR 0.152.
 */
package rice.selector;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import rice.environment.logging.LogManager;
import rice.environment.time.TimeSource;
import rice.selector.SelectionKeyHandler;
import rice.selector.SelectorManager;

public class ProfileSelector
extends SelectorManager {
    int HEART_BEAT_INTERVAL = 60000;
    long lastHeartBeat = 0L;
    public String lastTaskType = null;
    public String lastTaskClass = null;
    public String lastTaskToString = null;
    public long lastTaskHash = 0L;
    int numInvocationsScheduled = 0;
    int numInvocationsExecuted = 0;
    int maxInvokes = 0;
    private Hashtable stats = new Hashtable();
    public static boolean useHeartbeat = true;
    public static boolean recordStats = true;

    public ProfileSelector(String instance, TimeSource timeSource, LogManager log) {
        super(instance, timeSource, log);
        new Thread(new Runnable(){

            public void run() {
                while (true) {
                    System.out.println("LastTask: type:" + ProfileSelector.this.lastTaskType + " class:" + ProfileSelector.this.lastTaskClass + " toString():" + ProfileSelector.this.lastTaskToString + " hash:" + ProfileSelector.this.lastTaskHash);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }, "ProfileSelectorWatchdog").start();
    }

    protected void onLoop() {
        if (!useHeartbeat) {
            return;
        }
        long curTime = this.timeSource.currentTimeMillis();
        if (curTime - this.lastHeartBeat > (long)this.HEART_BEAT_INTERVAL) {
            System.out.println("selector heartbeat " + new Date() + " maxInvokes:" + this.maxInvokes + " invokesSched:" + this.numInvocationsScheduled + " invokesExe:" + this.numInvocationsExecuted + " CurrentThread:" + Thread.currentThread() + "@" + System.identityHashCode(Thread.currentThread()));
            this.printStats();
            this.lastHeartBeat = curTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Runnable d) {
        ProfileSelector profileSelector = this;
        synchronized (profileSelector) {
            ++this.numInvocationsScheduled;
            super.invoke(d);
        }
        int numInvokes = this.invocations.size();
        if (numInvokes > this.maxInvokes) {
            this.maxInvokes = numInvokes;
        }
    }

    public void addStat(String s, long time) {
        if (!recordStats) {
            return;
        }
        Stat st = (Stat)this.stats.get(s);
        if (st == null) {
            st = new Stat(s);
            this.stats.put(s, st);
        }
        st.addTime(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStats() {
        if (!recordStats) {
            return;
        }
        ArrayList<Stat> list = new ArrayList<Stat>(this.stats.size());
        if (this.stats != null) {
            Hashtable hashtable = this.stats;
            synchronized (hashtable) {
                Enumeration e = this.stats.elements();
                while (e.hasMoreElements()) {
                    Stat s = (Stat)e.nextElement();
                    list.add(s);
                }
            }
        }
        Collections.sort(list, new Comparator(){

            public boolean equals(Object arg0) {
                return false;
            }

            public int compare(Object arg0, Object arg1) {
                Stat stat1 = (Stat)arg0;
                Stat stat2 = (Stat)arg1;
                return (int)(stat2.totalTime - stat1.totalTime);
            }
        });
        Iterator i = list.iterator();
        while (i.hasNext()) {
            System.out.println("  " + i.next());
        }
    }

    protected void doSelections() throws IOException {
        SelectionKey[] keys = this.selectedKeys();
        for (int i = 0; i < keys.length; ++i) {
            this.selector.selectedKeys().remove(keys[i]);
            SelectionKeyHandler skh = (SelectionKeyHandler)keys[i].attachment();
            if (skh != null) {
                int time;
                long startTime;
                if (keys[i].isValid() && keys[i].isAcceptable()) {
                    this.lastTaskType = "Accept";
                    this.lastTaskClass = skh.getClass().getName();
                    this.lastTaskToString = skh.toString();
                    this.lastTaskHash = System.identityHashCode(skh);
                    startTime = this.timeSource.currentTimeMillis();
                    skh.accept(keys[i]);
                    time = (int)(this.timeSource.currentTimeMillis() - startTime);
                    this.lastTaskType = "Accept Complete";
                    this.addStat("accepting", time);
                }
                if (keys[i].isValid() && keys[i].isConnectable()) {
                    this.lastTaskType = "Connect";
                    this.lastTaskClass = skh.getClass().getName();
                    this.lastTaskToString = skh.toString();
                    this.lastTaskHash = System.identityHashCode(skh);
                    startTime = this.timeSource.currentTimeMillis();
                    skh.connect(keys[i]);
                    time = (int)(this.timeSource.currentTimeMillis() - startTime);
                    this.lastTaskType = "Connect Complete";
                    this.addStat("connecting", time);
                }
                if (keys[i].isValid() && keys[i].isReadable()) {
                    this.lastTaskType = "Read";
                    this.lastTaskClass = skh.getClass().getName();
                    this.lastTaskToString = skh.toString();
                    this.lastTaskHash = System.identityHashCode(skh);
                    startTime = this.timeSource.currentTimeMillis();
                    skh.read(keys[i]);
                    time = (int)(this.timeSource.currentTimeMillis() - startTime);
                    this.lastTaskType = "Read Complete";
                }
                if (!keys[i].isValid() || !keys[i].isWritable()) continue;
                this.lastTaskType = "Write";
                this.lastTaskClass = skh.getClass().getName();
                this.lastTaskToString = skh.toString();
                this.lastTaskHash = System.identityHashCode(skh);
                startTime = this.timeSource.currentTimeMillis();
                skh.write(keys[i]);
                time = (int)(this.timeSource.currentTimeMillis() - startTime);
                this.lastTaskType = "Write Complete";
                continue;
            }
            keys[i].channel().close();
            keys[i].cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvocations() {
        Iterator i;
        ProfileSelector profileSelector = this;
        synchronized (profileSelector) {
            i = new ArrayList(this.invocations).iterator();
            this.invocations.clear();
        }
        while (i.hasNext()) {
            ++this.numInvocationsExecuted;
            Runnable run = (Runnable)i.next();
            try {
                this.lastTaskType = "Invocation";
                this.lastTaskClass = run.getClass().getName();
                this.lastTaskToString = run.toString();
                this.lastTaskHash = System.identityHashCode(run);
                long startTime = this.timeSource.currentTimeMillis();
                run.run();
                int time = (int)(this.timeSource.currentTimeMillis() - startTime);
                this.lastTaskType = "Invocation Complete";
            }
            catch (Exception e) {
                if (this.logger.level > 1000) continue;
                this.logger.logException("Invoking runnable caused exception " + e + " - continuing", e);
            }
        }
        ProfileSelector e = this;
        synchronized (e) {
            i = new ArrayList(this.modifyKeys).iterator();
        }
        while (i.hasNext()) {
            SelectionKey key = (SelectionKey)i.next();
            if (!key.isValid() || key.attachment() == null) continue;
            SelectionKeyHandler skh = (SelectionKeyHandler)key.attachment();
            this.lastTaskType = "ModifyKey";
            this.lastTaskClass = skh.getClass().getName();
            this.lastTaskHash = System.identityHashCode(skh);
            this.lastTaskToString = skh.toString();
            skh.modifyKey(key);
            this.lastTaskType = "ModifyKey Complete";
        }
    }

    protected void doInvocations2() {
        Runnable run = this.getInvocation();
        while (run != null) {
            block5: {
                try {
                    this.lastTaskType = "Invocation";
                    this.lastTaskClass = run.getClass().getName();
                    this.lastTaskToString = run.toString();
                    this.lastTaskHash = System.identityHashCode(run);
                    long startTime = this.timeSource.currentTimeMillis();
                    run.run();
                    int time = (int)(this.timeSource.currentTimeMillis() - startTime);
                    this.addStat(run.getClass().getName(), time);
                    this.lastTaskType = "Invocation Complete";
                }
                catch (Exception e) {
                    if (this.logger.level > 1000) break block5;
                    this.logger.logException("Invoking runnable caused exception " + e + " - continuing", e);
                }
            }
            run = this.getInvocation();
        }
        SelectionKey key = this.getModifyKey();
        while (key != null) {
            if (key.isValid() && key.attachment() != null) {
                SelectionKeyHandler skh = (SelectionKeyHandler)key.attachment();
                this.lastTaskType = "ModifyKey";
                this.lastTaskClass = skh.getClass().getName();
                this.lastTaskHash = System.identityHashCode(skh);
                this.lastTaskToString = skh.toString();
                skh.modifyKey(key);
                this.lastTaskType = "ModifyKey Complete";
            }
            key = this.getModifyKey();
        }
    }

    class Stat {
        int num = 0;
        String name = null;
        long totalTime = 0L;
        long maxTime = 0L;

        public Stat(String name) {
            this.name = name;
        }

        public void addTime(long t) {
            ++this.num;
            this.totalTime += t;
            if (t > this.maxTime) {
                this.maxTime = t;
            }
        }

        public String toString() {
            long avgTime = this.totalTime / (long)this.num;
            return this.name + "\t maxTime:" + this.maxTime + "\t avgTime:" + avgTime + "\t numInstances:" + this.num + "\t totalTime:" + this.totalTime;
        }
    }
}

