/*
 * Decompiled with CFR 0.152.
 */
package rice.persistence.testing;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.commonapi.PastryIdFactory;
import rice.persistence.MemoryStorage;
import rice.persistence.Storage;
import rice.persistence.testing.Test;

public class MemoryStorageTest
extends Test {
    private IdFactory FACTORY;
    protected Storage storage;
    protected boolean store;
    private Id[] data;
    private Integer[] metadata;

    public MemoryStorageTest(boolean store, Environment env) {
        super(env);
        this.FACTORY = new PastryIdFactory(env);
        this.storage = new MemoryStorage(this.FACTORY);
        this.data = new Id[500];
        this.metadata = new Integer[500];
        int[] x = new int[5];
        for (int i = 0; i < 500; ++i) {
            x[3] = i;
            this.data[i] = this.FACTORY.buildId(x);
            this.metadata[i] = new Integer(i);
        }
        this.store = store;
    }

    public void setUp(final Continuation c) {
        final Continuation put4 = new Continuation(){

            public void receiveResult(Object o) {
                if (!o.equals(new Boolean(true))) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Fourth object was not inserted.");
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.sectionEnd();
                c.receiveResult(new Boolean(true));
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        final Continuation put3 = new Continuation(){

            public void receiveResult(Object o) {
                if (!o.equals(new Boolean(true))) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Third object was not inserted.");
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.stepStart("Storing Fourth Object");
                MemoryStorageTest.this.storage.store(MemoryStorageTest.this.data[4], MemoryStorageTest.this.metadata[4], (Serializable)((Object)"Fourth Object"), put4);
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        final Continuation put2 = new Continuation(){

            public void receiveResult(Object o) {
                if (!o.equals(new Boolean(true))) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Second object was not inserted.");
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.stepStart("Storing Third Object");
                MemoryStorageTest.this.storage.store(MemoryStorageTest.this.data[3], MemoryStorageTest.this.metadata[3], (Serializable)((Object)"Third Object"), put3);
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        Continuation put1 = new Continuation(){

            public void receiveResult(Object o) {
                if (!o.equals(new Boolean(true))) {
                    MemoryStorageTest.this.stepDone("FAILURE", "First object was not inserted.");
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.stepStart("Storing Second Object");
                MemoryStorageTest.this.storage.store(MemoryStorageTest.this.data[2], MemoryStorageTest.this.metadata[2], (Serializable)((Object)"Second Object"), put2);
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        this.sectionStart("Storing Objects");
        this.stepStart("Storing First Object");
        this.storage.store(this.data[1], this.metadata[1], (Serializable)((Object)"First Object"), put1);
    }

    public void testRetreival(final Continuation c) {
        final Continuation get5 = new Continuation(){

            public void receiveResult(Object o) {
                if (o != null) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Fifth object was returned (should not be present).");
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.sectionEnd();
                c.receiveResult(new Boolean(true));
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        final Continuation get4 = new Continuation(){

            public void receiveResult(Object o) {
                if (o == null) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Returned object was null.");
                    return;
                }
                if (!o.equals("Fourth Object")) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Returned object was not correct: " + o);
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.stepStart("Attempting Fifth Object");
                MemoryStorageTest.this.storage.getObject(MemoryStorageTest.this.data[5], get5);
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        final Continuation get3 = new Continuation(){

            public void receiveResult(Object o) {
                if (o == null) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Returned object was null.");
                    return;
                }
                if (!o.equals("Third Object")) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Returned object was not correct: " + o);
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.stepStart("Retrieving Fourth Object");
                MemoryStorageTest.this.storage.getObject(MemoryStorageTest.this.data[4], get4);
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        final Continuation get2 = new Continuation(){

            public void receiveResult(Object o) {
                if (o == null) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Returned object was null.");
                    return;
                }
                if (!o.equals("Second Object")) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Returned object was not correct: " + o);
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.stepStart("Retrieving Third Object");
                MemoryStorageTest.this.storage.getObject(MemoryStorageTest.this.data[3], get3);
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        final Continuation get1 = new Continuation(){

            public void receiveResult(Object o) {
                if (o == null) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Returned object was null.");
                    return;
                }
                if (!o.equals("First Object")) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Returned object was not correct: " + o);
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.stepStart("Retrieving Second Object");
                MemoryStorageTest.this.storage.getObject(MemoryStorageTest.this.data[2], get2);
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        Continuation get0 = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    MemoryStorageTest.this.sectionStart("Retrieving Objects");
                    MemoryStorageTest.this.stepStart("Retrieving First Object");
                    MemoryStorageTest.this.storage.getObject(MemoryStorageTest.this.data[1], get1);
                } else {
                    MemoryStorageTest.this.stepException(new RuntimeException("SetUp did not complete correctly."));
                }
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        if (this.store) {
            this.setUp(get0);
        } else {
            get1.receiveResult("First Object");
        }
    }

    public void testExists(final Continuation c) {
        this.testRetreival(new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    MemoryStorageTest.this.sectionStart("Checking for Objects");
                    MemoryStorageTest.this.stepStart("Checking for First Object");
                    if (MemoryStorageTest.this.storage.exists(MemoryStorageTest.this.data[1])) {
                        MemoryStorageTest.this.stepDone("SUCCESS");
                    } else {
                        MemoryStorageTest.this.stepDone("FAILURE");
                    }
                    MemoryStorageTest.this.stepStart("Checking for Second Object");
                    if (MemoryStorageTest.this.storage.exists(MemoryStorageTest.this.data[2])) {
                        MemoryStorageTest.this.stepDone("SUCCESS");
                    } else {
                        MemoryStorageTest.this.stepDone("FAILURE");
                    }
                    MemoryStorageTest.this.stepStart("Checking for Third Object");
                    if (MemoryStorageTest.this.storage.exists(MemoryStorageTest.this.data[3])) {
                        MemoryStorageTest.this.stepDone("SUCCESS");
                    } else {
                        MemoryStorageTest.this.stepDone("FAILURE");
                    }
                    MemoryStorageTest.this.stepStart("Checking for Fourth Object");
                    if (MemoryStorageTest.this.storage.exists(MemoryStorageTest.this.data[4])) {
                        MemoryStorageTest.this.stepDone("SUCCESS");
                    } else {
                        MemoryStorageTest.this.stepDone("FAILURE");
                    }
                    MemoryStorageTest.this.stepStart("Checking for Fifth Object");
                    if (!MemoryStorageTest.this.storage.exists(MemoryStorageTest.this.data[5])) {
                        MemoryStorageTest.this.stepDone("SUCCESS");
                    } else {
                        MemoryStorageTest.this.stepDone("FAILURE");
                    }
                    MemoryStorageTest.this.sectionEnd();
                    MemoryStorageTest.this.sectionStart("Checking for Metadata");
                    MemoryStorageTest.this.stepStart("Checking for First Object Metadata");
                    if (MemoryStorageTest.this.metadata[1].equals(MemoryStorageTest.this.storage.getMetadata(MemoryStorageTest.this.data[1]))) {
                        MemoryStorageTest.this.stepDone("SUCCESS");
                    } else {
                        MemoryStorageTest.this.stepDone("FAILURE");
                    }
                    MemoryStorageTest.this.stepStart("Checking for Second Object Metadata");
                    if (MemoryStorageTest.this.metadata[2].equals(MemoryStorageTest.this.storage.getMetadata(MemoryStorageTest.this.data[2]))) {
                        MemoryStorageTest.this.stepDone("SUCCESS");
                    } else {
                        MemoryStorageTest.this.stepDone("FAILURE");
                    }
                    MemoryStorageTest.this.stepStart("Checking for Third Object Metadata");
                    if (MemoryStorageTest.this.metadata[3].equals(MemoryStorageTest.this.storage.getMetadata(MemoryStorageTest.this.data[3]))) {
                        MemoryStorageTest.this.stepDone("SUCCESS");
                    } else {
                        MemoryStorageTest.this.stepDone("FAILURE");
                    }
                    MemoryStorageTest.this.stepStart("Checking for Fourth Object Metadata");
                    if (MemoryStorageTest.this.metadata[4].equals(MemoryStorageTest.this.storage.getMetadata(MemoryStorageTest.this.data[4]))) {
                        MemoryStorageTest.this.stepDone("SUCCESS");
                    } else {
                        MemoryStorageTest.this.stepDone("FAILURE");
                    }
                    MemoryStorageTest.this.stepStart("Checking for Fifth Object Metadata");
                    if (!MemoryStorageTest.this.metadata[5].equals(MemoryStorageTest.this.storage.getMetadata(MemoryStorageTest.this.data[5]))) {
                        MemoryStorageTest.this.stepDone("SUCCESS");
                    } else {
                        MemoryStorageTest.this.stepDone("FAILURE");
                    }
                } else {
                    throw new RuntimeException("SetUp did not complete correctly!");
                }
                MemoryStorageTest.this.sectionEnd();
                MemoryStorageTest.this.sectionStart("Modifying Metadata");
                MemoryStorageTest.this.stepStart("Changing Metadata");
                MemoryStorageTest.this.storage.setMetadata(MemoryStorageTest.this.data[4], new Integer(5001), new Continuation(){

                    public void receiveResult(Object o) {
                        MemoryStorageTest.this.stepDone("SUCCESS");
                        MemoryStorageTest.this.stepStart("Checking for New Metadata");
                        if (new Integer(5001).equals(MemoryStorageTest.this.storage.getMetadata(MemoryStorageTest.this.data[4]))) {
                            MemoryStorageTest.this.stepDone("SUCCESS");
                        } else {
                            MemoryStorageTest.this.stepDone("FAILURE");
                        }
                        MemoryStorageTest.this.sectionEnd();
                        c.receiveResult(new Boolean(true));
                    }

                    public void receiveException(Exception e) {
                        MemoryStorageTest.this.stepException(e);
                    }
                });
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        });
    }

    private void testRemoval(final Continuation c) {
        final Continuation done1 = new Continuation(){

            public void receiveResult(Object o) {
                if (o == null) {
                    MemoryStorageTest.this.stepDone("SUCCESS");
                } else {
                    MemoryStorageTest.this.stepDone("FAILURE");
                }
                MemoryStorageTest.this.sectionEnd();
                c.receiveResult(new Boolean(true));
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        Continuation retrieve1 = new Continuation(){

            public void receiveResult(Object o) {
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        final Continuation check1 = new Continuation(){

            public void receiveResult(Object o) {
                if (!MemoryStorageTest.this.store || o.equals(new Boolean(true))) {
                    MemoryStorageTest.this.stepDone("SUCCESS");
                } else {
                    MemoryStorageTest.this.stepDone("FAILURE");
                }
                MemoryStorageTest.this.stepStart("Checking for First Object");
                boolean result = MemoryStorageTest.this.storage.exists(MemoryStorageTest.this.data[1]);
                if (!MemoryStorageTest.this.store || !result) {
                    MemoryStorageTest.this.stepDone("SUCCESS");
                } else {
                    MemoryStorageTest.this.stepDone("FAILURE");
                }
                MemoryStorageTest.this.stepStart("Attempting to Retrieve First Object");
                MemoryStorageTest.this.storage.getObject(MemoryStorageTest.this.data[1], done1);
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        Continuation remove1 = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    MemoryStorageTest.this.sectionStart("Testing Removal");
                    MemoryStorageTest.this.stepStart("Removing First Object");
                    MemoryStorageTest.this.storage.unstore(MemoryStorageTest.this.data[1], check1);
                } else {
                    MemoryStorageTest.this.stepException(new RuntimeException("Exists did not complete correctly."));
                }
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        this.testExists(remove1);
    }

    private void testScan(final Continuation c) {
        final Continuation handleBadScan = new Continuation(){

            public void receiveResult(Object o) {
                MemoryStorageTest.this.stepDone("FAILURE", "Query returned; should have thrown exception");
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.sectionEnd();
                c.receiveResult(new Boolean(true));
            }
        };
        final Continuation query = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    MemoryStorageTest.this.stepDone("SUCCESS");
                } else {
                    MemoryStorageTest.this.stepDone("FAILURE");
                }
                MemoryStorageTest.this.stepStart("Requesting Scan from 3 to 6");
                IdSet result = MemoryStorageTest.this.storage.scan(MemoryStorageTest.this.FACTORY.buildIdRange(MemoryStorageTest.this.data[3], MemoryStorageTest.this.data[6]));
                if (result.numElements() != 2) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Result had " + result.numElements() + " elements, expected 2.");
                    return;
                }
                if (!result.isMemberId(MemoryStorageTest.this.data[3]) || !result.isMemberId(MemoryStorageTest.this.data[4])) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Result had incorrect elements " + MemoryStorageTest.this.data[0] + ", " + MemoryStorageTest.this.data[1] + ", expected 3 and 4.");
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.stepStart("Requesting Scan from 8 to 10");
                result = MemoryStorageTest.this.storage.scan(MemoryStorageTest.this.FACTORY.buildIdRange(MemoryStorageTest.this.data[8], MemoryStorageTest.this.data[10]));
                if (result.numElements() != 0) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Result had " + result.numElements() + " elements, expected 0.");
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.stepStart("Requesting Scan from 'Monkey' to 9");
                handleBadScan.receiveException(new Exception());
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        Continuation insertString = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    MemoryStorageTest.this.sectionStart("Testing Scan");
                    MemoryStorageTest.this.stepStart("Inserting String as Key");
                    MemoryStorageTest.this.storage.store(MemoryStorageTest.this.data[11], null, (Serializable)((Object)"Monkey"), query);
                } else {
                    MemoryStorageTest.this.stepException(new RuntimeException("Removal did not complete correctly."));
                }
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        this.testRemoval(insertString);
    }

    private void testRandomInserts(final Continuation c) {
        int START_NUM = 10;
        int END_NUM = 98;
        int SKIP = 2;
        int NUM_ELEMENTS = 45;
        final Continuation checkRandom = new Continuation(){

            public void receiveResult(Object o) {
                MemoryStorageTest.this.stepStart("Checking object deletion");
                int NUM_DELETED = (Integer)o;
                int length = MemoryStorageTest.this.storage.scan(MemoryStorageTest.this.FACTORY.buildIdRange(MemoryStorageTest.this.data[23], MemoryStorageTest.this.data[113])).numElements();
                int desired = 45 - NUM_DELETED;
                if (length != desired) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Expected " + desired + " objects after deletes, found " + length + ".");
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.sectionEnd();
                c.receiveResult(new Boolean(true));
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        final Continuation removeRandom = new Continuation(){
            private int count = 10;
            private int num_deleted = 0;

            public void receiveResult(Object o) {
                if (this.count == 10) {
                    MemoryStorageTest.this.stepStart("Removing random subset of objects");
                }
                if (o.equals(new Boolean(false))) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Deletion of " + this.count + " failed.");
                    return;
                }
                if (this.count == 98) {
                    MemoryStorageTest.this.stepDone("SUCCESS");
                    checkRandom.receiveResult(new Integer(this.num_deleted));
                    return;
                }
                if (MemoryStorageTest.this.environment.getRandomSource().nextBoolean()) {
                    ++this.num_deleted;
                    MemoryStorageTest.this.storage.unstore(MemoryStorageTest.this.data[13 + (this.count += 2)], this);
                } else {
                    this.count += 2;
                    this.receiveResult(new Boolean(true));
                }
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        final Continuation checkScan = new Continuation(){
            private int count = 10;

            public void receiveResult(Object o) {
                MemoryStorageTest.this.stepStart("Checking scans for all ranges");
                for (int count = 10; count < 96; count += 2) {
                    IdSet result = MemoryStorageTest.this.storage.scan(MemoryStorageTest.this.FACTORY.buildIdRange(MemoryStorageTest.this.data[13 + (count += 2)], MemoryStorageTest.this.data[111]));
                    int i = 45 - (count - 10 + 2) / 2;
                    if (result.numElements() == i) continue;
                    MemoryStorageTest.this.stepDone("FAILURE", "Expected " + i + " found " + result.numElements() + " keys in scan from " + count + " to " + 98 + ".");
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                removeRandom.receiveResult(new Boolean(true));
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        final Continuation checkExists = new Continuation(){

            public void receiveResult(Object o) {
                MemoryStorageTest.this.stepStart("Checking exists for all 50 objects");
                for (int count = 10; count < 98; count += 2) {
                    boolean b = MemoryStorageTest.this.storage.exists(MemoryStorageTest.this.data[13 + count]);
                    if (b) continue;
                    MemoryStorageTest.this.stepDone("FAILURE", "Element " + count + " did exist (" + MemoryStorageTest.this.data[13 + count].toStringFull() + ") - should not have (START " + 10 + " END " + 98 + ").");
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                checkScan.receiveResult(new Boolean(true));
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        Continuation insert = new Continuation(){
            private int count = 10;

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(false))) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Insertion of " + this.count + " failed.");
                    return;
                }
                if (this.count == 10) {
                    MemoryStorageTest.this.sectionStart("Stress Testing");
                    MemoryStorageTest.this.stepStart("Inserting 40 objects from 100 to 1000000 bytes");
                }
                if (this.count > 98) {
                    MemoryStorageTest.this.stepDone("SUCCESS");
                    checkExists.receiveResult(new Boolean(true));
                    return;
                }
                int num = this.count;
                this.count += 2;
                MemoryStorageTest.this.storage.store(MemoryStorageTest.this.data[13 + num], null, (Serializable)new byte[num * num], this);
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        this.testScan(insert);
    }

    private void testErrors(final Continuation c) {
        final Continuation validateNullValue = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Null value should return false");
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.sectionEnd();
                c.receiveResult(new Boolean(true));
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        final Continuation insertNullValue = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Null key should return false");
                    return;
                }
                MemoryStorageTest.this.stepDone("SUCCESS");
                MemoryStorageTest.this.stepStart("Inserting null value");
                MemoryStorageTest.this.storage.store(MemoryStorageTest.this.data[12], null, null, validateNullValue);
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        Continuation insertNullKey = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(false))) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Randon insert tests failed.");
                    return;
                }
                MemoryStorageTest.this.sectionStart("Testing Error Cases");
                MemoryStorageTest.this.stepStart("Inserting null key");
                MemoryStorageTest.this.storage.store(null, null, (Serializable)((Object)"null key"), insertNullValue);
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        };
        this.testRandomInserts(insertNullKey);
    }

    public void testVariableLength() {
        final HashSet tmp = new HashSet();
        final HashSet all = new HashSet();
        this.testErrors(new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(false))) {
                    MemoryStorageTest.this.stepDone("FAILURE", "Error tests failed");
                    return;
                }
                MemoryStorageTest.this.sectionStart("Testing variable-length Ids");
                MemoryStorageTest.this.stepStart("Inserting a whole bunch of Ids");
                new Continuation(){
                    int num = 0;

                    public void receiveResult(Object o) {
                        if (o.equals(new Boolean(false))) {
                            MemoryStorageTest.this.stepDone("FAILURE", "Insert of Id #" + this.num + " failed");
                            return;
                        }
                        if (this.num < 1000) {
                            ++this.num;
                            MemoryStorageTest.this.storage.store(new VariableId(this.num), null, (Serializable)((Object)(this.num + " length")), this);
                        } else {
                            MemoryStorageTest.this.stepDone("SUCCESS");
                            MemoryStorageTest.this.stepStart("Reinserting same Ids");
                            new Continuation(){
                                int num = 0;

                                public void receiveResult(Object o) {
                                    if (o.equals(new Boolean(false))) {
                                        MemoryStorageTest.this.stepDone("FAILURE", "Reinsert of Id #" + this.num + " failed");
                                        return;
                                    }
                                    if (this.num < 1000) {
                                        ++this.num;
                                        VariableId id = new VariableId(this.num);
                                        all.add(id);
                                        tmp.add(id);
                                        MemoryStorageTest.this.storage.store(new VariableId(this.num), null, (Serializable)((Object)(this.num + " length")), this);
                                    } else {
                                        MemoryStorageTest.this.stepDone("SUCCESS");
                                        MemoryStorageTest.this.stepStart("Deleting all Ids again");
                                        new Continuation(){
                                            Id id = null;

                                            public void receiveResult(Object o) {
                                                if (o.equals(new Boolean(false))) {
                                                    MemoryStorageTest.this.stepDone("FAILURE", "Delete of Id " + this.id + " failed");
                                                    return;
                                                }
                                                if (tmp.size() > 0) {
                                                    this.id = (Id)tmp.iterator().next();
                                                    tmp.remove(this.id);
                                                    MemoryStorageTest.this.storage.unstore(this.id, this);
                                                } else {
                                                    MemoryStorageTest.this.stepDone("SUCCESS");
                                                    MemoryStorageTest.this.sectionEnd();
                                                    System.out.println("All tests completed successfully - exiting.");
                                                    System.exit(0);
                                                }
                                            }

                                            public void receiveException(Exception e) {
                                                MemoryStorageTest.this.stepException(e);
                                            }
                                        }.receiveResult(Boolean.TRUE);
                                    }
                                }

                                public void receiveException(Exception e) {
                                    MemoryStorageTest.this.stepException(e);
                                }
                            }.receiveResult(Boolean.TRUE);
                        }
                    }

                    public void receiveException(Exception e) {
                        MemoryStorageTest.this.stepException(e);
                    }
                }.receiveResult(Boolean.TRUE);
            }

            public void receiveException(Exception e) {
                MemoryStorageTest.this.stepException(e);
            }
        });
    }

    public void start() {
        this.testVariableLength();
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws IOException {
        MemoryStorageTest test = new MemoryStorageTest(true, new Environment());
        test.start();
    }

    public class VariableId
    implements Id {
        protected int num;
        public static final short TYPE = 4893;
        public static final String STRING = "0123456789ABCDEF";

        public VariableId(int num) {
            this.num = num;
        }

        public boolean isBetween(Id ccw, Id cw) {
            return false;
        }

        public int getByteArrayLength() {
            return 0;
        }

        public short getType() {
            return 4893;
        }

        public boolean clockwise(Id nid) {
            return false;
        }

        public Id addToId(Id.Distance offset) {
            return null;
        }

        public Id.Distance distanceFromId(Id nid) {
            return null;
        }

        public Id.Distance longDistanceFromId(Id nid) {
            return null;
        }

        public byte[] toByteArray() {
            return null;
        }

        public void toByteArray(byte[] array, int offset) {
        }

        public String toStringFull() {
            if (this.num <= STRING.length()) {
                return STRING.substring(0, this.num);
            }
            return STRING + this.num;
        }

        public int compareTo(Object o) {
            return 0;
        }

        public void serialize(OutputBuffer buf) throws IOException {
            buf.writeInt(this.num);
        }
    }
}

