/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.io.IOException;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Vector;
import rice.environment.Environment;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.pastry.testing.PingClient;

public class PastryTest {
    private DirectPastryNodeFactory factory;
    private NetworkSimulator simulator;
    private Vector pastryNodes;
    private Vector pingClients;
    private Environment environment;

    public PastryTest(Environment env) {
        this.environment = env;
        this.simulator = new EuclideanNetwork(env);
        this.factory = new DirectPastryNodeFactory(new RandomNodeIdFactory(env), this.simulator, env);
        this.pastryNodes = new Vector();
        this.pingClients = new Vector();
    }

    private NodeHandle getBootstrap() {
        NodeHandle bootstrap = null;
        try {
            PastryNode lastnode = (PastryNode)this.pastryNodes.lastElement();
            bootstrap = lastnode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return bootstrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePastryNode() {
        PastryNode pn = this.factory.newNode(this.getBootstrap());
        this.pastryNodes.addElement(pn);
        PingClient pc = new PingClient(pn);
        this.pingClients.addElement(pc);
        PastryNode pastryNode = pn;
        synchronized (pastryNode) {
            while (!pn.isReady()) {
                try {
                    pn.wait();
                }
                catch (InterruptedException ie) {}
            }
        }
    }

    public void sendPings(int k) {
        int n = this.pingClients.size();
        for (int i = 0; i < k; ++i) {
            int from = this.environment.getRandomSource().nextInt(n);
            int to = this.environment.getRandomSource().nextInt(n);
            PingClient pc = (PingClient)this.pingClients.get(from);
            PastryNode pn = (PastryNode)this.pastryNodes.get(to);
            pc.sendTrace(pn.getNodeId());
            while (this.simulate()) {
            }
            System.out.println("-------------------");
        }
    }

    public boolean simulate() {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
        PastryTest pt = new PastryTest(Environment.directEnvironment());
        int n = 4000;
        int m = 100;
        int k = 10;
        int msgCount = 0;
        Date old = new Date();
        for (int i = 0; i < n; ++i) {
            pt.makePastryNode();
            if (i % 100 == 0) {
                System.out.println("Created node " + i + "/" + n);
            }
            ++msgCount;
            if ((i + 1) % m != 0) continue;
            Date now = new Date();
            System.out.println(i + 1 + " " + (now.getTime() - old.getTime()) + " " + msgCount);
            msgCount = 0;
            old = now;
        }
        System.out.println(n + " nodes constructed");
        pt.sendPings(k);
    }
}

