/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RouterAddress;

public class StandardRouter
extends PastryAppl {
    public StandardRouter(PastryNode thePastryNode) {
        super(thePastryNode, RouterAddress.getCode());
    }

    public void receiveMessage(Message msg) {
        if (!(msg instanceof RouteMessage)) {
            throw new Error("message " + msg + " bounced at StandardRouter");
        }
        this.route((RouteMessage)msg);
    }

    private void route(RouteMessage rm) {
        if (!rm.routeMessage(this.thePastryNode.getLocalHandle())) {
            this.receiveRouteMessage(rm);
        }
    }

    private void receiveRouteMessage(RouteMessage msg) {
        Id target;
        if (this.logger.level <= 400) {
            this.logger.log("receiveRouteMessage(" + msg + ")");
        }
        if ((target = msg.getTarget()) == null) {
            target = this.thePastryNode.getNodeId();
        }
        int cwSize = this.thePastryNode.getLeafSet().cwSize();
        int ccwSize = this.thePastryNode.getLeafSet().ccwSize();
        int lsPos = this.thePastryNode.getLeafSet().mostSimilar(target);
        if (lsPos == 0) {
            msg.nextHop = this.thePastryNode.getLocalHandle();
        } else if (lsPos > 0 && (lsPos < cwSize || !this.thePastryNode.getLeafSet().get(lsPos).getNodeId().clockwise(target)) || lsPos < 0 && (-lsPos < ccwSize || this.thePastryNode.getLeafSet().get(lsPos).getNodeId().clockwise(target))) {
            NodeHandle handle;
            if (this.logger.level <= 300) {
                this.logger.log("receiveRouteMessage(" + msg + "):1");
            }
            if (!(handle = this.thePastryNode.getLeafSet().get(lsPos)).isAlive()) {
                this.thePastryNode.getLeafSet().remove(handle);
                this.receiveRouteMessage(msg);
                return;
            }
            msg.nextHop = handle;
            msg.getOptions().setRerouteIfSuspected(false);
            this.thePastryNode.getRoutingTable().put(handle);
        } else {
            if (this.logger.level <= 300) {
                this.logger.log("receiveRouteMessage(" + msg + "):2");
            }
            RouteSet rs = this.thePastryNode.getRoutingTable().getBestEntry(target);
            NodeHandle handle = null;
            if (rs == null || (handle = rs.closestNode(1)) == null) {
                if (rs != null) {
                    for (int index = 0; index < rs.size(); ++index) {
                        NodeHandle nh = rs.get(index);
                        if (nh.isAlive()) continue;
                        rs.remove(nh);
                        --index;
                    }
                }
                if ((handle = this.thePastryNode.getRoutingTable().bestAlternateRoute(1, target)) == null) {
                    handle = this.thePastryNode.getLeafSet().get(lsPos);
                    if (!handle.isAlive()) {
                        this.thePastryNode.getLeafSet().remove(handle);
                        this.receiveRouteMessage(msg);
                        return;
                    }
                    msg.getOptions().setRerouteIfSuspected(false);
                } else {
                    if (this.logger.level <= 300) {
                        this.logger.log("receiveRouteMessage(" + msg + "):3");
                    }
                    Id.Distance altDist = handle.getNodeId().distance(target);
                    Id.Distance lsDist = this.thePastryNode.getLeafSet().get(lsPos).getNodeId().distance(target);
                    if (lsDist.compareTo(altDist) < 0) {
                        handle = this.thePastryNode.getLeafSet().get(lsPos);
                        if (!handle.isAlive()) {
                            this.thePastryNode.getLeafSet().remove(handle);
                            this.receiveRouteMessage(msg);
                            return;
                        }
                        msg.getOptions().setRerouteIfSuspected(false);
                    }
                }
            }
            msg.nextHop = handle;
        }
        this.checkForRouteTableHole(msg, msg.nextHop);
        msg.setPrevNode(this.thePastryNode.getLocalHandle());
        this.thePastryNode.receiveMessage(msg);
    }

    private void checkForRouteTableHole(RouteMessage msg, NodeHandle handle) {
        Id key;
        int index;
        NodeHandle prevNode;
        if (this.logger.level <= 300) {
            this.logger.log("checkForRouteTableHole(" + msg + "," + handle + ")");
        }
        if ((prevNode = msg.getPrevNode()) == null) {
            if (this.logger.level <= 400) {
                this.logger.log("No prevNode defined in " + msg);
            }
            return;
        }
        if (prevNode.equals(this.getNodeHandle())) {
            if (this.logger.level <= 400) {
                this.logger.log("prevNode is me in " + msg);
            }
            return;
        }
        LeafSet ls = this.thePastryNode.getLeafSet();
        if (ls.overlaps()) {
            return;
        }
        if (ls.member(prevNode) && (index = ls.getIndex(prevNode)) != ls.cwSize() && index != -ls.ccwSize()) {
            return;
        }
        Id prevId = prevNode.getNodeId();
        int diffDigit = prevId.indexOfMSDD(key = msg.getTarget(), this.thePastryNode.getRoutingTable().baseBitLength());
        if (diffDigit == this.thePastryNode.getNodeId().indexOfMSDD(key, this.thePastryNode.getRoutingTable().baseBitLength())) {
            RouteSet[] row = this.thePastryNode.getRoutingTable().getRow(diffDigit);
            BroadcastRouteRow brr = new BroadcastRouteRow(this.thePastryNode.getLocalHandle(), row);
            if (prevNode.isAlive()) {
                if (this.logger.level <= 500) {
                    this.logger.log("Found hole in " + prevNode + "'s routing table. Sending " + brr.toStringFull());
                }
                this.thePastryNode.send(prevNode, brr);
            }
        }
    }

    public boolean deliverWhenNotReady() {
        return true;
    }

    public void messageForAppl(Message msg) {
        throw new RuntimeException("Should not be called.");
    }
}

