/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.io.IOException;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.PJavaSerializedDeserializer;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.InitiateRouteSetMaintenance;
import rice.pastry.routing.RequestRouteRow;
import rice.pastry.routing.RouteProtocolAddress;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;

public class StandardRouteSetProtocol
extends PastryAppl {
    private final int maxTrials;
    private RoutingTable routeTable;
    private Environment environmet;
    protected Logger logger;

    public StandardRouteSetProtocol(PastryNode ln, RoutingTable rt, Environment env) {
        this(ln, rt, env, null);
    }

    public StandardRouteSetProtocol(PastryNode ln, RoutingTable rt, Environment env, MessageDeserializer md) {
        super(ln, null, RouteProtocolAddress.getCode(), md == null ? new SRSPDeserializer(ln) : md);
        this.environmet = env;
        this.maxTrials = (1 << rt.baseBitLength()) / 2;
        this.routeTable = rt;
        this.logger = env.getLogManager().getLogger(this.getClass(), null);
    }

    public void messageForAppl(Message msg) {
        if (msg instanceof BroadcastRouteRow) {
            BroadcastRouteRow brr = (BroadcastRouteRow)msg;
            if (this.logger.level <= 405) {
                this.logger.log("Received " + brr.toStringFull());
            }
            RouteSet[] row = brr.getRow();
            NodeHandle nh = brr.from();
            if (nh.isAlive()) {
                this.routeTable.put(nh);
            }
            for (int i = 0; i < row.length; ++i) {
                RouteSet rs = row[i];
                for (int j = 0; rs != null && j < rs.size(); ++j) {
                    nh = rs.get(j);
                    if (!nh.isAlive()) continue;
                    this.routeTable.put(nh);
                }
            }
        } else if (msg instanceof RequestRouteRow) {
            RequestRouteRow rrr = (RequestRouteRow)msg;
            int reqRow = rrr.getRow();
            NodeHandle nh = rrr.returnHandle();
            RouteSet[] row = this.routeTable.getRow(reqRow);
            BroadcastRouteRow brr = new BroadcastRouteRow(this.thePastryNode.getLocalHandle(), row);
            if (this.logger.level <= 405) {
                this.logger.log("Responding to " + rrr + " with " + brr.toStringFull());
            }
            this.thePastryNode.send(nh, brr);
        } else if (msg instanceof InitiateRouteSetMaintenance) {
            this.maintainRouteSet();
        } else {
            throw new Error("StandardRouteSetProtocol: received message is of unknown type");
        }
    }

    private void maintainRouteSet() {
        if (this.logger.level <= 800) {
            this.logger.log("maintainRouteSet " + this.thePastryNode.getLocalHandle().getNodeId());
        }
        for (byte i = (byte)(this.routeTable.numRows() - 1); i >= 0; i = (byte)(i - 1)) {
            int j;
            RouteSet[] row = this.routeTable.getRow(i);
            BroadcastRouteRow brr = new BroadcastRouteRow(this.thePastryNode.getLocalHandle(), row);
            RequestRouteRow rrr = new RequestRouteRow(this.thePastryNode.getLocalHandle(), i);
            int myCol = this.thePastryNode.getLocalHandle().getNodeId().getDigit(i, this.routeTable.baseBitLength());
            for (j = 0; j < this.maxTrials; ++j) {
                RouteSet rs;
                int col = this.environmet.getRandomSource().nextInt(this.routeTable.numColumns());
                if (col == myCol || (rs = row[col]) == null || rs.size() <= 0) continue;
                NodeHandle nh = rs.closestNode(10);
                if (!nh.isAlive()) {
                    if (this.logger.level <= 500) {
                        this.logger.log("found dead node in table:" + nh);
                    }
                    rs.remove(nh);
                    break;
                }
                if (this.logger.level <= 500) {
                    this.logger.log("swapping with " + (i + 1) + "/" + this.routeTable.numRows() + " " + (j + 1) + "/" + this.maxTrials + ":" + nh);
                }
                this.thePastryNode.send(nh, brr);
                this.thePastryNode.send(nh, rrr);
                break;
            }
            if (j == this.maxTrials) break;
        }
    }

    public boolean deliverWhenNotReady() {
        return true;
    }

    static class SRSPDeserializer
    extends PJavaSerializedDeserializer {
        public SRSPDeserializer(PastryNode pn) {
            super(pn);
        }

        public Message deserialize(InputBuffer buf, short type, byte priority, NodeHandle sender) throws IOException {
            switch (type) {
                case 1: {
                    return new RequestRouteRow(sender, buf);
                }
                case 2: {
                    return new BroadcastRouteRow(buf, this.pn, this.pn);
                }
            }
            return null;
        }
    }
}

