/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.io.IOException;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.pastry.Id;
import rice.pastry.JoinFailedException;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.join.InitiateJoin;
import rice.pastry.join.JoinAddress;
import rice.pastry.join.JoinRequest;
import rice.pastry.leafset.BroadcastLeafSet;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.PJavaSerializedDeserializer;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;

public class StandardJoinProtocol
extends PastryAppl {
    protected NodeHandle localHandle;
    protected RoutingTable routeTable;
    protected LeafSet leafSet;

    public StandardJoinProtocol(PastryNode ln, NodeHandle lh, RoutingTable rt, LeafSet ls) {
        this(ln, lh, rt, ls, null);
    }

    public StandardJoinProtocol(PastryNode ln, NodeHandle lh, RoutingTable rt, LeafSet ls, MessageDeserializer md) {
        super(ln, null, JoinAddress.getCode(), md == null ? new SJPDeserializer(ln) : md);
        this.localHandle = lh;
        this.routeTable = rt;
        this.leafSet = ls;
    }

    public int getAddress() {
        return JoinAddress.getCode();
    }

    protected void setReady() {
        this.thePastryNode.setReady();
    }

    public void receiveMessage(Message msg) {
        block24: {
            if (msg instanceof JoinRequest) {
                JoinRequest jr = (JoinRequest)msg;
                NodeHandle nh = jr.getHandle();
                if (!jr.accepted()) {
                    if (this.thePastryNode.isReady()) {
                        jr.acceptJoin(this.localHandle, this.leafSet);
                        this.thePastryNode.send(nh, jr);
                    } else if (this.logger.level <= 800) {
                        this.logger.log("NOTE: Dropping incoming JoinRequest " + jr + " because local node is not ready!");
                    }
                } else {
                    NodeHandle jh = jr.getJoinHandle();
                    if (jh.getId().equals(this.localHandle.getId()) && !jh.equals(this.localHandle)) {
                        if (this.logger.level <= 900) {
                            this.logger.log("NodeId collision, unable to join: " + this.localHandle + ":" + jh);
                        }
                    } else if (jh.isAlive()) {
                        this.routeTable.put(jh);
                        this.broadcastRows(jr);
                        BroadcastLeafSet bls = new BroadcastLeafSet(jh, jr.getLeafSet(), 1, 0L);
                        this.thePastryNode.receiveMessage(bls);
                        this.setReady();
                    }
                }
            } else {
                if (msg instanceof RouteMessage) {
                    RouteMessage rm = (RouteMessage)msg;
                    try {
                        JoinRequest jr = (JoinRequest)rm.unwrap(this.deserializer);
                        Id localId = this.localHandle.getNodeId();
                        NodeHandle jh = jr.getHandle();
                        Id nid = jh.getNodeId();
                        if (!jh.equals(this.localHandle)) {
                            byte base = this.thePastryNode.getRoutingTable().baseBitLength();
                            int msdd = localId.indexOfMSDD(nid, base);
                            int last = jr.lastRow();
                            for (int i = last - 1; msdd > 0 && i >= msdd; --i) {
                                RouteSet[] row = this.routeTable.getRow(i);
                                jr.pushRow(row);
                            }
                            rm.routeMessage(this.localHandle);
                        }
                        break block24;
                    }
                    catch (IOException ioe) {
                        if (this.logger.level <= 1000) {
                            this.logger.logException("StandardJoinProtocol.receiveMessage()", ioe);
                        }
                        break block24;
                    }
                }
                if (msg instanceof InitiateJoin) {
                    InitiateJoin ij = (InitiateJoin)msg;
                    NodeHandle nh = ij.getHandle();
                    if (nh == null) {
                        if (this.logger.level <= 1000) {
                            this.logger.log("ERROR: Cannot join ring.  All bootstraps are faulty." + ij);
                        }
                        this.thePastryNode.joinFailed(new JoinFailedException("Cannot join ring.  All bootstraps are faulty." + ij));
                    } else if (nh.isAlive()) {
                        JoinRequest jr = new JoinRequest(this.localHandle, this.thePastryNode.getRoutingTable().baseBitLength());
                        RouteMessage rm = new RouteMessage(this.localHandle.getNodeId(), jr);
                        rm.getOptions().setRerouteIfSuspected(false);
                        rm.setPrevNode(this.localHandle);
                        try {
                            nh.bootstrap(rm);
                        }
                        catch (IOException ioe) {
                            if (this.logger.level > 1000) break block24;
                            this.logger.logException("Error bootstrapping.", ioe);
                        }
                    }
                }
            }
        }
    }

    public void broadcastRows(JoinRequest jr) {
        BroadcastRouteRow brr;
        RouteSet[] row;
        int i;
        int n = jr.numRows();
        for (i = jr.lastRow(); i < n; ++i) {
            row = jr.getRow(i);
            if (row == null) continue;
            brr = new BroadcastRouteRow(this.localHandle, row);
            this.thePastryNode.receiveMessage(brr);
        }
        for (i = jr.lastRow(); i < n; ++i) {
            row = jr.getRow(i);
            brr = new BroadcastRouteRow(this.localHandle, row);
            for (int j = 0; j < row.length; ++j) {
                NodeHandle nh;
                RouteSet rs = row[j];
                if (rs == null || (nh = rs.closestNode()) == null) continue;
                this.thePastryNode.send(nh, brr);
            }
        }
    }

    public void messageForAppl(Message msg) {
        throw new RuntimeException("Should not be called.");
    }

    public boolean deliverWhenNotReady() {
        return true;
    }

    static class SJPDeserializer
    extends PJavaSerializedDeserializer {
        public SJPDeserializer(PastryNode pn) {
            super(pn);
        }

        public Message deserialize(InputBuffer buf, short type, byte priority, NodeHandle sender) throws IOException {
            switch (type) {
                case 1: {
                    return new JoinRequest(buf, this.pn, sender, this.pn);
                }
            }
            return null;
        }
    }
}

