/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.messaging;

import java.io.IOException;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.socket.SourceRoute;
import rice.pastry.socket.messaging.SocketMessage;

public class RoutesResponseMessage
extends SocketMessage {
    private SourceRoute[] routes;
    public static final short TYPE = 13;

    public RoutesResponseMessage(SourceRoute[] routes) {
        this.routes = routes;
    }

    public RoutesResponseMessage(InputBuffer buf) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                int numRoutes = buf.readInt();
                this.routes = new SourceRoute[numRoutes];
                for (int i = 0; i < numRoutes; ++i) {
                    this.routes[i] = SourceRoute.build(buf);
                }
                break;
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }

    public SourceRoute[] getRoutes() {
        return this.routes;
    }

    public short getType() {
        return 13;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        buf.writeInt(this.routes.length);
        for (int i = 0; i < this.routes.length; ++i) {
            this.routes[i].serialize(buf);
        }
    }
}

