/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.WeakHashMap;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.socket.EpochInetSocketAddress;

public class SourceRoute
extends PRawMessage
implements Serializable {
    protected EpochInetSocketAddress[] path;
    private static final long serialVersionUID = -4402277039316685149L;
    private static WeakHashMap SOURCE_ROUTE_MAP = new WeakHashMap();
    public static final short TYPE = 1;

    private SourceRoute(EpochInetSocketAddress[] path) {
        super(0);
        this.path = path;
    }

    public EpochInetSocketAddress getFirstHop() {
        return this.path[0];
    }

    public EpochInetSocketAddress getLastHop() {
        return this.path[this.path.length - 1];
    }

    public int getNumHops() {
        return this.path.length;
    }

    public EpochInetSocketAddress getHop(int i) {
        return this.path[i];
    }

    public boolean isDirect() {
        return this.path.length == 1;
    }

    public short getType() {
        return 1;
    }

    private Object readResolve() throws ObjectStreamException {
        return SourceRoute.resolve(SOURCE_ROUTE_MAP, this);
    }

    public int hashCode() {
        int result = 399388937;
        for (int i = 0; i < this.path.length; ++i) {
            result ^= this.path[i].hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        boolean ret = Arrays.equals(this.path, ((SourceRoute)o).path);
        return ret;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        for (int i = 0; i < this.path.length; ++i) {
            EpochInetSocketAddress thePath = this.path[i];
            for (int ctr = 0; ctr < thePath.address.length; ++ctr) {
                InetSocketAddress theAddr = thePath.address[ctr];
                InetAddress theAddr2 = theAddr.getAddress();
                if (theAddr2 == null) {
                    result.append(theAddr.toString());
                } else {
                    String ha = theAddr2.getHostAddress();
                    result.append(ha + ":" + theAddr.getPort());
                }
                if (ctr >= thePath.address.length - 1) continue;
                result.append(";");
            }
            if (i >= this.path.length - 1) continue;
            result.append(" -> ");
        }
        result.append("}");
        return result.toString();
    }

    public String toStringFull() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        for (int i = 0; i < this.path.length; ++i) {
            result.append(this.path[i].toString());
            if (i >= this.path.length - 1) continue;
            result.append(" -> ");
        }
        result.append("}");
        return result.toString();
    }

    public SourceRoute reverse(EpochInetSocketAddress localAddress) {
        EpochInetSocketAddress[] result = new EpochInetSocketAddress[this.path.length];
        for (int i = 0; i < this.path.length - 1; ++i) {
            result[i] = this.path[this.path.length - 2 - i];
        }
        result[result.length - 1] = localAddress;
        return SourceRoute.build(result);
    }

    public SourceRoute reverse() {
        EpochInetSocketAddress[] result = new EpochInetSocketAddress[this.path.length];
        for (int i = 0; i < this.path.length; ++i) {
            result[i] = this.path[this.path.length - 1 - i];
        }
        return SourceRoute.build(result);
    }

    public boolean goesThrough(EpochInetSocketAddress address) {
        for (int i = 0; i < this.path.length; ++i) {
            if (!this.path[i].equals(address)) continue;
            return true;
        }
        return false;
    }

    public SourceRoute removeLastHop() {
        EpochInetSocketAddress[] result = new EpochInetSocketAddress[this.path.length - 1];
        System.arraycopy(this.path, 0, result, 0, result.length);
        return SourceRoute.build(result);
    }

    public SourceRoute append(EpochInetSocketAddress address) {
        EpochInetSocketAddress[] result = new EpochInetSocketAddress[this.path.length + 1];
        System.arraycopy(this.path, 0, result, 0, this.path.length);
        result[result.length - 1] = address;
        return SourceRoute.build(result);
    }

    public SourceRoute prepend(EpochInetSocketAddress address) {
        EpochInetSocketAddress[] result = new EpochInetSocketAddress[this.path.length + 1];
        System.arraycopy(this.path, 0, result, 1, this.path.length);
        result[0] = address;
        return SourceRoute.build(result);
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        buf.writeInt(this.path.length);
        for (int i = 0; i < this.path.length; ++i) {
            this.path[i].serialize(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SourceRoute resolve(WeakHashMap map, SourceRoute route) {
        WeakHashMap weakHashMap = map;
        synchronized (weakHashMap) {
            WeakReference ref = (WeakReference)map.get(route);
            SourceRoute result = null;
            if (ref != null && (result = (SourceRoute)ref.get()) != null) {
                return result;
            }
            map.put(route, new WeakReference<SourceRoute>(route));
            return route;
        }
    }

    public static SourceRoute build(EpochInetSocketAddress[] path) {
        return SourceRoute.resolve(SOURCE_ROUTE_MAP, new SourceRoute(path));
    }

    public static SourceRoute build(EpochInetSocketAddress address) {
        return SourceRoute.resolve(SOURCE_ROUTE_MAP, new SourceRoute(new EpochInetSocketAddress[]{address}));
    }

    public static SourceRoute build(InputBuffer buf) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                int numInPath = buf.readInt();
                EpochInetSocketAddress[] path = new EpochInetSocketAddress[numInPath];
                for (int i = 0; i < numInPath; ++i) {
                    path[i] = EpochInetSocketAddress.build(buf);
                }
                return new SourceRoute(path);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }
}

