/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

public class EpochInetSocketAddress
implements Serializable {
    protected InetSocketAddress[] address;
    protected long epoch;
    private static final long serialVersionUID = 2081191512212313338L;
    public static final long EPOCH_UNKNOWN = -1L;

    public EpochInetSocketAddress(InetSocketAddress address) {
        this(address, -1L);
    }

    public EpochInetSocketAddress(InetSocketAddress address, long epoch) {
        this(new InetSocketAddress[]{address}, epoch);
    }

    public EpochInetSocketAddress(InetSocketAddress[] addressList, long epoch) {
        this.address = addressList;
        this.epoch = epoch;
    }

    public InetSocketAddress getAddress(EpochInetSocketAddress local) {
        try {
            for (int ctr = 0; ctr < this.address.length; ++ctr) {
                if (this.address[ctr].getAddress().equals(local.address[ctr].getAddress())) continue;
                return this.address[ctr];
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new RuntimeException("ArrayIndexOutOfBoundsException in " + this + ".getAddress(" + local + ")", aioobe);
        }
        return this.address[this.address.length - 1];
    }

    public InetSocketAddress getAddress(InetAddress[] local) {
        try {
            for (int ctr = 0; ctr < this.address.length; ++ctr) {
                if (this.address[ctr].getAddress().equals(local[ctr])) continue;
                return this.address[ctr];
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            String s = "";
            for (int ctr = 0; ctr < local.length; ++ctr) {
                s = s + local[ctr];
                if (ctr >= local.length - 1) continue;
                s = s + ":";
            }
            throw new RuntimeException("ArrayIndexOutOfBoundsException in " + this + ".getAddress(" + local + ")", aioobe);
        }
        return this.address[this.address.length - 1];
    }

    public InetSocketAddress getInnermostAddress() {
        return this.address[this.address.length - 1];
    }

    public long getEpoch() {
        return this.epoch;
    }

    public short getSerializedLength() {
        return (short)(9 + this.address.length * 6);
    }

    public int hashCode() {
        int result = (int)this.epoch;
        for (int i = 0; i < this.address.length; ++i) {
            result ^= this.address[i].hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        EpochInetSocketAddress that = (EpochInetSocketAddress)o;
        if (this.epoch != that.epoch) {
            return false;
        }
        return this.addressEquals(that);
    }

    public boolean addressEquals(EpochInetSocketAddress that) {
        if (this.address.length != that.address.length) {
            return false;
        }
        for (int ctr = 0; ctr < this.address.length; ++ctr) {
            if (this.address[ctr].equals(that.address[ctr])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "";
        for (int ctr = 0; ctr < this.address.length; ++ctr) {
            s = s + this.address[ctr];
            if (ctr >= this.address.length - 1) continue;
            s = s + ":";
        }
        return s + " [" + this.epoch + "]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)this.address.length);
        for (int ctr = 0; ctr < this.address.length; ++ctr) {
            buf.write(this.address[ctr].getAddress().getAddress(), 0, 4);
            buf.writeShort((short)this.address[ctr].getPort());
        }
        buf.writeLong(this.epoch);
    }

    public static EpochInetSocketAddress build(InputBuffer buf) throws IOException {
        int numAddresses = buf.readByte();
        InetSocketAddress[] saddr = new InetSocketAddress[numAddresses];
        for (int ctr = 0; ctr < numAddresses; ++ctr) {
            byte[] addrBytes = new byte[4];
            buf.read(addrBytes);
            InetAddress addr = InetAddress.getByAddress(addrBytes);
            short port = buf.readShort();
            saddr[ctr] = new InetSocketAddress(addr, (int)port);
        }
        long epoch = buf.readLong();
        return new EpochInetSocketAddress(saddr, epoch);
    }
}

