/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import rice.environment.logging.Logger;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.NodeSetEventSource;
import rice.pastry.NodeSetListener;
import rice.pastry.NodeSetUpdate;
import rice.pastry.PastryNode;
import rice.pastry.routing.RouteSet;

public class RoutingTable
extends Observable
implements NodeSetEventSource {
    public byte idBaseBitLength;
    private Id myNodeId;
    public NodeHandle myNodeHandle;
    protected PastryNode pn;
    private RouteSet[][] routingTable;
    private int maxEntries;
    Logger logger;
    ArrayList listeners = new ArrayList();
    public static final int TEST_FAIL_NO_PREFIX_MATCH = -1;
    public static final int TEST_FAIL_EXISTING_ARE_BETTER = 0;
    public static final int TEST_SUCCESS_BETTER_PROXIMITY = 1;
    public static final int TEST_SUCCESS_ENTRY_WAS_DEAD = 2;
    public static final int TEST_SUCCESS_AVAILABLE_SPACE = 3;
    public static final int TEST_SUCCESS_NO_ENTRIES = 4;

    public RoutingTable(NodeHandle me, int max, byte base, PastryNode pn) {
        this.logger = pn.getEnvironment().getLogManager().getLogger(RoutingTable.class, null);
        this.pn = pn;
        this.idBaseBitLength = base;
        this.myNodeId = me.getNodeId();
        this.myNodeHandle = me;
        this.maxEntries = max;
        int cols = 1 << this.idBaseBitLength;
        int rows = 160 / this.idBaseBitLength;
        this.routingTable = new RouteSet[rows][cols];
        for (int i = 0; i < rows; ++i) {
            int myCol = this.myNodeId.getDigit(i, this.idBaseBitLength);
            this.routingTable[i][myCol] = new RouteSet(this.maxEntries, i, myCol, pn);
            this.routingTable[i][myCol].put(this.myNodeHandle);
            this.routingTable[i][myCol].setRoutingTable(this);
        }
    }

    public RouteSet getRouteSet(int index, int digit) {
        RouteSet ns = this.routingTable[index][digit];
        return ns;
    }

    public RouteSet getBestEntry(Id key) {
        int diffDigit = this.myNodeId.indexOfMSDD(key, this.idBaseBitLength);
        if (diffDigit < 0) {
            return null;
        }
        int digit = key.getDigit(diffDigit, this.idBaseBitLength);
        return this.routingTable[diffDigit][digit];
    }

    public NodeHandle get(Id nid) {
        RouteSet ns = this.getBestEntry(nid);
        if (ns == null) {
            return null;
        }
        return ns.get(nid);
    }

    public RouteSet[] getRow(int i) {
        try {
            return this.routingTable[i];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            if (this.logger.level <= 900) {
                this.logger.log("Warning, call to RoutingTable.getRow(" + i + ") max should be " + (this.routingTable.length - 1));
            }
            return null;
        }
    }

    public int numColumns() {
        return this.routingTable[0].length;
    }

    public byte numRows() {
        return (byte)this.routingTable.length;
    }

    public byte baseBitLength() {
        return this.idBaseBitLength;
    }

    public NodeHandle bestAlternateRoute(Id key) {
        return this.bestAlternateRoute(2, key);
    }

    public NodeHandle bestAlternateRoute(int minLiveness, Id key) {
        int cols = 1 << this.idBaseBitLength;
        int diffDigit = this.myNodeId.indexOfMSDD(key, this.idBaseBitLength);
        if (diffDigit < 0) {
            return null;
        }
        int keyDigit = key.getDigit(diffDigit, this.idBaseBitLength);
        int myDigit = this.myNodeId.getDigit(diffDigit, this.idBaseBitLength);
        Id.Distance bestDistance = this.myNodeId.distance(key);
        NodeHandle alt = null;
        boolean finished = false;
        int i = 1;
        while (!finished) {
            for (int j = 0; j < 2; ++j) {
                int digit = j == 0 ? keyDigit + i & cols - 1 : keyDigit + cols - i & cols - 1;
                RouteSet rs = this.getRouteSet(diffDigit, digit);
                for (int k = 0; rs != null && k < rs.size(); ++k) {
                    Id.Distance nDist;
                    NodeHandle n = rs.get(k);
                    if (n.getLiveness() > minLiveness || bestDistance.compareTo(nDist = n.getNodeId().distance(key)) <= 0) continue;
                    bestDistance = nDist;
                    alt = n;
                }
                if (digit != myDigit) continue;
                finished = true;
            }
            ++i;
        }
        return alt;
    }

    public NodeSet alternateRoutes(Id key, int max) {
        NodeSet set = new NodeSet();
        int cols = 1 << this.idBaseBitLength;
        int diffDigit = this.myNodeId.indexOfMSDD(key, this.idBaseBitLength);
        if (diffDigit < 0) {
            return set;
        }
        int keyDigit = key.getDigit(diffDigit, this.idBaseBitLength);
        int myDigit = this.myNodeId.getDigit(diffDigit, this.idBaseBitLength);
        Id.Distance myDistance = this.myNodeId.distance(key);
        boolean finished = false;
        int count = 0;
        int i = 0;
        while (!finished) {
            for (int j = 0; j < 2; ++j) {
                int digit = j == 0 ? keyDigit + i & cols - 1 : keyDigit + cols - i & cols - 1;
                RouteSet rs = this.getRouteSet(diffDigit, digit);
                for (int k = 0; rs != null && k < rs.size(); ++k) {
                    NodeHandle n = rs.get(k);
                    if (!n.isAlive()) continue;
                    Id.Distance nDist = n.getNodeId().distance(key);
                    if (set == null || count >= max || myDistance.compareTo(nDist) <= 0) continue;
                    set.put(n);
                    ++count;
                }
                if (digit != myDigit) continue;
                finished = true;
            }
            ++i;
        }
        return set;
    }

    private RouteSet makeBestEntry(Id key) {
        int diffDigit = this.myNodeId.indexOfMSDD(key, this.idBaseBitLength);
        if (diffDigit < 0) {
            return null;
        }
        int digit = key.getDigit(diffDigit, this.idBaseBitLength);
        if (this.routingTable[diffDigit][digit] == null) {
            this.routingTable[diffDigit][digit] = new RouteSet(this.maxEntries, diffDigit, digit, this.pn);
            this.routingTable[diffDigit][digit].setRoutingTable(this);
        }
        return this.routingTable[diffDigit][digit];
    }

    public synchronized boolean put(NodeHandle handle) {
        Id nid;
        RouteSet ns;
        if (this.logger.level <= 400) {
            this.logger.log("RT: put(" + handle + ")");
        }
        if ((ns = this.makeBestEntry(nid = handle.getNodeId())) != null) {
            return ns.put(handle);
        }
        return false;
    }

    public synchronized int test(NodeHandle handle) {
        Id key = handle.getNodeId();
        int diffDigit = this.myNodeId.indexOfMSDD(key, this.idBaseBitLength);
        if (diffDigit < 0) {
            return -1;
        }
        int digit = key.getDigit(diffDigit, this.idBaseBitLength);
        if (this.routingTable[diffDigit][digit] == null) {
            return 4;
        }
        RouteSet rs = this.routingTable[diffDigit][digit];
        if (rs.size() == 0) {
            return 4;
        }
        if (rs.size() < rs.capacity()) {
            return 3;
        }
        int prox = this.pn.proximity(handle);
        if (prox == Integer.MAX_VALUE) {
            return 0;
        }
        for (int i = 0; i < rs.size(); ++i) {
            NodeHandle nh = rs.get(i);
            if (!nh.isAlive()) {
                return 2;
            }
            if (this.pn.proximity(nh) <= prox) continue;
            return 1;
        }
        return 0;
    }

    public synchronized NodeHandle remove(NodeHandle nh) {
        RouteSet ns;
        if (this.logger.level <= 400) {
            this.logger.log("RT: remove(" + nh + ")");
        }
        if ((ns = this.getBestEntry(nh.getNodeId())) == null) {
            return null;
        }
        return ns.remove(nh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeSetUpdate(Object o, NodeHandle handle, boolean added) {
        if (this.logger.level <= 500) {
            RouteSet rs = (RouteSet)o;
            if (added) {
                this.logger.log("RT: added(" + handle + ")@(" + rs.row + "," + Id.tran[rs.col] + ")");
            } else {
                this.logger.log("RT: removed(" + handle + ")@(" + rs.row + "," + Id.tran[rs.col] + ")");
            }
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((NodeSetListener)this.listeners.get(i)).nodeSetUpdate(this, handle, added);
            }
        }
        if (this.countObservers() > 0) {
            this.setChanged();
            this.notifyObservers(new NodeSetUpdate(handle, added));
        }
    }

    public String toString() {
        String s = "routing table: \n";
        for (int i = this.routingTable.length - 1; i >= 0; --i) {
            for (int j = 0; j < this.routingTable[i].length; ++j) {
                s = this.routingTable[i][j] != null ? s + "" + this.routingTable[i][j].size() + "\t" : s + "0\t";
            }
            s = s + "\n";
        }
        return s;
    }

    public int numEntries() {
        int count = 0;
        int maxr = this.numRows();
        int maxc = this.numColumns();
        for (int r = 0; r < maxr; ++r) {
            for (int c = 0; c < maxc; ++c) {
                RouteSet rs = this.routingTable[r][c];
                if (rs == null) continue;
                count += rs.size();
            }
        }
        return count;
    }

    public int numUniqueEntries() {
        HashSet<NodeHandle> set = new HashSet<NodeHandle>();
        int maxr = this.numRows();
        int maxc = this.numColumns();
        for (int r = 0; r < maxr; ++r) {
            for (int c = 0; c < maxc; ++c) {
                RouteSet rs = this.routingTable[r][c];
                if (rs == null) continue;
                for (int i = 0; i < rs.size(); ++i) {
                    set.add(rs.get(i));
                }
            }
        }
        return set.size();
    }

    public void addObserver(Observer o) {
        if (this.logger.level <= 900) {
            this.logger.logException("WARNING: Observer on RoutingTable is deprecated", new Exception("Stack Trace"));
        }
        super.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        if (this.logger.level <= 900) {
            this.logger.log("WARNING: Observer on RoutingTable is deprecated");
        }
        super.deleteObserver(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeSetListener(NodeSetListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeSetListener(NodeSetListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    public synchronized List asList() {
        ArrayList<NodeHandle> rtHandles = new ArrayList<NodeHandle>(this.numEntries());
        for (int r = 0; r < this.numRows(); ++r) {
            RouteSet[] row = this.getRow(r);
            for (int c = 0; c < this.numColumns(); ++c) {
                RouteSet entry = row[c];
                if (entry == null) continue;
                for (int i = 0; i < entry.size(); ++i) {
                    NodeHandle nh = entry.get(i);
                    if (nh.equals(this.pn.getLocalHandle())) continue;
                    rtHandles.add(nh);
                }
            }
        }
        return rtHandles;
    }

    public void destroy() {
        for (int r = 0; r < this.routingTable.length; ++r) {
            for (int c = 0; c < this.routingTable[r].length; ++c) {
                if (this.routingTable[r][c] == null) continue;
                this.routingTable[r][c].destroy();
                this.routingTable[r][c] = null;
            }
        }
    }
}

