/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.NodeHandle;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.routing.RouteProtocolAddress;

public class RequestRouteRow
extends PRawMessage
implements Serializable {
    private byte row;
    public static final short TYPE = 1;

    public RequestRouteRow(NodeHandle nh, byte r) {
        this(null, nh, r);
    }

    public RequestRouteRow(Date stamp, NodeHandle nh, byte r) {
        super(RouteProtocolAddress.getCode(), stamp);
        this.setSender(nh);
        this.row = r;
        this.setPriority((byte)0);
    }

    public RequestRouteRow(NodeHandle sender, InputBuffer buf) throws IOException {
        super(RouteProtocolAddress.getCode(), null);
        this.setSender(sender);
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                this.row = buf.readByte();
                this.setPriority((byte)0);
                break;
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }

    public int getRow() {
        return this.row;
    }

    public short getType() {
        return 1;
    }

    public NodeHandle returnHandle() {
        return this.getSender();
    }

    public String toString() {
        String s = "";
        s = s + "RequestRouteRow(row " + this.row + " by " + this.getSender().getNodeId() + ")";
        return s;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        buf.writeByte(this.row);
    }
}

