/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.PastryNode;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.routing.RouteProtocolAddress;
import rice.pastry.routing.RouteSet;

public class BroadcastRouteRow
extends PRawMessage
implements Serializable {
    private NodeHandle fromNode;
    private RouteSet[] row;
    public static final short TYPE = 2;

    public BroadcastRouteRow(Date stamp, NodeHandle from, RouteSet[] r) {
        super(RouteProtocolAddress.getCode(), stamp);
        this.fromNode = from;
        this.row = r;
        this.setPriority((byte)0);
    }

    public BroadcastRouteRow(NodeHandle from, RouteSet[] r) {
        this(null, from, r);
    }

    public BroadcastRouteRow(InputBuffer buf, NodeHandleFactory nhf, PastryNode localNode) throws IOException {
        super(RouteProtocolAddress.getCode(), null);
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                this.fromNode = nhf.readNodeHandle(buf);
                this.row = new RouteSet[buf.readByte()];
                for (int i = 0; i < this.row.length; ++i) {
                    if (!buf.readBoolean()) continue;
                    this.row[i] = new RouteSet(buf, nhf, localNode);
                }
                break;
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }

    public RouteSet[] getRow() {
        return this.row;
    }

    public short getType() {
        return 2;
    }

    public NodeHandle from() {
        return this.fromNode;
    }

    public String toString() {
        String s = "";
        s = s + "BroadcastRouteRow(of " + this.fromNode.getNodeId() + ")";
        return s;
    }

    public String toStringFull() {
        String s = "BRR{" + this.fromNode + "}:";
        for (int i = 0; i < this.row.length; ++i) {
            s = s + this.row[i] + "|";
        }
        return s;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        this.fromNode.serialize(buf);
        buf.writeByte((byte)this.row.length);
        for (int i = 0; i < this.row.length; ++i) {
            if (this.row[i] != null) {
                buf.writeBoolean(true);
                this.row[i].serialize(buf);
                continue;
            }
            buf.writeBoolean(false);
        }
    }
}

