/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.leafset;

import java.io.IOException;
import java.util.Date;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.LeafSetProtocolAddress;
import rice.pastry.messaging.PRawMessage;

public class BroadcastLeafSet
extends PRawMessage {
    private NodeHandle fromNode;
    private LeafSet theLeafSet;
    private int theType;
    private long requestTimeStamp;
    public static final short TYPE = 2;
    public static final int Update = 0;
    public static final int JoinInitial = 1;
    public static final int JoinAdvertise = 2;
    public static final int Correction = 3;

    public BroadcastLeafSet(NodeHandle from, LeafSet leafSet, int type, long requestTimeStamp) {
        this(null, from, leafSet, type, requestTimeStamp);
    }

    public BroadcastLeafSet(Date stamp, NodeHandle from, LeafSet leafSet, int type, long requestTimeStamp) {
        super(LeafSetProtocolAddress.getCode(), stamp);
        if (leafSet == null) {
            throw new IllegalArgumentException("Leafset is null");
        }
        this.fromNode = from;
        this.theLeafSet = leafSet.copy();
        this.theType = type;
        this.requestTimeStamp = requestTimeStamp;
        this.setPriority((byte)0);
    }

    public BroadcastLeafSet(InputBuffer buf, NodeHandleFactory nhf) throws IOException {
        super(LeafSetProtocolAddress.getCode());
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                this.fromNode = nhf.readNodeHandle(buf);
                this.theLeafSet = LeafSet.build(buf, nhf);
                this.theType = buf.readByte();
                this.requestTimeStamp = buf.readLong();
                break;
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }

    public short getType() {
        return 2;
    }

    public long getTimeStamp() {
        return this.requestTimeStamp;
    }

    public NodeHandle from() {
        return this.fromNode;
    }

    public LeafSet leafSet() {
        return this.theLeafSet;
    }

    public int type() {
        return this.theType;
    }

    public String toString() {
        String s = "BroadcastLeafSet(of " + this.fromNode.getNodeId() + ":" + this.theLeafSet + ")";
        return s;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        this.fromNode.serialize(buf);
        this.theLeafSet.serialize(buf);
        buf.writeByte((byte)this.theType);
        buf.writeLong(this.requestTimeStamp);
    }
}

