/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.dist;

import java.net.InetSocketAddress;
import java.util.Vector;
import rice.Continuation;
import rice.Executable;
import rice.environment.Environment;
import rice.pastry.ExponentialBackoffScheduledMessage;
import rice.pastry.Id;
import rice.pastry.NetworkListener;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.ScheduledMessage;
import rice.pastry.join.InitiateJoin;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.messaging.Message;
import rice.pastry.routing.InitiateRouteSetMaintenance;
import rice.selector.Timer;

public abstract class DistPastryNode
extends PastryNode {
    protected int leafSetMaintFreq;
    protected int routeSetMaintFreq;
    protected Timer timer;
    private Vector listeners;
    private ScheduledMessage joinEvent;
    protected ScheduledMessage leafSetRoutineMaintenance = null;
    protected ScheduledMessage routeSetRoutineMaintenance = null;
    private static Vector errors = new Vector();

    protected DistPastryNode(Id id, Environment e) {
        super(id, e);
        this.timer = e.getSelectorManager().getTimer();
        this.listeners = new Vector();
    }

    public Timer getTimer() {
        return this.timer;
    }

    protected NetworkListener[] getNetworkListeners() {
        return this.listeners.toArray(new NetworkListener[0]);
    }

    public void addNetworkListener(NetworkListener listener) {
        this.listeners.add(listener);
    }

    public void broadcastChannelClosed(InetSocketAddress addr) {
        NetworkListener[] listeners = this.getNetworkListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].channelClosed(addr);
        }
    }

    public void broadcastChannelOpened(InetSocketAddress addr, int reason) {
        NetworkListener[] listeners = this.getNetworkListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].channelOpened(addr, reason);
        }
    }

    public void broadcastSentListeners(int address, short msgType, InetSocketAddress dest, int size, int wireType) {
        NetworkListener[] listeners = this.getNetworkListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].dataSent(address, msgType, dest, size, wireType);
        }
    }

    public void broadcastReceivedListeners(int address, short msgType, InetSocketAddress from, int size, int wireType) {
        NetworkListener[] listeners = this.getNetworkListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].dataReceived(address, msgType, from, size, wireType);
        }
    }

    public final void initiateJoin(NodeHandle[] bootstrap) {
        if (this.logger.level <= 700) {
            this.logger.log("DistPN.initiateJoin()");
        }
        if (bootstrap != null) {
            this.joinEvent = this.scheduleMsgExpBackoff(new InitiateJoin(bootstrap), 0L, 15000L, 2.0);
        } else {
            this.setReady();
        }
    }

    public void nodeIsReady() {
        if (this.joinEvent != null) {
            this.joinEvent.cancel();
        }
    }

    public void doneNode(NodeHandle[] bootstrap) {
        if (this.routeSetMaintFreq > 0) {
            this.routeSetRoutineMaintenance = this.scheduleMsgAtFixedRate(new InitiateRouteSetMaintenance(), this.routeSetMaintFreq * 1000, this.routeSetMaintFreq * 1000);
            if (this.logger.level <= 700) {
                this.logger.log("Scheduling routeSetMaint for " + this.routeSetMaintFreq * 1000 + "," + this.routeSetMaintFreq * 1000);
            }
        }
        if (this.leafSetMaintFreq > 0) {
            this.leafSetRoutineMaintenance = this.scheduleMsgAtFixedRate(new InitiateLeafSetMaintenance(), this.leafSetMaintFreq * 1000, this.leafSetMaintFreq * 1000);
            if (this.logger.level <= 700) {
                this.logger.log("Scheduling leafSetMaint for " + this.leafSetMaintFreq * 1000 + "," + this.leafSetMaintFreq * 1000);
            }
        }
    }

    public void destroy() {
        super.destroy();
        if (this.leafSetRoutineMaintenance != null) {
            this.leafSetRoutineMaintenance.cancel();
        }
        if (this.routeSetRoutineMaintenance != null) {
            this.routeSetRoutineMaintenance.cancel();
        }
    }

    public ScheduledMessage scheduleMsg(Message msg, long delay) {
        ScheduledMessage sm = new ScheduledMessage(this, msg);
        this.timer.schedule(sm, delay);
        return sm;
    }

    public ScheduledMessage scheduleMsg(Message msg, long delay, long period) {
        ScheduledMessage sm = new ScheduledMessage(this, msg);
        this.timer.schedule(sm, delay, period);
        return sm;
    }

    public ExponentialBackoffScheduledMessage scheduleMsgExpBackoff(Message msg, long delay, long initialPeriod, double expBase) {
        ExponentialBackoffScheduledMessage sm = new ExponentialBackoffScheduledMessage(this, msg, this.timer, delay, initialPeriod, expBase);
        return sm;
    }

    public ScheduledMessage scheduleMsgAtFixedRate(Message msg, long delay, long period) {
        ScheduledMessage sm = new ScheduledMessage(this, msg);
        this.timer.scheduleAtFixedRate(sm, delay, period);
        return sm;
    }

    public void process(Executable task, Continuation command) {
        this.getEnvironment().getProcessor().process(task, command, this.getEnvironment().getSelectorManager(), this.getEnvironment().getTimeSource(), this.getEnvironment().getLogManager());
    }
}

