/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import rice.environment.Environment;
import rice.pastry.direct.BasicNetworkSimulator;
import rice.pastry.direct.NodeRecord;

public class EuclideanNetwork
extends BasicNetworkSimulator {
    final int side;

    public EuclideanNetwork(Environment env) {
        super(env);
        this.side = (int)((double)this.maxDiameter / Math.sqrt(2.0));
    }

    public NodeRecord generateNodeRecord() {
        return new EuclideanNodeRecord();
    }

    private class EuclideanNodeRecord
    implements NodeRecord {
        public int x;
        public int y;
        public boolean alive;

        public EuclideanNodeRecord() {
            this.x = EuclideanNetwork.this.random.nextInt() % EuclideanNetwork.this.side;
            this.y = EuclideanNetwork.this.random.nextInt() % EuclideanNetwork.this.side;
            this.alive = true;
        }

        public float proximity(NodeRecord that) {
            return Math.round((double)this.networkDelay(that) * 2.0);
        }

        public float networkDelay(NodeRecord that) {
            EuclideanNodeRecord nr = (EuclideanNodeRecord)that;
            int dx = this.x - nr.x;
            int dy = this.y - nr.y;
            float ret = (float)Math.sqrt(dx * dx + dy * dy);
            if ((double)ret < 2.0 && !this.equals(that)) {
                return 2.0f;
            }
            return ret;
        }

        public String toString() {
            return "ENR(" + this.x + "," + this.y + ")";
        }

        public void markDead() {
        }
    }
}

