/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.util.Hashtable;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.ReadyStrategy;
import rice.pastry.ScheduledMessage;
import rice.pastry.client.PastryAppl;
import rice.pastry.direct.DirectAppSocket;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.NodeRecord;
import rice.pastry.join.InitiateJoin;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.selector.Timer;

public class DirectPastryNode
extends PastryNode {
    private static Hashtable currentNode = new Hashtable();
    private NetworkSimulator simulator;
    protected boolean alive = true;
    NodeRecord record;
    protected Timer timer;
    int seq = 0;
    ScheduledMessage joinTask;
    Hashtable nodeHandles = new Hashtable();

    public static synchronized DirectPastryNode setCurrentNode(DirectPastryNode dpn) {
        Thread current = Thread.currentThread();
        DirectPastryNode ret = (DirectPastryNode)currentNode.get(current);
        if (dpn == null) {
            currentNode.remove(current);
        } else {
            currentNode.put(current, dpn);
        }
        return ret;
    }

    public static synchronized DirectPastryNode getCurrentNode() {
        Thread current = Thread.currentThread();
        DirectPastryNode ret = (DirectPastryNode)currentNode.get(current);
        return ret;
    }

    public DirectPastryNode(Id id, NetworkSimulator sim, Environment e, NodeRecord nr) {
        super(id, e);
        this.timer = e.getSelectorManager().getTimer();
        this.simulator = sim;
        this.record = nr;
    }

    public void doneNode(NodeHandle[] bootstrap) {
        this.initiateJoin(bootstrap);
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void destroy() {
        this.record.markDead();
        this.routeSet.destroy();
        this.leafSet.destroy();
        super.destroy();
        this.alive = false;
        if (this.joinTask != null) {
            this.joinTask.cancel();
        }
        this.setReadyStrategy(new ReadyStrategy(){

            public void start() {
                throw new RuntimeException("Can't start!");
            }

            public boolean isReady() {
                return false;
            }

            public void setReady(boolean r) {
            }
        });
        this.setReady(false);
        this.notifyReadyObservers();
        this.simulator.removeNode(this);
    }

    public final void initiateJoin(NodeHandle[] bootstrap) {
        if (bootstrap != null && bootstrap[0] != null) {
            this.joinTask = this.scheduleMsg(new InitiateJoin(bootstrap), 0L, 5000L);
        } else {
            this.setReady();
        }
    }

    public final void nodeIsReady() {
        if (this.joinTask != null) {
            this.joinTask.cancel();
            this.joinTask = null;
        }
    }

    public ScheduledMessage scheduleMsg(Message msg, long delay) {
        return this.simulator.deliverMessage(msg, this, (int)delay);
    }

    public ScheduledMessage scheduleMsg(Message msg, long delay, long period) {
        DirectPastryNode temp = DirectPastryNode.setCurrentNode(this);
        ScheduledMessage ret = this.simulator.deliverMessage(msg, this, (int)delay, (int)period);
        DirectPastryNode.setCurrentNode(temp);
        return ret;
    }

    public ScheduledMessage scheduleMsgAtFixedRate(Message msg, long delay, long period) {
        return this.simulator.deliverMessageFixedRate(msg, this, (int)delay, (int)period);
    }

    public NodeHandle coalesce(NodeHandle newHandle) {
        NodeHandle ret = (NodeHandle)this.nodeHandles.get(newHandle);
        if (ret == null) {
            this.nodeHandles.put(newHandle, newHandle);
            ret = newHandle;
        }
        return ret;
    }

    public synchronized void receiveMessage(Message msg) {
        if (!this.getEnvironment().getSelectorManager().isSelectorThread()) {
            this.simulator.deliverMessage(msg, this);
            return;
        }
        DirectPastryNode temp = DirectPastryNode.setCurrentNode(this);
        super.receiveMessage(msg);
        DirectPastryNode.setCurrentNode(temp);
    }

    public synchronized void route(RouteMessage rm) {
        if (!this.getEnvironment().getSelectorManager().isSelectorThread()) {
            this.simulator.deliverMessage(rm, this);
            return;
        }
        DirectPastryNode temp = DirectPastryNode.setCurrentNode(this);
        super.receiveMessage(rm);
        DirectPastryNode.setCurrentNode(temp);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int proximity(NodeHandle that) {
        if (!that.isAlive()) {
            return Integer.MAX_VALUE;
        }
        float result = this.simulator.proximity((DirectNodeHandle)this.getLocalHandle(), (DirectNodeHandle)that);
        return (int)result;
    }

    public void send(NodeHandle nh, Message m) {
        if (nh == this.getLocalHandle()) {
            this.receiveMessage(m);
            return;
        }
        if (!nh.isAlive()) {
            if (this.logger.level <= 500) {
                this.logger.log("DirectNodeHandle: attempt to send message " + m + " to a dead node " + this.getNodeId() + "!");
            }
        } else {
            this.simulator.deliverMessage(m, ((DirectNodeHandle)nh).getRemote(), this.proximity(nh));
        }
    }

    public void connect(NodeHandle remoteNode, AppSocketReceiver receiver, PastryAppl appl, int timeout) {
        DirectNodeHandle dnh = (DirectNodeHandle)remoteNode;
        this.simulator.enqueueDelivery(new DirectAppSocket(dnh, receiver, appl, this.simulator).getAcceptorDelivery(), Math.round(this.simulator.networkDelay((DirectNodeHandle)this.localhandle, dnh)));
    }

    public NodeHandle readNodeHandle(InputBuffer buf) {
        throw new RuntimeException("Should not be called.");
    }
}

