/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Iterator;
import java.util.LinkedList;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.appsocket.AppSocket;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.exception.AppNotRegisteredException;
import rice.p2p.commonapi.exception.NoReceiverAvailableException;
import rice.p2p.commonapi.exception.NodeIsDeadException;
import rice.pastry.client.PastryAppl;
import rice.pastry.direct.Delivery;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.NetworkSimulator;

public class DirectAppSocket {
    DirectNodeHandle acceptorNodeHandle;
    PastryAppl acceptorAppl;
    AppSocketReceiver connectorReceiver;
    PastryAppl connectorAppl;
    NetworkSimulator simulator;
    DirectAppSocketEndpoint acceptorEndpoint;
    DirectAppSocketEndpoint connectorEndpoint;
    Logger logger;
    public static final byte[] EOF = new byte[0];
    private static final int MAX_BYTES_IN_FLIGHT = 10000;

    DirectAppSocket(DirectNodeHandle acceptor, AppSocketReceiver connector, PastryAppl connectorAppl, NetworkSimulator simulator) {
        this.acceptorNodeHandle = acceptor;
        DirectPastryNode acceptorNode = acceptor.getRemote();
        this.connectorReceiver = connector;
        this.connectorAppl = connectorAppl;
        this.simulator = simulator;
        this.acceptorAppl = acceptorNode.getMessageDispatch().getDestinationByAddress(connectorAppl.getAddress());
        this.logger = simulator.getEnvironment().getLogManager().getLogger(DirectAppSocket.class, "");
        this.acceptorEndpoint = new DirectAppSocketEndpoint(acceptor);
        this.connectorEndpoint = new DirectAppSocketEndpoint((DirectNodeHandle)connectorAppl.getNodeHandle());
        this.acceptorEndpoint.setCounterpart(this.connectorEndpoint);
        this.connectorEndpoint.setCounterpart(this.acceptorEndpoint);
    }

    public Delivery getAcceptorDelivery() {
        return new AcceptorDelivery();
    }

    public String toString() {
        return "DAS{" + this.connectorAppl + "->" + this.acceptorAppl + "}";
    }

    class ConnectorExceptionDelivery
    implements Delivery {
        Exception e;

        public ConnectorExceptionDelivery(Exception e) {
            this.e = e;
        }

        public int getSeq() {
            return -1;
        }

        public void deliver() {
            DirectAppSocket.this.connectorReceiver.receiveException(null, this.e);
        }
    }

    class ConnectorDelivery
    implements Delivery {
        ConnectorDelivery() {
        }

        public int getSeq() {
            return -1;
        }

        public void deliver() {
            if (DirectAppSocket.this.connectorAppl.getNodeHandle().isAlive()) {
                DirectAppSocket.this.connectorReceiver.receiveSocket(DirectAppSocket.this.connectorEndpoint);
            } else {
                System.out.println("NOT IMPLEMENTED: Connector died during application socket initiation.");
            }
        }
    }

    class AcceptorDelivery
    implements Delivery {
        AcceptorDelivery() {
        }

        public int getSeq() {
            return -1;
        }

        public void deliver() {
            if (DirectAppSocket.this.acceptorNodeHandle.isAlive()) {
                if (DirectAppSocket.this.acceptorAppl == null) {
                    DirectAppSocket.this.simulator.enqueueDelivery(new ConnectorExceptionDelivery(new AppNotRegisteredException()), Math.round(DirectAppSocket.this.simulator.networkDelay(DirectAppSocket.this.acceptorNodeHandle, (DirectNodeHandle)DirectAppSocket.this.connectorAppl.getNodeHandle())));
                } else if (DirectAppSocket.this.acceptorAppl.receiveSocket(DirectAppSocket.this.acceptorEndpoint)) {
                    DirectAppSocket.this.simulator.enqueueDelivery(new ConnectorDelivery(), Math.round(DirectAppSocket.this.simulator.networkDelay(DirectAppSocket.this.acceptorNodeHandle, (DirectNodeHandle)DirectAppSocket.this.connectorAppl.getNodeHandle())));
                } else {
                    DirectAppSocket.this.simulator.enqueueDelivery(new ConnectorExceptionDelivery(new NoReceiverAvailableException()), Math.round(DirectAppSocket.this.simulator.networkDelay(DirectAppSocket.this.acceptorNodeHandle, (DirectNodeHandle)DirectAppSocket.this.connectorAppl.getNodeHandle())));
                }
            } else {
                DirectAppSocket.this.simulator.enqueueDelivery(new ConnectorExceptionDelivery(new NodeIsDeadException()), Math.round(DirectAppSocket.this.simulator.networkDelay(DirectAppSocket.this.acceptorNodeHandle, (DirectNodeHandle)DirectAppSocket.this.connectorAppl.getNodeHandle())));
            }
        }
    }

    class DirectAppSocketEndpoint
    implements AppSocket {
        DirectAppSocketEndpoint counterpart;
        AppSocketReceiver reader;
        AppSocketReceiver writer;
        DirectNodeHandle localNodeHandle;
        int seq = 0;
        boolean inputClosed;
        boolean outputClosed;
        int bytesInFlight = 0;
        LinkedList byteDeliveries = new LinkedList();
        int firstOffset = 0;

        public DirectAppSocketEndpoint(DirectNodeHandle localNodeHandle) {
            this.localNodeHandle = localNodeHandle;
        }

        public DirectNodeHandle getRemoteNodeHandle() {
            return this.counterpart.localNodeHandle;
        }

        public void setCounterpart(DirectAppSocketEndpoint counterpart) {
            this.counterpart = counterpart;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long read(ByteBuffer[] dsts, int offset, int length) {
            int lengthRead = 0;
            DirectAppSocketEndpoint directAppSocketEndpoint = this;
            synchronized (directAppSocketEndpoint) {
                if (this.byteDeliveries.getFirst() == EOF) {
                    this.inputClosed = true;
                    return -1L;
                }
                Iterator i = this.byteDeliveries.iterator();
                while (i.hasNext()) {
                    byte[] msg = (byte[])i.next();
                    for (int dstCtr = offset; dstCtr < offset + length; ++dstCtr) {
                        ByteBuffer curBuffer = dsts[dstCtr];
                        int lengthToPut = curBuffer.remaining();
                        if (lengthToPut > msg.length - this.firstOffset) {
                            lengthToPut = msg.length - this.firstOffset;
                        }
                        curBuffer.put(msg, this.firstOffset, lengthToPut);
                        this.firstOffset += lengthToPut;
                        lengthRead += lengthToPut;
                        if (this.firstOffset == msg.length) break;
                        offset = dstCtr + 1;
                    }
                    if (this.firstOffset != msg.length) break;
                    i.remove();
                    this.firstOffset = 0;
                }
            }
            this.bytesInFlight -= lengthRead;
            DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){

                public int getSeq() {
                    return 0;
                }

                public void deliver() {
                    DirectAppSocketEndpoint.this.notifyCanWrite();
                }
            }, 0);
            return lengthRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            int lengthToWrite;
            if (this.outputClosed) {
                throw new ClosedChannelException();
            }
            int availableToWrite = 0;
            for (int i = offset; i < offset + length; ++i) {
                availableToWrite += srcs[i].remaining();
            }
            DirectAppSocketEndpoint directAppSocketEndpoint = this.counterpart;
            synchronized (directAppSocketEndpoint) {
                lengthToWrite = 10000 - this.counterpart.bytesInFlight;
                if (lengthToWrite > availableToWrite) {
                    lengthToWrite = availableToWrite;
                }
                this.counterpart.bytesInFlight += lengthToWrite;
            }
            final byte[] msg = new byte[lengthToWrite];
            int remaining = lengthToWrite;
            int i = offset;
            while (remaining > 0) {
                int lengthToReadFromBuffer = srcs[i].remaining();
                if (remaining < lengthToReadFromBuffer) {
                    lengthToReadFromBuffer = remaining;
                }
                srcs[i].get(msg, lengthToWrite - remaining, lengthToReadFromBuffer);
                remaining -= lengthToReadFromBuffer;
                ++i;
            }
            if (DirectAppSocket.this.logger.level <= 400) {
                DirectAppSocket.this.logger.log(this + ".write(" + lengthToWrite + ")");
            }
            DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){
                int mySeq;
                {
                    this.mySeq = DirectAppSocketEndpoint.this.seq++;
                }

                public int getSeq() {
                    return this.mySeq;
                }

                public void deliver() {
                    DirectAppSocketEndpoint.this.counterpart.addToReadQueue(msg);
                }
            }, Math.round(DirectAppSocket.this.simulator.networkDelay(this.localNodeHandle, this.counterpart.localNodeHandle)));
            return lengthToWrite;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addToReadQueue(byte[] msg) {
            DirectAppSocketEndpoint directAppSocketEndpoint = this;
            synchronized (directAppSocketEndpoint) {
                if (DirectAppSocket.this.logger.level <= 500) {
                    if (msg == EOF) {
                        DirectAppSocket.this.logger.log(this + ": addToReadQueue(EOF)");
                    } else {
                        DirectAppSocket.this.logger.log(this + ": addToReadQueue(" + msg.length + ")");
                    }
                }
                this.byteDeliveries.addLast(msg);
            }
            this.notifyCanRead();
        }

        protected void notifyCanWrite() {
            if (this.writer == null) {
                return;
            }
            if (this.counterpart.bytesInFlight < 10000) {
                AppSocketReceiver temp = this.writer;
                this.writer = null;
                temp.receiveSelectResult(this, false, true);
            }
        }

        protected void notifyCanRead() {
            if (this.byteDeliveries.isEmpty()) {
                return;
            }
            if (this.reader != null) {
                AppSocketReceiver temp = this.reader;
                this.reader = null;
                temp.receiveSelectResult(this, true, false);
            }
        }

        public void register(boolean wantToRead, boolean wantToWrite, int timeout, AppSocketReceiver receiver) {
            if (wantToWrite) {
                this.writer = receiver;
                DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){

                    public int getSeq() {
                        return 0;
                    }

                    public void deliver() {
                        DirectAppSocketEndpoint.this.notifyCanWrite();
                    }
                }, 0);
            }
            if (wantToRead) {
                this.reader = receiver;
                DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){

                    public int getSeq() {
                        return 0;
                    }

                    public void deliver() {
                        DirectAppSocketEndpoint.this.notifyCanRead();
                    }
                }, 0);
            }
        }

        public void shutdownOutput() {
            if (DirectAppSocket.this.logger.level <= 400) {
                DirectAppSocket.this.logger.log(this + ".shutdownOutput()");
            }
            this.outputClosed = true;
            DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){
                int mySeq;
                {
                    this.mySeq = DirectAppSocketEndpoint.this.seq++;
                }

                public int getSeq() {
                    return this.mySeq;
                }

                public void deliver() {
                    DirectAppSocketEndpoint.this.counterpart.addToReadQueue(EOF);
                }
            }, Math.round(DirectAppSocket.this.simulator.networkDelay(this.localNodeHandle, this.counterpart.localNodeHandle)));
        }

        public void shutdownInput() {
            this.inputClosed = true;
        }

        public void close() {
            this.shutdownOutput();
            this.shutdownInput();
        }

        public String toString() {
            return "DAS{" + this.localNodeHandle + ":" + this.writer + "->" + this.counterpart.localNodeHandle + ":" + this.reader + "}";
        }
    }
}

