/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.appsocket.AppSocket;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSetEventSource;
import rice.pastry.NodeSetListener;
import rice.pastry.PastryNode;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.JavaSerializedDeserializer;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.RawMessageDelivery;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RoutingTable;
import rice.pastry.routing.SendOptions;
import rice.pastry.standard.StandardAddress;

public abstract class PastryAppl
implements Observer {
    protected MessageDeserializer deserializer;
    protected String instance;
    protected PastryNode thePastryNode;
    protected int address;
    protected Logger logger;
    LinkedList undeliveredMessages = new LinkedList();
    protected AppSocketReceiver receiver;

    public PastryAppl(PastryNode pn) {
        this(pn, null);
    }

    public PastryAppl(PastryNode pn, String instance) {
        this(pn, instance, 0, null);
        this.register();
    }

    public PastryAppl(PastryNode pn, String instance, int address, MessageDeserializer md) {
        this.address = address;
        if (instance != null) {
            this.instance = instance;
            if (address == 0) {
                this.address = StandardAddress.getAddress(this.getClass(), instance, pn.getEnvironment());
            }
        }
        this.thePastryNode = pn;
        this.logger = pn.getEnvironment().getLogManager().getLogger(this.getClass(), instance);
        this.deserializer = md;
        if (this.deserializer == null) {
            this.deserializer = new JavaSerializedDeserializer(pn);
        }
    }

    public PastryAppl(PastryNode pn, int port) {
        this(pn, null, port, null);
    }

    public int getAddress() {
        return this.address;
    }

    public final Id getNodeId() {
        return this.thePastryNode.getNodeId();
    }

    public NodeHandle getNodeHandle() {
        return this.thePastryNode.getLocalHandle();
    }

    public LeafSet getLeafSet() {
        return this.thePastryNode.getLeafSet().copy();
    }

    public RoutingTable getRoutingTable() {
        return this.thePastryNode.getRoutingTable();
    }

    public boolean isClosest(Id key) {
        return this.thePastryNode.isClosest(key);
    }

    protected void setDeserializer(MessageDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    public void register() {
        this.thePastryNode.registerReceiver(this.getAddress(), this);
        this.thePastryNode.addLeafSetListener(new LeafSetObserver());
        this.thePastryNode.addRouteSetListener(new RouteSetObserver());
        this.thePastryNode.registerApp(this);
        this.thePastryNode.addObserver(this);
    }

    public void receiveMessageInternal(RawMessageDelivery msg) {
        Message m;
        try {
            m = msg.deserialize(this.deserializer);
        }
        catch (IOException ioe) {
            if (this.logger.level <= 1000) {
                this.logger.logException("Error deserializing " + msg + " in " + this + ".  Message will be dropped.", ioe);
            }
            return;
        }
        catch (RuntimeException re) {
            if (this.logger.level <= 1000) {
                this.logger.logException("Error deserializing " + msg + " in " + this + ".  Message will be dropped.", re);
            }
            throw re;
        }
        this.receiveMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void receiveMessage(Message msg) {
        LinkedList linkedList = this.undeliveredMessages;
        synchronized (linkedList) {
            if (!this.deliverWhenNotReady() && !this.thePastryNode.isReady()) {
                return;
            }
        }
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] recv " + msg);
        }
        if (msg instanceof RouteMessage) {
            RouteMessage rm = (RouteMessage)msg;
            try {
                if (!this.enrouteMessage(rm.unwrap(this.deserializer), rm.getTarget(), rm.nextHop, rm.getOptions())) return;
                rm.routeMessage(this.thePastryNode.getLocalHandle());
                return;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error deserializing message " + rm, ioe);
            }
        } else {
            this.messageForAppl(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable arg0, Object arg1) {
        Boolean b;
        if (arg0 == this.thePastryNode && arg1 instanceof Boolean && (b = (Boolean)arg1).booleanValue()) {
            ArrayList copy;
            LinkedList linkedList = this.undeliveredMessages;
            synchronized (linkedList) {
                copy = new ArrayList(this.undeliveredMessages);
                this.undeliveredMessages.clear();
            }
            for (Message m : copy) {
                this.receiveMessage(m);
            }
        }
    }

    public boolean routeMsgDirect(NodeHandle dest, Message msg, SendOptions opt) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] routemsgdirect " + msg + " to " + dest);
        }
        if (!dest.isAlive()) {
            return false;
        }
        this.thePastryNode.send(dest, msg);
        return dest.isAlive();
    }

    public void routeMsg(Id key, Message msg, SendOptions opt) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] routemsg " + msg + " to " + key);
        }
        RouteMessage rm = new RouteMessage(key, msg, opt);
        this.thePastryNode.receiveMessage(rm);
    }

    public abstract void messageForAppl(Message var1);

    public boolean enrouteMessage(Message msg, Id key, NodeHandle nextHop, SendOptions opt) {
        return true;
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
    }

    public void routeSetChange(NodeHandle nh, boolean wasAdded) {
    }

    public void notifyReady() {
    }

    public boolean deliverWhenNotReady() {
        return false;
    }

    public void destroy() {
    }

    public void connect(NodeHandle handle, AppSocketReceiver receiver, int timeout) {
        this.thePastryNode.connect(handle, receiver, this, timeout);
    }

    public void accept(AppSocketReceiver receiver) {
        this.receiver = receiver;
    }

    public boolean receiveSocket(AppSocket socket) {
        AppSocketReceiver theReceiver = this.receiver;
        this.receiver = null;
        if (theReceiver == null) {
            return false;
        }
        theReceiver.receiveSocket(socket);
        return true;
    }

    private class RouteSetObserver
    implements NodeSetListener {
        private RouteSetObserver() {
        }

        public void nodeSetUpdate(NodeSetEventSource nodeSetEventSource, NodeHandle handle, boolean added) {
            PastryAppl.this.routeSetChange(handle, added);
        }
    }

    private class LeafSetObserver
    implements NodeSetListener {
        private LeafSetObserver() {
        }

        public void nodeSetUpdate(NodeSetEventSource nodeSetEventSource, NodeHandle handle, boolean added) {
            PastryAppl.this.leafSetChange(handle, added);
        }
    }
}

