/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.Random;
import java.util.WeakHashMap;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

public class Id
implements rice.p2p.commonapi.Id {
    private int[] Id = new int[5];
    public static final short TYPE = 1;
    private static WeakHashMap ID_MAP = new WeakHashMap();
    public static final String[] tran = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    public static final int IdBitLength = 160;
    public static final int nlen = 5;
    static final long serialVersionUID = 2166868464271508935L;
    public static final int[] Null = new int[]{0, 0, 0, 0, 0};
    public static final int[] One = new int[]{1, 0, 0, 0, 0};
    public static final int[] NegOne = new int[]{-1, -1, -1, -1, -1};
    public static final int[] Half = new int[]{128, 0, 0, 0, 0};

    protected Id(int[] material) {
        for (int i = 0; i < 5 && i < material.length; ++i) {
            this.Id[i] = material[i];
        }
    }

    public Id getCW() {
        Distance one = new Distance(One);
        return this.add(one);
    }

    public Id getCCW() {
        Distance negone = new Distance(NegOne);
        return this.add(negone);
    }

    public boolean isBetween(Id ccw, Id cw) {
        if (ccw.equals(cw)) {
            return false;
        }
        if (ccw.clockwise(cw)) {
            return this.clockwise(cw) && !this.clockwise(ccw);
        }
        return !this.clockwise(ccw) || this.clockwise(cw);
    }

    public int getDigit(int i, int b) {
        int bitIndex = b * i + 160 % b;
        int index = bitIndex / 32;
        int shift = bitIndex % 32;
        long val = this.Id[index];
        if (shift + b > 32) {
            val = val & 0xFFFFFFFFL | (long)this.Id[index + 1] << 32;
        }
        return (int)(val >> shift) & (1 << b) - 1;
    }

    public Id getDomainPrefix(int row, int column, int suffixDigit, int b) {
        Id res = new Id(this.Id);
        res.setDigit(row, column, b);
        for (int i = 0; i < row; ++i) {
            res.setDigit(i, suffixDigit, b);
        }
        return rice.pastry.Id.build(res.Id);
    }

    public Id getAlternateId(int num, int b, int i) {
        if (num > 1 << b || i < 0 || i >= num) {
            return null;
        }
        Id res = new Id(this.Id);
        int digit = res.getDigit(rice.pastry.Id.numDigits(b) - 1, b) + (1 << b) / num * i;
        res.setDigit(rice.pastry.Id.numDigits(b) - 1, digit, b);
        return rice.pastry.Id.build(res.Id);
    }

    public boolean isBetween(rice.p2p.commonapi.Id ccw, rice.p2p.commonapi.Id cw) {
        return this.isBetween((Id)ccw, (Id)cw);
    }

    public int getByteArrayLength() {
        return 20;
    }

    public short getType() {
        return 1;
    }

    private void setBit(int i, int v) {
        int index = i / 32;
        int shift = i % 32;
        int val = this.Id[index];
        int mask = 1 << shift;
        this.Id[index] = v == 1 ? val | mask : val & ~mask;
    }

    private void setDigit(int i, int v, int b) {
        int bitIndex = b * i + 160 % b;
        int index = bitIndex / 32;
        int shift = bitIndex % 32;
        int mask = (1 << b) - 1;
        if (shift + b > 32) {
            long newd = (long)(v & mask) << shift;
            long vmask = (long)mask << shift ^ 0xFFFFFFFFFFFFFFFFL;
            long val = this.Id[index];
            val = val & 0xFFFFFFFFL | (long)this.Id[index + 1] << 32;
            val = val & vmask | newd;
            this.Id[index] = (int)val;
            this.Id[index + 1] = (int)(val >> 32);
        } else {
            int newd = (v & mask) << shift;
            int vmask = ~(mask << shift);
            this.Id[index] = this.Id[index] & vmask | newd;
        }
    }

    public void serialize(OutputBuffer buf) throws IOException {
        for (int i = 0; i < this.Id.length; ++i) {
            buf.writeInt(this.Id[i]);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return rice.pastry.Id.resolve(ID_MAP, this);
    }

    public void blit(byte[] target) {
        this.blit(target, 0);
    }

    public void blit(byte[] target, int offset) {
        for (int j = 0; j < 20; ++j) {
            int k = this.Id[j / 4] >> j % 4 * 8;
            target[offset + j] = (byte)(k & 0xFF);
        }
    }

    public byte[] copy() {
        byte[] target = new byte[20];
        this.blit(target);
        return target;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Id)) {
            return false;
        }
        Id nid = (Id)obj;
        for (int i = 0; i < 5; ++i) {
            if (this.Id[i] == nid.Id[i]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object obj) {
        Id oth = (Id)obj;
        for (int i = 4; i >= 0; --i) {
            if (this.Id[i] == oth.Id[i]) continue;
            long t = (long)this.Id[i] & 0xFFFFFFFFL;
            long o = (long)oth.Id[i] & 0xFFFFFFFFL;
            if (t < o) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public byte[] toByteArray() {
        return this.copy();
    }

    public void toByteArray(byte[] array, int offset) {
        this.blit(array, offset);
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < 5; ++i) {
            h ^= this.Id[i];
        }
        return h;
    }

    public Id add(Distance offset) {
        int[] array = new int[5];
        int carry = 0;
        for (int i = 0; i < 5; ++i) {
            long x = (long)this.Id[i] & 0xFFFFFFFFL;
            long y = (long)offset.difference[i] & 0xFFFFFFFFL;
            long sum = x + y + (long)carry;
            carry = sum >= 0x100000000L ? 1 : 0;
            array[i] = (int)sum;
        }
        return rice.pastry.Id.build(array);
    }

    public Distance distance(Id nid) {
        int[] dist = this.absDistance(nid);
        if ((dist[4] & Integer.MIN_VALUE) != 0) {
            this.invert(dist);
        }
        Distance d = new Distance(dist);
        return d;
    }

    public Distance distance(Id nid, Distance d) {
        int[] dist = d.difference;
        this.absDistance(nid, dist);
        if ((dist[4] & Integer.MIN_VALUE) != 0) {
            this.invert(dist);
        }
        return d;
    }

    public Distance longDistance(Id nid) {
        int[] dist = this.absDistance(nid);
        if ((dist[4] & Integer.MIN_VALUE) == 0) {
            this.invert(dist);
        }
        Distance d = new Distance(dist);
        return d;
    }

    public boolean equals(Id nid) {
        if (nid == null) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            if (this.Id[i] == nid.Id[i]) continue;
            return false;
        }
        return true;
    }

    public boolean clockwise(Id nid) {
        int i;
        boolean diffMSB = (this.Id[4] & Integer.MIN_VALUE) != (nid.Id[4] & Integer.MIN_VALUE);
        int x = this.Id[4] & Integer.MAX_VALUE;
        int y = nid.Id[4] & Integer.MAX_VALUE;
        if (x != y) {
            return y > x ^ diffMSB;
        }
        for (i = 3; i >= 0 && this.Id[i] == nid.Id[i]; --i) {
        }
        if (i < 0) {
            return diffMSB;
        }
        long yl = (long)nid.Id[i] & 0xFFFFFFFFL;
        long xl = (long)this.Id[i] & 0xFFFFFFFFL;
        return yl > xl ^ diffMSB;
    }

    public boolean checkBit(int i) {
        int index = i / 32;
        int val = this.Id[index];
        int shift = i % 32;
        int mask = 1 << shift;
        return (val & mask) != 0;
    }

    public int indexOfMSDB(Id nid) {
        for (int i = 4; i >= 0; --i) {
            int cmp = this.Id[i] ^ nid.Id[i];
            if (cmp == 0) continue;
            int j = 0;
            int tmp = cmp & 0xFFFF0000;
            if (tmp != 0) {
                cmp = tmp;
                j += 16;
            }
            if ((tmp = cmp & 0xFF00FF00) != 0) {
                cmp = tmp;
                j += 8;
            }
            if ((tmp = cmp & 0xF0F0F0F0) != 0) {
                cmp = tmp;
                j += 4;
            }
            if ((tmp = cmp & 0xCCCCCCCC) != 0) {
                cmp = tmp;
                j += 2;
            }
            if ((tmp = cmp & 0xAAAAAAAA) != 0) {
                cmp = tmp;
                ++j;
            }
            return 32 * i + j;
        }
        return -1;
    }

    public int indexOfMSDD(Id nid, int base) {
        int ind = this.indexOfMSDB(nid);
        if ((ind -= 160 % base) < 0) {
            return ind;
        }
        return ind / base;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<0x");
        int n = 40;
        for (int i = n - 1; i >= n - 6; --i) {
            buffer.append(tran[this.getDigit(i, 4)]);
        }
        buffer.append("..>");
        return buffer.toString();
    }

    public String toStringBare() {
        StringBuffer buffer = new StringBuffer();
        int n = 40;
        for (int i = n - 1; i >= n - 6; --i) {
            buffer.append(tran[this.getDigit(i, 4)]);
        }
        return buffer.toString();
    }

    public String toStringFull() {
        StringBuffer buffer = new StringBuffer();
        int n = 40;
        for (int i = n - 1; i >= 0; --i) {
            buffer.append(tran[this.getDigit(i, 4)]);
        }
        return buffer.toString();
    }

    public boolean clockwise(rice.p2p.commonapi.Id nid) {
        return this.clockwise((Id)nid);
    }

    public rice.p2p.commonapi.Id addToId(Id.Distance offset) {
        return this.add((Distance)offset);
    }

    public Id.Distance distanceFromId(rice.p2p.commonapi.Id nid) {
        return this.distance((Id)nid);
    }

    public Id.Distance longDistanceFromId(rice.p2p.commonapi.Id nid) {
        return this.longDistance((Id)nid);
    }

    private int[] absDistance(Id nid) {
        return this.absDistance(nid, new int[5]);
    }

    private int[] absDistance(Id nid, int[] dist) {
        int carry = 0;
        if (this.compareTo(nid) > 0) {
            for (int i = 0; i < 5; ++i) {
                long x = (long)this.Id[i] & 0xFFFFFFFFL;
                long y = (long)nid.Id[i] & 0xFFFFFFFFL;
                long diff = x - y - (long)carry;
                carry = diff < 0L ? 1 : 0;
                dist[i] = (int)diff;
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                long y = (long)nid.Id[i] & 0xFFFFFFFFL;
                long x = (long)this.Id[i] & 0xFFFFFFFFL;
                long diff = y - x - (long)carry;
                carry = diff < 0L ? 1 : 0;
                dist[i] = (int)diff;
            }
        }
        return dist;
    }

    private void invert(int[] dist) {
        int carry = 0;
        for (int i = 0; i < 5; ++i) {
            long diff = (long)dist[i] & 0xFFFFFFFFL;
            if ((diff = 0L - diff - (long)carry) < 0L) {
                carry = 1;
            }
            dist[i] = (int)diff;
        }
    }

    public static int numDigits(int base) {
        return 160 / base;
    }

    public static Id makeRandomId(Random rng) {
        byte[] material = new byte[20];
        rng.nextBytes(material);
        return rice.pastry.Id.build(material);
    }

    public static Id makeRandomId(RandomSource rng) {
        byte[] material = new byte[20];
        rng.nextBytes(material);
        return rice.pastry.Id.build(material);
    }

    public static Id build(int[] material) {
        return rice.pastry.Id.resolve(ID_MAP, new Id(material));
    }

    public static Id build(InputBuffer buf) throws IOException {
        int[] material = new int[5];
        for (int i = 0; i < material.length; ++i) {
            material[i] = buf.readInt();
        }
        return rice.pastry.Id.build(material);
    }

    public static Id build(String hex) {
        while (hex.length() < 40) {
            hex = hex + "0";
        }
        return rice.pastry.Id.build(hex.toUpperCase().toCharArray(), 0, hex.length());
    }

    public static Id build(char[] chars, int offset, int length) {
        int[] array = new int[5];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 8; ++j) {
                array[4 - i] = array[4 - i] << 4 | rice.pastry.Id.trans(chars[offset + 8 * i + j]);
            }
        }
        return rice.pastry.Id.build(array);
    }

    protected static byte trans(char c) {
        if ('0' <= c && '9' >= c) {
            return (byte)(c - 48);
        }
        return (byte)(c - 65 + 10);
    }

    public static Id build(byte[] material) {
        return rice.pastry.Id.build(rice.pastry.Id.trans(material));
    }

    protected static int[] trans(byte[] material) {
        int[] array = new int[5];
        for (int j = 0; j < 20 && j < material.length; ++j) {
            int k = material[j] & 0xFF;
            int n = j / 4;
            array[n] = array[n] | k << j % 4 * 8;
        }
        return array;
    }

    public static Id build() {
        return rice.pastry.Id.build(new int[5]);
    }

    protected static int[] trans(String hex) {
        int[] ints = new int[5];
        for (int i = 0; i < 5; ++i) {
            String s = hex.substring(i * 8, (i + 1) * 8);
            ints[4 - i] = new BigInteger(s, 16).intValue();
        }
        return ints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Id resolve(WeakHashMap map, Id id) {
        WeakHashMap weakHashMap = map;
        synchronized (weakHashMap) {
            WeakReference ref = (WeakReference)map.get(id);
            Id result = null;
            if (ref != null && (result = (Id)ref.get()) != null) {
                return result;
            }
            map.put(id, new WeakReference<Id>(id));
            return id;
        }
    }

    public static class Distance
    implements Id.Distance {
        private int[] difference;

        public Distance() {
            this.difference = new int[5];
        }

        public Distance(byte[] diff) {
            this.difference = new int[5];
            for (int j = 0; j < 20 && j < diff.length; ++j) {
                int k = diff[j] & 0xFF;
                int n = j / 4;
                this.difference[n] = this.difference[n] | k << j % 4 * 8;
            }
        }

        public Distance(int[] diff) {
            this.difference = diff;
        }

        public void blit(byte[] target) {
            this.blit(target, 0);
        }

        public void blit(byte[] target, int offset) {
            for (int j = 0; j < 20; ++j) {
                int k = this.difference[j / 4] >> j % 4 * 8;
                target[offset + j] = (byte)(k & 0xFF);
            }
        }

        public byte[] copy() {
            byte[] target = new byte[20];
            this.blit(target);
            return target;
        }

        public int compareTo(Object obj) {
            Distance oth = (Distance)obj;
            for (int i = 4; i >= 0; --i) {
                if (this.difference[i] == oth.difference[i]) continue;
                long t = (long)this.difference[i] & 0xFFFFFFFFL;
                long o = (long)oth.difference[i] & 0xFFFFFFFFL;
                if (t < o) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public Distance shift(int cnt, int fill) {
            return this.shift(cnt, fill, false);
        }

        public Distance shift(int cnt, int fill, boolean roundUp) {
            int bit = 0;
            int lsb = 0;
            if (cnt > 0) {
                for (int j = 0; j < cnt; ++j) {
                    int carry = fill == 0 ? 0 : Integer.MIN_VALUE;
                    for (int i = 4; i >= 0; --i) {
                        bit = this.difference[i] & 1;
                        this.difference[i] = this.difference[i] >>> 1 | carry;
                        carry = bit == 0 ? 0 : Integer.MIN_VALUE;
                    }
                    if (j != 0) continue;
                    lsb = bit;
                }
                if (roundUp && lsb > 0) {
                    this.inc();
                }
            } else {
                for (int j = 0; j < -cnt; ++j) {
                    int carry = fill == 0 ? 0 : 1;
                    for (int i = 0; i < 5; ++i) {
                        bit = this.difference[i] & Integer.MIN_VALUE;
                        this.difference[i] = this.difference[i] << 1 | carry;
                        carry = bit == 0 ? 0 : 1;
                    }
                }
            }
            return this;
        }

        public int hashCode() {
            int h = 0;
            for (int i = 0; i < 5; ++i) {
                h ^= this.difference[i];
            }
            return h;
        }

        public String toString() {
            String s = "0x";
            String[] tran = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
            for (int j = 19; j >= 0; --j) {
                int k = this.difference[j / 4] >> j % 4 * 8;
                s = s + tran[k >> 4 & 0xF] + tran[k & 0xF];
            }
            return "< Id.distance " + s + " >";
        }

        public Id.Distance shiftDistance(int cnt, int fill) {
            return this.shift(cnt, fill);
        }

        private void inc() {
            int carry = 1;
            for (int i = 0; i < 5; ++i) {
                long x = (long)this.difference[i] & 0xFFFFFFFFL;
                long sum = x + (long)carry;
                carry = sum >= 0x100000000L ? 1 : 0;
                this.difference[i] = (int)sum;
            }
        }
    }
}

