/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util.rawserialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.util.rawserialization.JavaSerializationException;

public class JavaSerializedMessage
implements RawMessage {
    Message msg;

    public JavaSerializedMessage(Message msg) {
        this.msg = msg;
        if (msg == null) {
            throw new RuntimeException("msg cannot be null");
        }
    }

    public short getType() {
        return 0;
    }

    public Message getMessage() {
        return this.msg;
    }

    public byte getPriority() {
        return this.msg.getPriority();
    }

    public void serialize(OutputBuffer buf) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.msg);
            oos.close();
            byte[] temp = baos.toByteArray();
            buf.write(temp, 0, temp.length);
        }
        catch (IOException ioe) {
            throw new JavaSerializationException(this.msg, ioe);
        }
    }

    public String toString() {
        return "JavaSerializedMessage[" + this.msg + "]";
    }
}

