/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util.rawserialization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.util.rawserialization.JavaDeserializer;

public class JavaSerializedDeserializer
implements MessageDeserializer {
    protected Endpoint endpoint;
    private boolean deserializeOnlyTypeZero = true;

    public JavaSerializedDeserializer(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setAlwaysUseJavaSerialization(boolean val) {
        this.deserializeOnlyTypeZero = !val;
    }

    public Message deserialize(InputBuffer buf, short type, byte priority, NodeHandle sender) throws IOException {
        if (this.deserializeOnlyTypeZero && type != 0) {
            throw new IllegalArgumentException("Type must be zero, was " + type + ".  See http://freepastry.org/FreePastry/extendingRawMessages.html for more information.");
        }
        Object o = null;
        try {
            byte[] array = new byte[buf.bytesRemaining()];
            buf.read(array);
            JavaDeserializer ois = new JavaDeserializer(new ByteArrayInputStream(array), this.endpoint);
            o = ois.readObject();
            Message ret = (Message)o;
            return ret;
        }
        catch (StreamCorruptedException sce) {
            if (!this.deserializeOnlyTypeZero) {
                throw new RuntimeException("Not a java serialized message!  See http://freepastry.org/FreePastry/extendingRawMessages.html for more information.", sce);
            }
            throw sce;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unknown class type in message - closing channel.", e);
        }
    }
}

