/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Random;
import rice.environment.random.simple.SimpleRandomSource;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.util.MathUtils;

public class BloomFilter
implements Serializable {
    protected int[] parameters;
    protected int length;
    protected BitSet set;
    public static int PARAMETER_LENGTH = 4;

    public BloomFilter(int num, int length) {
        SimpleRandomSource rand = new SimpleRandomSource(null);
        this.length = length;
        this.set = new BitSet(length);
        this.parameters = new int[num];
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = MathUtils.randomInt(rand);
        }
    }

    public BloomFilter(InputBuffer buf) throws IOException {
        this.length = buf.readInt();
        this.parameters = new int[buf.readInt()];
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = buf.readInt();
        }
        int numBits = buf.readInt();
        this.set = new BitSet(numBits);
        byte curByte = buf.readByte();
        for (int i = 0; i < numBits; ++i) {
            if ((curByte >>> i % 8 & 1) == 1) {
                this.set.set(i);
            }
            if (i >= numBits - 1 || i % 8 != 7) continue;
            curByte = buf.readByte();
        }
    }

    public String getBitSet() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BloomFilter ");
        for (int i = 0; i < this.length; ++i) {
            if (this.set.get(i)) {
                buffer.append("1");
                continue;
            }
            buffer.append("0");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public void add(byte[] array) {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.set.set(this.hash(array, i));
        }
    }

    public boolean check(byte[] array) {
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.set.get(this.hash(array, i))) continue;
            return false;
        }
        return true;
    }

    protected int hash(byte[] array, int i) {
        if (this.length <= 0) {
            return 0;
        }
        return MathUtils.mod(this.doHash(array, this.parameters[i]), this.length);
    }

    protected int doHash(byte[] array, int seed) {
        int result = 0;
        byte[] tmp = new byte[4];
        for (int i = 0; i < array.length; i += 4) {
            System.arraycopy(array, i, tmp, 0, array.length - i < 4 ? array.length - i : 4);
            result += result * seed + MathUtils.byteArrayToInt(tmp);
        }
        return result;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeInt(this.length);
        buf.writeInt(this.parameters.length);
        for (int i = 0; i < this.parameters.length; ++i) {
            buf.writeInt(this.parameters[i]);
        }
        int numBits = this.set.length();
        buf.writeInt(numBits);
        byte curByte = 0;
        for (int i = 0; i < numBits; ++i) {
            if (i > 0 && i % 8 == 0) {
                buf.writeByte(curByte);
                curByte = 0;
            }
            if (!this.set.get(i)) continue;
            curByte = (byte)(curByte | 1 << i % 8);
        }
        buf.writeByte(curByte);
    }

    public static void main(String[] args) throws IOException {
        Random rng = new Random();
        for (int i = 0; i < 135; ++i) {
            BloomFilter a = new BloomFilter(1, i);
            for (int j = 0; j < i / 2; ++j) {
                int flip = rng.nextInt(i);
                a.set.flip(flip);
            }
            System.out.println("a:" + a.set);
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputBuffer obuf = new OutputBuffer(){
                DataOutputStream dos;
                {
                    this.dos = new DataOutputStream(baos);
                }

                public ByteArrayOutputStream getBaos() {
                    return baos;
                }

                public void writeInt(int v) throws IOException {
                    this.dos.writeInt(v);
                }

                public void writeByte(byte v) throws IOException {
                    this.dos.writeByte(v);
                }

                public int bytesRemaining() {
                    throw new RuntimeException("Not Implemented.");
                }

                public void writeUTF(String str) throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public void writeShort(short v) throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public void writeLong(long v) throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public void writeFloat(float v) throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public void writeDouble(double v) throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public void writeChar(char v) throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public void writeBoolean(boolean v) throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }
            };
            a.serialize(obuf);
            final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            InputBuffer buf = new InputBuffer(){
                DataInputStream dis;
                {
                    this.dis = new DataInputStream(bais);
                }

                public int readInt() throws IOException {
                    return this.dis.readInt();
                }

                public byte readByte() throws IOException {
                    return this.dis.readByte();
                }

                public int bytesRemaining() {
                    throw new RuntimeException("Not Implemented.");
                }

                public String readUTF() throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public short readShort() throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public short peakShort() throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public long readLong() throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public float readFloat() throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public double readDouble() throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public char readChar() throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public boolean readBoolean() throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public int read(byte[] b) throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    throw new RuntimeException("Not Implemented.");
                }
            };
            BloomFilter b = new BloomFilter(buf);
            if (b.set.equals(a.set)) continue;
            System.out.println(i + "a:" + a.set);
            System.out.println(i + "b:" + b.set);
            System.out.println();
        }
    }
}

