/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.AnycastMessage;
import rice.p2p.scribe.rawserialization.RawScribeContent;
import rice.p2p.scribe.rawserialization.ScribeContentDeserializer;

public class SubscribeMessage
extends AnycastMessage {
    protected NodeHandle subscriber;
    protected Id previousParent;
    protected int id;
    public static final short TYPE = 2;

    public SubscribeMessage(NodeHandle source, Topic topic, int id, RawScribeContent content) {
        this(source, topic, null, id, content);
    }

    public SubscribeMessage(NodeHandle source, Topic topic, Id previousParent, int id, RawScribeContent content) {
        super(source, topic, content);
        this.id = id;
        this.subscriber = source;
        this.previousParent = previousParent;
    }

    private SubscribeMessage(InputBuffer buf, Endpoint endpoint, ScribeContentDeserializer contentDeserializer) throws IOException {
        super(buf, endpoint, contentDeserializer);
        this.id = buf.readInt();
        if (buf.readBoolean()) {
            this.previousParent = endpoint.readId(buf, buf.readShort());
        }
        this.subscriber = endpoint.readNodeHandle(buf);
    }

    public NodeHandle getSubscriber() {
        return this.subscriber;
    }

    public Id getPreviousParent() {
        return this.previousParent;
    }

    public int getId() {
        return this.id;
    }

    public short getType() {
        return 2;
    }

    public String toString() {
        return "[SubscribeMessage " + this.topic + " subscriber " + this.subscriber + " ID " + this.id + "]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        super.serializeHelper(buf);
        buf.writeInt(this.id);
        if (this.previousParent == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeShort(this.previousParent.getType());
            this.previousParent.serialize(buf);
        }
        this.subscriber.serialize(buf);
    }

    public static SubscribeMessage buildSM(InputBuffer buf, Endpoint endpoint, ScribeContentDeserializer scd) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new SubscribeMessage(buf, endpoint, scd);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }
}

