/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.AbstractSubscribeMessage;

public class SubscribeAckMessage
extends AbstractSubscribeMessage {
    protected Id[] pathToRoot;
    public static final short TYPE = 3;

    public SubscribeAckMessage(NodeHandle source, Topic topic, Id[] pathToRoot, int id) {
        super(source, topic, id);
        this.pathToRoot = pathToRoot;
    }

    private SubscribeAckMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        this.pathToRoot = new Id[buf.readInt()];
        for (int i = 0; i < this.pathToRoot.length; ++i) {
            this.pathToRoot[i] = endpoint.readId(buf, buf.readShort());
        }
    }

    public Id[] getPathToRoot() {
        return this.pathToRoot;
    }

    public short getType() {
        return 3;
    }

    public String toString() {
        return "SubscribeAckMessage " + this.topic + " ID: " + this.id;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        super.serialize(buf);
        buf.writeInt(this.pathToRoot.length);
        for (int i = 0; i < this.pathToRoot.length; ++i) {
            buf.writeShort(this.pathToRoot[i].getType());
            this.pathToRoot[i].serialize(buf);
        }
    }

    public static SubscribeAckMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new SubscribeAckMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }
}

