/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.scribe.Topic;

public abstract class ScribeMessage
implements RawMessage {
    protected NodeHandle source;
    protected Topic topic;
    private static final long serialVersionUID = 4593674882226544604L;

    protected ScribeMessage(NodeHandle source, Topic topic) {
        this.source = source;
        this.topic = topic;
    }

    protected ScribeMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        if (buf.readBoolean()) {
            this.source = endpoint.readNodeHandle(buf);
        }
        this.topic = new Topic(buf, endpoint);
    }

    public byte getPriority() {
        return 10;
    }

    public NodeHandle getSource() {
        return this.source;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void setSource(NodeHandle source) {
        this.source = source;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        boolean hasSource = this.source != null;
        buf.writeBoolean(hasSource);
        if (hasSource) {
            this.source.serialize(buf);
        }
        this.topic.serialize(buf);
    }
}

