/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.ScribeMessage;
import rice.p2p.scribe.rawserialization.JavaSerializedScribeContent;
import rice.p2p.scribe.rawserialization.RawScribeContent;
import rice.p2p.scribe.rawserialization.ScribeContentDeserializer;

public class PublishRequestMessage
extends ScribeMessage {
    protected RawScribeContent content;
    public static final short TYPE = 9;

    public PublishRequestMessage(NodeHandle source, Topic topic, ScribeContent content) {
        this(source, topic, content instanceof RawScribeContent ? (RawScribeContent)content : new JavaSerializedScribeContent(content));
    }

    public PublishRequestMessage(NodeHandle source, Topic topic, RawScribeContent content) {
        super(source, topic);
        this.content = content;
    }

    private PublishRequestMessage(InputBuffer buf, Endpoint endpoint, ScribeContentDeserializer cd) throws IOException {
        super(buf, endpoint);
        short contentType = buf.readShort();
        this.content = contentType == 0 ? new JavaSerializedScribeContent(cd.deserializeScribeContent(buf, endpoint, contentType)) : (RawScribeContent)cd.deserializeScribeContent(buf, endpoint, contentType);
    }

    public ScribeContent getContent() {
        if (this.content.getType() == 0) {
            return ((JavaSerializedScribeContent)this.content).getContent();
        }
        return this.content;
    }

    public short getType() {
        return 9;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        super.serialize(buf);
        buf.writeShort(this.content.getType());
        this.content.serialize(buf);
    }

    public static PublishRequestMessage build(InputBuffer buf, Endpoint endpoint, ScribeContentDeserializer scd) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new PublishRequestMessage(buf, endpoint, scd);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }
}

