/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe;

import rice.environment.Environment;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.scribe.ScribeClient;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.AnycastMessage;
import rice.p2p.scribe.messaging.SubscribeMessage;

public interface ScribePolicy {
    public boolean allowSubscribe(SubscribeMessage var1, ScribeClient[] var2, NodeHandle[] var3);

    public void directAnycast(AnycastMessage var1, NodeHandle var2, NodeHandle[] var3);

    public void childAdded(Topic var1, NodeHandle var2);

    public void childRemoved(Topic var1, NodeHandle var2);

    public static class LimitedScribePolicy
    extends DefaultScribePolicy {
        protected int maxChildren;

        public LimitedScribePolicy(int max, Environment env) {
            super(env);
            this.maxChildren = max;
        }

        public boolean allowSubscribe(SubscribeMessage message, ScribeClient[] clients, NodeHandle[] children) {
            return children.length < this.maxChildren - 1;
        }
    }

    public static class DefaultScribePolicy
    implements ScribePolicy {
        protected Environment environment;

        public DefaultScribePolicy(Environment env) {
            this.environment = env;
        }

        public boolean allowSubscribe(SubscribeMessage message, ScribeClient[] clients, NodeHandle[] children) {
            return true;
        }

        public void directAnycast(AnycastMessage message, NodeHandle parent, NodeHandle[] children) {
            if (parent != null) {
                message.addLast(parent);
            }
            for (int i = 0; i < children.length; ++i) {
                int j = this.environment.getRandomSource().nextInt(children.length);
                int k = this.environment.getRandomSource().nextInt(children.length);
                NodeHandle tmp = children[j];
                children[j] = children[k];
                children[k] = tmp;
            }
            for (int l = 0; l < children.length; ++l) {
                message.addFirst(children[l]);
            }
        }

        public void childAdded(Topic topic, NodeHandle child) {
        }

        public void childRemoved(Topic topic, NodeHandle child) {
        }
    }
}

