/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.replication.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.replication.messaging.ReplicationMessage;
import rice.p2p.util.IdBloomFilter;

public class RequestMessage
extends ReplicationMessage {
    protected IdRange[] ranges;
    protected IdBloomFilter[] filters;
    public static final short TYPE = 2;

    public RequestMessage(NodeHandle source, IdRange[] ranges, IdBloomFilter[] filters) {
        super(source);
        this.ranges = ranges;
        this.filters = filters;
    }

    private RequestMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        int i;
        this.filters = new IdBloomFilter[buf.readInt()];
        for (i = 0; i < this.filters.length; ++i) {
            this.filters[i] = new IdBloomFilter(buf);
        }
        this.ranges = new IdRange[buf.readInt()];
        for (i = 0; i < this.ranges.length; ++i) {
            this.ranges[i] = endpoint.readIdRange(buf);
        }
    }

    public IdRange[] getRanges() {
        return this.ranges;
    }

    public IdBloomFilter[] getFilters() {
        return this.filters;
    }

    public short getType() {
        return 2;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        int i;
        buf.writeByte((byte)0);
        super.serialize(buf);
        buf.writeInt(this.filters.length);
        for (i = 0; i < this.filters.length; ++i) {
            this.filters[i].serialize(buf);
        }
        buf.writeInt(this.ranges.length);
        for (i = 0; i < this.ranges.length; ++i) {
            this.ranges[i].serialize(buf);
        }
    }

    public static RequestMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new RequestMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }
}

