/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.gc.rawserialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.PastException;
import rice.p2p.past.gc.GCPast;
import rice.p2p.past.gc.GCPastContent;
import rice.p2p.past.gc.GCPastContentHandle;
import rice.p2p.past.gc.GCPastMetadata;
import rice.p2p.past.gc.rawserialization.RawGCPastContent;
import rice.p2p.util.rawserialization.JavaSerializationException;

public class JavaSerializedGCPastContent
implements RawGCPastContent {
    public GCPastContent content;
    public static final short TYPE = 0;

    public JavaSerializedGCPastContent(GCPastContent content) {
        this.content = content;
    }

    public short getType() {
        return 0;
    }

    public PastContent getContent() {
        return this.content;
    }

    public PastContentHandle getHandle(Past local) {
        return this.content.getHandle(local);
    }

    public Id getId() {
        return this.content.getId();
    }

    public boolean isMutable() {
        return this.content.isMutable();
    }

    public long getVersion() {
        return this.content.getVersion();
    }

    public GCPastContentHandle getHandle(GCPast local, long expiration) {
        return this.content.getHandle(local, expiration);
    }

    public GCPastMetadata getMetadata(long expiration) {
        return this.content.getMetadata(expiration);
    }

    public void serialize(OutputBuffer buf) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.content);
            oos.close();
            byte[] temp = baos.toByteArray();
            buf.writeInt(temp.length);
            buf.write(temp, 0, temp.length);
        }
        catch (IOException ioe) {
            throw new JavaSerializationException(this.content, ioe);
        }
    }

    public String toString() {
        return "JSPC [" + this.content + "]";
    }

    public PastContent checkInsert(Id id, PastContent existingContent) throws PastException {
        return this.content.checkInsert(id, existingContent);
    }
}

