/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.gc;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.Vector;
import rice.Continuation;
import rice.Executable;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastException;
import rice.p2p.past.PastImpl;
import rice.p2p.past.PastPolicy;
import rice.p2p.past.gc.GCId;
import rice.p2p.past.gc.GCIdRange;
import rice.p2p.past.gc.GCIdSet;
import rice.p2p.past.gc.GCNode;
import rice.p2p.past.gc.GCPast;
import rice.p2p.past.gc.GCPastContent;
import rice.p2p.past.gc.GCPastMetadata;
import rice.p2p.past.gc.messaging.GCCollectMessage;
import rice.p2p.past.gc.messaging.GCInsertMessage;
import rice.p2p.past.gc.messaging.GCLookupHandlesMessage;
import rice.p2p.past.gc.messaging.GCRefreshMessage;
import rice.p2p.past.messaging.FetchHandleMessage;
import rice.p2p.past.messaging.PastMessage;
import rice.persistence.Cache;
import rice.persistence.StorageManager;

public class GCPastImpl
extends PastImpl
implements GCPast {
    protected IdFactory realFactory;
    public int collected = 0;
    public int refreshed = 0;
    public static final long DEFAULT_EXPIRATION = Long.MAX_VALUE;

    public GCPastImpl(Node node, StorageManager manager, int replicas, String instance, PastPolicy policy, long collectionInterval) {
        this(node, manager, null, replicas, instance, policy, collectionInterval, null);
    }

    public GCPastImpl(Node node, StorageManager manager, Cache backup, int replicas, String instance, PastPolicy policy, long collectionInterval, StorageManager trash) {
        super(new GCNode(node), manager, backup, replicas, instance, policy, trash);
        this.realFactory = node.getIdFactory();
        this.endpoint.scheduleMessage(new GCCollectMessage(0, this.getLocalNodeHandle(), node.getId()), collectionInterval, collectionInterval);
        this.endpoint.setDeserializer(new GCPastDeserializer());
    }

    public String toString() {
        if (this.endpoint == null) {
            return super.toString();
        }
        return "GCPastImpl[" + this.endpoint.getInstance() + "]";
    }

    public void insert(PastContent obj, Continuation command) {
        this.insert(obj, Long.MAX_VALUE, command);
    }

    public void insert(final PastContent obj, final long expiration, Continuation command) {
        if (this.logger.level <= 500) {
            this.logger.log("Inserting data of class " + obj.getClass().getName() + " under " + obj.getId().toStringFull());
        }
        this.doInsert(obj.getId(), new PastImpl.MessageBuilder(){

            public PastMessage buildMessage() {
                return new GCInsertMessage(GCPastImpl.this.getUID(), obj, expiration, GCPastImpl.this.getLocalNodeHandle(), obj.getId());
            }
        }, command, this.socketStrategy.sendAlongSocket(1, obj));
    }

    public void refresh(Id[] array, long expiration, Continuation command) {
        long[] expirations = new long[array.length];
        Arrays.fill(expirations, expiration);
        this.refresh(array, expirations, command);
    }

    public void refresh(final Id[] array, long[] expirations, Continuation command) {
        if (this.logger.level <= 500) {
            this.logger.log("Refreshing " + array.length + " data elements");
        }
        GCIdSet set = new GCIdSet(this.realFactory);
        for (int i = 0; i < array.length; ++i) {
            set.addId(new GCId(array[i], expirations[i]));
        }
        this.refresh(set, new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                Object[] result = new Object[array.length];
                Arrays.fill(result, Boolean.TRUE);
                this.parent.receiveResult(result);
            }
        });
    }

    protected void refresh(final GCIdSet ids, Continuation command) {
        final Logger logger = this.environment.getLogManager().getLogger(GCPastImpl.class, this.instance);
        if (logger.level <= 500) {
            logger.log("REFRESH: CALLED WITH " + ids.numElements() + " ELEMENTS");
        }
        if (ids.numElements() == 0) {
            command.receiveResult(new Object[0]);
            return;
        }
        final Id[] array = ids.asArray();
        GCId start = (GCId)array[0];
        if (logger.level <= 500) {
            logger.log("REFRESH: GETTINGS ALL HANDLES OF " + start);
        }
        this.sendRequest(start.getId(), (PastMessage)new GCLookupHandlesMessage(this.getUID(), start.getId(), this.getLocalNodeHandle(), start.getId()), (Continuation)new Continuation.NamedContinuation("GCLookupHandles for " + start.getId(), command){

            public void receiveResult(Object o) {
                final NodeHandleSet set = (NodeHandleSet)o;
                final ReplicaMap map = new ReplicaMap();
                if (logger.level <= 500) {
                    logger.log("REFRESH: GOT " + set + " SET OF HANDLES!");
                }
                GCPastImpl.this.endpoint.process(new Executable(){

                    public Object execute() {
                        if (logger.level <= 500) {
                            logger.log("REFRESH: ON PROCESSING THREAD!");
                        }
                        for (int i = 0; i < array.length; ++i) {
                            GCId id = (GCId)array[i];
                            NodeHandleSet replicas = GCPastImpl.this.endpoint.replicaSet(id.getId(), GCPastImpl.this.replicationFactor + 1, set.getHandle(set.size() - 1), set);
                            if (replicas == null || replicas.size() != set.size() && replicas.size() != GCPastImpl.this.replicationFactor + 1) continue;
                            for (int j = 0; j < replicas.size(); ++j) {
                                map.addReplica(replicas.getHandle(j), id);
                            }
                            ++GCPastImpl.this.refreshed;
                            ids.removeId(id);
                        }
                        if (logger.level <= 500) {
                            logger.log("REFRESH: DONE WITH PROCESSING THREAD - MOVING TO NORMAL THREAD!");
                        }
                        return null;
                    }
                }, new Continuation.StandardContinuation(this.parent){

                    public void receiveResult(Object o) {
                        if (logger.level <= 500) {
                            logger.log("REFRESH: BACK ON NORMAL THREAD!");
                        }
                        final Iterator iterator = map.getReplicas();
                        Continuation.StandardContinuation send = new Continuation.StandardContinuation(this.parent){

                            public void receiveResult(Object o) {
                                if (iterator.hasNext()) {
                                    NodeHandle next = (NodeHandle)iterator.next();
                                    GCIdSet ids = map.getIds(next);
                                    if (logger.level <= 500) {
                                        logger.log("REFRESH: SENDING REQUEST TO " + next + " FOR IDSET " + ids);
                                    }
                                    GCPastImpl.this.sendRequest(next, new GCRefreshMessage(GCPastImpl.this.getUID(), ids, GCPastImpl.this.getLocalNodeHandle(), next.getId()), new Continuation.NamedContinuation("GCRefresh to " + next, this));
                                } else {
                                    if (logger.level <= 500) {
                                        logger.log("REFRESH: DONE SENDING REQUESTS, RECURSING");
                                    }
                                    GCPastImpl.this.refresh(ids, this.parent);
                                }
                            }

                            public void receiveException(Exception e) {
                                if (logger.level <= 500) {
                                    logger.log("GOT EXCEPTION " + e + " REFRESHING ITEMS - CONTINUING");
                                }
                                this.receiveResult(null);
                            }
                        };
                        send.receiveResult(null);
                    }
                });
            }
        });
    }

    public boolean forward(RouteMessage message) {
        try {
            if (message.getMessage(this.endpoint.getDeserializer()) instanceof GCLookupHandlesMessage) {
                return true;
            }
            return super.forward(message);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void deliver(Id id, Message message) {
        PastMessage msg = (PastMessage)message;
        if (msg.isResponse()) {
            super.deliver(id, message);
        } else if (msg instanceof GCInsertMessage) {
            final GCInsertMessage imsg = (GCInsertMessage)msg;
            ++this.inserts;
            if (this.policy.allowInsert(imsg.getContent())) {
                Id theId = imsg.getContent().getId();
                if (theId == null && this.logger.level <= 1000) {
                    this.logger.log("Error: null Id from " + imsg.getContent() + " from " + imsg + " in " + this);
                }
                this.storage.getObject(theId, new Continuation.StandardContinuation(this.getResponseContinuation(msg)){

                    public void receiveResult(Object o) {
                        try {
                            GCPastContent content = (GCPastContent)imsg.getContent().checkInsert(imsg.getContent().getId(), (PastContent)o);
                            GCPastImpl.this.storage.store(content.getId(), content.getMetadata(imsg.getExpiration()), content, this.parent);
                        }
                        catch (PastException e) {
                            this.parent.receiveException(e);
                        }
                    }
                });
            } else {
                this.getResponseContinuation(msg).receiveResult(new Boolean(false));
            }
        } else if (msg instanceof GCRefreshMessage) {
            GCRefreshMessage rmsg = (GCRefreshMessage)msg;
            final Iterator<GCId> i = Arrays.asList(rmsg.getKeys()).iterator();
            final Vector result = new Vector();
            this.other += rmsg.getKeys().length;
            Continuation.StandardContinuation process = new Continuation.StandardContinuation(this.getResponseContinuation(msg)){

                public void receiveResult(Object o) {
                    if (o != null) {
                        result.addElement(o);
                    }
                    if (i.hasNext()) {
                        final GCId id = (GCId)i.next();
                        if (GCPastImpl.this.storage.exists(id.getId())) {
                            GCPastMetadata metadata = (GCPastMetadata)GCPastImpl.this.storage.getMetadata(id.getId());
                            if (metadata != null) {
                                if (metadata.getExpiration() < id.getExpiration()) {
                                    GCPastImpl.this.storage.setMetadata(id.getId(), metadata.setExpiration(id.getExpiration()), this);
                                } else {
                                    this.receiveResult(Boolean.FALSE);
                                }
                            } else {
                                GCPastImpl.this.storage.getObject(id.getId(), new Continuation.StandardContinuation(this){

                                    public void receiveResult(Object o) {
                                        GCPastImpl.this.storage.setMetadata(id.getId(), ((GCPastContent)o).getMetadata(id.getExpiration()), this.parent);
                                    }
                                });
                            }
                        } else if (GCPastImpl.this.trash != null) {
                            GCPastImpl.this.trash.getObject(id.getId(), new Continuation.StandardContinuation(this){

                                public void receiveResult(Object o) {
                                    if (o != null && o instanceof GCPastContent) {
                                        if (((GCPastImpl)GCPastImpl.this).logger.level <= 500) {
                                            GCPastImpl.this.logger.log("GCREFRESH: Restoring object " + id + " from trash!");
                                        }
                                        GCPastContent content = (GCPastContent)o;
                                        GCPastImpl.this.storage.store(id.getId(), content.getMetadata(id.getExpiration()), content, new Continuation.StandardContinuation(this.parent){

                                            public void receiveResult(Object o) {
                                                GCPastImpl.this.trash.unstore(id.getId(), this.parent);
                                            }
                                        });
                                    } else {
                                        this.parent.receiveResult(Boolean.FALSE);
                                    }
                                }
                            });
                        } else {
                            this.receiveResult(Boolean.FALSE);
                        }
                    } else {
                        this.parent.receiveResult(result.toArray(new Boolean[0]));
                    }
                }
            };
            process.receiveResult(null);
        } else if (msg instanceof GCLookupHandlesMessage) {
            GCLookupHandlesMessage lmsg = (GCLookupHandlesMessage)msg;
            NodeHandleSet set = this.endpoint.neighborSet(lmsg.getMax());
            set.removeHandle(this.getLocalNodeHandle().getId());
            set.putHandle(this.getLocalNodeHandle());
            if (this.logger.level <= 400) {
                this.logger.log("Returning neighbor set " + set + " for lookup handles of id " + lmsg.getId() + " max " + lmsg.getMax() + " at " + this.endpoint.getId());
            }
            this.getResponseContinuation(msg).receiveResult(set);
        } else if (msg instanceof GCCollectMessage) {
            this.collect(this.storage.scanMetadataValuesHead(new GCPastMetadata(this.environment.getTimeSource().currentTimeMillis())), new Continuation.ListenerContinuation("Removal of expired ids", this.environment){

                public void receiveResult(Object o) {
                    if (GCPastImpl.this.environment.getTimeSource().currentTimeMillis() > Long.MAX_VALUE) {
                        GCPastImpl.this.collect(GCPastImpl.this.storage.scanMetadataValuesNull(), new Continuation.ListenerContinuation("Removal of default expired ids", GCPastImpl.this.environment));
                    }
                }
            });
        } else if (msg instanceof FetchHandleMessage) {
            final FetchHandleMessage fmsg = (FetchHandleMessage)msg;
            ++this.fetchHandles;
            this.storage.getObject(fmsg.getId(), new Continuation.StandardContinuation(this.getResponseContinuation(msg)){

                public void receiveResult(Object o) {
                    GCPastContent content = (GCPastContent)o;
                    if (content != null) {
                        GCPastMetadata metadata;
                        if (((GCPastImpl)GCPastImpl.this).logger.level <= 500) {
                            GCPastImpl.this.logger.log("Retrieved data for fetch handles of id " + fmsg.getId());
                        }
                        if ((metadata = (GCPastMetadata)GCPastImpl.this.storage.getMetadata(fmsg.getId())) != null) {
                            this.parent.receiveResult(content.getHandle(GCPastImpl.this, metadata.getExpiration()));
                        } else {
                            this.parent.receiveResult(content.getHandle(GCPastImpl.this, Long.MAX_VALUE));
                        }
                    } else {
                        this.parent.receiveResult(null);
                    }
                }
            });
        } else {
            super.deliver(id, message);
        }
    }

    protected void collect(SortedMap map, Continuation command) {
        final Iterator i = map.keySet().iterator();
        Continuation.StandardContinuation remove = new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                if (i.hasNext()) {
                    final Id gid = (Id)i.next();
                    GCPastMetadata metadata = (GCPastMetadata)GCPastImpl.this.storage.getMetadata(gid);
                    ++GCPastImpl.this.collected;
                    if (GCPastImpl.this.trash != null) {
                        GCPastImpl.this.storage.getObject(gid, new Continuation.StandardContinuation(this){

                            public void receiveResult(Object o) {
                                if (o != null) {
                                    GCPastImpl.this.trash.store(gid, GCPastImpl.this.storage.getMetadata(gid), (Serializable)o, new Continuation.StandardContinuation(this.parent){

                                        public void receiveResult(Object o) {
                                            GCPastImpl.this.storage.unstore(gid, this.parent);
                                        }
                                    });
                                } else {
                                    GCPastImpl.this.storage.unstore(gid, this);
                                }
                            }
                        });
                    } else {
                        GCPastImpl.this.storage.unstore(gid, this);
                    }
                } else {
                    this.parent.receiveResult(Boolean.TRUE);
                }
            }
        };
        remove.receiveResult(null);
    }

    public void fetch(final Id id, NodeHandle hint, Continuation command) {
        GCId gcid;
        if (this.logger.level <= 400) {
            this.logger.log("Sending out replication fetch request for the id " + id);
        }
        if ((gcid = (GCId)id).getExpiration() < this.environment.getTimeSource().currentTimeMillis()) {
            command.receiveResult(Boolean.TRUE);
        } else if (this.storage.exists(gcid.getId())) {
            GCPastMetadata metadata = (GCPastMetadata)this.storage.getMetadata(gcid.getId());
            if (metadata == null) {
                this.storage.getObject(gcid.getId(), new Continuation.StandardContinuation(command){

                    public void receiveResult(Object o) {
                        GCPastContent content = (GCPastContent)o;
                        GCPastImpl.this.storage.setMetadata(content.getId(), content.getMetadata(gcid.getExpiration()), this.parent);
                    }
                });
            } else if (metadata.getExpiration() < gcid.getExpiration()) {
                this.storage.setMetadata(gcid.getId(), metadata.setExpiration(gcid.getExpiration()), command);
            } else {
                command.receiveResult(Boolean.TRUE);
            }
        } else {
            this.policy.fetch(gcid.getId(), hint, this.backup, this, new Continuation.StandardContinuation(command){

                public void receiveResult(Object o) {
                    if (o == null) {
                        if (((GCPastImpl)GCPastImpl.this).logger.level <= 900) {
                            GCPastImpl.this.logger.log("Could not fetch id " + id + " - policy returned null in namespace " + GCPastImpl.this.instance);
                        }
                        this.parent.receiveResult(new Boolean(false));
                    } else {
                        GCPastContent content = (GCPastContent)o;
                        if (((GCPastImpl)GCPastImpl.this).logger.level <= 300) {
                            GCPastImpl.this.logger.log("inserting replica of id " + id);
                        }
                        GCPastImpl.this.storage.getStorage().store(gcid.getId(), content.getMetadata(gcid.getExpiration()), content, this.parent);
                    }
                }
            });
        }
    }

    public void remove(Id id, Continuation command) {
        super.remove(((GCId)id).getId(), command);
    }

    public IdSet scan(IdRange range) {
        GCIdRange gcRange = (GCIdRange)range;
        return new GCIdSet(this.storage.getStorage().scan(gcRange.getRange()), this.storage.getStorage().scanMetadata(gcRange.getRange()));
    }

    public IdSet scan() {
        return new GCIdSet(this.storage.getStorage().scan(), this.storage.getStorage().scanMetadata());
    }

    public boolean exists(Id id) {
        if (id instanceof GCId) {
            return this.storage.getStorage().exists(((GCId)id).getId());
        }
        return this.storage.getStorage().exists(id);
    }

    public void existsInOverlay(Id id, Continuation command) {
        if (id instanceof GCId) {
            super.existsInOverlay(((GCId)id).getId(), command);
        } else {
            super.existsInOverlay(id, command);
        }
    }

    public void reInsert(final Id id, Continuation command) {
        if (id instanceof GCId) {
            this.storage.getObject(((GCId)id).getId(), new Continuation.StandardContinuation(command){

                public void receiveResult(Object o) {
                    GCPastImpl.this.insert((PastContent)o, ((GCId)id).getExpiration(), new Continuation.StandardContinuation(this.parent){

                        public void receiveResult(Object result) {
                            Boolean[] results = (Boolean[])result;
                            for (int i = 0; i < results.length; ++i) {
                                if (!results[i].booleanValue()) continue;
                                this.parent.receiveResult(Boolean.TRUE);
                                return;
                            }
                            this.parent.receiveResult(Boolean.FALSE);
                        }
                    });
                }
            });
        } else {
            GCPastMetadata metadata = (GCPastMetadata)this.storage.getMetadata(id);
            if (metadata == null) {
                super.reInsert(id, command);
            } else {
                this.reInsert(new GCId(id, metadata.getExpiration()), command);
            }
        }
    }

    protected class ReplicaMap {
        protected HashMap map = new HashMap();

        protected ReplicaMap() {
        }

        public Iterator getReplicas() {
            return this.map.keySet().iterator();
        }

        public GCIdSet getIds(NodeHandle replica) {
            return (GCIdSet)this.map.get(replica);
        }

        public void addReplica(NodeHandle handle, GCId id) {
            IdSet set = (IdSet)this.map.get(handle);
            if (set == null) {
                set = new GCIdSet(GCPastImpl.this.realFactory);
                this.map.put(handle, set);
            }
            set.addId(id);
        }
    }

    protected class GCPastDeserializer
    extends PastImpl.PastDeserializer {
        protected GCPastDeserializer() {
        }

        public Message deserialize(InputBuffer buf, short type, byte priority, NodeHandle sender) throws IOException {
            try {
                switch (type) {
                    case 9: {
                        return GCInsertMessage.buildGC(buf, GCPastImpl.this.endpoint, GCPastImpl.this.contentDeserializer);
                    }
                    case 10: {
                        return GCLookupHandlesMessage.buildGC(buf, GCPastImpl.this.endpoint);
                    }
                    case 11: {
                        return GCRefreshMessage.build(buf, GCPastImpl.this.endpoint);
                    }
                }
            }
            catch (IOException e) {
                if (((GCPastImpl)GCPastImpl.this).logger.level <= 1000) {
                    GCPastImpl.this.logger.log("Exception in deserializer in " + GCPastImpl.this.endpoint.toString() + ":" + GCPastImpl.this.instance + " " + e);
                }
                throw e;
            }
            return super.deserialize(buf, type, priority, sender);
        }
    }
}

