/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import rice.environment.Environment;
import rice.p2p.commonapi.Id;
import rice.p2p.util.SecurityUtils;
import rice.p2p.util.XMLObjectInputStream;
import rice.p2p.util.XMLObjectOutputStream;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.dist.DistPastryNodeFactory;

public class RingCertificate
implements Serializable {
    protected String name;
    protected Id id;
    protected Integer protocol;
    protected InetSocketAddress[] bootstraps;
    protected Integer port;
    protected InetSocketAddress logServer;
    protected PublicKey key;
    protected Long version;
    protected byte[] signature;
    private static final long serialVersionUID = 5915358246762577456L;
    protected static HashMap CERTIFICATES = new HashMap();

    public RingCertificate(String name, Id id, int protocol, InetSocketAddress[] bootstraps, int port, PublicKey key, InetSocketAddress logServer) {
        this.name = name;
        this.id = id;
        this.bootstraps = bootstraps;
        this.port = new Integer(port);
        this.key = key;
        this.logServer = logServer;
        this.version = new Long(System.currentTimeMillis());
        this.protocol = new Integer(protocol);
    }

    public String getName() {
        return this.name;
    }

    public Id getId() {
        return this.id;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public long getVersion() {
        return this.version;
    }

    public InetSocketAddress[] getBootstraps() {
        return this.bootstraps;
    }

    public int getPort() {
        return this.port;
    }

    public PublicKey getKey() {
        return this.key;
    }

    public InetSocketAddress getLogServer() {
        return this.logServer;
    }

    private Object getIdentifier() {
        return new Object[]{this.name, this.id, this.bootstraps, this.port, this.key, this.logServer, this.version, this.protocol};
    }

    private void refresh() {
        this.logServer = this.refreshAddress(this.logServer);
    }

    private InetSocketAddress refreshAddress(InetSocketAddress address) {
        return new InetSocketAddress(address.getAddress().getHostName(), address.getPort());
    }

    private void sign(PrivateKey priv) {
        if (this.signature != null) {
            throw new IllegalArgumentException("Attempt to sign an already-signed RingCertificate!");
        }
        try {
            this.signature = SecurityUtils.sign(SecurityUtils.serialize(this.getIdentifier()), priv);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean verify(PublicKey pub) {
        if (this.signature == null) {
            throw new IllegalArgumentException("Attempt to verify an unsigned RingCertificate!");
        }
        try {
            return SecurityUtils.verify(SecurityUtils.serialize(this.getIdentifier()), this.signature, pub);
        }
        catch (SecurityException e) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "[Ring Certificate for ring '" + this.name + "' (" + this.id + ")]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(File file) throws IOException {
        ObjectOutputStream oos = null;
        try {
            oos = new XMLObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
            oos.writeObject(this);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    public static RingCertificate getCertificate(Id ringId) {
        return (RingCertificate)CERTIFICATES.get(ringId);
    }

    private static RingCertificate readFromStream(InputStream stream) throws IOException {
        ObjectInputStream ois = null;
        try {
            ois = new XMLObjectInputStream(new BufferedInputStream(new GZIPInputStream(stream)));
            RingCertificate ringCertificate = (RingCertificate)ois.readObject();
            return ringCertificate;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    private static void writeKeyPair(KeyPair pair, String pass, String ring) throws IOException {
        byte[] cipher = SecurityUtils.encryptSymmetric(SecurityUtils.serialize(pair), SecurityUtils.hash(pass.getBytes()));
        XMLObjectOutputStream oos = new XMLObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(ring.toLowerCase() + ".ringkeypair.enc"))));
        oos.writeObject(cipher);
        ((ObjectOutputStream)oos).close();
    }

    public static KeyPair readKeyPair(String ring, String pass) throws ClassNotFoundException, IOException {
        XMLObjectInputStream ois = new XMLObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(ring.toLowerCase() + ".ringkeypair.enc"))));
        byte[] cipher = (byte[])ois.readObject();
        ((ObjectInputStream)ois).close();
        return (KeyPair)SecurityUtils.deserialize(SecurityUtils.decryptSymmetric(cipher, SecurityUtils.hash(pass.getBytes())));
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(System.out));
        File f = new File("ca.keypair.enc");
        XMLObjectInputStream ois = new XMLObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(f))));
        KeyPair caPair = (KeyPair)SecurityUtils.deserialize(SecurityUtils.decryptSymmetric((byte[])ois.readObject(), SecurityUtils.hash(RingCertificate.prompt(r, w, "Please enter the CA password: ").trim().getBytes())));
        ((ObjectInputStream)ois).close();
        String ring = RingCertificate.prompt(r, w, "Please enter the name of the ring (rice, berkeley): ");
        String[] bootstrap = RingCertificate.prompt(r, w, "Please enter the bootstraps (host1:port1,host2:port2...): ").trim().split(",");
        int port = Integer.parseInt(RingCertificate.prompt(r, w, "Please enter the default port for nodes: "));
        String logServer = RingCertificate.prompt(r, w, "Please enter the log upload server (host:port): ");
        String pass = RingCertificate.prompt(r, w, "Please enter a password for the ring keypair: ");
        int protocolId = 0;
        protocolId = DistPastryNodeFactory.PROTOCOL_SOCKET;
        Id id = RingCertificate.generateId(ring, env);
        InetSocketAddress log = RingCertificate.toInetSocketAddress(logServer);
        InetSocketAddress[] bootstraps = new InetSocketAddress[bootstrap.length];
        for (int i = 0; i < bootstraps.length; ++i) {
            bootstraps[i] = RingCertificate.toInetSocketAddress(bootstrap[i]);
        }
        KeyPair pair = SecurityUtils.generateKeyAsymmetric();
        RingCertificate cert = new RingCertificate(ring, id, protocolId, bootstraps, port, pair.getPublic(), log);
        cert.sign(caPair.getPrivate());
        if (!cert.verify(caPair.getPublic())) {
            throw new RuntimeException("Could not verify generated certificate!");
        }
        cert.writeToFile(new File(ring.toLowerCase() + ".ringcert"));
        RingCertificate.writeKeyPair(pair, pass, ring.toLowerCase());
        System.exit(0);
    }

    private static String prompt(BufferedReader r, BufferedWriter w, String prompt) throws IOException {
        w.write(prompt);
        w.flush();
        return r.readLine();
    }

    private static InetSocketAddress toInetSocketAddress(String s) throws IOException {
        String host = s.substring(0, s.indexOf(":"));
        int port = Integer.parseInt(s.substring(s.indexOf(":") + 1));
        return new InetSocketAddress(host, port);
    }

    private static Id generateId(String s, Environment env) {
        int i;
        String ring = s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
        PastryIdFactory pif = new PastryIdFactory(env);
        Id ringId = pif.buildId(ring);
        byte[] ringData = ringId.toByteArray();
        for (i = 0; i < ringData.length - env.getParameters().getInt("p2p_multiring_base"); ++i) {
            ringData[i] = 0;
        }
        if (s.toLowerCase().equals("global")) {
            for (i = 0; i < ringData.length; ++i) {
                ringData[i] = 0;
            }
        }
        return pif.buildId(ringData);
    }

    static {
        try {
            URL a = ClassLoader.getSystemResource("ca.publickey");
            InputStream b = a.openStream();
            GZIPInputStream c = new GZIPInputStream(b);
            BufferedInputStream d = new BufferedInputStream(c);
            XMLObjectInputStream ois = new XMLObjectInputStream(d);
            PublicKey caPublic = (PublicKey)ois.readObject();
            ((ObjectInputStream)ois).close();
            URL a1 = ClassLoader.getSystemResource("ringcert.list");
            InputStream b1 = a1.openStream();
            InputStreamReader c1 = new InputStreamReader(b1);
            BufferedReader r = new BufferedReader(c1);
            String filename = null;
            while ((filename = r.readLine()) != null) {
                URL a2 = ClassLoader.getSystemResource(filename);
                InputStream b2 = a2.openStream();
                RingCertificate cert = RingCertificate.readFromStream(b2);
                if (cert.verify(caPublic)) {
                    if (RingCertificate.getCertificate(cert.getId()) != null && RingCertificate.getCertificate(cert.getId()).getVersion() >= cert.getVersion()) continue;
                    cert.refresh();
                    CERTIFICATES.put(cert.getId(), cert);
                    continue;
                }
                System.err.println("RINGCERT: Could not verify ring certificate " + cert + " ignoring.");
            }
        }
        catch (Exception e) {
            System.err.println("RINGCERT: ERROR: Found exception " + e + " while reading in ring certificates!");
            e.printStackTrace();
        }
    }
}

