/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Observable;
import java.util.Observer;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.multiring.RingId;

public class MultiringNodeHandle
extends NodeHandle
implements Observer {
    protected NodeHandle handle;
    protected Id ringId;
    static final long serialVersionUID = -2972303779251779984L;

    public MultiringNodeHandle(Id ringId, NodeHandle handle) {
        this.handle = handle;
        this.ringId = ringId;
        handle.addObserver(this);
    }

    public MultiringNodeHandle(InputBuffer buf, Endpoint endpoint) throws IOException {
        this.ringId = endpoint.readId(buf, buf.readShort());
        this.handle = endpoint.readNodeHandle(buf);
        this.handle.addObserver(this);
    }

    protected NodeHandle getHandle() {
        return this.handle;
    }

    public Id getRingId() {
        return this.ringId;
    }

    public Id getId() {
        return RingId.build(this.ringId, this.handle.getId());
    }

    public boolean isAlive() {
        return this.handle.isAlive();
    }

    public int proximity() {
        return this.handle.proximity();
    }

    public void update(Observable o, Object obj) {
        this.setChanged();
        this.notifyObservers(obj);
    }

    public String toString() {
        return "{MNH " + this.handle.toString() + "@" + this.ringId + "}";
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiringNodeHandle)) {
            return false;
        }
        return ((MultiringNodeHandle)o).handle.equals(this.handle) && ((MultiringNodeHandle)o).ringId.equals(this.ringId);
    }

    public int hashCode() {
        return this.handle.hashCode() + this.ringId.hashCode();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.handle.addObserver(this);
    }

    public boolean checkLiveness() {
        return this.handle.checkLiveness();
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeShort(this.ringId.getType());
        this.ringId.serialize(buf);
        this.handle.serialize(buf);
    }
}

