/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.FragmentKey;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierQueryMessage
extends GlacierMessage {
    protected FragmentKey[] keys;
    public static final short TYPE = 5;

    public GlacierQueryMessage(int uid, FragmentKey[] keys, NodeHandle source, Id dest, char tag) {
        super(uid, source, dest, false, tag);
        this.keys = keys;
    }

    private GlacierQueryMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        this.keys = new FragmentKey[buf.readInt()];
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = new FragmentKey(buf, endpoint);
        }
    }

    public FragmentKey getKey(int index) {
        return this.keys[index];
    }

    public short getType() {
        return 5;
    }

    public int numKeys() {
        return this.keys.length;
    }

    public String toString() {
        return "[GlacierQuery for " + this.keys[0] + " (" + (this.numKeys() - 1) + " more keys)]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        super.serialize(buf);
        buf.writeInt(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i].serialize(buf);
        }
    }

    public static GlacierQueryMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GlacierQueryMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }
}

