/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2;

import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import rice.Continuation;
import rice.Executable;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.glacier.Fragment;
import rice.p2p.glacier.FragmentKey;
import rice.p2p.glacier.FragmentKeySet;
import rice.p2p.glacier.Glacier;
import rice.p2p.glacier.GlacierException;
import rice.p2p.glacier.VersionKey;
import rice.p2p.glacier.VersioningPast;
import rice.p2p.glacier.v2.BloomFilter;
import rice.p2p.glacier.v2.DebugContent;
import rice.p2p.glacier.v2.FragmentAndManifest;
import rice.p2p.glacier.v2.FragmentMetadata;
import rice.p2p.glacier.v2.GlacierContentHandle;
import rice.p2p.glacier.v2.GlacierContinuation;
import rice.p2p.glacier.v2.GlacierNotEnoughFragmentsException;
import rice.p2p.glacier.v2.GlacierPolicy;
import rice.p2p.glacier.v2.GlacierStatistics;
import rice.p2p.glacier.v2.GlacierStatisticsListener;
import rice.p2p.glacier.v2.Manifest;
import rice.p2p.glacier.v2.messaging.GlacierDataMessage;
import rice.p2p.glacier.v2.messaging.GlacierFetchMessage;
import rice.p2p.glacier.v2.messaging.GlacierMessage;
import rice.p2p.glacier.v2.messaging.GlacierNeighborRequestMessage;
import rice.p2p.glacier.v2.messaging.GlacierNeighborResponseMessage;
import rice.p2p.glacier.v2.messaging.GlacierQueryMessage;
import rice.p2p.glacier.v2.messaging.GlacierRangeForwardMessage;
import rice.p2p.glacier.v2.messaging.GlacierRangeQueryMessage;
import rice.p2p.glacier.v2.messaging.GlacierRangeResponseMessage;
import rice.p2p.glacier.v2.messaging.GlacierRefreshCompleteMessage;
import rice.p2p.glacier.v2.messaging.GlacierRefreshPatchMessage;
import rice.p2p.glacier.v2.messaging.GlacierRefreshProbeMessage;
import rice.p2p.glacier.v2.messaging.GlacierRefreshResponseMessage;
import rice.p2p.glacier.v2.messaging.GlacierResponseMessage;
import rice.p2p.glacier.v2.messaging.GlacierSyncMessage;
import rice.p2p.glacier.v2.messaging.GlacierTimeoutMessage;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.gc.GCPast;
import rice.p2p.past.gc.GCPastContent;
import rice.p2p.past.rawserialization.JavaPastContentDeserializer;
import rice.p2p.past.rawserialization.JavaPastContentHandleDeserializer;
import rice.p2p.past.rawserialization.PastContentDeserializer;
import rice.p2p.past.rawserialization.PastContentHandleDeserializer;
import rice.p2p.util.DebugCommandHandler;
import rice.persistence.PersistentStorage;
import rice.persistence.Storage;
import rice.persistence.StorageManager;

public class GlacierImpl
implements Application,
DebugCommandHandler,
GCPast,
Glacier,
VersioningPast {
    protected final StorageManager fragmentStorage;
    protected final StorageManager neighborStorage;
    protected final GlacierPolicy policy;
    protected final Node node;
    protected final int numFragments;
    protected final String instance;
    protected final int numSurvivors;
    protected final Endpoint endpoint;
    protected final IdFactory factory;
    protected final Hashtable continuations;
    protected final Hashtable pendingTraffic;
    protected StorageManager trashStorage;
    protected long nextContinuationTimeout;
    protected IdRange responsibleRange;
    protected int nextUID;
    protected CancellableTask timer;
    protected GlacierStatistics statistics;
    protected Vector listeners;
    protected long currentFragmentRequestTimeout;
    protected long tokenBucket;
    protected long bucketLastUpdated;
    protected long bucketMin;
    protected long bucketMax;
    protected long bucketConsumed;
    private final long SECONDS = 1000L;
    private final long MINUTES = 60000L;
    private final long HOURS = 3600000L;
    private final long DAYS = 86400000L;
    private final long WEEKS = 604800000L;
    private final boolean logStatistics;
    private final boolean faultInjectionEnabled;
    private final long insertTimeout;
    private final double minFragmentsAfterInsert;
    private final long refreshTimeout;
    private final long expireNeighborsDelayAfterJoin;
    private final long expireNeighborsInterval;
    private long neighborTimeout;
    private final long syncDelayAfterJoin;
    private final long syncMinRemainingLifetime;
    private final long syncMinQuietTime;
    private final int syncBloomFilterNumHashes;
    private final int syncBloomFilterBitsPerKey;
    private final int syncPartnersPerTrial;
    private long syncInterval;
    private final long syncRetryInterval;
    private int syncMaxFragments;
    private final int fragmentRequestMaxAttempts;
    private final long fragmentRequestTimeoutDefault;
    private final long fragmentRequestTimeoutMin;
    private final long fragmentRequestTimeoutMax;
    private final long fragmentRequestTimeoutDecrement;
    private final long manifestRequestTimeout;
    private final long manifestRequestInitialBurst;
    private final long manifestRequestRetryBurst;
    private final int manifestAggregationFactor;
    private final long overallRestoreTimeout;
    private final long handoffDelayAfterJoin;
    private final long handoffInterval;
    private final int handoffMaxFragments;
    private final long garbageCollectionInterval;
    private final int garbageCollectionMaxFragmentsPerRun;
    private final long localScanInterval;
    private final int localScanMaxFragmentsPerRun;
    private final double restoreMaxRequestFactor;
    private final int restoreMaxBoosts;
    private final long rateLimitedCheckInterval;
    private int rateLimitedRequestsPerSecond;
    private final boolean enableBulkRefresh;
    private final long bulkRefreshProbeInterval;
    private final double bulkRefreshMaxProbeFactor;
    private final long bulkRefreshManifestInterval;
    private final int bulkRefreshManifestAggregationFactor;
    private final int bulkRefreshPatchAggregationFactor;
    private final long bulkRefreshPatchInterval;
    private final int bulkRefreshPatchRetries;
    private long bucketTokensPerSecond;
    private long bucketMaxBurstSize;
    private final double jitterRange;
    private final long statisticsReportInterval;
    private final int maxActiveRestores;
    private int[] numActiveRestores;
    private final char tagNeighbor = '\u0001';
    private final char tagSync = (char)2;
    private final char tagSyncManifests = (char)3;
    private final char tagSyncFetch = (char)4;
    private final char tagHandoff = (char)5;
    private final char tagDebug = (char)6;
    private final char tagRefresh = (char)7;
    private final char tagInsert = (char)8;
    private final char tagLookupHandles = (char)9;
    private final char tagLookup = (char)10;
    private final char tagFetch = (char)11;
    private final char tagLocalScan = (char)12;
    private final char tagMax = (char)13;
    private Environment environment;
    protected Logger logger;
    protected PastContentDeserializer contentDeserializer;
    protected PastContentHandleDeserializer contentHandleDeserializer;

    public GlacierImpl(Node nodeArg, StorageManager fragmentStorageArg, StorageManager neighborStorageArg, int numFragmentsArg, int numSurvivorsArg, IdFactory factoryArg, String instanceArg, GlacierPolicy policyArg) {
        this.environment = nodeArg.getEnvironment();
        this.logger = this.environment.getLogManager().getLogger(GlacierImpl.class, instanceArg);
        Parameters p = this.environment.getParameters();
        this.logStatistics = p.getBoolean("p2p_glacier_logStatistics");
        this.faultInjectionEnabled = p.getBoolean("p2p_glacier_faultInjectionEnabled");
        this.insertTimeout = p.getLong("p2p_glacier_insertTimeout");
        this.minFragmentsAfterInsert = p.getDouble("p2p_glacier_minFragmentsAfterInsert");
        this.refreshTimeout = p.getLong("p2p_glacier_refreshTimeout");
        this.expireNeighborsDelayAfterJoin = p.getLong("p2p_glacier_expireNeighborsDelayAfterJoin");
        this.expireNeighborsInterval = p.getLong("p2p_glacier_expireNeighborsInterval");
        this.neighborTimeout = p.getLong("p2p_glacier_neighborTimeout");
        this.syncDelayAfterJoin = p.getLong("p2p_glacier_syncDelayAfterJoin");
        this.syncMinRemainingLifetime = p.getLong("p2p_glacier_syncMinRemainingLifetime");
        this.syncMinQuietTime = p.getLong("p2p_glacier_syncMinQuietTime");
        this.syncBloomFilterNumHashes = p.getInt("p2p_glacier_syncBloomFilterNumHashes");
        this.syncBloomFilterBitsPerKey = p.getInt("p2p_glacier_syncBloomFilterBitsPerKey");
        this.syncPartnersPerTrial = p.getInt("p2p_glacier_syncPartnersPerTrial");
        this.syncInterval = p.getLong("p2p_glacier_syncInterval");
        this.syncRetryInterval = p.getLong("p2p_glacier_syncRetryInterval");
        this.syncMaxFragments = p.getInt("p2p_glacier_syncMaxFragments");
        this.fragmentRequestMaxAttempts = p.getInt("p2p_glacier_fragmentRequestMaxAttempts");
        this.fragmentRequestTimeoutDefault = p.getLong("p2p_glacier_fragmentRequestTimeoutDefault");
        this.fragmentRequestTimeoutMin = p.getLong("p2p_glacier_fragmentRequestTimeoutMin");
        this.fragmentRequestTimeoutMax = p.getLong("p2p_glacier_fragmentRequestTimeoutMax");
        this.fragmentRequestTimeoutDecrement = p.getLong("p2p_glacier_fragmentRequestTimeoutDecrement");
        this.manifestRequestTimeout = p.getLong("p2p_glacier_manifestRequestTimeout");
        this.manifestRequestInitialBurst = p.getLong("p2p_glacier_manifestRequestInitialBurst");
        this.manifestRequestRetryBurst = p.getLong("p2p_glacier_manifestRequestRetryBurst");
        this.manifestAggregationFactor = p.getInt("p2p_glacier_manifestAggregationFactor");
        this.overallRestoreTimeout = p.getLong("p2p_glacier_overallRestoreTimeout");
        this.handoffDelayAfterJoin = p.getLong("p2p_glacier_handoffDelayAfterJoin");
        this.handoffInterval = p.getLong("p2p_glacier_handoffInterval");
        this.handoffMaxFragments = p.getInt("p2p_glacier_handoffMaxFragments");
        this.garbageCollectionInterval = p.getLong("p2p_glacier_garbageCollectionInterval");
        this.garbageCollectionMaxFragmentsPerRun = p.getInt("p2p_glacier_garbageCollectionMaxFragmentsPerRun");
        this.localScanInterval = p.getLong("p2p_glacier_localScanInterval");
        this.localScanMaxFragmentsPerRun = p.getInt("p2p_glacier_localScanMaxFragmentsPerRun");
        this.restoreMaxRequestFactor = p.getDouble("p2p_glacier_restoreMaxRequestFactor");
        this.restoreMaxBoosts = p.getInt("p2p_glacier_restoreMaxBoosts");
        this.rateLimitedCheckInterval = p.getLong("p2p_glacier_rateLimitedCheckInterval");
        this.rateLimitedRequestsPerSecond = p.getInt("p2p_glacier_rateLimitedRequestsPerSecond");
        this.enableBulkRefresh = p.getBoolean("p2p_glacier_enableBulkRefresh");
        this.bulkRefreshProbeInterval = p.getLong("p2p_glacier_bulkRefreshProbeInterval");
        this.bulkRefreshMaxProbeFactor = p.getDouble("p2p_glacier_bulkRefreshMaxProbeFactor");
        this.bulkRefreshManifestInterval = p.getLong("p2p_glacier_bulkRefreshManifestInterval");
        this.bulkRefreshManifestAggregationFactor = p.getInt("p2p_glacier_bulkRefreshManifestAggregationFactor");
        this.bulkRefreshPatchAggregationFactor = p.getInt("p2p_glacier_bulkRefreshPatchAggregationFactor");
        this.bulkRefreshPatchInterval = p.getLong("p2p_glacier_bulkRefreshPatchInterval");
        this.bulkRefreshPatchRetries = p.getInt("p2p_glacier_bulkRefreshPatchRetries");
        this.bucketTokensPerSecond = p.getLong("p2p_glacier_bucketTokensPerSecond");
        this.bucketMaxBurstSize = p.getLong("p2p_glacier_bucketMaxBurstSize");
        this.jitterRange = p.getDouble("p2p_glacier_jitterRange");
        this.statisticsReportInterval = p.getLong("p2p_glacier_statisticsReportInterval");
        this.maxActiveRestores = p.getInt("p2p_glacier_maxActiveRestores");
        this.fragmentStorage = fragmentStorageArg;
        this.neighborStorage = neighborStorageArg;
        this.trashStorage = null;
        this.policy = policyArg;
        this.node = nodeArg;
        this.instance = instanceArg;
        this.endpoint = this.node.buildEndpoint(this, this.instance);
        this.endpoint.setDeserializer(new MessageDeserializer(){

            public Message deserialize(InputBuffer buf, short type, byte priority, NodeHandle sender) throws IOException {
                switch (type) {
                    case 1: {
                        return GlacierDataMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                    case 2: {
                        return GlacierFetchMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                    case 3: {
                        return GlacierNeighborRequestMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                    case 4: {
                        return GlacierNeighborResponseMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                    case 5: {
                        return GlacierQueryMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                    case 6: {
                        return GlacierRangeForwardMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                    case 7: {
                        return GlacierRangeQueryMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                    case 8: {
                        return GlacierRangeResponseMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                    case 9: {
                        return GlacierRefreshCompleteMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                    case 10: {
                        return GlacierRefreshPatchMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                    case 11: {
                        return GlacierRefreshProbeMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                    case 12: {
                        return GlacierRefreshResponseMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                    case 13: {
                        return GlacierResponseMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                    case 14: {
                        return GlacierSyncMessage.build(buf, GlacierImpl.this.endpoint);
                    }
                }
                throw new IllegalArgumentException("Unknown type:" + type);
            }
        });
        this.contentDeserializer = new JavaPastContentDeserializer();
        this.contentHandleDeserializer = new JavaPastContentHandleDeserializer();
        this.numFragments = numFragmentsArg;
        this.numSurvivors = numSurvivorsArg;
        this.factory = factoryArg;
        this.responsibleRange = null;
        this.nextUID = 0;
        this.continuations = new Hashtable();
        this.pendingTraffic = new Hashtable();
        this.timer = null;
        this.nextContinuationTimeout = -1L;
        this.statistics = new GlacierStatistics(13, this.environment);
        this.listeners = new Vector();
        this.numActiveRestores = new int[1];
        this.numActiveRestores[0] = 0;
        this.currentFragmentRequestTimeout = this.fragmentRequestTimeoutDefault;
        this.tokenBucket = 0L;
        this.bucketLastUpdated = this.environment.getTimeSource().currentTimeMillis();
        this.determineResponsibleRange();
        this.endpoint.register();
    }

    private byte[] getHashInput(VersionKey vkey, long expiration) {
        byte[] a = vkey.toByteArray();
        byte[] b = new byte[a.length + 8];
        for (int i = 0; i < a.length; ++i) {
            b[i] = a[i];
        }
        b[a.length + 0] = (byte)(0xFFL & expiration >> 56);
        b[a.length + 1] = (byte)(0xFFL & expiration >> 48);
        b[a.length + 2] = (byte)(0xFFL & expiration >> 40);
        b[a.length + 3] = (byte)(0xFFL & expiration >> 32);
        b[a.length + 4] = (byte)(0xFFL & expiration >> 24);
        b[a.length + 5] = (byte)(0xFFL & expiration >> 16);
        b[a.length + 6] = (byte)(0xFFL & expiration >> 8);
        b[a.length + 7] = (byte)(0xFFL & expiration);
        return b;
    }

    protected int getUID() {
        return this.nextUID++;
    }

    private Id getFragmentLocation(Id objectKey, int fragmentNr, long version) {
        double totalOffset = (double)((float)fragmentNr / (float)this.numFragments) + (double)version * 0.36787940442237393;
        return objectKey.addToId(this.factory.buildIdDistance(GlacierImpl.getDistance(totalOffset - Math.floor(totalOffset))));
    }

    private Id getFragmentLocation(FragmentKey fkey) {
        return this.getFragmentLocation(fkey.getVersionKey().getId(), fkey.getFragmentID(), fkey.getVersionKey().getVersion());
    }

    public Id[][] getNeighborRanges() {
        Iterator iter = this.neighborStorage.scan().getIterator();
        Vector<Id> ccwIDs = new Vector<Id>();
        Vector<Id> cwIDs = new Vector<Id>();
        Id myID = this.getLocalNodeHandle().getId();
        while (iter.hasNext()) {
            Id thisNeighbor = (Id)iter.next();
            if (myID.clockwise(thisNeighbor)) {
                cwIDs.add(thisNeighbor);
                continue;
            }
            ccwIDs.add(thisNeighbor);
        }
        for (int j = 0; j < 2; ++j) {
            Vector<Id> v = j == 0 ? cwIDs : ccwIDs;
            boolean madeProgress = true;
            while (madeProgress) {
                madeProgress = false;
                for (int i = 0; i < v.size() - 1; ++i) {
                    if (!((Id)v.elementAt(i + 1)).clockwise((Id)v.elementAt(i))) continue;
                    Object h = v.elementAt(i);
                    v.setElementAt((Id)v.elementAt(i + 1), i);
                    v.setElementAt((Id)h, i + 1);
                    madeProgress = true;
                }
            }
        }
        Vector<Id> allIDs = new Vector<Id>();
        allIDs.addAll(ccwIDs);
        allIDs.add(myID);
        allIDs.addAll(cwIDs);
        Id[][] result = new Id[allIDs.size()][3];
        for (int i = 0; i < allIDs.size(); ++i) {
            Id cwId;
            Id ccwId;
            Id currentElement = (Id)allIDs.elementAt(i);
            if (i > 0) {
                Id previousElement = (Id)allIDs.elementAt(i - 1);
                ccwId = previousElement.addToId(previousElement.distanceFromId(currentElement).shiftDistance(1, 0));
            } else {
                ccwId = currentElement;
            }
            if (i < allIDs.size() - 1) {
                Id nextElement = (Id)allIDs.elementAt(i + 1);
                cwId = currentElement.addToId(currentElement.distanceFromId(nextElement).shiftDistance(1, 0));
            } else {
                cwId = currentElement;
            }
            result[i][0] = ccwId;
            result[i][1] = currentElement;
            result[i][2] = cwId;
        }
        return result;
    }

    public int getReplicationFactor() {
        return 1;
    }

    public NodeHandle getLocalNodeHandle() {
        return this.endpoint.getLocalNodeHandle();
    }

    public long getTrashSize() {
        if (this.trashStorage == null) {
            return 0L;
        }
        return this.trashStorage.getStorage().getTotalSize();
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setTrashcan(StorageManager trashStorage) {
        this.trashStorage = trashStorage;
    }

    private void setTimer(int timeoutMsec) {
        this.timer = this.endpoint.scheduleMessage(new GlacierTimeoutMessage(0, this.getLocalNodeHandle()), timeoutMsec);
    }

    public void setSyncInterval(int syncIntervalSec) {
        this.syncInterval = (long)syncIntervalSec * 1000L;
    }

    public void setSyncMaxFragments(int syncMaxFragments) {
        this.syncMaxFragments = syncMaxFragments;
    }

    public void setRateLimit(int rps) {
        this.rateLimitedRequestsPerSecond = rps;
    }

    public void setNeighborTimeout(long neighborTimeoutMin) {
        this.neighborTimeout = neighborTimeoutMin * 60000L;
    }

    public void setBandwidthLimit(long bytesPerSecond, long maxBurst) {
        this.bucketTokensPerSecond = bytesPerSecond;
        this.bucketMaxBurstSize = maxBurst;
    }

    public void setContentDeserializer(PastContentDeserializer deserializer) {
        this.contentDeserializer = deserializer;
    }

    public void setContentHandleDeserializer(PastContentHandleDeserializer deserializer) {
        this.contentHandleDeserializer = deserializer;
    }

    public void startup() {
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Neighbor continuation";
            }

            public void init() {
                NodeHandle localHandle;
                this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.expireNeighborsDelayAfterJoin;
                NodeHandleSet leafSet = GlacierImpl.this.endpoint.neighborSet(999);
                NodeHandle cwExtreme = localHandle = GlacierImpl.this.getLocalNodeHandle();
                NodeHandle ccwExtreme = localHandle;
                for (int i = 0; i < leafSet.size(); ++i) {
                    NodeHandle thisHandle = leafSet.getHandle(i);
                    if (localHandle.getId().clockwise(thisHandle.getId())) {
                        if (!cwExtreme.getId().clockwise(thisHandle.getId())) continue;
                        cwExtreme = thisHandle;
                        continue;
                    }
                    if (!ccwExtreme.getId().clockwise(thisHandle.getId())) continue;
                    ccwExtreme = thisHandle;
                }
                IdRange leafRange = GlacierImpl.this.factory.buildIdRange(ccwExtreme.getId(), cwExtreme.getId());
                for (int k = 0; k < leafSet.size(); ++k) {
                    if (leafSet.getHandle(k).getId().equals(GlacierImpl.this.getLocalNodeHandle().getId())) continue;
                    GlacierImpl.this.neighborSeen(leafSet.getHandle(k).getId(), GlacierImpl.this.environment.getTimeSource().currentTimeMillis());
                    if (GlacierImpl.this.logger.level <= 800) {
                        GlacierImpl.this.logger.log("Asking " + leafSet.getHandle(k).getId() + " about neighbors in " + leafRange);
                    }
                    GlacierImpl.this.sendMessage(null, new GlacierNeighborRequestMessage(this.getMyUID(), leafRange, GlacierImpl.this.getLocalNodeHandle(), leafSet.getHandle(k).getId(), '\u0001'), leafSet.getHandle(k));
                }
            }

            public void receiveResult(Object o) {
                if (o instanceof GlacierNeighborResponseMessage) {
                    GlacierNeighborResponseMessage gnrm = (GlacierNeighborResponseMessage)o;
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("NeighborResponse from " + gnrm.getSource() + " with " + gnrm.numNeighbors() + " neighbors");
                    }
                    for (int i = 0; i < gnrm.numNeighbors(); ++i) {
                        GlacierImpl.this.neighborSeen(gnrm.getNeighbor(i), gnrm.getLastSeen(i));
                    }
                } else if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.log("Unknown response in neighbor continuation: " + o + " -- discarded");
                }
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.logException("Exception in neighbor continuation: ", e);
                }
                this.terminate();
            }

            public void timeoutExpired() {
                this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.expireNeighborsInterval;
                final long earliestAcceptableDate = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() - GlacierImpl.this.neighborTimeout;
                IdSet allNeighbors = GlacierImpl.this.neighborStorage.scan();
                Iterator iter = allNeighbors.getIterator();
                NodeHandleSet leafSet = GlacierImpl.this.endpoint.neighborSet(999);
                if (GlacierImpl.this.logger.level <= 800) {
                    GlacierImpl.this.logger.log("Checking neighborhood for expired certificates...");
                }
                while (iter.hasNext()) {
                    final Id thisNeighbor = (Id)iter.next();
                    if (leafSet.memberHandle(thisNeighbor)) {
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("CNE: Refreshing current neighbor: " + thisNeighbor);
                        }
                        GlacierImpl.this.neighborSeen(thisNeighbor, GlacierImpl.this.environment.getTimeSource().currentTimeMillis());
                        continue;
                    }
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("CNE: Retrieving " + thisNeighbor);
                    }
                    GlacierImpl.this.neighborStorage.getObject(thisNeighbor, new Continuation(){

                        public void receiveResult(Object o) {
                            if (o == null) {
                                if (GlacierImpl.this.logger.level <= 900) {
                                    GlacierImpl.this.logger.log("CNE: Cannot retrieve neighbor " + thisNeighbor);
                                }
                                return;
                            }
                            long lastSeen = (Long)o;
                            if (lastSeen < earliestAcceptableDate) {
                                if (GlacierImpl.this.logger.level <= 800) {
                                    GlacierImpl.this.logger.log("CNE: Removing expired neighbor " + thisNeighbor + " (" + lastSeen + "<" + earliestAcceptableDate + ")");
                                }
                                GlacierImpl.this.neighborStorage.unstore(thisNeighbor, new Continuation(){

                                    public void receiveResult(Object o) {
                                        if (GlacierImpl.this.logger.level <= 500) {
                                            GlacierImpl.this.logger.log("CNE unstore successful: " + thisNeighbor + ", returned " + o);
                                        }
                                    }

                                    public void receiveException(Exception e) {
                                        if (GlacierImpl.this.logger.level <= 900) {
                                            GlacierImpl.this.logger.log("CNE unstore failed: " + thisNeighbor + ", returned " + e);
                                        }
                                    }
                                });
                            } else if (GlacierImpl.this.logger.level <= 800) {
                                GlacierImpl.this.logger.log("CNE: Neighbor " + thisNeighbor + " still active, last seen " + lastSeen);
                            }
                        }

                        public void receiveException(Exception e) {
                            if (GlacierImpl.this.logger.level <= 900) {
                                GlacierImpl.this.logger.log("CNE: Exception while retrieving neighbor " + thisNeighbor + ", e=" + e);
                            }
                        }
                    });
                }
                GlacierImpl.this.determineResponsibleRange();
            }
        });
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;
            int offset;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Sync continuation";
            }

            public void init() {
                this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.syncDelayAfterJoin;
            }

            public void receiveResult(Object o) {
                if (o instanceof GlacierRangeResponseMessage) {
                    final GlacierRangeResponseMessage grrm = (GlacierRangeResponseMessage)o;
                    Id ccwId = GlacierImpl.this.getFragmentLocation(grrm.getCommonRange().getCCWId(), GlacierImpl.this.numFragments - this.offset, 0L);
                    Id cwId = GlacierImpl.this.getFragmentLocation(grrm.getCommonRange().getCWId(), GlacierImpl.this.numFragments - this.offset, 0L);
                    final IdRange originalRange = GlacierImpl.this.factory.buildIdRange(ccwId, cwId);
                    if (GlacierImpl.this.logger.level <= 800) {
                        GlacierImpl.this.logger.log("Range response (offset: " + this.offset + "): " + grrm.getCommonRange() + ", original=" + originalRange);
                    }
                    final IdSet keySet = GlacierImpl.this.fragmentStorage.scan();
                    GlacierImpl.this.endpoint.process(new Executable(){

                        public Object execute() {
                            BloomFilter bv = new BloomFilter((2 * keySet.numElements() + 5) * GlacierImpl.this.syncBloomFilterBitsPerKey, GlacierImpl.this.syncBloomFilterNumHashes, GlacierImpl.this.environment.getRandomSource());
                            Iterator iter = keySet.getIterator();
                            while (iter.hasNext()) {
                                FragmentKey fkey = (FragmentKey)iter.next();
                                Id thisPos = GlacierImpl.this.getFragmentLocation(fkey);
                                if (!originalRange.containsId(thisPos)) continue;
                                FragmentMetadata metadata = (FragmentMetadata)GlacierImpl.this.fragmentStorage.getMetadata(fkey);
                                if (metadata != null) {
                                    long currentExp = metadata.getCurrentExpiration();
                                    long prevExp = metadata.getPreviousExpiration();
                                    if (GlacierImpl.this.logger.level <= 400) {
                                        GlacierImpl.this.logger.log(" - Adding " + fkey + " as " + fkey.getVersionKey().getId() + ", ecur=" + currentExp + ", eprev=" + prevExp);
                                    }
                                    bv.add(GlacierImpl.this.getHashInput(fkey.getVersionKey(), currentExp));
                                    bv.add(GlacierImpl.this.getHashInput(fkey.getVersionKey(), prevExp));
                                    continue;
                                }
                                if (GlacierImpl.this.logger.level > 900) continue;
                                GlacierImpl.this.logger.log("SYNC Cannot read metadata of object " + fkey.toStringFull() + ", storage returned null");
                            }
                            return bv;
                        }
                    }, new Continuation(){

                        public void receiveResult(Object o) {
                            if (o instanceof BloomFilter) {
                                BloomFilter bv = (BloomFilter)o;
                                if (GlacierImpl.this.logger.level <= 500) {
                                    GlacierImpl.this.logger.log("Got " + bv);
                                }
                                if (GlacierImpl.this.logger.level <= 800) {
                                    GlacierImpl.this.logger.log(keySet.numElements() + " keys added, sending sync request...");
                                }
                                GlacierImpl.this.sendMessage(null, new GlacierSyncMessage(GlacierImpl.this.getUID(), grrm.getCommonRange(), offset, bv, GlacierImpl.this.getLocalNodeHandle(), grrm.getSource().getId(), '\u0002'), grrm.getSource());
                            } else if (GlacierImpl.this.logger.level <= 900) {
                                GlacierImpl.this.logger.log("While processing range response: Result is of unknown type: " + o + " -- discarding request");
                            }
                        }

                        public void receiveException(Exception e) {
                            if (GlacierImpl.this.logger.level <= 900) {
                                GlacierImpl.this.logger.logException("Exception while processing range response: " + e + " -- discarding request", e);
                            }
                        }
                    });
                } else if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.log("Unknown result in sync continuation: " + o + " -- discarded");
                }
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.logException("Exception in sync continuation: ", e);
                }
                this.terminate();
            }

            public void timeoutExpired() {
                if (GlacierImpl.this.numActiveRestores[0] > 0) {
                    if (GlacierImpl.this.logger.level <= 800) {
                        GlacierImpl.this.logger.log("Sync postponed; " + GlacierImpl.this.numActiveRestores[0] + " fetches pending");
                    }
                    this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.jitterTerm(GlacierImpl.this.syncRetryInterval);
                } else {
                    this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.jitterTerm(GlacierImpl.this.syncInterval);
                    this.offset = 1 + GlacierImpl.this.environment.getRandomSource().nextInt(GlacierImpl.this.numFragments - 1);
                    Id dest = GlacierImpl.this.getFragmentLocation(GlacierImpl.this.getLocalNodeHandle().getId(), this.offset, 0L);
                    Id ccwId = GlacierImpl.this.getFragmentLocation(GlacierImpl.this.responsibleRange.getCCWId(), this.offset, 0L);
                    Id cwId = GlacierImpl.this.getFragmentLocation(GlacierImpl.this.responsibleRange.getCWId(), this.offset, 0L);
                    IdRange requestedRange = GlacierImpl.this.factory.buildIdRange(ccwId, cwId);
                    if (GlacierImpl.this.logger.level <= 800) {
                        GlacierImpl.this.logger.log("Sending range query for (" + requestedRange + ") to " + dest);
                    }
                    GlacierImpl.this.sendMessage(dest, new GlacierRangeQueryMessage(this.getMyUID(), requestedRange, GlacierImpl.this.getLocalNodeHandle(), dest, '\u0002'), null);
                }
            }
        });
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Handoff continuation";
            }

            public void init() {
                this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.handoffDelayAfterJoin;
            }

            public void receiveResult(Object o) {
                if (o instanceof GlacierResponseMessage) {
                    final GlacierResponseMessage grm = (GlacierResponseMessage)o;
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("Received handoff response from " + grm.getSource().getId() + " with " + grm.numKeys() + " keys");
                    }
                    for (int i = 0; i < grm.numKeys(); ++i) {
                        final FragmentKey thisKey = grm.getKey(i);
                        if (grm.getAuthoritative(i)) {
                            if (grm.getHaveIt(i)) {
                                Id thisPos = GlacierImpl.this.getFragmentLocation(thisKey);
                                if (!GlacierImpl.this.responsibleRange.containsId(thisPos)) {
                                    if (GlacierImpl.this.logger.level <= 500) {
                                        GlacierImpl.this.logger.log("Deleting fragment " + thisKey);
                                    }
                                    GlacierImpl.this.deleteFragment(thisKey, new Continuation(){

                                        public void receiveResult(Object o) {
                                            if (GlacierImpl.this.logger.level <= 500) {
                                                GlacierImpl.this.logger.log("Handed off fragment deleted: " + thisKey + " (o=" + o + ")");
                                            }
                                        }

                                        public void receiveException(Exception e) {
                                            if (GlacierImpl.this.logger.level <= 900) {
                                                GlacierImpl.this.logger.logException("Delete failed during handoff: " + thisKey + ", returned ", e);
                                            }
                                        }
                                    });
                                    continue;
                                }
                                if (GlacierImpl.this.logger.level > 900) continue;
                                GlacierImpl.this.logger.log("Handoff response for " + thisKey + ", for which I am still responsible (attack?) -- ignored");
                                continue;
                            }
                            GlacierImpl.this.fragmentStorage.getObject(thisKey, new Continuation(){

                                public void receiveResult(Object o) {
                                    if (o != null) {
                                        if (GlacierImpl.this.logger.level <= 800) {
                                            GlacierImpl.this.logger.log("Fragment " + thisKey + " found (" + o + "), handing off...");
                                        }
                                        FragmentAndManifest fam = (FragmentAndManifest)o;
                                        GlacierImpl.this.sendMessage(null, new GlacierDataMessage(grm.getUID(), thisKey, fam.fragment, fam.manifest, GlacierImpl.this.getLocalNodeHandle(), grm.getSource().getId(), true, '\u0005'), grm.getSource());
                                    } else if (GlacierImpl.this.logger.level <= 900) {
                                        GlacierImpl.this.logger.log("Handoff failed; fragment " + thisKey + " not found in fragment store");
                                    }
                                }

                                public void receiveException(Exception e) {
                                    if (GlacierImpl.this.logger.level <= 900) {
                                        GlacierImpl.this.logger.logException("Handoff failed; exception while fetching " + thisKey + ", e=", e);
                                    }
                                }
                            });
                            continue;
                        }
                        if (GlacierImpl.this.logger.level > 500) continue;
                        GlacierImpl.this.logger.log("Ignoring fragment " + thisKey + " (haveIt=" + grm.getHaveIt(i) + ", authoritative=" + grm.getAuthoritative(i) + ")");
                    }
                } else if (o instanceof GlacierDataMessage) {
                    final GlacierDataMessage gdm = (GlacierDataMessage)o;
                    for (int i = 0; i < gdm.numKeys(); ++i) {
                        final FragmentKey thisKey = gdm.getKey(i);
                        Fragment thisFragment = gdm.getFragment(i);
                        final Manifest thisManifest = gdm.getManifest(i);
                        if (thisFragment != null && thisManifest != null) {
                            if (GlacierImpl.this.logger.level <= 800) {
                                GlacierImpl.this.logger.log("Handoff: Received Fragment+Manifest for " + thisKey);
                            }
                            if (!GlacierImpl.this.responsibleRange.containsId(GlacierImpl.this.getFragmentLocation(thisKey))) {
                                if (GlacierImpl.this.logger.level > 900) continue;
                                GlacierImpl.this.logger.log("Handoff: Not responsible for " + thisKey + " (at " + GlacierImpl.this.getFragmentLocation(thisKey) + ") -- discarding");
                                continue;
                            }
                            if (!GlacierImpl.this.policy.checkSignature(thisManifest, thisKey.getVersionKey())) {
                                if (GlacierImpl.this.logger.level > 900) continue;
                                GlacierImpl.this.logger.log("Handoff: Manifest is not signed properly");
                                continue;
                            }
                            if (!thisManifest.validatesFragment(thisFragment, thisKey.getFragmentID(), GlacierImpl.this.environment.getLogManager().getLogger(Manifest.class, GlacierImpl.this.instance))) {
                                if (GlacierImpl.this.logger.level > 900) continue;
                                GlacierImpl.this.logger.log("Handoff: Manifest does not validate this fragment");
                                continue;
                            }
                            if (!GlacierImpl.this.fragmentStorage.exists(thisKey)) {
                                if (GlacierImpl.this.logger.level <= 500) {
                                    GlacierImpl.this.logger.log("Handoff: Verified ok. Storing locally.");
                                }
                                FragmentAndManifest fam = new FragmentAndManifest(thisFragment, thisManifest);
                                GlacierImpl.this.fragmentStorage.store(thisKey, new FragmentMetadata(thisManifest.getExpiration(), 0L, GlacierImpl.this.environment.getTimeSource().currentTimeMillis()), fam, new Continuation(){

                                    public void receiveResult(Object o) {
                                        if (GlacierImpl.this.logger.level <= 800) {
                                            GlacierImpl.this.logger.log("Handoff: Stored OK, sending receipt: " + thisKey);
                                        }
                                        GlacierImpl.this.sendMessage(null, new GlacierResponseMessage(gdm.getUID(), thisKey, true, thisManifest.getExpiration(), GlacierImpl.this.responsibleRange.containsId(GlacierImpl.this.getFragmentLocation(thisKey)), GlacierImpl.this.getLocalNodeHandle(), gdm.getSource().getId(), true, '\u0005'), gdm.getSource());
                                    }

                                    public void receiveException(Exception e) {
                                        if (GlacierImpl.this.logger.level <= 900) {
                                            GlacierImpl.this.logger.log("Handoff: receiveException(" + e + ") while storing a fragment -- unexpected, ignored (key=" + thisKey + ")");
                                        }
                                    }
                                });
                                continue;
                            }
                            if (GlacierImpl.this.logger.level <= 900) {
                                GlacierImpl.this.logger.log("Handoff: We already have a fragment with this key! -- sending response");
                            }
                            GlacierImpl.this.sendMessage(null, new GlacierResponseMessage(gdm.getUID(), thisKey, true, thisManifest.getExpiration(), true, GlacierImpl.this.getLocalNodeHandle(), gdm.getSource().getId(), true, '\u0005'), gdm.getSource());
                            continue;
                        }
                        if (GlacierImpl.this.logger.level > 900) continue;
                        GlacierImpl.this.logger.log("Handoff: Either fragment or manifest are missing!");
                    }
                } else if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.log("Unexpected response in handoff continuation: " + o + " -- ignored");
                }
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.logException("Exception in handoff continuation: ", e);
                }
            }

            public void timeoutExpired() {
                this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.jitterTerm(GlacierImpl.this.handoffInterval);
                if (GlacierImpl.this.logger.level <= 800) {
                    GlacierImpl.this.logger.log("Checking fragment storage for fragments to hand off...");
                }
                if (GlacierImpl.this.logger.level <= 500) {
                    GlacierImpl.this.logger.log("Currently responsible for: " + GlacierImpl.this.responsibleRange);
                }
                Iterator iter = GlacierImpl.this.fragmentStorage.scan().getIterator();
                Vector<FragmentKey> handoffs = new Vector<FragmentKey>();
                Id destination = null;
                while (iter.hasNext()) {
                    FragmentKey fkey = (FragmentKey)iter.next();
                    Id thisPos = GlacierImpl.this.getFragmentLocation(fkey);
                    if (GlacierImpl.this.responsibleRange.containsId(thisPos)) continue;
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("Must hand off " + fkey + " @" + thisPos);
                    }
                    handoffs.add(fkey);
                    if (handoffs.size() >= GlacierImpl.this.handoffMaxFragments) {
                        if (GlacierImpl.this.logger.level > 500) break;
                        GlacierImpl.this.logger.log("Limit of " + GlacierImpl.this.handoffMaxFragments + " reached for handoff");
                        break;
                    }
                    if (destination != null) continue;
                    destination = thisPos;
                }
                if (destination == null) {
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("Nothing to hand off -- returning");
                    }
                    return;
                }
                int numHandoffs = Math.min(handoffs.size(), GlacierImpl.this.handoffMaxFragments);
                if (GlacierImpl.this.logger.level <= 800) {
                    GlacierImpl.this.logger.log("Handing off " + numHandoffs + " fragments (out of " + handoffs.size() + ")");
                }
                FragmentKey[] keys = new FragmentKey[numHandoffs];
                for (int i = 0; i < numHandoffs; ++i) {
                    keys[i] = (FragmentKey)handoffs.elementAt(i);
                }
                GlacierImpl.this.sendMessage(destination, new GlacierQueryMessage(this.getMyUID(), keys, GlacierImpl.this.getLocalNodeHandle(), destination, '\u0005'), null);
            }
        });
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Garbage collector";
            }

            public void init() {
                this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.garbageCollectionInterval;
            }

            public void receiveResult(Object o) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.log("GC received object: " + o);
                }
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.logException("GC received exception: ", e);
                }
            }

            public void timeoutExpired() {
                this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.garbageCollectionInterval;
                final long now = GlacierImpl.this.environment.getTimeSource().currentTimeMillis();
                IdSet fragments = GlacierImpl.this.fragmentStorage.scan();
                int doneSoFar = 0;
                int candidates = 0;
                if (GlacierImpl.this.logger.level <= 800) {
                    GlacierImpl.this.logger.log("Garbage collection started at " + now + ", scanning " + fragments.numElements() + " fragment(s)...");
                }
                Iterator iter = fragments.getIterator();
                while (iter.hasNext()) {
                    final Id thisKey = (Id)iter.next();
                    final FragmentMetadata metadata = (FragmentMetadata)GlacierImpl.this.fragmentStorage.getMetadata(thisKey);
                    if (metadata != null) {
                        if (metadata.getCurrentExpiration() >= now) continue;
                        ++candidates;
                        if (doneSoFar >= GlacierImpl.this.garbageCollectionMaxFragmentsPerRun) continue;
                        ++doneSoFar;
                        GlacierImpl.this.deleteFragment(thisKey, new Continuation(){

                            public void receiveResult(Object o) {
                                if (GlacierImpl.this.logger.level <= 800) {
                                    GlacierImpl.this.logger.log("GC collected " + thisKey.toStringFull() + ", expired " + (now - metadata.getCurrentExpiration()) + " msec ago");
                                }
                            }

                            public void receiveException(Exception e) {
                                if (GlacierImpl.this.logger.level <= 500) {
                                    GlacierImpl.this.logger.log("GC cannot collect " + thisKey.toStringFull());
                                }
                            }
                        });
                        continue;
                    }
                    if (GlacierImpl.this.logger.level > 900) continue;
                    GlacierImpl.this.logger.log("GC cannot read metadata in object " + thisKey.toStringFull() + ", storage returned null");
                }
                if (GlacierImpl.this.logger.level <= 800) {
                    GlacierImpl.this.logger.log("Garbage collection completed at " + GlacierImpl.this.environment.getTimeSource().currentTimeMillis());
                }
                if (GlacierImpl.this.logger.level <= 800) {
                    GlacierImpl.this.logger.log("Found " + candidates + " candidate(s), collected " + doneSoFar);
                }
            }
        });
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Local scan";
            }

            public void init() {
                this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.localScanInterval;
            }

            public void receiveResult(Object o) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.log("Local scan received object: " + o);
                }
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.logException("Local scan received exception: ", e);
                }
            }

            public void timeoutExpired() {
                this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.jitterTerm(GlacierImpl.this.localScanInterval);
                final IdSet fragments = GlacierImpl.this.fragmentStorage.scan();
                long now = GlacierImpl.this.environment.getTimeSource().currentTimeMillis();
                TreeSet<VersionKey> queries = new TreeSet<VersionKey>();
                if (GlacierImpl.this.logger.level <= 800) {
                    GlacierImpl.this.logger.log("Performing local scan over " + fragments.numElements() + " fragment(s)...");
                }
                Iterator iter = fragments.getIterator();
                while (iter.hasNext()) {
                    FragmentKey thisKey = (FragmentKey)iter.next();
                    FragmentMetadata metadata = (FragmentMetadata)GlacierImpl.this.fragmentStorage.getMetadata(thisKey);
                    if (metadata != null && metadata.currentExpirationDate >= now) {
                        Id thisObjectKey = thisKey.getVersionKey().getId();
                        long thisVersion = thisKey.getVersionKey().getVersion();
                        int thisFragmentID = thisKey.getFragmentID();
                        int fidLeft = (thisFragmentID + GlacierImpl.this.numFragments - 1) % GlacierImpl.this.numFragments;
                        int fidRight = (thisFragmentID + 1) % GlacierImpl.this.numFragments;
                        if (GlacierImpl.this.responsibleRange.containsId(GlacierImpl.this.getFragmentLocation(thisObjectKey, fidLeft, thisVersion)) && !fragments.isMemberId(thisKey.getPeerKey(fidLeft))) {
                            if (GlacierImpl.this.logger.level <= 400) {
                                GlacierImpl.this.logger.log("Missing: " + thisKey + " L=" + fidLeft);
                            }
                            queries.add(thisKey.getVersionKey());
                        }
                        if (!GlacierImpl.this.responsibleRange.containsId(GlacierImpl.this.getFragmentLocation(thisObjectKey, fidRight, thisVersion)) || fragments.isMemberId(thisKey.getPeerKey(fidRight))) continue;
                        if (GlacierImpl.this.logger.level <= 400) {
                            GlacierImpl.this.logger.log("Missing: " + thisKey + " R=" + fidRight);
                        }
                        queries.add(thisKey.getVersionKey());
                        continue;
                    }
                    if (GlacierImpl.this.logger.level > 400) continue;
                    GlacierImpl.this.logger.log("Expired, ignoring in local scan: " + thisKey);
                }
                if (!queries.isEmpty()) {
                    int queriesSent;
                    int queriesHere;
                    if (GlacierImpl.this.logger.level <= 800) {
                        GlacierImpl.this.logger.log("Local scan completed; " + queries.size() + " objects incomplete in local store");
                    }
                    iter = queries.iterator();
                    for (queriesSent = 0; iter.hasNext() && queriesSent < GlacierImpl.this.localScanMaxFragmentsPerRun; queriesSent += queriesHere) {
                        final VersionKey thisVKey = (VersionKey)iter.next();
                        int localFragmentID = 0;
                        queriesHere = 0;
                        for (int i = 0; i < GlacierImpl.this.numFragments; ++i) {
                            FragmentKey keyHere = new FragmentKey(thisVKey, i);
                            if (fragments.isMemberId(keyHere)) {
                                localFragmentID = i;
                                break;
                            }
                            if (!GlacierImpl.this.responsibleRange.containsId(GlacierImpl.this.getFragmentLocation(keyHere))) continue;
                            ++queriesHere;
                        }
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("Local scan: Fetching manifest for " + thisVKey + " (" + queriesHere + " pending queries)");
                        }
                        GlacierImpl.this.fragmentStorage.getObject(new FragmentKey(thisVKey, localFragmentID), new Continuation(){

                            public void receiveResult(Object o) {
                                if (o instanceof FragmentAndManifest) {
                                    final Manifest thisManifest = ((FragmentAndManifest)o).manifest;
                                    for (int i = 0; i < GlacierImpl.this.numFragments; ++i) {
                                        final FragmentKey thisKey = new FragmentKey(thisVKey, i);
                                        if (!GlacierImpl.this.responsibleRange.containsId(GlacierImpl.this.getFragmentLocation(thisKey)) || fragments.isMemberId(thisKey)) continue;
                                        if (GlacierImpl.this.logger.level <= 500) {
                                            GlacierImpl.this.logger.log("Local scan: Sending query for " + thisKey);
                                        }
                                        final long tStart = GlacierImpl.this.environment.getTimeSource().currentTimeMillis();
                                        GlacierImpl.this.rateLimitedRetrieveFragment(thisKey, thisManifest, '\f', new GlacierContinuation(){

                                            public long getTimeout() {
                                                return tStart + GlacierImpl.this.overallRestoreTimeout;
                                            }

                                            public String toString() {
                                                return "Local scan: Fetch fragment: " + thisKey;
                                            }

                                            public void receiveResult(Object o) {
                                                if (o instanceof Fragment) {
                                                    if (GlacierImpl.this.logger.level <= 800) {
                                                        GlacierImpl.this.logger.log("Local scan: Received fragment " + thisKey + " (from primary) matches existing manifest, storing...");
                                                    }
                                                    FragmentAndManifest fam = new FragmentAndManifest((Fragment)o, thisManifest);
                                                    GlacierImpl.this.fragmentStorage.store(thisKey, new FragmentMetadata(thisManifest.getExpiration(), 0L, GlacierImpl.this.environment.getTimeSource().currentTimeMillis()), fam, new Continuation(){

                                                        public void receiveResult(Object o) {
                                                            if (GlacierImpl.this.logger.level <= 500) {
                                                                GlacierImpl.this.logger.log("Local scan: Recovered fragment stored OK");
                                                            }
                                                        }

                                                        public void receiveException(Exception e) {
                                                            if (GlacierImpl.this.logger.level <= 900) {
                                                                GlacierImpl.this.logger.log("Local scan: receiveException(" + e + ") while storing a fragment with existing manifest (key=" + thisKey + ")");
                                                            }
                                                        }
                                                    });
                                                } else if (GlacierImpl.this.logger.level <= 900) {
                                                    GlacierImpl.this.logger.log("Local scan: FS received something other than a fragment: " + o);
                                                }
                                            }

                                            public void receiveException(Exception e) {
                                                if (GlacierImpl.this.logger.level <= 900) {
                                                    GlacierImpl.this.logger.logException("Local scan: Exception while recovering synced fragment " + thisKey + ": ", e);
                                                }
                                                this.terminate();
                                            }

                                            public void timeoutExpired() {
                                                if (GlacierImpl.this.logger.level <= 900) {
                                                    GlacierImpl.this.logger.log("Local scan: Timeout while fetching synced fragment " + thisKey + " -- aborted");
                                                }
                                                this.terminate();
                                            }
                                        });
                                    }
                                } else if (GlacierImpl.this.logger.level <= 900) {
                                    GlacierImpl.this.logger.log("Local scan: Cannot retrieve " + thisVKey + " from local store, received o=" + o);
                                }
                            }

                            public void receiveException(Exception e) {
                                if (GlacierImpl.this.logger.level <= 900) {
                                    GlacierImpl.this.logger.logException("Local scan: Cannot retrieve " + thisVKey + " from local store, exception e=", e);
                                }
                            }
                        });
                    }
                    if (GlacierImpl.this.logger.level <= 800) {
                        GlacierImpl.this.logger.log(queriesSent + " queries sent after local scan");
                    }
                } else if (GlacierImpl.this.logger.level <= 800) {
                    GlacierImpl.this.logger.log("Local scan completed; no missing fragments");
                }
            }
        });
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Traffic shaper";
            }

            public void init() {
                this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.rateLimitedCheckInterval;
            }

            public void receiveResult(Object o) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.log("TS received object: " + o);
                }
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.logException("TS received exception: ", e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void timeoutExpired() {
                this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + 1000L;
                if (GlacierImpl.this.pendingTraffic.isEmpty()) {
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("Traffic shaper: Idle");
                    }
                    this.nextTimeout += GlacierImpl.this.rateLimitedCheckInterval;
                    return;
                }
                int numCurrentRestores = 0;
                int[] nArray = GlacierImpl.this.numActiveRestores;
                synchronized (nArray) {
                    numCurrentRestores = GlacierImpl.this.numActiveRestores[0];
                }
                if (GlacierImpl.this.logger.level <= 800) {
                    GlacierImpl.this.logger.log("Traffic shaper: " + GlacierImpl.this.pendingTraffic.size() + " jobs waiting (" + numCurrentRestores + " active jobs, " + GlacierImpl.this.tokenBucket + " tokens)");
                }
                GlacierImpl.this.updateTokenBucket();
                if (numCurrentRestores < GlacierImpl.this.maxActiveRestores && GlacierImpl.this.tokenBucket > 0L) {
                    for (int i = 0; i < GlacierImpl.this.rateLimitedRequestsPerSecond; ++i) {
                        if (GlacierImpl.this.pendingTraffic.isEmpty()) continue;
                        Enumeration keys = GlacierImpl.this.pendingTraffic.keys();
                        Object thisKey = keys.nextElement();
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("Sending request " + thisKey);
                        }
                        Continuation c = (Continuation)GlacierImpl.this.pendingTraffic.remove(thisKey);
                        c.receiveResult(new Boolean(true));
                    }
                }
            }
        });
        this.addContinuation(new GlacierContinuation(){
            long nextTimeout;

            public long getTimeout() {
                return this.nextTimeout;
            }

            public String toString() {
                return "Statistics";
            }

            public void init() {
                this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.statisticsReportInterval;
            }

            public void receiveResult(Object o) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.log("STAT received object: " + o);
                }
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.logException("STAT received exception: ", e);
                }
            }

            public void timeoutExpired() {
                this.nextTimeout += GlacierImpl.this.statisticsReportInterval;
                if (!GlacierImpl.this.listeners.isEmpty()) {
                    Storage storageT;
                    GlacierImpl.this.statistics.pendingRequests = GlacierImpl.this.pendingTraffic.size();
                    GlacierImpl.this.statistics.numNeighbors = GlacierImpl.this.neighborStorage.scan().numElements();
                    GlacierImpl.this.statistics.numFragments = GlacierImpl.this.fragmentStorage.scan().numElements();
                    GlacierImpl.this.statistics.numContinuations = GlacierImpl.this.continuations.size();
                    GlacierImpl.this.statistics.responsibleRange = GlacierImpl.this.responsibleRange;
                    GlacierImpl.this.statistics.activeFetches = GlacierImpl.this.numActiveRestores[0];
                    GlacierImpl.this.statistics.bucketMin = GlacierImpl.this.bucketMin;
                    GlacierImpl.this.statistics.bucketMax = GlacierImpl.this.bucketMax;
                    GlacierImpl.this.statistics.bucketConsumed = GlacierImpl.this.bucketConsumed;
                    GlacierImpl.this.statistics.bucketTokensPerSecond = GlacierImpl.this.bucketTokensPerSecond;
                    GlacierImpl.this.statistics.bucketMaxBurstSize = GlacierImpl.this.bucketMaxBurstSize;
                    GlacierImpl.this.bucketMin = GlacierImpl.this.tokenBucket;
                    GlacierImpl.this.bucketMax = GlacierImpl.this.tokenBucket;
                    GlacierImpl.this.bucketConsumed = 0L;
                    Storage storageF = GlacierImpl.this.fragmentStorage.getStorage();
                    if (storageF instanceof PersistentStorage) {
                        GlacierImpl.this.statistics.fragmentStorageSize = ((PersistentStorage)storageF).getTotalSize();
                    }
                    Storage storage = storageT = GlacierImpl.this.trashStorage == null ? null : GlacierImpl.this.trashStorage.getStorage();
                    if (storageT instanceof PersistentStorage) {
                        GlacierImpl.this.statistics.trashStorageSize = ((PersistentStorage)storageT).getTotalSize();
                    }
                    if (GlacierImpl.this.logStatistics) {
                        GlacierImpl.this.statistics.dump(GlacierImpl.this.environment.getLogManager().getLogger(GlacierStatistics.class, GlacierImpl.this.instance));
                    }
                    Enumeration enumeration = GlacierImpl.this.listeners.elements();
                    while (enumeration.hasMoreElements()) {
                        GlacierStatisticsListener gsl = (GlacierStatisticsListener)enumeration.nextElement();
                        gsl.receiveStatistics(GlacierImpl.this.statistics);
                    }
                }
                GlacierImpl.this.statistics = new GlacierStatistics(13, GlacierImpl.this.environment);
            }
        });
    }

    protected void updateTokenBucket() {
        long now = this.environment.getTimeSource().currentTimeMillis();
        long contentsBefore = this.tokenBucket;
        while (this.bucketLastUpdated < now) {
            this.bucketLastUpdated += 100L;
            this.tokenBucket += this.bucketTokensPerSecond / 10L;
            if (this.tokenBucket <= this.bucketMaxBurstSize) continue;
            this.tokenBucket = this.bucketMaxBurstSize;
        }
        if (this.bucketMax < this.tokenBucket) {
            this.bucketMax = this.tokenBucket;
        }
        if (this.logger.level <= 500) {
            this.logger.log("Token bucket contains " + this.tokenBucket + " tokens (added " + (this.tokenBucket - contentsBefore) + ")");
        }
    }

    private long jitterTerm(long basis) {
        return (long)((1.0 - this.jitterRange) * (double)basis) + (long)this.environment.getRandomSource().nextInt((int)(2.0 * this.jitterRange * (double)basis));
    }

    private void deleteFragment(final Id fkey, final Continuation command) {
        if (this.trashStorage != null) {
            if (this.logger.level <= 800) {
                this.logger.log("Moving fragment " + fkey.toStringFull() + " to trash");
            }
            this.fragmentStorage.getObject(fkey, new Continuation(){

                public void receiveResult(Object o) {
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("Fragment " + fkey.toStringFull() + " retrieved, storing in trash");
                    }
                    if (o != null) {
                        GlacierImpl.this.trashStorage.store(fkey, null, (Serializable)o, new Continuation(){

                            public void receiveResult(Object o) {
                                if (GlacierImpl.this.logger.level <= 500) {
                                    GlacierImpl.this.logger.log("Deleting fragment " + fkey.toStringFull());
                                }
                                GlacierImpl.this.fragmentStorage.unstore(fkey, command);
                            }

                            public void receiveException(Exception e) {
                                if (GlacierImpl.this.logger.level <= 900) {
                                    GlacierImpl.this.logger.logException("Cannot store in trash: " + fkey.toStringFull() + ", e=", e);
                                }
                                command.receiveException(e);
                            }
                        });
                    } else {
                        this.receiveException(new GlacierException("Move to trash: Fragment " + fkey + " does not exist?!?"));
                    }
                }

                public void receiveException(Exception e) {
                    if (GlacierImpl.this.logger.level <= 900) {
                        GlacierImpl.this.logger.logException("Cannot retrieve fragment " + fkey + " for deletion: e=", e);
                    }
                    command.receiveException(new GlacierException("Cannot retrieve fragment " + fkey + " for deletion"));
                }
            });
        } else {
            if (this.logger.level <= 800) {
                this.logger.log("Deleting fragment " + fkey.toStringFull());
            }
            this.fragmentStorage.unstore(fkey, command);
        }
    }

    public void sendMessage(Id id, GlacierMessage message, NodeHandle hint) {
        String className = message.getClass().getName();
        if (this.logger.level <= 800) {
            this.logger.log("Send " + (hint == null ? "OVR" : "DIR") + " T" + message.getTag() + " " + className.substring(className.lastIndexOf(46) + 8));
        }
        char c = message.getTag();
        this.statistics.messagesSentByTag[c] = this.statistics.messagesSentByTag[c] + 1;
        this.endpoint.route(id, message, hint);
    }

    private void addContinuation(GlacierContinuation gc) {
        int thisUID = this.getUID();
        gc.setup(thisUID);
        this.continuations.put(new Integer(thisUID), gc);
        gc.init();
        long thisTimeout = gc.getTimeout();
        long now = this.environment.getTimeSource().currentTimeMillis();
        if (this.nextContinuationTimeout == -1L || thisTimeout < this.nextContinuationTimeout) {
            if (this.nextContinuationTimeout != -1L) {
                this.cancelTimer();
            }
            this.nextContinuationTimeout = thisTimeout;
            if (this.nextContinuationTimeout > now) {
                this.setTimer((int)(this.nextContinuationTimeout - now));
            } else {
                this.timerExpired();
            }
        }
    }

    private void determineResponsibleRange() {
        Id cwPeer = null;
        Id ccwPeer = null;
        Id xcwPeer = null;
        Id xccwPeer = null;
        Id myNodeId = this.getLocalNodeHandle().getId();
        if (this.logger.level <= 500) {
            this.logger.log("Determining responsible range");
        }
        Iterator iter = this.neighborStorage.scan().getIterator();
        while (iter.hasNext()) {
            Id thisNeighbor = (Id)iter.next();
            if (this.logger.level <= 400) {
                this.logger.log("Considering neighbor: " + thisNeighbor);
            }
            if (myNodeId.clockwise(thisNeighbor)) {
                if (cwPeer == null || thisNeighbor.isBetween(myNodeId, cwPeer)) {
                    cwPeer = thisNeighbor;
                }
                if (xcwPeer != null && !xcwPeer.clockwise(thisNeighbor)) continue;
                xcwPeer = thisNeighbor;
                continue;
            }
            if (ccwPeer == null || thisNeighbor.isBetween(ccwPeer, myNodeId)) {
                ccwPeer = thisNeighbor;
            }
            if (xccwPeer != null && xccwPeer.clockwise(thisNeighbor)) continue;
            xccwPeer = thisNeighbor;
        }
        if (ccwPeer == null) {
            ccwPeer = xcwPeer;
        }
        if (cwPeer == null) {
            cwPeer = xccwPeer;
        }
        if (this.logger.level <= 500) {
            this.logger.log("XCCW: " + xccwPeer + " CCW: " + ccwPeer + " ME: " + myNodeId + " CW: " + cwPeer + " XCW: " + xcwPeer);
        }
        if (ccwPeer == null || cwPeer == null) {
            this.responsibleRange = this.factory.buildIdRange(myNodeId, myNodeId);
            return;
        }
        Id.Distance ccwHalfDistance = !myNodeId.clockwise(ccwPeer) ? ccwPeer.distanceFromId(myNodeId).shiftDistance(1, 0) : ccwPeer.longDistanceFromId(myNodeId).shiftDistance(1, 0);
        Id.Distance cwHalfDistance = myNodeId.clockwise(cwPeer) ? cwPeer.distanceFromId(myNodeId).shiftDistance(1, 0) : cwPeer.longDistanceFromId(myNodeId).shiftDistance(1, 0);
        this.responsibleRange = this.factory.buildIdRange(ccwPeer.addToId(ccwHalfDistance), myNodeId.addToId(cwHalfDistance));
        if (this.logger.level <= 800) {
            this.logger.log("New range: " + this.responsibleRange);
        }
    }

    private void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void panic(String s) throws Error {
        if (this.logger.level <= 1000) {
            this.logger.log("PANIC: " + s);
        }
        throw new Error("Panic");
    }

    public String handleDebugCommand(String command) {
        if (command.indexOf(" ") < 0) {
            return null;
        }
        String myInstance = "glacier." + this.instance.substring(this.instance.lastIndexOf("-") + 1);
        String requestedInstance = command.substring(0, command.indexOf(" "));
        String cmd = command.substring(requestedInstance.length() + 1);
        if (!requestedInstance.equals(myInstance) && !requestedInstance.equals("g")) {
            return null;
        }
        if (this.logger.level <= 800) {
            this.logger.log("Debug command: " + cmd);
        }
        if (cmd.startsWith("ls")) {
            FragmentKeySet keyset = (FragmentKeySet)this.fragmentStorage.scan();
            Iterator iter = keyset.getIterator();
            StringBuffer result = new StringBuffer();
            long now = this.environment.getTimeSource().currentTimeMillis();
            if (cmd.indexOf("-r") < 0) {
                now = 0L;
            }
            result.append(keyset.numElements() + " fragment(s)\n");
            while (iter.hasNext()) {
                FragmentKey thisKey = (FragmentKey)iter.next();
                boolean isMine = this.responsibleRange.containsId(this.getFragmentLocation(thisKey));
                FragmentMetadata metadata = (FragmentMetadata)this.fragmentStorage.getMetadata(thisKey);
                if (metadata == null) continue;
                result.append(thisKey.toStringFull() + " " + (isMine ? "OK" : "MI") + " " + (metadata.getCurrentExpiration() - now) + " " + (metadata.getPreviousExpiration() - now) + "\n");
            }
            return result.toString();
        }
        if (cmd.startsWith("show config")) {
            return "numFragments = " + this.numFragments + "\n" + "numSurvivors = " + this.numSurvivors + "\n" + "insertTimeout = " + (int)(this.insertTimeout / 1000L) + " sec\n" + "minFragmentsAfterInsert = " + this.minFragmentsAfterInsert + "x" + this.numSurvivors + "\n" + "refreshTimeout = " + (int)(this.refreshTimeout / 1000L) + " sec\n" + "expireNeighborsDelayAfterJoin = " + (int)(this.expireNeighborsDelayAfterJoin / 1000L) + " sec\n" + "expireNeighborsInterval = " + (int)(this.expireNeighborsInterval / 60000L) + " min\n" + "neighborTimeout = " + (int)(this.neighborTimeout / 3600000L) + " hrs\n" + "syncDelayAfterJoin = " + (int)(this.syncDelayAfterJoin / 1000L) + " sec\n" + "syncMinRemainingLifetime = " + (int)(this.syncMinRemainingLifetime / 1000L) + " sec\n" + "syncMinQuietTime = " + (int)(this.syncMinQuietTime / 1000L) + " sec\n" + "syncBloomFilter = " + this.syncBloomFilterNumHashes + " hashes, " + this.syncBloomFilterBitsPerKey + " bpk\n" + "syncPartnersPerTrial = " + this.syncPartnersPerTrial + "\n" + "syncInterval = " + (int)(this.syncInterval / 60000L) + " min\n" + "syncMaxFragments = " + this.syncMaxFragments + "\n" + "fragmentRequestMaxAttempts = " + this.fragmentRequestMaxAttempts + "\n" + "fragmentRequestTimeoutDefault = " + (int)(this.fragmentRequestTimeoutDefault / 1000L) + " sec\n" + "manifestRequestTimeout = " + (int)(this.manifestRequestTimeout / 1000L) + " sec\n" + "manifestBurst = " + this.manifestRequestInitialBurst + " -> " + this.manifestRequestRetryBurst + "\n" + "manifestAggregationFactor = " + this.manifestAggregationFactor + "\n" + "overallRestoreTimeout = " + (int)(this.overallRestoreTimeout / 1000L) + " sec\n" + "handoffDelayAfterJoin = " + (int)(this.handoffDelayAfterJoin / 1000L) + " sec\n" + "handoffInterval = " + (int)(this.handoffInterval / 1000L) + " sec\n" + "handoffMaxFragments = " + this.handoffMaxFragments + "\n" + "garbageCollectionInterval = " + (int)(this.garbageCollectionInterval / 60000L) + " min\n" + "garbageCollectionMaxFragmentsPerRun = " + this.garbageCollectionMaxFragmentsPerRun + "\n" + "localScanInterval = " + (int)(this.localScanInterval / 60000L) + " min\n" + "localScanMaxFragmentsPerRun = " + this.localScanMaxFragmentsPerRun + "\n" + "restoreMaxRequestFactor = " + this.restoreMaxRequestFactor + "\n" + "restoreMaxBoosts = " + this.restoreMaxBoosts + "\n" + "rateLimitedCheckInterval = " + (int)(this.rateLimitedCheckInterval / 1000L) + " sec\n" + "rateLimitedRequestsPerSecond = " + this.rateLimitedRequestsPerSecond + "\n";
        }
        if (cmd.startsWith("flush") && this.faultInjectionEnabled) {
            FragmentKeySet keyset = (FragmentKeySet)this.fragmentStorage.scan();
            Iterator iter = keyset.getIterator();
            while (iter.hasNext()) {
                FragmentKey thisKey = (FragmentKey)iter.next();
                this.fragmentStorage.unstore(thisKey, new Continuation(){

                    public void receiveResult(Object o) {
                    }

                    public void receiveException(Exception e) {
                    }
                });
            }
            return keyset.numElements() + " objects deleted\n";
        }
        if (cmd.startsWith("refresh")) {
            String args = cmd.substring(8);
            String expirationArg = args.substring(args.lastIndexOf(32) + 1);
            String keyArg = args.substring(0, args.lastIndexOf(32));
            Id id = this.factory.buildIdFromToString(keyArg);
            long expiration = this.environment.getTimeSource().currentTimeMillis() + Long.parseLong(expirationArg);
            final String[] ret = new String[]{null};
            this.refresh(new Id[]{id}, expiration, new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return "refresh(" + id + ", " + expiration + ")=" + ret[0];
        }
        if (cmd.startsWith("neighbors")) {
            final Iterator iter = this.neighborStorage.scan().getIterator();
            final StringBuffer result = new StringBuffer();
            final long now = cmd.indexOf("-r") < 0 ? 0L : this.environment.getTimeSource().currentTimeMillis();
            final String[] ret = new String[]{null};
            result.append(this.neighborStorage.scan().numElements() + " neighbor(s)\n");
            Continuation c = new Continuation(){
                Id currentLookup;

                public void receiveResult(Object o) {
                    if (o != null) {
                        result.append(this.currentLookup.toStringFull() + " " + ((Long)o - now) + "\n");
                    }
                    if (iter.hasNext()) {
                        this.currentLookup = (Id)iter.next();
                        GlacierImpl.this.neighborStorage.getObject(this.currentLookup, this);
                    } else {
                        ret[0] = "OK";
                    }
                }

                public void receiveException(Exception e) {
                    ret[0] = "Exception: " + e;
                }
            };
            c.receiveResult(null);
            while (ret[0] == null) {
                Thread.yield();
            }
            result.append(ret[0] + "\n");
            return result.toString();
        }
        if (cmd.startsWith("status")) {
            String result = "";
            result = result + "Responsible for: " + this.responsibleRange + "\n";
            result = result + "Local time: " + new Date() + "\n\n";
            result = result + this.fragmentStorage.scan().numElements() + " fragments\n";
            result = result + this.neighborStorage.scan().numElements() + " neighbors\n";
            result = result + this.continuations.size() + " active continuations\n";
            result = result + this.pendingTraffic.size() + " pending requests\n";
            return result;
        }
        if (cmd.startsWith("insert") && this.faultInjectionEnabled) {
            String args = cmd.substring(7);
            String expirationArg = args.substring(args.lastIndexOf(32) + 1);
            String numObjectsArg = args.substring(0, args.lastIndexOf(32));
            int numObjects = Integer.parseInt(numObjectsArg);
            final int lifetime = Integer.parseInt(expirationArg);
            String result = "";
            for (int i = 0; i < numObjects; ++i) {
                final Id randomID = this.factory.buildRandomId(this.environment.getRandomSource());
                result = result + randomID.toStringFull() + "\n";
                this.pendingTraffic.put(new VersionKey(randomID, 0L), new Continuation.SimpleContinuation(){

                    public void receiveResult(Object o) {
                        GlacierImpl.this.insert(new DebugContent(randomID, false, 0L, new byte[0]), GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + (long)lifetime, new Continuation(){

                            public void receiveResult(Object o) {
                            }

                            public void receiveException(Exception e) {
                            }
                        });
                    }
                });
            }
            return result + numObjects + " object(s) with lifetime " + lifetime + "ms created\n";
        }
        if (cmd.startsWith("delete") && this.faultInjectionEnabled) {
            String[] vkeyS = cmd.substring(7).split("[v#]");
            Id key = this.factory.buildIdFromToString(vkeyS[0]);
            long version = Long.parseLong(vkeyS[1]);
            VersionKey vkey = new VersionKey(key, version);
            FragmentKey id = new FragmentKey(vkey, Integer.parseInt(vkeyS[2]));
            final String[] ret = new String[]{null};
            this.fragmentStorage.unstore(id, new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return "delete(" + id + ")=" + ret[0];
        }
        if (cmd.startsWith("burst") && this.faultInjectionEnabled) {
            String[] vkeyS = cmd.substring(6).split("[v#]");
            Id key = this.factory.buildIdFromToString(vkeyS[0]);
            long version = Long.parseLong(vkeyS[1]);
            VersionKey vkey = new VersionKey(key, version);
            final FragmentKey id = new FragmentKey(vkey, Integer.parseInt(vkeyS[2]));
            final Id fragmentLoc = this.getFragmentLocation(id);
            final String[] ret = new String[]{""};
            final Boolean[] done = new Boolean[]{null};
            final long now = this.environment.getTimeSource().currentTimeMillis();
            this.addContinuation(new GlacierContinuation(){
                int receivedSoFar = 0;
                final int total = 100;

                public long getTimeout() {
                    return now + 120000L;
                }

                public String toString() {
                    return "Burst continuation";
                }

                public void init() {
                    for (int i = 0; i < 100; ++i) {
                        GlacierImpl.this.sendMessage(fragmentLoc, new GlacierQueryMessage(this.getMyUID(), new FragmentKey[]{id}, GlacierImpl.this.getLocalNodeHandle(), fragmentLoc, '\u0006'), null);
                    }
                }

                public void receiveResult(Object o) {
                    if (o instanceof GlacierResponseMessage) {
                        ret[0] = ret[0] + (GlacierImpl.this.environment.getTimeSource().currentTimeMillis() - now) + " msec (" + ((GlacierResponseMessage)o).getSource().getId() + ")\n";
                        if (++this.receivedSoFar == 100) {
                            this.timeoutExpired();
                        }
                    }
                }

                public void receiveException(Exception e) {
                }

                public void timeoutExpired() {
                    done[0] = new Boolean(true);
                    this.terminate();
                }
            });
            while (done[0] == null) {
                Thread.yield();
            }
            return "burst(" + id + ")=" + ret[0];
        }
        if (cmd.startsWith("manifest")) {
            String[] vkeyS = cmd.substring(9).split("v");
            Id key = this.factory.buildIdFromToString(vkeyS[0]);
            long version = Long.parseLong(vkeyS[1]);
            VersionKey vkey = new VersionKey(key, version);
            final String[] ret = new String[]{null};
            this.retrieveManifest(vkey, '\u0006', new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = o instanceof Manifest ? ((Manifest)o).toStringFull() : "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return "manifest(" + vkey + ")=" + ret[0];
        }
        if (cmd.startsWith("retrieve")) {
            String[] vkeyS = cmd.substring(9).split("[v#]");
            Id key = this.factory.buildIdFromToString(vkeyS[0]);
            long version = Long.parseLong(vkeyS[1]);
            VersionKey vkey = new VersionKey(key, version);
            final FragmentKey id = new FragmentKey(vkey, Integer.parseInt(vkeyS[2]));
            final FragmentMetadata metadata = (FragmentMetadata)this.fragmentStorage.getMetadata(id);
            final String[] ret = new String[]{null};
            this.fragmentStorage.getObject(id, new Continuation(){

                public void receiveResult(Object o) {
                    FragmentAndManifest fam = (FragmentAndManifest)o;
                    MessageDigest md = null;
                    try {
                        md = MessageDigest.getInstance("SHA");
                    }
                    catch (NoSuchAlgorithmException e) {
                        // empty catch block
                    }
                    md.reset();
                    md.update(fam.fragment.getPayload());
                    ret[0] = "OK\n\nFragment: " + fam.fragment.getPayload().length + " bytes, Hash=[" + GlacierImpl.dump(md.digest(), false) + "], ID=" + id.getFragmentID() + "\n\nValidation: " + (fam.manifest.validatesFragment(fam.fragment, id.getFragmentID(), GlacierImpl.this.environment.getLogManager().getLogger(Manifest.class, GlacierImpl.this.instance)) ? "OK" : "FAIL") + "\n\n" + fam.manifest.toStringFull() + "\n\nMetadata:\n - Stored since: " + metadata.getStoredSince() + "\n - Current expiration: " + metadata.getCurrentExpiration() + "\n - Previous expiration: " + metadata.getPreviousExpiration() + "\n";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return "retrieve(" + id + ")=" + ret[0];
        }
        if (cmd.startsWith("validate")) {
            FragmentKeySet keyset = (FragmentKeySet)this.fragmentStorage.scan();
            final Iterator iter = keyset.getIterator();
            final StringBuffer result = new StringBuffer();
            result.append(keyset.numElements() + " fragment(s)\n");
            final String[] ret = new String[]{null};
            if (iter.hasNext()) {
                final FragmentKey thisKey = (FragmentKey)iter.next();
                this.fragmentStorage.getObject(thisKey, new Continuation(){
                    FragmentKey currentKey;
                    int totalChecks;
                    int totalFailures;
                    {
                        this.currentKey = thisKey;
                        this.totalChecks = 1;
                        this.totalFailures = 0;
                    }

                    public void receiveResult(Object o) {
                        FragmentAndManifest fam = (FragmentAndManifest)o;
                        boolean success = fam.manifest.validatesFragment(fam.fragment, this.currentKey.getFragmentID(), GlacierImpl.this.environment.getLogManager().getLogger(Manifest.class, GlacierImpl.this.instance));
                        if (!success) {
                            ++this.totalFailures;
                        }
                        result.append(this.currentKey.toStringFull() + " " + (success ? "OK" : "FAIL") + "\n");
                        this.advance();
                    }

                    public void receiveException(Exception e) {
                        ++this.totalFailures;
                        result.append(this.currentKey.toStringFull() + " EXC: " + e + "\n");
                        this.advance();
                    }

                    public void advance() {
                        if (iter.hasNext()) {
                            this.currentKey = (FragmentKey)iter.next();
                            ++this.totalChecks;
                            GlacierImpl.this.fragmentStorage.getObject(this.currentKey, this);
                        } else {
                            ret[0] = this.totalFailures == 0 ? "OK (" + this.totalChecks + " fragments checked)" : "FAIL, " + this.totalFailures + "/" + this.totalChecks + " fragments damaged";
                        }
                    }
                });
                while (ret[0] == null) {
                    Thread.yield();
                }
                return "validate=" + ret[0] + "\n\n" + result.toString();
            }
            return "validate: no objects\n\n" + result.toString();
        }
        if (cmd.startsWith("fetch")) {
            String[] vkeyS = cmd.substring(6).split("[v#]");
            Id key = this.factory.buildIdFromToString(vkeyS[0]);
            long version = Long.parseLong(vkeyS[1]);
            VersionKey vkey = new VersionKey(key, version);
            final FragmentKey id = new FragmentKey(vkey, Integer.parseInt(vkeyS[2]));
            final long now = this.environment.getTimeSource().currentTimeMillis();
            final Id fragmentLoc = this.getFragmentLocation(id);
            final String[] ret = new String[]{null};
            this.addContinuation(new GlacierContinuation(){

                public long getTimeout() {
                    return now + 5000L;
                }

                public String toString() {
                    return "DebugFetch continuation";
                }

                public void init() {
                    GlacierImpl.this.sendMessage(fragmentLoc, new GlacierFetchMessage(this.getMyUID(), id, 3, GlacierImpl.this.getLocalNodeHandle(), fragmentLoc, '\u0006'), null);
                }

                public void receiveResult(Object o) {
                    if (o instanceof GlacierDataMessage) {
                        GlacierDataMessage gdm = (GlacierDataMessage)o;
                        MessageDigest md = null;
                        try {
                            md = MessageDigest.getInstance("SHA");
                        }
                        catch (NoSuchAlgorithmException e) {
                            // empty catch block
                        }
                        md.reset();
                        md.update(gdm.getFragment(0).getPayload());
                        ret[0] = "\n\nResponse: " + gdm.getKey(0).toStringFull() + " (" + gdm.numKeys() + " keys)\n" + "Holder: " + gdm.getSource() + "\n" + "Fragment: " + gdm.getFragment(0).getPayload().length + " bytes, Hash=[" + GlacierImpl.dump(md.digest(), false) + "]\n\nValidation: " + (gdm.getManifest(0).validatesFragment(gdm.getFragment(0), gdm.getKey(0).getFragmentID(), GlacierImpl.this.environment.getLogManager().getLogger(Manifest.class, GlacierImpl.this.instance)) ? "OK" : "FAIL") + "\n\n" + gdm.getManifest(0).toStringFull();
                        this.terminate();
                    } else {
                        ret[0] = "Received " + o;
                        this.terminate();
                    }
                }

                public void receiveException(Exception e) {
                    ret[0] = "Exception=" + e;
                    this.terminate();
                }

                public void timeoutExpired() {
                    ret[0] = "Timeout";
                    this.terminate();
                }
            });
            while (ret[0] == null && this.environment.getTimeSource().currentTimeMillis() < now + 5000L) {
                Thread.yield();
            }
            if (ret[0] == null) {
                ret[0] = "Timeout";
            }
            return "fetch(" + id + "@" + fragmentLoc + ")=" + ret[0];
        }
        return null;
    }

    public void insert(PastContent obj, Continuation command) {
        this.insert(obj, Long.MAX_VALUE, command);
    }

    public void refresh(Id[] ids, long[] expirations, Continuation command) {
        long[] versions = new long[ids.length];
        Arrays.fill(versions, 0L);
        this.refresh(ids, versions, expirations, command);
    }

    public void refresh(Id[] ids, long expiration, Continuation command) {
        long[] expirations = new long[ids.length];
        Arrays.fill(expirations, expiration);
        this.refresh(ids, expirations, command);
    }

    public void refresh(final Id[] ids, final long[] versions, final long[] expirations, final Continuation command) {
        if (!this.enableBulkRefresh) {
            Continuation.MultiContinuation mc = new Continuation.MultiContinuation(command, ids.length);
            for (int i = 0; i < ids.length; ++i) {
                VersionKey thisVersionKey;
                Continuation prev;
                final Continuation thisContinuation = mc.getSubContinuation(i);
                final Id thisId = ids[i];
                final long thisVersion = versions[i];
                final long thisExpiration = expirations[i];
                if (this.logger.level <= 800) {
                    this.logger.log("refresh(" + thisId.toStringFull() + "v" + thisVersion + ", exp=" + thisExpiration + ")");
                }
                if ((prev = (Continuation)this.pendingTraffic.put(thisVersionKey = new VersionKey(thisId, thisVersion), new Continuation.SimpleContinuation(){

                    public void receiveResult(Object o) {
                        GlacierImpl.this.retrieveManifest(thisVersionKey, '\u0007', new Continuation(){

                            public void receiveResult(Object o) {
                                if (o instanceof Manifest) {
                                    Manifest manifest = (Manifest)o;
                                    if (GlacierImpl.this.logger.level <= 500) {
                                        GlacierImpl.this.logger.log("refresh(" + thisId.toStringFull() + "v" + thisVersion + "): Got manifest");
                                    }
                                    manifest = GlacierImpl.this.policy.updateManifest(new VersionKey(thisId, thisVersion), manifest, thisExpiration);
                                    Manifest[] manifests = new Manifest[GlacierImpl.this.numFragments];
                                    for (int i = 0; i < GlacierImpl.this.numFragments; ++i) {
                                        manifests[i] = manifest;
                                    }
                                    GlacierImpl.this.distribute(new VersionKey(thisId, thisVersion), null, manifests, thisExpiration, '\u0007', thisContinuation);
                                } else {
                                    if (GlacierImpl.this.logger.level <= 900) {
                                        GlacierImpl.this.logger.log("refresh(" + thisId + "v" + thisVersion + "): Cannot retrieve manifest");
                                    }
                                    thisContinuation.receiveResult(new GlacierException("Cannot retrieve manifest -- retry later"));
                                }
                            }

                            public void receiveException(Exception e) {
                                if (GlacierImpl.this.logger.level <= 900) {
                                    GlacierImpl.this.logger.logException("refresh(" + thisId + "v" + thisVersion + "): Exception while retrieving manifest: ", e);
                                }
                                thisContinuation.receiveException(e);
                            }
                        });
                    }
                })) == null) continue;
                prev.receiveException(new GlacierException("Key collision in traffic shaper (refresh)"));
            }
        } else {
            this.addContinuation(new GlacierContinuation(){
                int minAcceptable;
                FragmentKey[][] fragmentKey;
                VersionKey[] versionKey;
                Id[][] fragmentLocation;
                NodeHandle[][] fragmentHolder;
                boolean[][] fragmentChecked;
                Vector holders;
                Manifest[] manifests;
                int[] successes;
                boolean answered;
                long nextTimeout;
                int currentStage;
                int retriesRemaining;
                final int stageProbing = 1;
                final int stageFetchingManifests = 2;
                final int stagePatching = 3;
                {
                    this.minAcceptable = (int)((double)GlacierImpl.this.numSurvivors * GlacierImpl.this.minFragmentsAfterInsert);
                    this.stageProbing = 1;
                    this.stageFetchingManifests = 2;
                    this.stagePatching = 3;
                }

                public long getTimeout() {
                    return this.nextTimeout;
                }

                public String toString() {
                    return "AggregateRefresh continuation (" + this.fragmentKey.length + " fragments)";
                }

                public void init() {
                    if (GlacierImpl.this.logger.level <= 800) {
                        GlacierImpl.this.logger.log("Initializing AggregateRefresh continuation");
                    }
                    this.fragmentKey = new FragmentKey[ids.length][GlacierImpl.this.numFragments];
                    this.fragmentLocation = new Id[ids.length][GlacierImpl.this.numFragments];
                    this.fragmentHolder = new NodeHandle[ids.length][GlacierImpl.this.numFragments];
                    this.fragmentChecked = new boolean[ids.length][GlacierImpl.this.numFragments];
                    this.manifests = new Manifest[ids.length];
                    this.versionKey = new VersionKey[ids.length];
                    this.successes = new int[ids.length];
                    this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.bulkRefreshProbeInterval;
                    this.currentStage = 1;
                    this.holders = new Vector();
                    this.retriesRemaining = (int)(GlacierImpl.this.bulkRefreshMaxProbeFactor * (double)GlacierImpl.this.numFragments);
                    this.answered = false;
                    boolean haveFragmentMyself = false;
                    for (int i = 0; i < ids.length; ++i) {
                        this.manifests[i] = null;
                        this.versionKey[i] = new VersionKey(ids[i], versions[i]);
                        for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                            this.fragmentKey[i][j] = new FragmentKey(new VersionKey(ids[i], versions[i]), j);
                            this.fragmentLocation[i][j] = GlacierImpl.this.getFragmentLocation(this.fragmentKey[i][j]);
                            this.fragmentChecked[i][j] = false;
                            if (GlacierImpl.this.fragmentStorage.getMetadata(this.fragmentKey[i][j]) != null) {
                                haveFragmentMyself = true;
                                this.fragmentHolder[i][j] = GlacierImpl.this.getLocalNodeHandle();
                                continue;
                            }
                            this.fragmentHolder[i][j] = null;
                        }
                    }
                    if (haveFragmentMyself) {
                        this.holders.add(GlacierImpl.this.getLocalNodeHandle());
                    }
                    Arrays.fill(this.successes, 0);
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("AR Initialization completed, " + this.fragmentKey.length + " candidate objects. Triggering first probe...");
                    }
                    this.timeoutExpired();
                }

                public void receiveResult(Object o) {
                    if (o instanceof GlacierRefreshResponseMessage) {
                        NodeHandle holder;
                        GlacierRefreshResponseMessage grrm = (GlacierRefreshResponseMessage)o;
                        IdRange thisRange = grrm.getRange();
                        NodeHandle nodeHandle = holder = grrm.isOnline() ? grrm.getSource() : null;
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("AR got refresh response: range " + thisRange + ", online=" + grrm.isOnline());
                        }
                        if (thisRange != null) {
                            for (int i = 0; i < ids.length; ++i) {
                                for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                                    if (!thisRange.containsId(this.fragmentLocation[i][j])) continue;
                                    this.fragmentChecked[i][j] = true;
                                    this.fragmentHolder[i][j] = holder;
                                }
                            }
                        }
                        if (!this.holders.contains(holder)) {
                            this.holders.add(holder);
                        }
                    } else if (o instanceof GlacierDataMessage) {
                        GlacierDataMessage gdm = (GlacierDataMessage)o;
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("AR Received data message with " + gdm.numKeys() + " keys");
                        }
                        for (int i = 0; i < gdm.numKeys(); ++i) {
                            if (gdm.getManifest(i) == null || gdm.getKey(i) == null) continue;
                            Manifest thisManifest = gdm.getManifest(i);
                            FragmentKey thisKey = gdm.getKey(i);
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("AR Received manifest for " + gdm.getKey(i) + ", checking signature...");
                            }
                            if (GlacierImpl.this.policy.checkSignature(thisManifest, thisKey.getVersionKey())) {
                                if (GlacierImpl.this.logger.level <= 500) {
                                    GlacierImpl.this.logger.log("AR Signature OK");
                                }
                                for (int j = 0; j < ids.length; ++j) {
                                    if (this.manifests[j] != null || !this.versionKey[j].equals(thisKey.getVersionKey())) continue;
                                    this.manifests[j] = thisManifest;
                                    if (GlacierImpl.this.logger.level > 500) continue;
                                    GlacierImpl.this.logger.log("AR Storing under #" + j);
                                }
                                continue;
                            }
                            if (GlacierImpl.this.logger.level > 900) continue;
                            GlacierImpl.this.logger.log("AR Invalid signature");
                        }
                    } else if (o instanceof GlacierRefreshCompleteMessage) {
                        GlacierRefreshCompleteMessage grcm = (GlacierRefreshCompleteMessage)o;
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("AR Refresh completion reported by " + grcm.getSource());
                        }
                        for (int i = 0; i < grcm.numKeys(); ++i) {
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("AR Refresh completion: Key " + grcm.getKey(i) + ", " + grcm.getUpdates(i) + " update(s)");
                            }
                            int index = -1;
                            for (int j = 0; j < ids.length; ++j) {
                                if (!grcm.getKey(i).equals(this.versionKey[j])) continue;
                                index = j;
                            }
                            if (index >= 0) {
                                int maxSuccesses = 0;
                                for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                                    if (this.fragmentChecked[index][j] || this.fragmentHolder[index][j] == null || !this.fragmentHolder[index][j].equals(grcm.getSource())) continue;
                                    ++maxSuccesses;
                                    this.fragmentChecked[index][j] = true;
                                }
                                if (grcm.getUpdates(i) > (long)maxSuccesses) {
                                    if (GlacierImpl.this.logger.level <= 900) {
                                        GlacierImpl.this.logger.log("Node " + grcm.getSource() + " reports " + grcm.getUpdates(i) + " for " + grcm.getKey(i) + ", but is responsible for only " + maxSuccesses + " fragments -- duplicate message, or under attack?");
                                    }
                                    int n = index;
                                    this.successes[n] = this.successes[n] + maxSuccesses;
                                    continue;
                                }
                                int n = index;
                                this.successes[n] = (int)((long)this.successes[n] + grcm.getUpdates(i));
                                continue;
                            }
                            if (GlacierImpl.this.logger.level > 900) continue;
                            GlacierImpl.this.logger.log("Node " + grcm.getSource() + " reports completion for " + grcm.getKey(i) + ", but no refresh request matches?!?");
                        }
                        if (!this.answered) {
                            boolean allSuccessful = true;
                            for (int i = 0; i < this.successes.length; ++i) {
                                if (this.successes[i] >= this.minAcceptable) continue;
                                allSuccessful = false;
                            }
                            if (allSuccessful) {
                                if (GlacierImpl.this.logger.level <= 500) {
                                    GlacierImpl.this.logger.log("AR Reporing success");
                                }
                                Object[] result = new Object[ids.length];
                                for (int i = 0; i < ids.length; ++i) {
                                    result[i] = new Boolean(true);
                                }
                                this.answered = true;
                                command.receiveResult(result);
                            }
                        }
                    } else if (GlacierImpl.this.logger.level <= 900) {
                        GlacierImpl.this.logger.log("Unexpected result in AR continuation: " + o + " -- discarded");
                    }
                }

                public void receiveException(Exception e) {
                    if (GlacierImpl.this.logger.level <= 900) {
                        GlacierImpl.this.logger.logException("Exception during AggregateRefresh: ", e);
                    }
                    this.terminate();
                    if (!this.answered) {
                        Object[] result = new Object[ids.length];
                        GlacierException ee = new GlacierException("Exception during refresh: " + e);
                        for (int i = 0; i < ids.length; ++i) {
                            result[i] = ee;
                        }
                        this.answered = true;
                        command.receiveResult(result);
                    }
                }

                public void timeoutExpired() {
                    if (this.currentStage == 1) {
                        this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.bulkRefreshProbeInterval;
                        int nextProbe = GlacierImpl.this.environment.getRandomSource().nextInt(ids.length);
                        int nextFID = GlacierImpl.this.environment.getRandomSource().nextInt(GlacierImpl.this.numFragments);
                        for (int maxSteps = ids.length * GlacierImpl.this.numFragments; maxSteps > 0 && this.fragmentChecked[nextProbe][nextFID]; --maxSteps) {
                            if (++nextFID < GlacierImpl.this.numFragments) continue;
                            nextFID = 0;
                            nextProbe = (nextProbe + 1) % ids.length;
                        }
                        if (!this.fragmentChecked[nextProbe][nextFID] && this.retriesRemaining > 0) {
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("AR Sending a probe to " + this.fragmentKey[nextProbe][nextFID] + " at " + this.fragmentLocation[nextProbe][nextFID] + " (" + this.retriesRemaining + " probes left)");
                            }
                            this.fragmentChecked[nextProbe][nextFID] = true;
                            --this.retriesRemaining;
                            GlacierImpl.this.sendMessage(this.fragmentLocation[nextProbe][nextFID], new GlacierRefreshProbeMessage(this.getMyUID(), this.fragmentLocation[nextProbe][nextFID], GlacierImpl.this.getLocalNodeHandle(), this.fragmentLocation[nextProbe][nextFID], '\u0007'), null);
                        } else {
                            this.currentStage = 2;
                            this.retriesRemaining = 3;
                        }
                    }
                    if (this.currentStage == 2) {
                        int i;
                        this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.bulkRefreshManifestInterval;
                        boolean[] objectCovered = new boolean[ids.length];
                        boolean allObjectsCovered = true;
                        for (i = 0; i < ids.length; ++i) {
                            objectCovered[i] = this.manifests[i] != null;
                            allObjectsCovered &= objectCovered[i];
                        }
                        if (!allObjectsCovered && this.retriesRemaining-- > 0) {
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("AR Fetching manifests, " + this.retriesRemaining + " attempts remaining");
                            }
                            block2: while (true) {
                                int idx = GlacierImpl.this.environment.getRandomSource().nextInt(ids.length);
                                int maxSteps = ids.length + 2;
                                while (objectCovered[idx] && --maxSteps > 0) {
                                    idx = (idx + 1) % ids.length;
                                }
                                if (maxSteps <= 0) break;
                                int fid = GlacierImpl.this.environment.getRandomSource().nextInt(GlacierImpl.this.numFragments);
                                maxSteps = GlacierImpl.this.numFragments + 2;
                                while (this.fragmentHolder[idx][fid] == null && --maxSteps > 0) {
                                    fid = (fid + 1) % GlacierImpl.this.numFragments;
                                }
                                if (this.fragmentHolder[idx][fid] != null) {
                                    int i2;
                                    NodeHandle thisHolder = this.fragmentHolder[idx][fid];
                                    Vector<FragmentKey> idsToQuery = new Vector<FragmentKey>();
                                    block5: for (i2 = 0; i2 < ids.length; ++i2) {
                                        if (objectCovered[i2]) continue;
                                        for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                                            if (this.fragmentHolder[i2][j] == null || !this.fragmentHolder[i2][j].equals(thisHolder)) continue;
                                            idsToQuery.add(this.fragmentKey[i2][j]);
                                            objectCovered[i2] = true;
                                            continue block5;
                                        }
                                    }
                                    if (GlacierImpl.this.logger.level <= 500) {
                                        GlacierImpl.this.logger.log("AR Asking " + thisHolder + " for " + idsToQuery.size() + " manifests");
                                    }
                                    i2 = 0;
                                    while (true) {
                                        if (i2 >= idsToQuery.size()) continue block2;
                                        int idsHere = Math.min(idsToQuery.size() - i2, GlacierImpl.this.bulkRefreshManifestAggregationFactor);
                                        FragmentKey[] keys = new FragmentKey[idsHere];
                                        for (int j = 0; j < idsHere; ++j) {
                                            keys[j] = (FragmentKey)idsToQuery.elementAt(i2 + j);
                                        }
                                        if (GlacierImpl.this.logger.level <= 500) {
                                            GlacierImpl.this.logger.log("AR Sending a manifest fetch with " + idsHere + " IDs, starting at " + keys[0]);
                                        }
                                        GlacierImpl.this.sendMessage(null, new GlacierFetchMessage(this.getMyUID(), keys, 2, GlacierImpl.this.getLocalNodeHandle(), thisHolder.getId(), '\u0007'), thisHolder);
                                        i2 += GlacierImpl.this.bulkRefreshManifestAggregationFactor;
                                    }
                                }
                                objectCovered[idx] = true;
                            }
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("AR Manifest fetches sent; awaiting responses...");
                            }
                        } else {
                            this.currentStage = 3;
                            this.retriesRemaining = GlacierImpl.this.bulkRefreshPatchRetries;
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("AR Patching manifests...");
                            }
                            for (i = 0; i < ids.length; ++i) {
                                if (this.manifests[i] == null) continue;
                                this.manifests[i] = GlacierImpl.this.policy.updateManifest(this.versionKey[i], this.manifests[i], expirations[i]);
                            }
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("AR Done patching manifests");
                            }
                            for (i = 0; i < ids.length; ++i) {
                                for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                                    this.fragmentChecked[i][j] = this.fragmentHolder[i][j] == null || this.manifests[i] == null;
                                }
                            }
                        }
                    }
                    if (this.currentStage == 3) {
                        this.nextTimeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.bulkRefreshPatchInterval;
                        if (this.retriesRemaining-- > 0) {
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("AR Sending patches... (" + this.retriesRemaining + " retries left)");
                            }
                            int totalPatchesSent = 0;
                            for (int h = 0; h < this.holders.size(); ++h) {
                                NodeHandle thisHolder = (NodeHandle)this.holders.elementAt(h);
                                boolean[] sendPatchForObject = new boolean[ids.length];
                                int numPatches = 0;
                                for (int i = 0; i < ids.length; ++i) {
                                    sendPatchForObject[i] = false;
                                    for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                                        if (this.fragmentChecked[i][j] || !this.fragmentHolder[i][j].equals(thisHolder)) continue;
                                        sendPatchForObject[i] = true;
                                    }
                                    if (!sendPatchForObject[i]) continue;
                                    ++numPatches;
                                }
                                if (GlacierImpl.this.logger.level <= 500) {
                                    GlacierImpl.this.logger.log("AR Holder #" + h + " (" + thisHolder + ") should get " + numPatches + " patches");
                                }
                                int nextPatch = 0;
                                for (int i = 0; i < numPatches; i += GlacierImpl.this.bulkRefreshPatchAggregationFactor) {
                                    int patchesHere = Math.min(numPatches - i, GlacierImpl.this.bulkRefreshPatchAggregationFactor);
                                    VersionKey[] keys = new VersionKey[patchesHere];
                                    long[] lifetimes = new long[patchesHere];
                                    byte[][] signatures = new byte[patchesHere][];
                                    for (int j = 0; j < patchesHere; ++j) {
                                        while (!sendPatchForObject[nextPatch]) {
                                            ++nextPatch;
                                        }
                                        keys[j] = this.versionKey[nextPatch];
                                        lifetimes[j] = expirations[nextPatch];
                                        signatures[j] = this.manifests[nextPatch].signature;
                                        ++nextPatch;
                                    }
                                    if (GlacierImpl.this.logger.level <= 500) {
                                        GlacierImpl.this.logger.log("AR Sending a patch with " + patchesHere + " IDs, starting at " + keys[0] + ", to " + thisHolder.getId());
                                    }
                                    totalPatchesSent += patchesHere;
                                    GlacierImpl.this.sendMessage(null, new GlacierRefreshPatchMessage(this.getMyUID(), keys, lifetimes, signatures, GlacierImpl.this.getLocalNodeHandle(), thisHolder.getId(), '\u0007'), thisHolder);
                                }
                            }
                            if (totalPatchesSent == 0) {
                                if (GlacierImpl.this.logger.level <= 500) {
                                    GlacierImpl.this.logger.log("AR No patches sent; refresh seems to be complete...");
                                }
                                this.retriesRemaining = 0;
                                this.timeoutExpired();
                            }
                        } else {
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("AR Giving up");
                            }
                            this.terminate();
                            Object[] result = new Object[ids.length];
                            for (int i = 0; i < ids.length; ++i) {
                                Object object = result[i] = this.successes[i] >= this.minAcceptable ? new Boolean(true) : new GlacierException("Only " + this.successes[i] + " fragments of " + this.versionKey[i] + " refreshed successfully; need " + this.minAcceptable);
                                if (GlacierImpl.this.logger.level > 500) continue;
                                GlacierImpl.this.logger.log(" - AR Result for " + this.versionKey[i] + ": " + (result[i] instanceof Boolean ? "OK" : "Failed") + " (with " + this.successes[i] + "/" + GlacierImpl.this.numFragments + " fragments, " + this.minAcceptable + " acceptable)");
                            }
                            this.answered = true;
                            command.receiveResult(result);
                        }
                    }
                }
            });
        }
    }

    private void distribute(final VersionKey key, final Fragment[] fragments, final Manifest[] manifests, final long expiration, final char tag, final Continuation command) {
        final long tStart = this.environment.getTimeSource().currentTimeMillis();
        this.addContinuation(new GlacierContinuation(){
            NodeHandle[] holder;
            boolean[] receiptReceived;
            boolean doInsert;
            boolean doRefresh;
            boolean answered;
            boolean inhibitInsertions;
            int minAcceptable;
            {
                this.doInsert = fragments != null;
                this.doRefresh = !this.doInsert;
                this.answered = false;
                this.inhibitInsertions = true;
                this.minAcceptable = (int)((double)GlacierImpl.this.numSurvivors * GlacierImpl.this.minFragmentsAfterInsert);
            }

            public long getTimeout() {
                return tStart + (this.doRefresh ? GlacierImpl.this.refreshTimeout : GlacierImpl.this.insertTimeout);
            }

            public String toString() {
                return this.whoAmI() + " continuation for " + key;
            }

            private int numReceiptsReceived() {
                int result = 0;
                for (int i = 0; i < this.receiptReceived.length; ++i) {
                    if (!this.receiptReceived[i]) continue;
                    ++result;
                }
                return result;
            }

            private int numHoldersKnown() {
                int result = 0;
                for (int i = 0; i < this.holder.length; ++i) {
                    if (this.holder[i] == null) continue;
                    ++result;
                }
                return result;
            }

            private String whoAmI() {
                return this.doRefresh ? "Refresh" : "Insert";
            }

            public void init() {
                if (GlacierImpl.this.logger.level <= 800) {
                    GlacierImpl.this.logger.log("Initializing " + this.whoAmI() + " continuation for " + key);
                }
                this.holder = new NodeHandle[GlacierImpl.this.numFragments];
                this.receiptReceived = new boolean[GlacierImpl.this.numFragments];
                if (GlacierImpl.this.logger.level <= 500) {
                    GlacierImpl.this.logger.log("Sending queries for " + key);
                }
                for (int i = 0; i < GlacierImpl.this.numFragments; ++i) {
                    Id fragmentLoc = GlacierImpl.this.getFragmentLocation(key.getId(), i, key.getVersion());
                    FragmentKey[] keys = new FragmentKey[]{new FragmentKey(key, i)};
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("Query #" + i + " to " + fragmentLoc);
                    }
                    GlacierImpl.this.sendMessage(fragmentLoc, new GlacierQueryMessage(this.getMyUID(), keys, GlacierImpl.this.getLocalNodeHandle(), fragmentLoc, tag), null);
                }
            }

            public void receiveResult(Object o) {
                if (o instanceof GlacierResponseMessage) {
                    GlacierResponseMessage grm = (GlacierResponseMessage)o;
                    if (!grm.getKey(0).getVersionKey().equals(key)) {
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.log(this.whoAmI() + " response got routed to the wrong key: " + key);
                        }
                        return;
                    }
                    int fragmentID = grm.getKey(0).getFragmentID();
                    if (fragmentID < GlacierImpl.this.numFragments) {
                        if (grm.getAuthoritative(0)) {
                            if (this.doInsert && !grm.getHaveIt(0)) {
                                if (this.holder[fragmentID] == null) {
                                    this.holder[fragmentID] = grm.getSource();
                                    if (!this.inhibitInsertions) {
                                        if (GlacierImpl.this.logger.level <= 500) {
                                            GlacierImpl.this.logger.log("Got insert response, sending fragment " + grm.getKey(0));
                                        }
                                        GlacierImpl.this.sendMessage(null, new GlacierDataMessage(this.getMyUID(), grm.getKey(0), fragments[fragmentID], manifests[fragmentID], GlacierImpl.this.getLocalNodeHandle(), grm.getSource().getId(), false, tag), grm.getSource());
                                    } else if (this.numHoldersKnown() >= this.minAcceptable) {
                                        if (GlacierImpl.this.logger.level <= 500) {
                                            GlacierImpl.this.logger.log("Got " + this.numHoldersKnown() + " insert responses, sending fragments...");
                                        }
                                        this.inhibitInsertions = false;
                                        for (int i = 0; i < this.holder.length; ++i) {
                                            if (this.holder[i] == null) continue;
                                            if (GlacierImpl.this.logger.level <= 500) {
                                                GlacierImpl.this.logger.log("Sending fragment #" + i);
                                            }
                                            GlacierImpl.this.sendMessage(null, new GlacierDataMessage(this.getMyUID(), new FragmentKey(key, i), fragments[i], manifests[i], GlacierImpl.this.getLocalNodeHandle(), this.holder[i].getId(), false, tag), this.holder[i]);
                                        }
                                        if (GlacierImpl.this.logger.level <= 500) {
                                            GlacierImpl.this.logger.log("Done sending fragments, now accepting further responses");
                                        }
                                    } else if (GlacierImpl.this.logger.level <= 500) {
                                        GlacierImpl.this.logger.log("Got insert response #" + this.numHoldersKnown() + " (" + this.minAcceptable + " needed to start insertion)");
                                    }
                                } else if (GlacierImpl.this.logger.level <= 900) {
                                    GlacierImpl.this.logger.log("Received two insert responses for the same fragment -- discarded");
                                }
                            } else if (grm.getHaveIt(0) && grm.getExpiration(0) < expiration) {
                                if (this.holder[fragmentID] == null) {
                                    this.holder[fragmentID] = grm.getSource();
                                    if (GlacierImpl.this.logger.level <= 500) {
                                        GlacierImpl.this.logger.log("Got refresh response (exp=" + grm.getExpiration(0) + "<" + expiration + "), sending manifest " + grm.getKey(0));
                                    }
                                    GlacierImpl.this.sendMessage(null, new GlacierDataMessage(this.getMyUID(), grm.getKey(0), null, manifests[fragmentID], GlacierImpl.this.getLocalNodeHandle(), grm.getSource().getId(), false, tag), grm.getSource());
                                    if (this.doRefresh) {
                                        this.receiptReceived[fragmentID] = true;
                                        if (this.numReceiptsReceived() >= this.minAcceptable && !this.answered) {
                                            this.answered = true;
                                            this.reportSuccess();
                                        }
                                    }
                                } else if (GlacierImpl.this.logger.level <= 900) {
                                    GlacierImpl.this.logger.log("Received two refresh responses for the same fragment -- discarded");
                                }
                            } else if (grm.getHaveIt(0) && grm.getExpiration(0) >= expiration) {
                                if (GlacierImpl.this.logger.level <= 500) {
                                    GlacierImpl.this.logger.log("Receipt received after " + this.whoAmI() + ": " + grm.getKey(0));
                                }
                                this.receiptReceived[fragmentID] = true;
                                if (this.numReceiptsReceived() >= this.minAcceptable && !this.answered) {
                                    this.answered = true;
                                    this.reportSuccess();
                                }
                            }
                        } else if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log(this.whoAmI() + " response, but not authoritative -- ignoring");
                        }
                    } else if (GlacierImpl.this.logger.level <= 900) {
                        GlacierImpl.this.logger.log("Fragment ID too large in " + this.whoAmI() + " response -- discarded");
                    }
                    return;
                }
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.log("Unknown response to " + this.whoAmI() + " continuation: " + o + " -- discarded");
                }
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.logException("Exception during " + this.whoAmI() + "(" + key + "): ", e);
                }
                if (!this.answered) {
                    this.answered = true;
                    command.receiveException(new GlacierException("Exception while inserting/refreshing: " + e));
                }
                this.terminate();
            }

            private void reportSuccess() {
                if (GlacierImpl.this.logger.level <= 500) {
                    GlacierImpl.this.logger.log("Reporting success for " + key + ", " + this.numReceiptsReceived() + "/" + GlacierImpl.this.numFragments + " receipts received so far");
                }
                if (this.doInsert) {
                    command.receiveResult(new Boolean[]{new Boolean(true)});
                } else {
                    command.receiveResult(new Boolean(true));
                }
            }

            public void timeoutExpired() {
                if (this.numReceiptsReceived() >= this.minAcceptable) {
                    if (GlacierImpl.this.logger.level <= 800) {
                        GlacierImpl.this.logger.log(this.whoAmI() + " of " + key + " successful, " + this.numReceiptsReceived() + "/" + GlacierImpl.this.numFragments + " receipts received");
                    }
                    if (!this.answered) {
                        this.answered = true;
                        this.reportSuccess();
                    }
                } else {
                    if (GlacierImpl.this.logger.level <= 900) {
                        GlacierImpl.this.logger.log(this.whoAmI() + " " + key + " failed, only " + this.numReceiptsReceived() + "/" + GlacierImpl.this.numFragments + " receipts received");
                    }
                    if (!this.answered) {
                        this.answered = true;
                        command.receiveException(new GlacierException(this.whoAmI() + " failed, did not receive enough receipts"));
                    }
                }
                this.terminate();
            }
        });
    }

    public void insert(final PastContent obj, final long expiration, final Continuation command) {
        long theVersion = obj instanceof GCPastContent ? ((GCPastContent)obj).getVersion() : 0L;
        final VersionKey vkey = new VersionKey(obj.getId(), theVersion);
        if (this.logger.level <= 800) {
            this.logger.log("insert(" + obj + " (id=" + vkey.toStringFull() + ", mutable=" + obj.isMutable() + ")");
        }
        this.endpoint.process(new Executable(){

            public Object execute() {
                boolean[] generateFragment = new boolean[GlacierImpl.this.numFragments];
                Arrays.fill(generateFragment, true);
                return GlacierImpl.this.policy.encodeObject(obj, generateFragment);
            }
        }, new Continuation(){

            public void receiveResult(Object o) {
                final Fragment[] fragments = (Fragment[])o;
                if (fragments == null) {
                    command.receiveException(new GlacierException("Cannot encode object"));
                    return;
                }
                if (GlacierImpl.this.logger.level <= 500) {
                    GlacierImpl.this.logger.log("insert(" + vkey.toStringFull() + ") encoded fragments OK, creating manifests...");
                }
                GlacierImpl.this.endpoint.process(new Executable(){

                    public Object execute() {
                        return GlacierImpl.this.policy.createManifests(vkey, obj, fragments, expiration);
                    }
                }, new Continuation(){

                    public void receiveResult(Object o) {
                        if (o instanceof Manifest[]) {
                            Manifest[] manifests = (Manifest[])o;
                            if (manifests == null) {
                                command.receiveException(new GlacierException("Cannot create manifests"));
                                return;
                            }
                            GlacierImpl.this.distribute(vkey, fragments, manifests, expiration, '\b', command);
                        } else {
                            if (GlacierImpl.this.logger.level <= 900) {
                                GlacierImpl.this.logger.log("insert(" + vkey.toStringFull() + ") cannot create manifests - returned o=" + o);
                            }
                            command.receiveException(new GlacierException("Cannot create manifests in insert()"));
                        }
                    }

                    public void receiveException(Exception e) {
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.log("insert(" + vkey.toStringFull() + ") cannot create manifests - exception e=" + e);
                        }
                        command.receiveException(e);
                    }
                });
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 1000) {
                    GlacierImpl.this.logger.logException("EncodeObject failed: e=", e);
                }
                command.receiveException(new GlacierException("EncodeObject failed: e=" + e));
            }
        });
    }

    private void timerExpired() {
        long earliestTimeout;
        int numDelete;
        if (this.logger.level <= 500) {
            this.logger.log("Timer expired");
        }
        boolean foundTerminated = false;
        do {
            long now = this.environment.getTimeSource().currentTimeMillis();
            int[] deleteList = new int[100];
            numDelete = 0;
            earliestTimeout = -1L;
            if (this.logger.level <= 500) {
                this.logger.log("Timer run at " + now);
            }
            Enumeration enu = this.continuations.elements();
            while (enu.hasMoreElements()) {
                GlacierContinuation gc = (GlacierContinuation)enu.nextElement();
                long currentTimeout = gc.getTimeout();
                if (!gc.hasTerminated() && currentTimeout < now + 1000L) {
                    if (this.logger.level <= 500) {
                        this.logger.log("Timer: Resuming [" + gc + "]");
                    }
                    gc.syncTimeoutExpired();
                    if (!gc.hasTerminated() && gc.getTimeout() <= currentTimeout) {
                        this.panic("Continuation does not set new timeout: " + gc);
                    }
                }
                if (!gc.hasTerminated()) {
                    if (earliestTimeout != -1L && gc.getTimeout() >= earliestTimeout) continue;
                    earliestTimeout = gc.getTimeout();
                    continue;
                }
                if (numDelete >= 100) continue;
                deleteList[numDelete++] = gc.getMyUID();
            }
            if (numDelete <= 0) continue;
            if (this.logger.level <= 500) {
                this.logger.log("Deleting " + numDelete + " expired continuations");
            }
            for (int i = 0; i < numDelete; ++i) {
                this.continuations.remove(new Integer(deleteList[i]));
            }
        } while (numDelete == 100 || earliestTimeout >= 0L && earliestTimeout < this.environment.getTimeSource().currentTimeMillis());
        if (earliestTimeout >= 0L) {
            if (this.logger.level <= 500) {
                this.logger.log("Next timeout is at " + earliestTimeout);
            }
            this.setTimer((int)Math.max(earliestTimeout - this.environment.getTimeSource().currentTimeMillis(), 1000L));
        } else if (this.logger.level <= 500) {
            this.logger.log("No more timeouts");
        }
    }

    public void neighborSeen(Id nodeId, long when) {
        if (nodeId.equals(this.getLocalNodeHandle().getId())) {
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("Neighbor " + nodeId + " was seen at " + when);
        }
        if (when > this.environment.getTimeSource().currentTimeMillis()) {
            if (this.logger.level <= 900) {
                this.logger.log("Neighbor: " + when + " is in the future (now=" + this.environment.getTimeSource().currentTimeMillis() + ")");
            }
            when = this.environment.getTimeSource().currentTimeMillis();
        }
        final Id fNodeId = nodeId;
        final long fWhen = when;
        this.neighborStorage.getObject(nodeId, new Continuation(){

            public void receiveResult(Object o) {
                long previousWhen;
                if (GlacierImpl.this.logger.level <= 500) {
                    GlacierImpl.this.logger.log("Continue: neighborSeen (" + fNodeId + ", " + fWhen + ") after getObject");
                }
                long l = previousWhen = o != null ? (Long)o : 0L;
                if (GlacierImpl.this.logger.level <= 500) {
                    GlacierImpl.this.logger.log("Neighbor: " + fNodeId + " previously seen at " + previousWhen);
                }
                if (previousWhen >= fWhen) {
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("Neighbor: No update needed (new TS=" + fWhen + ")");
                    }
                    return;
                }
                GlacierImpl.this.neighborStorage.store(fNodeId, null, new Long(fWhen), new Continuation(){

                    public void receiveResult(Object o) {
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("Continue: neighborSeen (" + fNodeId + ", " + fWhen + ") after store");
                        }
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("Neighbor: Updated " + fNodeId + " from " + previousWhen + " to " + fWhen);
                        }
                        GlacierImpl.this.determineResponsibleRange();
                    }

                    public void receiveException(Exception e) {
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.log("receiveException(" + e + ") while storing a neighbor (" + fNodeId + ")");
                        }
                    }
                });
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.log("receiveException(" + e + ") while retrieving a neighbor (" + fNodeId + ")");
                }
            }
        });
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public void update(NodeHandle handle, boolean joined) {
        if (this.logger.level <= 800) {
            this.logger.log("Leafset update: " + handle + " has " + (joined ? "joined" : "left"));
        }
        if (!joined) {
            return;
        }
        this.neighborSeen(handle.getId(), this.environment.getTimeSource().currentTimeMillis());
    }

    public void lookupHandle(Id id, NodeHandle handle, Continuation command) {
        command.receiveException(new UnsupportedOperationException("LookupHandle() is not supported on Glacier"));
    }

    public void lookupHandles(Id id, int num, Continuation command) {
        this.lookupHandles(id, 0L, num, command);
    }

    public void lookupHandles(final Id id, final long version, int num, final Continuation command) {
        if (this.logger.level <= 800) {
            this.logger.log("lookupHandles(" + id + "v" + version + ", n=" + num + ")");
        }
        this.retrieveManifest(new VersionKey(id, version), '\t', new Continuation(){
            boolean haveAnswered = false;

            public void receiveResult(Object o) {
                if (this.haveAnswered) {
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("lookupHandles(" + id + "): received manifest " + o + " but has already answered. Discarding...");
                    }
                    return;
                }
                if (o instanceof Manifest) {
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("lookupHandles(" + id + "): received manifest " + o + ", returning handle...");
                    }
                    this.haveAnswered = true;
                    command.receiveResult(new PastContentHandle[]{new GlacierContentHandle(id, version, GlacierImpl.this.getLocalNodeHandle(), (Manifest)o)});
                } else {
                    if (GlacierImpl.this.logger.level <= 900) {
                        GlacierImpl.this.logger.log("lookupHandles(" + id + "): Cannot retrieve manifest");
                    }
                    this.haveAnswered = true;
                    command.receiveResult(new PastContentHandle[]{null});
                }
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.logException("lookupHandles(" + id + "): Exception ", e);
                }
                this.haveAnswered = true;
                command.receiveException(e);
            }
        });
    }

    public void lookup(Id id, long version, Continuation command) {
        VersionKey vkey = new VersionKey(id, version);
        if (this.logger.level <= 800) {
            this.logger.log("lookup(" + id + "v" + version + ")");
        }
        this.retrieveObject(vkey, null, true, '\n', command);
    }

    public void lookup(Id id, boolean cache, Continuation command) {
        this.lookup(id, 0L, command);
    }

    public void lookup(Id id, Continuation command) {
        this.lookup(id, 0L, command);
    }

    public void fetch(PastContentHandle handle, Continuation command) {
        if (this.logger.level <= 800) {
            this.logger.log("fetch(" + handle.getId() + ")");
        }
        if (!(handle instanceof GlacierContentHandle)) {
            command.receiveException(new GlacierException("Unknown handle type"));
            return;
        }
        GlacierContentHandle gch = (GlacierContentHandle)handle;
        if (this.logger.level <= 500) {
            this.logger.log("exact: fetch(" + gch.getId() + "v" + gch.getVersion() + ")");
        }
        this.retrieveObject(new VersionKey(gch.getId(), gch.getVersion()), gch.getManifest(), true, '\u000b', command);
    }

    public void retrieveManifest(final VersionKey key, final char tag, final Continuation command) {
        if (this.logger.level <= 500) {
            this.logger.log("retrieveManifest(key=" + key + " tag=" + tag + ")");
        }
        this.addContinuation(new GlacierContinuation(){
            protected boolean[] checkedFragment;
            protected long timeout;

            public long getTimeout() {
                return this.timeout;
            }

            public String toString() {
                return "retrieveManifest(" + key + ")";
            }

            public void init() {
                this.checkedFragment = new boolean[GlacierImpl.this.numFragments];
                Arrays.fill(this.checkedFragment, false);
                this.timeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis() + GlacierImpl.this.manifestRequestTimeout;
                int i = 0;
                while ((long)i < GlacierImpl.this.manifestRequestInitialBurst) {
                    this.sendRandomRequest();
                    ++i;
                }
            }

            public int numCheckedFragments() {
                int result = 0;
                for (int i = 0; i < this.checkedFragment.length; ++i) {
                    if (!this.checkedFragment[i]) continue;
                    ++result;
                }
                return result;
            }

            public void sendRandomRequest() {
                int nextID;
                if (this.numCheckedFragments() >= GlacierImpl.this.numFragments) {
                    return;
                }
                while (this.checkedFragment[nextID = GlacierImpl.this.environment.getRandomSource().nextInt(GlacierImpl.this.numFragments)]) {
                }
                this.checkedFragment[nextID] = true;
                FragmentKey nextKey = new FragmentKey(key, nextID);
                Id nextLocation = GlacierImpl.this.getFragmentLocation(nextKey);
                if (GlacierImpl.this.logger.level <= 500) {
                    GlacierImpl.this.logger.log("retrieveManifest: Asking " + nextLocation + " for " + nextKey);
                }
                GlacierImpl.this.sendMessage(nextLocation, new GlacierFetchMessage(this.getMyUID(), nextKey, 2, GlacierImpl.this.getLocalNodeHandle(), nextLocation, tag), null);
            }

            public void receiveResult(Object o) {
                if (o instanceof GlacierDataMessage) {
                    GlacierDataMessage gdm = (GlacierDataMessage)o;
                    if (gdm.numKeys() > 0 && gdm.getManifest(0) != null) {
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("retrieveManifest(" + key + ") received manifest");
                        }
                        if (GlacierImpl.this.policy.checkSignature(gdm.getManifest(0), key)) {
                            command.receiveResult(gdm.getManifest(0));
                            this.terminate();
                        } else if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.log("retrieveManifest(" + key + "): invalid signature in " + gdm.getKey(0));
                        }
                    } else if (GlacierImpl.this.logger.level <= 900) {
                        GlacierImpl.this.logger.log("retrieveManifest(" + key + ") retrieved GDM without a manifest?!?");
                    }
                } else if (o instanceof GlacierResponseMessage) {
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("retrieveManifest(" + key + "): Fragment not available:" + ((GlacierResponseMessage)o).getKey(0));
                    }
                    if (this.numCheckedFragments() < GlacierImpl.this.numFragments) {
                        this.sendRandomRequest();
                    } else {
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.log("retrieveManifest(" + key + "): giving up");
                        }
                        command.receiveResult(null);
                        this.terminate();
                    }
                } else if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.log("retrieveManifest(" + key + ") received unexpected object: " + o);
                }
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.logException("retrieveManifest(" + key + ") received exception: ", e);
                }
            }

            public void timeoutExpired() {
                if (GlacierImpl.this.logger.level <= 500) {
                    GlacierImpl.this.logger.log("retrieveManifest(" + key + "): Timeout (" + this.numCheckedFragments() + " fragments checked)");
                }
                if (this.numCheckedFragments() < GlacierImpl.this.numFragments) {
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("retrying...");
                    }
                    int i = 0;
                    while ((long)i < GlacierImpl.this.manifestRequestRetryBurst) {
                        this.sendRandomRequest();
                        ++i;
                    }
                    this.timeout += GlacierImpl.this.manifestRequestTimeout;
                } else {
                    if (GlacierImpl.this.logger.level <= 900) {
                        GlacierImpl.this.logger.log("retrieveManifest(" + key + "): giving up");
                    }
                    this.terminate();
                    command.receiveResult(null);
                }
            }
        });
    }

    public void retrieveObject(final VersionKey key, final Manifest manifest, final boolean beStrict, final char tag, final Continuation c) {
        this.addContinuation(new GlacierContinuation(){
            protected boolean[] checkedFragment;
            protected Fragment[] haveFragment;
            protected int attemptsLeft;
            protected long timeout;

            public long getTimeout() {
                return this.timeout;
            }

            public int numHaveFragments() {
                int result = 0;
                for (int i = 0; i < this.haveFragment.length; ++i) {
                    if (this.haveFragment[i] == null) continue;
                    ++result;
                }
                return result;
            }

            public int numCheckedFragments() {
                int result = 0;
                for (int i = 0; i < this.checkedFragment.length; ++i) {
                    if (!this.checkedFragment[i]) continue;
                    ++result;
                }
                return result;
            }

            public String toString() {
                return "retrieveObject(" + key + ")";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void init() {
                int[] nArray = GlacierImpl.this.numActiveRestores;
                synchronized (nArray) {
                    int[] nArray2 = GlacierImpl.this.numActiveRestores;
                    nArray2[0] = nArray2[0] + 1;
                }
                this.checkedFragment = new boolean[GlacierImpl.this.numFragments];
                this.haveFragment = new Fragment[GlacierImpl.this.numFragments];
                for (int i = 0; i < GlacierImpl.this.numFragments; ++i) {
                    this.checkedFragment[i] = false;
                    this.haveFragment[i] = null;
                }
                this.timeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis();
                this.attemptsLeft = GlacierImpl.this.restoreMaxBoosts;
                this.timeoutExpired();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void localTerminate() {
                int[] nArray = GlacierImpl.this.numActiveRestores;
                synchronized (nArray) {
                    int[] nArray2 = GlacierImpl.this.numActiveRestores;
                    nArray2[0] = nArray2[0] - 1;
                }
                this.terminate();
            }

            public void receiveResult(Object o) {
                if (o instanceof GlacierDataMessage) {
                    GlacierDataMessage gdm = (GlacierDataMessage)o;
                    int fragmentID = gdm.getKey(0).getFragmentID();
                    if (!gdm.getKey(0).getVersionKey().equals(key) || fragmentID < 0 || fragmentID >= GlacierImpl.this.numFragments) {
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.log("retrieveObject: Bad data message (contains " + gdm.getKey(0) + ", expected " + key);
                        }
                        return;
                    }
                    Fragment thisFragment = gdm.getFragment(0);
                    if (thisFragment == null) {
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("Fragment " + ((GlacierDataMessage)o).getKey(0) + " not available (GDM returned null), sending another request");
                        }
                        if (this.numCheckedFragments() < GlacierImpl.this.numFragments) {
                            this.sendRandomRequest();
                        }
                        return;
                    }
                    if (!this.checkedFragment[fragmentID]) {
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.log("retrieveObject: Got fragment #" + fragmentID + ", but we never requested it -- ignored");
                        }
                        return;
                    }
                    if (this.haveFragment[fragmentID] != null) {
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.log("retrieveObject: Got duplicate fragment #" + fragmentID + " -- discarded");
                        }
                        return;
                    }
                    if (manifest != null && !manifest.validatesFragment(thisFragment, fragmentID, GlacierImpl.this.environment.getLogManager().getLogger(Manifest.class, GlacierImpl.this.instance))) {
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.log("Got invalid fragment #" + fragmentID + " -- discarded");
                        }
                        return;
                    }
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("retrieveObject: Received fragment #" + fragmentID + " for " + gdm.getKey(0));
                    }
                    this.haveFragment[fragmentID] = thisFragment;
                    GlacierImpl.this.currentFragmentRequestTimeout -= GlacierImpl.this.fragmentRequestTimeoutDecrement;
                    if (GlacierImpl.this.currentFragmentRequestTimeout < GlacierImpl.this.fragmentRequestTimeoutMin) {
                        GlacierImpl.this.currentFragmentRequestTimeout = GlacierImpl.this.fragmentRequestTimeoutMin;
                    }
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("Timeout decreased to " + GlacierImpl.this.currentFragmentRequestTimeout);
                    }
                    if (this.numHaveFragments() >= GlacierImpl.this.numSurvivors) {
                        Fragment[] material = new Fragment[GlacierImpl.this.numFragments];
                        int numAdded = 0;
                        for (int j = 0; j < GlacierImpl.this.numFragments; ++j) {
                            if (this.haveFragment[j] != null && numAdded < GlacierImpl.this.numSurvivors) {
                                material[j] = this.haveFragment[j];
                                ++numAdded;
                                continue;
                            }
                            material[j] = null;
                        }
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("Decode object: " + key);
                        }
                        PastContent theObject = GlacierImpl.this.policy.decodeObject(material, GlacierImpl.this.endpoint, GlacierImpl.this.contentDeserializer);
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("Decode complete: " + key);
                        }
                        if (theObject == null) {
                            if (GlacierImpl.this.logger.level <= 900) {
                                GlacierImpl.this.logger.log("retrieveObject: Decoder delivered " + theObject + ", unexpected -- failed");
                            }
                            c.receiveException(new GlacierException("Decoder delivered " + theObject + ", unexpected -- failed"));
                        } else {
                            c.receiveResult(theObject);
                        }
                        this.localTerminate();
                    }
                } else if (o instanceof GlacierResponseMessage) {
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("Fragment " + ((GlacierResponseMessage)o).getKey(0) + " not available");
                    }
                    if (this.numCheckedFragments() < GlacierImpl.this.numFragments) {
                        this.sendRandomRequest();
                    }
                } else if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.log("retrieveObject: Unexpected result: " + o);
                }
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.logException("retrieveObject: Exception ", e);
                }
                c.receiveException(e);
                this.localTerminate();
            }

            public void sendRandomRequest() {
                int nextID;
                while (this.checkedFragment[nextID = GlacierImpl.this.environment.getRandomSource().nextInt(GlacierImpl.this.numFragments)]) {
                }
                this.checkedFragment[nextID] = true;
                FragmentKey nextKey = new FragmentKey(key, nextID);
                Id nextLocation = GlacierImpl.this.getFragmentLocation(nextKey);
                if (GlacierImpl.this.logger.level <= 500) {
                    GlacierImpl.this.logger.log("retrieveObject: Asking " + nextLocation + " for " + nextKey);
                }
                GlacierImpl.this.sendMessage(nextLocation, new GlacierFetchMessage(this.getMyUID(), nextKey, 1, GlacierImpl.this.getLocalNodeHandle(), nextLocation, tag), null);
            }

            public void timeoutExpired() {
                if (this.attemptsLeft > 0) {
                    if (GlacierImpl.this.logger.level <= 500) {
                        GlacierImpl.this.logger.log("retrieveObject: Retrying (" + this.attemptsLeft + " attempts left)");
                    }
                    if (this.attemptsLeft < GlacierImpl.this.restoreMaxBoosts) {
                        GlacierImpl.this.currentFragmentRequestTimeout *= 2L;
                        if (GlacierImpl.this.currentFragmentRequestTimeout > GlacierImpl.this.fragmentRequestTimeoutMax) {
                            GlacierImpl.this.currentFragmentRequestTimeout = GlacierImpl.this.fragmentRequestTimeoutMax;
                        }
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("Timeout increased to " + GlacierImpl.this.currentFragmentRequestTimeout);
                        }
                    }
                    this.timeout += GlacierImpl.this.currentFragmentRequestTimeout;
                    --this.attemptsLeft;
                    int numRequests = GlacierImpl.this.numSurvivors - this.numHaveFragments();
                    if (this.attemptsLeft < GlacierImpl.this.restoreMaxBoosts - 1) {
                        numRequests = Math.min(2 * numRequests, GlacierImpl.this.numFragments - this.numCheckedFragments());
                    }
                    if (this.attemptsLeft == 0 && beStrict) {
                        numRequests = GlacierImpl.this.numFragments - this.numCheckedFragments();
                    }
                    for (int i = 0; i < numRequests && this.numCheckedFragments() < GlacierImpl.this.numFragments; ++i) {
                        this.sendRandomRequest();
                    }
                } else {
                    if (GlacierImpl.this.logger.level <= 800) {
                        GlacierImpl.this.logger.log("retrieveObject: Giving up on " + key + " (" + GlacierImpl.this.restoreMaxBoosts + " attempts, " + this.numCheckedFragments() + " checked, " + this.numHaveFragments() + " gotten)");
                    }
                    c.receiveException(new GlacierNotEnoughFragmentsException("Maximum number of attempts (" + GlacierImpl.this.restoreMaxBoosts + ") reached for key " + key, this.numCheckedFragments(), this.numHaveFragments()));
                    this.localTerminate();
                }
            }
        });
    }

    public void retrieveFragment(final FragmentKey key, final Manifest manifest, final char tag, final GlacierContinuation c) {
        final Continuation c2 = new Continuation(){

            public void receiveResult(Object o) {
                if (o != null) {
                    if (o instanceof FragmentAndManifest) {
                        Fragment thisFragment = ((FragmentAndManifest)o).fragment;
                        if (manifest.validatesFragment(thisFragment, key.getFragmentID(), GlacierImpl.this.environment.getLogManager().getLogger(Manifest.class, GlacierImpl.this.instance))) {
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("retrieveFragment: Found in trash: " + key.toStringFull());
                            }
                            c.receiveResult(thisFragment);
                            return;
                        }
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.log("Fragment found in trash, but does not match manifest?!? -- fetching normally");
                        }
                    } else if (GlacierImpl.this.logger.level <= 900) {
                        GlacierImpl.this.logger.log("Fragment " + key.toStringFull() + " found in trash, but object is not a FAM (" + o + ")?!? -- ignoring");
                    }
                }
                GlacierImpl.this.addContinuation(new GlacierContinuation(){
                    protected int attemptsLeft;
                    protected boolean inPhaseTwo;
                    protected long timeout;

                    public long getTimeout() {
                        return this.timeout;
                    }

                    public String toString() {
                        return "retrieveFragment(" + key + ")";
                    }

                    public void init() {
                        this.attemptsLeft = GlacierImpl.this.fragmentRequestMaxAttempts;
                        this.timeout = GlacierImpl.this.environment.getTimeSource().currentTimeMillis();
                        this.inPhaseTwo = false;
                        this.timeoutExpired();
                    }

                    public void receiveResult(Object o) {
                        if (o instanceof GlacierResponseMessage) {
                            GlacierResponseMessage grm = (GlacierResponseMessage)o;
                            if (!grm.getKey(0).equals(key)) {
                                if (GlacierImpl.this.logger.level <= 900) {
                                    GlacierImpl.this.logger.log("retrieveFragment: Response does not match key " + key + " -- discarded");
                                }
                                return;
                            }
                            if (this.attemptsLeft > 0 && !grm.getHaveIt(0)) {
                                this.attemptsLeft = 0;
                                this.timeoutExpired();
                            } else if (GlacierImpl.this.logger.level <= 900) {
                                GlacierImpl.this.logger.log("retrieveFragment: Unexpected GlacierResponseMessage: " + grm + " (key=" + key + ")");
                            }
                            return;
                        }
                        if (o instanceof GlacierDataMessage) {
                            GlacierDataMessage gdm = (GlacierDataMessage)o;
                            if (!gdm.getKey(0).equals(key)) {
                                if (GlacierImpl.this.logger.level <= 900) {
                                    GlacierImpl.this.logger.log("retrieveFragment: Data does not match key " + key + " -- discarded");
                                }
                                return;
                            }
                            Fragment thisFragment = gdm.getFragment(0);
                            if (thisFragment == null) {
                                if (GlacierImpl.this.logger.level <= 900) {
                                    GlacierImpl.this.logger.log("retrieveFragment: DataMessage does not contain any fragments -- discarded");
                                }
                                return;
                            }
                            if (!manifest.validatesFragment(thisFragment, gdm.getKey(0).getFragmentID(), GlacierImpl.this.environment.getLogManager().getLogger(Manifest.class, GlacierImpl.this.instance))) {
                                if (GlacierImpl.this.logger.level <= 900) {
                                    GlacierImpl.this.logger.log("Invalid fragment " + gdm.getKey(0) + " returned by primary -- ignored");
                                }
                                return;
                            }
                            c.receiveResult(thisFragment);
                            this.terminate();
                            return;
                        }
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.log("retrieveFragment: Unknown result " + o + " (key=" + key + ")");
                        }
                    }

                    public void receiveException(Exception e) {
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.logException("retrieveFragment: Exception ", e);
                        }
                        c.receiveException(e);
                        this.terminate();
                    }

                    public void timeoutExpired() {
                        if (this.attemptsLeft > 0) {
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("retrieveFragment: Retrying (" + this.attemptsLeft + " attempts left)");
                            }
                            this.timeout += GlacierImpl.this.currentFragmentRequestTimeout;
                            --this.attemptsLeft;
                            GlacierImpl.this.sendMessage(key.getVersionKey().getId(), new GlacierFetchMessage(this.getMyUID(), key, 1, GlacierImpl.this.getLocalNodeHandle(), key.getVersionKey().getId(), tag), null);
                        } else {
                            this.timeout += (long)(3 * GlacierImpl.this.restoreMaxBoosts) * GlacierImpl.this.currentFragmentRequestTimeout;
                            if (this.inPhaseTwo && GlacierImpl.this.logger.level <= 900) {
                                GlacierImpl.this.logger.log("retrieveFragment: Already in phase two");
                            }
                            this.inPhaseTwo = true;
                            GlacierImpl.this.retrieveObject(key.getVersionKey(), manifest, false, tag, new Continuation(){

                                public void receiveResult(Object o) {
                                    if (o == null) {
                                        if (GlacierImpl.this.logger.level <= 900) {
                                            GlacierImpl.this.logger.log("retrieveFragment: retrieveObject(" + key.getVersionKey() + ") failed, returns null");
                                        }
                                        c.receiveException(new GlacierException("Cannot restore either the object or the fragment -- try again later!"));
                                        return;
                                    }
                                    final PastContent retrievedObject = (PastContent)o;
                                    GlacierImpl.this.endpoint.process(new Executable(){

                                        public Object execute() {
                                            if (GlacierImpl.this.logger.level <= 500) {
                                                GlacierImpl.this.logger.log("Reencode object: " + key.getVersionKey());
                                            }
                                            boolean[] generateFragment = new boolean[GlacierImpl.this.numFragments];
                                            Arrays.fill(generateFragment, false);
                                            generateFragment[key.getFragmentID()] = true;
                                            Fragment[] result = GlacierImpl.this.policy.encodeObject(retrievedObject, generateFragment);
                                            if (GlacierImpl.this.logger.level <= 500) {
                                                GlacierImpl.this.logger.log("Reencode complete: " + key.getVersionKey());
                                            }
                                            return result;
                                        }
                                    }, new Continuation(){

                                        public void receiveResult(Object o) {
                                            Fragment[] frag = (Fragment[])o;
                                            if (!manifest.validatesFragment(frag[key.getFragmentID()], key.getFragmentID(), GlacierImpl.this.environment.getLogManager().getLogger(Manifest.class, GlacierImpl.this.instance))) {
                                                if (GlacierImpl.this.logger.level <= 900) {
                                                    GlacierImpl.this.logger.log("Reconstructed fragment #" + key.getFragmentID() + " does not match manifest ??!?");
                                                }
                                                c.receiveException(new GlacierException("Recovered object, but cannot re-encode it (strange!) -- try again later!"));
                                                return;
                                            }
                                            c.receiveResult(frag[key.getFragmentID()]);
                                        }

                                        public void receiveException(Exception e) {
                                            if (GlacierImpl.this.logger.level <= 1000) {
                                                GlacierImpl.this.logger.logException("Recovered object, but re-encode failed: ", e);
                                            }
                                            c.receiveException(new GlacierException("Recovered object, but re-encode failed: " + e));
                                        }
                                    });
                                }

                                public void receiveException(Exception e) {
                                    c.receiveException(e);
                                }
                            });
                            this.terminate();
                        }
                    }
                });
            }

            public void receiveException(Exception e) {
                if (GlacierImpl.this.logger.level <= 900) {
                    GlacierImpl.this.logger.log("Exception while checking for " + key.toStringFull() + " in trash storage -- ignoring");
                }
            }
        };
        if (this.trashStorage != null) {
            this.trashStorage.getObject(key, new Continuation(){

                public void receiveResult(Object o) {
                    if (o != null) {
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("retrieveFragment: Key " + key.toStringFull() + " found in trash, retrieving...");
                        } else if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("retrieveFragment: Key " + key.toStringFull() + " not found in trash");
                        }
                    }
                    c2.receiveResult(o);
                }

                public void receiveException(Exception e) {
                    if (GlacierImpl.this.logger.level <= 900) {
                        GlacierImpl.this.logger.log("Exception while getting object " + key + " from trash " + e);
                    }
                    c2.receiveResult(null);
                }
            });
        } else {
            if (this.logger.level <= 500) {
                this.logger.log("retrieveFragment: Key " + key.toStringFull() + " not found in trash");
            }
            c2.receiveResult(null);
        }
    }

    public void rateLimitedRetrieveFragment(final FragmentKey key, final Manifest manifest, final char tag, final GlacierContinuation c) {
        Continuation prev;
        if (this.logger.level <= 500) {
            this.logger.log("rateLimitedRetrieveFragment(" + key + ")");
        }
        if (this.pendingTraffic.containsKey(key)) {
            if (this.logger.level <= 500) {
                this.logger.log("Fragment is already being retrieved -- discarding request");
            }
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("Added pending job: retrieveFragment(" + key + ")");
        }
        if ((prev = (Continuation)this.pendingTraffic.put(key, new Continuation.SimpleContinuation(){

            public void receiveResult(Object o) {
                GlacierImpl.this.retrieveFragment(key, manifest, tag, c);
            }
        })) != null) {
            prev.receiveException(new GlacierException("Key collision in traffic shaper (rateLimitedRetrieveFragment)"));
        }
    }

    public void deliver(Id id, Message message) {
        int i;
        GlacierDataMessage gdm;
        GlacierMessage msg = (GlacierMessage)message;
        if (this.logger.level <= 500) {
            this.logger.log("Received message " + msg + " with destination " + id + " from " + msg.getSource().getId());
        }
        if (msg instanceof GlacierDataMessage) {
            gdm = (GlacierDataMessage)msg;
            long thisSize = 1000L;
            this.updateTokenBucket();
            for (i = 0; i < gdm.numKeys(); ++i) {
                if (gdm.getFragment(i) != null) {
                    thisSize += (long)gdm.getFragment(i).getPayload().length;
                }
                if (gdm.getManifest(i) == null) continue;
                thisSize += (long)(this.numFragments * 21);
            }
            this.tokenBucket -= thisSize;
            this.bucketConsumed += thisSize;
            if (this.bucketMin > this.tokenBucket) {
                this.bucketMin = this.tokenBucket;
            }
            if (this.logger.level <= 500) {
                this.logger.log("Token bucket contains " + this.tokenBucket + " tokens (consumed " + thisSize + ")");
            }
        }
        if (msg.isResponse()) {
            GlacierContinuation gc = (GlacierContinuation)this.continuations.get(new Integer(msg.getUID()));
            if (gc != null) {
                if (!gc.terminated) {
                    if (this.logger.level <= 500) {
                        this.logger.log("Resuming [" + gc + "]");
                    }
                    gc.syncReceiveResult(msg);
                    if (this.logger.level <= 500) {
                        this.logger.log("---");
                    }
                } else if (this.logger.level <= 500) {
                    this.logger.log("Message UID#" + msg.getUID() + " is response, but continuation has already terminated");
                }
            } else if (this.logger.level <= 500) {
                this.logger.log("Unusual: Message UID#" + msg.getUID() + " is response, but continuation not found");
            }
            return;
        }
        if (msg instanceof GlacierQueryMessage) {
            GlacierQueryMessage gqm = (GlacierQueryMessage)msg;
            FragmentKey[] keyA = new FragmentKey[gqm.numKeys()];
            boolean[] haveItA = new boolean[gqm.numKeys()];
            long[] expirationA = new long[gqm.numKeys()];
            boolean[] authoritativeA = new boolean[gqm.numKeys()];
            for (int i2 = 0; i2 < gqm.numKeys(); ++i2) {
                Id fragmentLocation = this.getFragmentLocation(gqm.getKey(i2));
                if (this.logger.level <= 800) {
                    this.logger.log("Queried for " + gqm.getKey(i2) + " (at " + fragmentLocation + ")");
                }
                keyA[i2] = gqm.getKey(i2);
                haveItA[i2] = this.fragmentStorage.exists(gqm.getKey(i2));
                if (haveItA[i2]) {
                    FragmentMetadata metadata = (FragmentMetadata)this.fragmentStorage.getMetadata(gqm.getKey(i2));
                    if (metadata != null) {
                        expirationA[i2] = metadata.getCurrentExpiration();
                    } else {
                        if (this.logger.level <= 900) {
                            this.logger.log("QUERY cannot read metadata in object " + gqm.getKey(i2).toStringFull() + ", storage returned null");
                        }
                        expirationA[i2] = 0L;
                        haveItA[i2] = false;
                    }
                } else {
                    expirationA[i2] = 0L;
                }
                if (this.logger.level <= 500) {
                    this.logger.log("My range is " + this.responsibleRange);
                }
                if (this.logger.level <= 500) {
                    this.logger.log("Location is " + fragmentLocation);
                }
                authoritativeA[i2] = this.responsibleRange.containsId(fragmentLocation);
                if (this.logger.level > 500) continue;
                this.logger.log("Result: haveIt=" + haveItA[i2] + " amAuthority=" + authoritativeA[i2] + " expiration=" + expirationA[i2]);
            }
            this.sendMessage(null, new GlacierResponseMessage(gqm.getUID(), keyA, haveItA, expirationA, authoritativeA, this.getLocalNodeHandle(), gqm.getSource().getId(), true, gqm.getTag()), gqm.getSource());
        } else {
            GlacierMessage grpm;
            if (msg instanceof GlacierNeighborRequestMessage) {
                final GlacierNeighborRequestMessage gnrm = (GlacierNeighborRequestMessage)msg;
                IdSet requestedNeighbors = this.neighborStorage.scan(gnrm.getRequestedRange());
                final int numRequested = requestedNeighbors.numElements();
                if (numRequested < 1) {
                    if (this.logger.level <= 500) {
                        this.logger.log("No neighbors in that range -- canceled");
                    }
                    return;
                }
                if (this.logger.level <= 800) {
                    this.logger.log("Neighbor request for " + gnrm.getRequestedRange() + ", found " + numRequested + " neighbors");
                }
                final Id[] neighbors = new Id[numRequested];
                final long[] lastSeen = new long[numRequested];
                Iterator iter = requestedNeighbors.getIterator();
                for (int i3 = 0; i3 < numRequested; ++i3) {
                    neighbors[i3] = (Id)iter.next();
                }
                this.neighborStorage.getObject(neighbors[0], new Continuation(){
                    int currentLookup = 0;

                    public void receiveResult(Object o) {
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("Continue: NeighborRequest from " + gnrm.getSource().getId() + " for range " + gnrm.getRequestedRange());
                        }
                        if (o == null) {
                            if (GlacierImpl.this.logger.level <= 900) {
                                GlacierImpl.this.logger.log("Problem while retrieving neighbors -- canceled");
                            }
                            return;
                        }
                        if (o instanceof Long) {
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("Retr: Neighbor " + neighbors[this.currentLookup] + " was last seen at " + o);
                            }
                            lastSeen[this.currentLookup] = (Long)o;
                            ++this.currentLookup;
                            if (this.currentLookup < numRequested) {
                                GlacierImpl.this.neighborStorage.getObject(neighbors[this.currentLookup], this);
                            } else {
                                if (GlacierImpl.this.logger.level <= 500) {
                                    GlacierImpl.this.logger.log("Sending neighbor response...");
                                }
                                GlacierImpl.this.sendMessage(null, new GlacierNeighborResponseMessage(gnrm.getUID(), neighbors, lastSeen, GlacierImpl.this.getLocalNodeHandle(), gnrm.getSource().getId(), gnrm.getTag()), gnrm.getSource());
                            }
                        }
                    }

                    public void receiveException(Exception e) {
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.logException("Problem while retrieving neighbors in range " + gnrm.getRequestedRange() + " for " + gnrm.getSource() + " -- canceled", e);
                        }
                    }
                });
                return;
            }
            if (msg instanceof GlacierSyncMessage) {
                final GlacierSyncMessage gsm = (GlacierSyncMessage)msg;
                if (this.logger.level <= 800) {
                    this.logger.log("SyncRequest from " + gsm.getSource().getId() + " for " + gsm.getRange() + " offset " + gsm.getOffsetFID());
                }
                if (this.logger.level <= 500) {
                    this.logger.log("Contains " + gsm.getBloomFilter());
                }
                Iterator iter = this.fragmentStorage.scan().getIterator();
                IdRange range = gsm.getRange();
                final int offset = gsm.getOffsetFID();
                BloomFilter bv = gsm.getBloomFilter();
                long earliestAcceptableExpiration = this.environment.getTimeSource().currentTimeMillis() + this.syncMinRemainingLifetime;
                long latestAcceptableStoredSince = this.environment.getTimeSource().currentTimeMillis() - this.syncMinQuietTime;
                final Vector<FragmentKey> missing = new Vector<FragmentKey>();
                while (iter.hasNext()) {
                    FragmentKey fkey = (FragmentKey)iter.next();
                    Id thisPos = this.getFragmentLocation(fkey);
                    if (range.containsId(thisPos)) {
                        FragmentMetadata metadata = (FragmentMetadata)this.fragmentStorage.getMetadata(fkey);
                        if (metadata != null) {
                            if (!bv.contains(this.getHashInput(fkey.getVersionKey(), metadata.getCurrentExpiration()))) {
                                if (metadata.getCurrentExpiration() >= earliestAcceptableExpiration) {
                                    if (metadata.getStoredSince() <= latestAcceptableStoredSince) {
                                        if (this.logger.level <= 400) {
                                            this.logger.log(fkey + " @" + thisPos + " - MISSING");
                                        }
                                        missing.add(fkey);
                                        if (missing.size() < this.syncMaxFragments) continue;
                                        if (this.logger.level > 800) break;
                                        this.logger.log("Limit of " + this.syncMaxFragments + " missing fragments reached");
                                        break;
                                    }
                                    if (this.logger.level > 500) continue;
                                    this.logger.log(fkey + " @" + thisPos + " - TOO FRESH (stored " + (this.environment.getTimeSource().currentTimeMillis() - metadata.getStoredSince()) + "ms)");
                                    continue;
                                }
                                if (this.logger.level > 500) continue;
                                this.logger.log(fkey + " @" + thisPos + " - EXPIRES SOON (in " + (metadata.getCurrentExpiration() - this.environment.getTimeSource().currentTimeMillis()) + "ms)");
                                continue;
                            }
                            if (this.logger.level > 400) continue;
                            this.logger.log(fkey + " @" + thisPos + " - OK");
                            continue;
                        }
                        if (this.logger.level > 900) continue;
                        this.logger.log("SYNC RESPONSE cannot read metadata in object " + fkey.toStringFull() + ", storage returned null");
                        continue;
                    }
                    if (this.logger.level > 400) continue;
                    this.logger.log(fkey + " @" + thisPos + " - OUT OF RANGE");
                }
                if (missing.isEmpty()) {
                    if (this.logger.level <= 800) {
                        this.logger.log("No fragments missing. OK. ");
                    }
                    return;
                }
                if (this.logger.level <= 800) {
                    this.logger.log("Sending " + missing.size() + " fragments to " + gsm.getSource().getId());
                }
                this.fragmentStorage.getObject((FragmentKey)missing.elementAt(0), new Continuation(){
                    int currentLookup = 0;
                    int manifestIndex = 0;
                    final int numLookups = missing.size();
                    Manifest[] manifests = new Manifest[Math.min(this.numLookups, GlacierImpl.access$5200(GlacierImpl.this))];
                    Fragment[] fragments = new Fragment[Math.min(this.numLookups, GlacierImpl.access$5200(GlacierImpl.this))];
                    FragmentKey[] keys = new FragmentKey[Math.min(this.numLookups, GlacierImpl.access$5200(GlacierImpl.this))];

                    public void receiveResult(Object o) {
                        FragmentKey thisKey = (FragmentKey)missing.elementAt(this.currentLookup);
                        if (o == null) {
                            if (GlacierImpl.this.logger.level <= 900) {
                                GlacierImpl.this.logger.log("SYN2: Fragment " + thisKey + " not found -- canceled SYN");
                            }
                            return;
                        }
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("Retrieved manifest " + thisKey + " (dest=" + gsm.getSource().getId() + ", offset=" + offset + ")");
                        }
                        FragmentAndManifest fam = (FragmentAndManifest)o;
                        if (!GlacierImpl.this.policy.checkSignature(fam.manifest, thisKey.getVersionKey())) {
                            GlacierImpl.this.panic("Signature mismatch!!");
                        }
                        this.fragments[this.manifestIndex] = null;
                        this.manifests[this.manifestIndex] = fam.manifest;
                        int hisFID = thisKey.getFragmentID() - offset;
                        if (hisFID < 0) {
                            hisFID += GlacierImpl.this.numFragments;
                        }
                        if (hisFID >= GlacierImpl.this.numFragments) {
                            GlacierImpl.this.panic("Assertion failed: L938");
                        }
                        this.keys[this.manifestIndex] = new FragmentKey(thisKey.getVersionKey(), hisFID);
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("He should have key " + this.keys[this.manifestIndex] + " @" + GlacierImpl.this.getFragmentLocation(this.keys[this.manifestIndex]));
                        }
                        ++this.manifestIndex;
                        ++this.currentLookup;
                        if (this.manifestIndex == GlacierImpl.this.manifestAggregationFactor || this.currentLookup == this.numLookups) {
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("Sending a packet with " + this.keys.length + " manifests to " + gsm.getSource().getId());
                            }
                            GlacierImpl.this.sendMessage(null, new GlacierDataMessage(GlacierImpl.this.getUID(), this.keys, this.fragments, this.manifests, GlacierImpl.this.getLocalNodeHandle(), gsm.getSource().getId(), false, '\u0003'), gsm.getSource());
                            this.manifestIndex = 0;
                            this.manifests = new Manifest[Math.min(this.numLookups - this.currentLookup, GlacierImpl.this.manifestAggregationFactor)];
                            this.keys = new FragmentKey[Math.min(this.numLookups - this.currentLookup, GlacierImpl.this.manifestAggregationFactor)];
                            this.fragments = new Fragment[Math.min(this.numLookups - this.currentLookup, GlacierImpl.this.manifestAggregationFactor)];
                        }
                        if (this.currentLookup < this.numLookups) {
                            GlacierImpl.this.fragmentStorage.getObject((FragmentKey)missing.elementAt(this.currentLookup), this);
                        }
                    }

                    public void receiveException(Exception e) {
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.log("SYN2: Exception while retrieving fragment " + missing.elementAt(this.currentLookup) + ", e=" + e + " -- canceled SYN");
                        }
                    }
                });
                return;
            }
            if (msg instanceof GlacierRefreshProbeMessage) {
                grpm = (GlacierRefreshProbeMessage)msg;
                Id requestedId = ((GlacierRefreshProbeMessage)grpm).getRequestedId();
                if (this.logger.level <= 800) {
                    this.logger.log("Refresh probe for " + requestedId + " (RR=" + this.responsibleRange + ")");
                }
                Id[][] ranges = this.getNeighborRanges();
                IdRange returnedRange = null;
                boolean online = false;
                if (this.responsibleRange.containsId(requestedId)) {
                    returnedRange = this.responsibleRange;
                    online = true;
                } else {
                    online = false;
                    for (int i4 = 0; i4 < ranges.length; ++i4) {
                        IdRange thisRange = this.factory.buildIdRange(ranges[i4][0], ranges[i4][2]);
                        if (this.logger.level <= 500) {
                            this.logger.log(" - " + thisRange + " (" + ranges[i4][1] + ")");
                        }
                        if (!thisRange.containsId(requestedId)) continue;
                        returnedRange = thisRange;
                    }
                }
                this.sendMessage(null, new GlacierRefreshResponseMessage(grpm.getUID(), returnedRange, online, this.getLocalNodeHandle(), grpm.getSource().getId(), grpm.getTag()), grpm.getSource());
            } else if (msg instanceof GlacierRefreshPatchMessage) {
                grpm = (GlacierRefreshPatchMessage)msg;
                if (this.logger.level <= 800) {
                    this.logger.log("AR Refresh patches received for " + ((GlacierRefreshPatchMessage)grpm).numKeys() + " keys. Processing...");
                }
                Continuation c = new Continuation((GlacierRefreshPatchMessage)grpm){
                    int[] successes;
                    int currentPhase;
                    FragmentKey currentKey;
                    int currentIndex;
                    int currentFID;
                    static final int phaseFetch = 1;
                    static final int phaseStore = 2;
                    static final int phaseAdvance = 3;
                    final /* synthetic */ GlacierRefreshPatchMessage val$grpm;
                    {
                        this.val$grpm = glacierRefreshPatchMessage;
                        this.successes = new int[this.val$grpm.numKeys()];
                        this.currentPhase = 3;
                        this.currentKey = null;
                        this.currentIndex = 0;
                        this.currentFID = -1;
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    public void receiveResult(Object o) {
                        block15: {
                            block16: {
                                block17: {
                                    FragmentMetadata metadata;
                                    block18: {
                                        if (this.currentPhase != 1) break block15;
                                        if (GlacierImpl.this.logger.level <= 500) {
                                            GlacierImpl.this.logger.log("AR Patch: Got FAM for " + this.currentKey);
                                        }
                                        FragmentAndManifest fam = (FragmentAndManifest)o;
                                        fam.manifest.update(this.val$grpm.getLifetime(this.currentIndex), this.val$grpm.getSignature(this.currentIndex));
                                        if (!GlacierImpl.this.policy.checkSignature(fam.manifest, this.currentKey.getVersionKey())) break block16;
                                        metadata = (FragmentMetadata)GlacierImpl.this.fragmentStorage.getMetadata(this.currentKey);
                                        if (metadata == null) break block17;
                                        if (metadata.currentExpirationDate > this.val$grpm.getLifetime(this.currentIndex)) break block18;
                                        this.currentPhase = 2;
                                        if (metadata.currentExpirationDate == this.val$grpm.getLifetime(this.currentIndex)) {
                                            if (GlacierImpl.this.logger.level <= 500) {
                                                GlacierImpl.this.logger.log("AR Duplicate refresh request (prev=" + metadata.previousExpirationDate + " cur=" + metadata.currentExpirationDate + " updated=" + this.val$grpm.getLifetime(this.currentIndex) + ") -- ignoring");
                                            }
                                            break block15;
                                        } else {
                                            FragmentMetadata newMetadata = new FragmentMetadata(this.val$grpm.getLifetime(this.currentIndex), metadata.currentExpirationDate, metadata.storedSince);
                                            if (GlacierImpl.this.logger.level <= 500) {
                                                GlacierImpl.this.logger.log("AR FAM " + this.currentKey + " updated (" + newMetadata.previousExpirationDate + " -> " + newMetadata.currentExpirationDate + "), writing to disk...");
                                            }
                                            GlacierImpl.this.fragmentStorage.store(this.currentKey, newMetadata, fam, this);
                                            return;
                                        }
                                    }
                                    if (GlacierImpl.this.logger.level <= 900) {
                                        GlacierImpl.this.logger.log("RefreshPatch attempts to roll back lifetime from " + metadata.currentExpirationDate + " to " + this.val$grpm.getLifetime(this.currentIndex));
                                    }
                                    this.currentPhase = 2;
                                    break block15;
                                }
                                if (GlacierImpl.this.logger.level <= 900) {
                                    GlacierImpl.this.logger.log("Cannot fetch metadata for key " + this.currentKey + ", got 'null'");
                                }
                                this.currentPhase = 3;
                                break block15;
                            }
                            if (GlacierImpl.this.logger.level <= 900) {
                                GlacierImpl.this.logger.log("RefreshPatch with invalid signature: " + this.currentKey);
                            }
                            this.currentPhase = 3;
                        }
                        if (this.currentPhase == 2) {
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("AR Patch: Update completed for " + this.currentKey);
                            }
                            int n = this.currentIndex;
                            this.successes[n] = this.successes[n] + 1;
                            this.currentPhase = 3;
                        }
                        if (this.currentPhase == 3) {
                            do {
                                ++this.currentFID;
                                if (this.currentFID >= GlacierImpl.this.numFragments) {
                                    this.currentFID = 0;
                                    ++this.currentIndex;
                                }
                                if (this.currentIndex >= this.val$grpm.numKeys()) {
                                    this.respond();
                                    return;
                                }
                                this.currentKey = new FragmentKey(this.val$grpm.getKey(this.currentIndex), this.currentFID);
                            } while (!GlacierImpl.this.fragmentStorage.exists(this.currentKey));
                            this.currentPhase = 1;
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("AR Patch: Fetching FAM for " + this.currentKey);
                            }
                            GlacierImpl.this.fragmentStorage.getObject(this.currentKey, this);
                        }
                    }

                    public void respond() {
                        int totalSuccesses = 0;
                        for (int i = 0; i < this.successes.length; ++i) {
                            totalSuccesses += this.successes[i];
                        }
                        if (GlacierImpl.this.logger.level <= 500) {
                            GlacierImpl.this.logger.log("AR Patch: Sending response (" + totalSuccesses + " updates total)");
                        }
                        GlacierImpl.this.sendMessage(null, new GlacierRefreshCompleteMessage(this.val$grpm.getUID(), this.val$grpm.getAllKeys(), this.successes, GlacierImpl.this.getLocalNodeHandle(), this.val$grpm.getSource().getId(), this.val$grpm.getTag()), this.val$grpm.getSource());
                    }

                    public void receiveException(Exception e) {
                        if (GlacierImpl.this.logger.level <= 900) {
                            GlacierImpl.this.logger.logException("Exception while processing AR patch (key " + this.currentKey + ", phase " + this.currentPhase + "): ", e);
                        }
                        this.currentPhase = 3;
                        this.receiveResult(null);
                    }
                };
                c.receiveResult(null);
            } else {
                if (msg instanceof GlacierRangeQueryMessage) {
                    GlacierRangeQueryMessage grqm = (GlacierRangeQueryMessage)msg;
                    IdRange requestedRange = grqm.getRequestedRange();
                    if (this.logger.level <= 800) {
                        this.logger.log("Range query for " + requestedRange);
                    }
                    Id[][] ranges = this.getNeighborRanges();
                    for (i = 0; i < ranges.length; ++i) {
                        IdRange thisRange = this.factory.buildIdRange(ranges[i][0], ranges[i][2]);
                        IdRange intersectRange = requestedRange.intersectRange(thisRange);
                        if (intersectRange.isEmpty()) continue;
                        if (this.logger.level <= 500) {
                            this.logger.log("     - Intersects: " + intersectRange + ", sending RangeForward");
                        }
                        this.sendMessage(ranges[i][1], new GlacierRangeForwardMessage(grqm.getUID(), requestedRange, grqm.getSource(), this.getLocalNodeHandle(), ranges[i][1], grqm.getTag()), null);
                    }
                    if (this.logger.level <= 500) {
                        this.logger.log("Finished processing range query");
                    }
                    return;
                }
                if (msg instanceof GlacierRangeForwardMessage) {
                    GlacierRangeForwardMessage grfm = (GlacierRangeForwardMessage)msg;
                    if (!grfm.getDestination().equals(this.getLocalNodeHandle().getId())) {
                        if (this.logger.level <= 900) {
                            this.logger.log("Glog(Logger.WARNINGNot for us (dest=" + grfm.getDestination() + ", we=" + this.getLocalNodeHandle().getId());
                        }
                        return;
                    }
                    IdRange commonRange = this.responsibleRange.intersectRange(grfm.getRequestedRange());
                    if (!commonRange.isEmpty()) {
                        if (this.logger.level <= 800) {
                            this.logger.log("Range forward: Returning common range " + commonRange + " to requestor " + grfm.getRequestor());
                        }
                        this.sendMessage(null, new GlacierRangeResponseMessage(grfm.getUID(), commonRange, this.getLocalNodeHandle(), grfm.getRequestor().getId(), grfm.getTag()), grfm.getRequestor());
                    } else if (this.logger.level <= 900) {
                        this.logger.log("Received GRFM by " + grfm.getRequestor() + ", but no common range??!? -- ignored");
                    }
                    return;
                }
                if (msg instanceof GlacierFetchMessage) {
                    final GlacierFetchMessage gfm = (GlacierFetchMessage)msg;
                    if (this.logger.level <= 800) {
                        this.logger.log("Fetch request for " + gfm.getKey(0) + (gfm.getNumKeys() > 1 ? " and " + (gfm.getNumKeys() - 1) + " other keys" : "") + ", request=" + gfm.getRequest());
                    }
                    this.fragmentStorage.getObject(gfm.getKey(0), new Continuation(){
                        int currentLookup = 0;
                        Fragment[] fragment = new Fragment[gfm.getNumKeys()];
                        Manifest[] manifest = new Manifest[gfm.getNumKeys()];
                        int numFragments = 0;
                        int numManifests = 0;

                        public void returnResponse() {
                            if (GlacierImpl.this.logger.level <= 500) {
                                GlacierImpl.this.logger.log("Returning response with " + this.numFragments + " fragments, " + this.numManifests + " manifests (" + gfm.getNumKeys() + " queries originally)");
                            }
                            GlacierImpl.this.sendMessage(null, new GlacierDataMessage(gfm.getUID(), gfm.getAllKeys(), this.fragment, this.manifest, GlacierImpl.this.getLocalNodeHandle(), gfm.getSource().getId(), true, gfm.getTag()), gfm.getSource());
                        }

                        public void receiveResult(Object o) {
                            if (o != null) {
                                if (GlacierImpl.this.logger.level <= 800) {
                                    GlacierImpl.this.logger.log("Fragment " + gfm.getKey(this.currentLookup) + " found (" + o + ")");
                                }
                                FragmentAndManifest fam = (FragmentAndManifest)o;
                                Fragment fragment = this.fragment[this.currentLookup] = (gfm.getRequest() & 1) != 0 ? fam.fragment : null;
                                if (this.fragment[this.currentLookup] != null) {
                                    ++this.numFragments;
                                }
                                Manifest manifest = this.manifest[this.currentLookup] = (gfm.getRequest() & 2) != 0 ? fam.manifest : null;
                                if (this.manifest[this.currentLookup] != null) {
                                    ++this.numManifests;
                                }
                            } else {
                                if (GlacierImpl.this.logger.level <= 800) {
                                    GlacierImpl.this.logger.log("Fragment " + gfm.getKey(this.currentLookup) + " not found");
                                }
                                this.fragment[this.currentLookup] = null;
                                this.manifest[this.currentLookup] = null;
                            }
                            this.nextLookup();
                        }

                        public void nextLookup() {
                            ++this.currentLookup;
                            if (this.currentLookup >= gfm.getNumKeys()) {
                                this.returnResponse();
                            } else {
                                GlacierImpl.this.fragmentStorage.getObject(gfm.getKey(this.currentLookup), this);
                            }
                        }

                        public void receiveException(Exception e) {
                            if (GlacierImpl.this.logger.level <= 900) {
                                GlacierImpl.this.logger.logException("Exception while retrieving fragment " + gfm.getKey(this.currentLookup) + " (lookup #" + this.currentLookup + "), e=", e);
                            }
                            this.fragment[this.currentLookup] = null;
                            this.manifest[this.currentLookup] = null;
                            this.nextLookup();
                        }
                    });
                } else {
                    if (msg instanceof GlacierDataMessage) {
                        gdm = (GlacierDataMessage)msg;
                        for (int i5 = 0; i5 < gdm.numKeys(); ++i5) {
                            final FragmentKey thisKey = gdm.getKey(i5);
                            Fragment thisFragment = gdm.getFragment(i5);
                            final Manifest thisManifest = gdm.getManifest(i5);
                            if (thisFragment != null && thisManifest != null) {
                                if (this.logger.level <= 800) {
                                    this.logger.log("Data: Fragment+Manifest for " + thisKey);
                                }
                                if (!this.responsibleRange.containsId(this.getFragmentLocation(thisKey))) {
                                    if (this.logger.level > 900) continue;
                                    this.logger.log("Not responsible for " + thisKey + " (at " + this.getFragmentLocation(thisKey) + ") -- discarding");
                                    continue;
                                }
                                if (!this.policy.checkSignature(thisManifest, thisKey.getVersionKey())) {
                                    if (this.logger.level > 900) continue;
                                    this.logger.log("Manifest is not signed properly");
                                    continue;
                                }
                                if (!thisManifest.validatesFragment(thisFragment, thisKey.getFragmentID(), this.environment.getLogManager().getLogger(Manifest.class, this.instance))) {
                                    if (this.logger.level > 900) continue;
                                    this.logger.log("Manifest does not validate this fragment");
                                    continue;
                                }
                                if (!this.fragmentStorage.exists(thisKey)) {
                                    if (this.logger.level <= 500) {
                                        this.logger.log("Verified ok. Storing locally.");
                                    }
                                    FragmentAndManifest fam = new FragmentAndManifest(thisFragment, thisManifest);
                                    this.fragmentStorage.store(thisKey, new FragmentMetadata(thisManifest.getExpiration(), 0L, this.environment.getTimeSource().currentTimeMillis()), fam, new Continuation(){

                                        public void receiveResult(Object o) {
                                            if (GlacierImpl.this.logger.level <= 800) {
                                                GlacierImpl.this.logger.log("Stored OK, sending receipt: " + thisKey);
                                            }
                                            GlacierImpl.this.sendMessage(null, new GlacierResponseMessage(gdm.getUID(), thisKey, true, thisManifest.getExpiration(), GlacierImpl.this.responsibleRange.containsId(GlacierImpl.this.getFragmentLocation(thisKey)), GlacierImpl.this.getLocalNodeHandle(), gdm.getSource().getId(), true, gdm.getTag()), gdm.getSource());
                                        }

                                        public void receiveException(Exception e) {
                                            if (GlacierImpl.this.logger.level <= 900) {
                                                GlacierImpl.this.logger.log("receiveException(" + e + ") while storing a fragment -- unexpected, ignored (key=" + thisKey + ")");
                                            }
                                        }
                                    });
                                    continue;
                                }
                                if (this.logger.level > 900) continue;
                                this.logger.log("We already have a fragment with this key! -- discarding");
                                continue;
                            }
                            if (thisFragment == null && thisManifest != null) {
                                if (!this.responsibleRange.containsId(this.getFragmentLocation(thisKey))) {
                                    if (this.logger.level > 900) continue;
                                    this.logger.log("Not responsible for " + thisKey + " (at " + this.getFragmentLocation(thisKey) + ") -- discarding");
                                    continue;
                                }
                                if (this.fragmentStorage.exists(thisKey)) {
                                    final FragmentMetadata metadata = (FragmentMetadata)this.fragmentStorage.getMetadata(thisKey);
                                    if (metadata == null || metadata.getCurrentExpiration() < thisManifest.getExpiration()) {
                                        if (this.logger.level <= 800) {
                                            this.logger.log("Replacing old manifest for " + thisKey + " (expires " + (metadata == null ? "(broken)" : "" + metadata.getCurrentExpiration()) + ") by new one (expires " + thisManifest.getExpiration() + ")");
                                        }
                                        this.fragmentStorage.getObject(thisKey, new Continuation(){

                                            public void receiveResult(Object o) {
                                                if (o instanceof FragmentAndManifest) {
                                                    FragmentAndManifest fam = (FragmentAndManifest)o;
                                                    if (GlacierImpl.this.logger.level <= 500) {
                                                        GlacierImpl.this.logger.log("Got FAM for " + thisKey + ", now replacing old manifest with new one...");
                                                    }
                                                    String fault = null;
                                                    if (!thisManifest.validatesFragment(fam.fragment, thisKey.getFragmentID(), GlacierImpl.this.environment.getLogManager().getLogger(Manifest.class, GlacierImpl.this.instance))) {
                                                        fault = "Update: Manifest does not validate this fragment";
                                                    }
                                                    if (!GlacierImpl.this.policy.checkSignature(thisManifest, thisKey.getVersionKey())) {
                                                        fault = "Update: Manifest is not signed properly";
                                                    }
                                                    if (!Arrays.equals(thisManifest.getObjectHash(), fam.manifest.getObjectHash())) {
                                                        fault = "Update: Object hashes not equal";
                                                    }
                                                    for (int i = 0; i < GlacierImpl.this.numFragments; ++i) {
                                                        if (Arrays.equals(thisManifest.getFragmentHash(i), fam.manifest.getFragmentHash(i))) continue;
                                                        fault = "Update: Fragment hash #" + i + " does not match";
                                                    }
                                                    if (fault == null) {
                                                        fam.manifest = thisManifest;
                                                        GlacierImpl.this.fragmentStorage.store(thisKey, new FragmentMetadata(thisManifest.getExpiration(), metadata == null ? 0L : metadata.getCurrentExpiration(), GlacierImpl.this.environment.getTimeSource().currentTimeMillis()), fam, new Continuation(){

                                                            public void receiveResult(Object o) {
                                                                if (GlacierImpl.this.logger.level <= 500) {
                                                                    GlacierImpl.this.logger.log("Old manifest for " + thisKey + " replaced OK, sending receipt");
                                                                }
                                                                GlacierImpl.this.sendMessage(null, new GlacierResponseMessage(gdm.getUID(), thisKey, true, thisManifest.getExpiration(), true, GlacierImpl.this.getLocalNodeHandle(), gdm.getSource().getId(), true, gdm.getTag()), gdm.getSource());
                                                            }

                                                            public void receiveException(Exception e) {
                                                                if (GlacierImpl.this.logger.level <= 900) {
                                                                    GlacierImpl.this.logger.logException("Cannot store refreshed manifest: ", e);
                                                                }
                                                            }
                                                        });
                                                    } else if (GlacierImpl.this.logger.level <= 900) {
                                                        GlacierImpl.this.logger.log(fault);
                                                    }
                                                } else if (GlacierImpl.this.logger.level <= 900) {
                                                    GlacierImpl.this.logger.log("Fragment store returns something other than a FAM: " + o);
                                                }
                                            }

                                            public void receiveException(Exception e) {
                                                if (GlacierImpl.this.logger.level <= 900) {
                                                    GlacierImpl.this.logger.logException("Cannot retrieve FAM for " + thisKey + ": ", e);
                                                }
                                            }
                                        });
                                        continue;
                                    }
                                    if (this.logger.level > 900) continue;
                                    this.logger.log("We already have exp=" + (metadata == null ? "(broken)" : "" + metadata.getCurrentExpiration()) + ", discarding manifest for " + thisKey + " with exp=" + thisManifest.getExpiration());
                                    continue;
                                }
                                if (this.logger.level <= 800) {
                                    this.logger.log("Data: Manifest for: " + thisKey + ", must fetch");
                                }
                                final long tStart = this.environment.getTimeSource().currentTimeMillis();
                                this.rateLimitedRetrieveFragment(thisKey, thisManifest, '\u0004', new GlacierContinuation(){

                                    public long getTimeout() {
                                        return tStart + GlacierImpl.this.overallRestoreTimeout;
                                    }

                                    public String toString() {
                                        return "Fetch synced fragment: " + thisKey;
                                    }

                                    public void receiveResult(Object o) {
                                        if (o instanceof Fragment) {
                                            if (!GlacierImpl.this.fragmentStorage.exists(thisKey)) {
                                                if (GlacierImpl.this.logger.level <= 800) {
                                                    GlacierImpl.this.logger.log("Received fragment " + thisKey + " (from primary) matches existing manifest, storing...");
                                                }
                                                FragmentAndManifest fam = new FragmentAndManifest((Fragment)o, thisManifest);
                                                GlacierImpl.this.fragmentStorage.store(thisKey, new FragmentMetadata(thisManifest.getExpiration(), 0L, GlacierImpl.this.environment.getTimeSource().currentTimeMillis()), fam, new Continuation(){

                                                    public void receiveResult(Object o) {
                                                        if (GlacierImpl.this.logger.level <= 500) {
                                                            GlacierImpl.this.logger.log("Recovered fragment stored OK");
                                                        }
                                                    }

                                                    public void receiveException(Exception e) {
                                                        if (GlacierImpl.this.logger.level <= 900) {
                                                            GlacierImpl.this.logger.log("receiveException(" + e + ") while storing a fragment with existing manifest (key=" + thisKey + ")");
                                                        }
                                                    }
                                                });
                                            } else if (GlacierImpl.this.logger.level <= 900) {
                                                GlacierImpl.this.logger.log("Received fragment " + thisKey + ", but it already exists in the fragment store");
                                            }
                                        } else if (GlacierImpl.this.logger.level <= 900) {
                                            GlacierImpl.this.logger.log("FS received something other than a fragment: " + o);
                                        }
                                    }

                                    public void receiveException(Exception e) {
                                        if (e instanceof GlacierNotEnoughFragmentsException) {
                                            GlacierNotEnoughFragmentsException gnf = (GlacierNotEnoughFragmentsException)e;
                                            if (GlacierImpl.this.logger.level <= 800) {
                                                GlacierImpl.this.logger.log("Not enough fragments to reconstruct " + thisKey + ": " + gnf.checked + "/" + GlacierImpl.this.numFragments + " checked, " + gnf.found + " found, " + GlacierImpl.this.numSurvivors + " needed");
                                            }
                                        } else if (GlacierImpl.this.logger.level <= 900) {
                                            GlacierImpl.this.logger.logException("Exception while recovering synced fragment " + thisKey + ": ", e);
                                        }
                                        this.terminate();
                                    }

                                    public void timeoutExpired() {
                                        if (GlacierImpl.this.logger.level <= 900) {
                                            GlacierImpl.this.logger.log("Timeout while fetching synced fragment " + thisKey + " -- aborted");
                                        }
                                        this.terminate();
                                    }
                                });
                                continue;
                            }
                            if (this.logger.level > 900) continue;
                            this.logger.log("Case not implemented! -- GDM");
                        }
                        return;
                    }
                    if (msg instanceof GlacierTimeoutMessage) {
                        this.timerExpired();
                        return;
                    }
                    this.panic("GLACIER ERROR - Received message " + msg + " of unknown type.");
                }
            }
        }
    }

    public void emptyTrash(Continuation c) {
        if (this.trashStorage != null) {
            if (this.logger.level <= 800) {
                this.logger.log("Emptying trash (removing all objects)");
            }
            this.trashStorage.flush(c);
        } else {
            c.receiveResult(null);
        }
    }

    public void addStatisticsListener(GlacierStatisticsListener gsl) {
        this.listeners.add(gsl);
    }

    public void removeStatisticsListener(GlacierStatisticsListener gsl) {
        this.listeners.removeElement(gsl);
    }

    private static byte[] getDistance(double d) {
        byte[] result = new byte[20];
        double c = 0.5;
        for (int i = 19; i >= 0; --i) {
            result[i] = 0;
            for (int j = 7; j >= 0; --j) {
                if (d >= c) {
                    int n = i;
                    result[n] = (byte)(result[n] | 1 << j);
                    d -= c;
                }
                c /= 2.0;
            }
        }
        return result;
    }

    private static String dump(byte[] data, boolean linebreak) {
        String hex = "0123456789ABCDEF";
        String result = "";
        for (int i = 0; i < data.length; ++i) {
            int d = data[i];
            if (d < 0) {
                d += 256;
            }
            int hi = d >> 4;
            int lo = d & 0xF;
            result = result + "0123456789ABCDEF".charAt(hi) + "0123456789ABCDEF".charAt(lo);
            if (linebreak && (i % 16 == 15 || i == data.length - 1)) {
                result = result + "\n";
                continue;
            }
            if (i == data.length - 1) continue;
            result = result + " ";
        }
        return result;
    }
}

