/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation.raw;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import rice.p2p.aggregation.Aggregate;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.gc.GCPastContent;
import rice.p2p.past.gc.rawserialization.JavaSerializedGCPastContent;
import rice.p2p.past.gc.rawserialization.RawGCPastContent;
import rice.p2p.past.rawserialization.PastContentDeserializer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

public class RawAggregate
extends Aggregate
implements RawGCPastContent {
    private RawGCPastContent[] rawComponents;
    private static final long serialVersionUID = -4891386773008082L;
    public static final short TYPE = 1;

    public RawAggregate(GCPastContent[] components, Id[] pointers) {
        super(components, pointers);
        this.buildRawComponents(components);
        this.myId = null;
        this.pointers = pointers;
    }

    public RawAggregate(RawGCPastContent[] components, Id[] pointers) {
        super(components, pointers);
        this.rawComponents = components;
        this.myId = null;
        this.pointers = pointers;
    }

    public RawAggregate(InputBuffer buf, Endpoint endpoint, PastContentDeserializer contentDeserializer) throws IOException {
        super(null, null);
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                int i;
                this.myId = endpoint.readId(buf, buf.readShort());
                this.pointers = new Id[buf.readShort()];
                for (i = 0; i < this.pointers.length; ++i) {
                    this.pointers[i] = endpoint.readId(buf, buf.readShort());
                }
                this.rawComponents = new RawGCPastContent[buf.readShort()];
                this.components = new GCPastContent[this.rawComponents.length];
                for (i = 0; i < this.rawComponents.length; ++i) {
                    short type = buf.readShort();
                    GCPastContent temp = (GCPastContent)contentDeserializer.deserializePastContent(buf, endpoint, type);
                    if (type == 0) {
                        this.components[i] = temp;
                        this.rawComponents[i] = new JavaSerializedGCPastContent(temp);
                        continue;
                    }
                    this.components[i] = temp;
                    this.rawComponents[i] = (RawGCPastContent)temp;
                }
                break;
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }

    public byte[] getContentHash() {
        byte[] bytes = null;
        int numBytes = 0;
        try {
            SimpleOutputBuffer buf = new SimpleOutputBuffer();
            this.serializeHelper(buf);
            bytes = buf.getBytes();
            numBytes = buf.getWritten();
        }
        catch (IOException ioe) {
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.reset();
        md.update(bytes, 0, numBytes);
        return md.digest();
    }

    public short getType() {
        return 1;
    }

    public int numComponents() {
        return this.rawComponents.length;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        buf.writeShort(this.myId.getType());
        this.myId.serialize(buf);
        this.serializeHelper(buf);
    }

    private void serializeHelper(OutputBuffer buf) throws IOException {
        int i;
        buf.writeShort((short)this.pointers.length);
        for (i = 0; i < this.pointers.length; ++i) {
            buf.writeShort(this.pointers[i].getType());
            this.pointers[i].serialize(buf);
        }
        buf.writeShort((short)this.rawComponents.length);
        for (i = 0; i < this.rawComponents.length; ++i) {
            buf.writeShort(this.rawComponents[i].getType());
            this.rawComponents[i].serialize(buf);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.buildRawComponents(this.components);
    }

    private void buildRawComponents(GCPastContent[] components) {
        this.rawComponents = new RawGCPastContent[components.length];
        for (int i = 0; i < this.rawComponents.length; ++i) {
            this.rawComponents[i] = this.rawComponents[i] instanceof RawGCPastContent ? (RawGCPastContent)components[i] : new JavaSerializedGCPastContent(components[i]);
        }
    }
}

