/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation;

import java.util.Arrays;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.glacier.VersioningPast;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.gc.GCPast;
import rice.p2p.past.rawserialization.PastContentDeserializer;
import rice.p2p.past.rawserialization.PastContentHandleDeserializer;

public class Moraine
implements GCPast,
VersioningPast {
    protected GCPast newPast;
    protected GCPast oldPast;
    protected VersioningPast vNewPast;
    protected VersioningPast vOldPast;
    protected Logger logger;

    public Moraine(GCPast newPast, GCPast oldPast) {
        this.newPast = newPast;
        this.oldPast = oldPast;
        this.vNewPast = (VersioningPast)((Object)newPast);
        this.vOldPast = (VersioningPast)((Object)oldPast);
        this.logger = newPast.getEnvironment().getLogManager().getLogger(Moraine.class, newPast.getInstance());
    }

    public NodeHandle getLocalNodeHandle() {
        return this.newPast.getLocalNodeHandle();
    }

    public int getReplicationFactor() {
        return this.newPast.getReplicationFactor();
    }

    public Environment getEnvironment() {
        return this.newPast.getEnvironment();
    }

    public String getInstance() {
        return this.newPast.getInstance();
    }

    public void setContentDeserializer(PastContentDeserializer deserializer) {
        this.newPast.setContentDeserializer(deserializer);
        this.oldPast.setContentDeserializer(deserializer);
    }

    public void setContentHandleDeserializer(PastContentHandleDeserializer deserializer) {
        this.newPast.setContentHandleDeserializer(deserializer);
        this.oldPast.setContentHandleDeserializer(deserializer);
    }

    public void insert(PastContent obj, Continuation command) {
        this.newPast.insert(obj, command);
    }

    public void lookup(Id id, Continuation command) {
        this.lookup(id, true, command);
    }

    public void lookup(final Id id, final boolean cache, final Continuation command) {
        this.newPast.lookup(id, cache, new Continuation(){

            public void receiveResult(Object result) {
                if (result == null) {
                    Moraine.this.oldPast.lookup(id, cache, new Continuation(){

                        public void receiveResult(Object result) {
                            command.receiveResult(result);
                        }

                        public void receiveException(Exception result) {
                            command.receiveException(result);
                        }
                    });
                } else {
                    command.receiveResult(result);
                }
            }

            public void receiveException(Exception result) {
                command.receiveException(result);
            }
        });
    }

    public void lookupHandles(final Id id, final int max, final Continuation command) {
        this.newPast.lookupHandles(id, max, new Continuation(){

            public void receiveResult(Object result) {
                Object[] results = (Object[])result;
                if (results.length == 1 && results[0] == null) {
                    Moraine.this.oldPast.lookupHandles(id, max, command);
                } else {
                    command.receiveResult(result);
                }
            }

            public void receiveException(Exception result) {
                if (Moraine.this.logger.level <= 900) {
                    Moraine.this.logger.logException("in Moraine.lookupHandles, newPast threw up: ", result);
                }
                Moraine.this.oldPast.lookupHandles(id, max, command);
            }
        });
    }

    public void lookupHandle(Id id, NodeHandle handle, Continuation command) {
        command.receiveException(new UnsupportedOperationException("LookupHandle() is not supported on Moraine"));
    }

    public void fetch(final PastContentHandle handle, final Continuation command) {
        this.newPast.fetch(handle, new Continuation(){

            public void receiveResult(Object result) {
                if (result == null) {
                    Moraine.this.oldPast.fetch(handle, command);
                } else {
                    command.receiveResult(result);
                }
            }

            public void receiveException(Exception result) {
                command.receiveException(result);
            }
        });
    }

    public void insert(PastContent obj, long expiration, Continuation command) {
        this.newPast.insert(obj, expiration, command);
    }

    public void refresh(final Id[] ids, final long[] expirations, final Continuation command) {
        this.oldPast.refresh(ids, expirations, new Continuation(){

            public void receiveResult(Object result) {
                Moraine.this.newPast.refresh(ids, expirations, command);
            }

            public void receiveException(Exception result) {
                if (Moraine.this.logger.level <= 900) {
                    Moraine.this.logger.logException("in Moraine.refresh, oldPast threw up: ", result);
                }
                this.receiveResult(null);
            }
        });
    }

    public void refresh(Id[] ids, long expiration, Continuation command) {
        long[] expirations = new long[ids.length];
        Arrays.fill(expirations, expiration);
        this.refresh(ids, expirations, command);
    }

    public void lookup(final Id id, final long version, final Continuation command) {
        this.vNewPast.lookup(id, version, new Continuation(){

            public void receiveResult(Object result) {
                if (result == null) {
                    Moraine.this.vOldPast.lookup(id, version, new Continuation(){

                        public void receiveResult(Object result) {
                            command.receiveResult(result);
                        }

                        public void receiveException(Exception result) {
                            command.receiveException(result);
                        }
                    });
                } else {
                    command.receiveResult(result);
                }
            }

            public void receiveException(Exception result) {
                command.receiveException(result);
            }
        });
    }

    public void lookupHandles(final Id id, final long version, final int num, final Continuation command) {
        this.vNewPast.lookupHandles(id, version, num, new Continuation(){

            public void receiveResult(Object result) {
                Object[] results = (Object[])result;
                if (results.length == 1 && results[0] == null) {
                    Moraine.this.vOldPast.lookupHandles(id, version, num, command);
                } else {
                    command.receiveResult(result);
                }
            }

            public void receiveException(Exception result) {
                if (Moraine.this.logger.level <= 900) {
                    Moraine.this.logger.logException("in Moraine.lookupHandles, newPast threw up: ", result);
                }
                Moraine.this.vOldPast.lookupHandles(id, version, num, command);
            }
        });
    }

    public void refresh(final Id[] ids, final long[] versions, final long[] expirations, final Continuation command) {
        this.vOldPast.refresh(ids, versions, expirations, new Continuation(){

            public void receiveResult(Object result) {
                Moraine.this.vNewPast.refresh(ids, versions, expirations, command);
            }

            public void receiveException(Exception result) {
                if (Moraine.this.logger.level <= 900) {
                    Moraine.this.logger.logException("in Moraine.refresh, oldPast threw up: ", result);
                }
                this.receiveResult(null);
            }
        });
    }
}

