/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.time.simulated;

import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.time.TimeSource;
import rice.selector.SelectorManager;
import rice.selector.TimerTask;

public class DirectTimeSource
implements TimeSource {
    private long time = 0L;
    private Logger logger = null;
    private String instance;
    private SelectorManager selectorManager;

    public DirectTimeSource(long time) {
        this(time, null);
    }

    public DirectTimeSource(long time, String instance) {
        if (time < 0L) {
            time = System.currentTimeMillis();
        } else {
            this.time = time;
        }
        this.instance = instance;
    }

    public DirectTimeSource(Parameters p) {
        this(p.getLong("direct_simulator_start_time"));
    }

    public void setLogManager(LogManager manager) {
        this.logger = manager.getLogger(DirectTimeSource.class, this.instance);
    }

    public void setSelectorManager(SelectorManager sm) {
        this.selectorManager = sm;
    }

    public synchronized void setTime(long newTime) {
        if (newTime < this.time) {
            throw new RuntimeException("Attempted to set time from " + this.time + " to " + newTime + ".");
        }
        if (this.logger.level <= 400) {
            this.logger.log("DirectTimeSource.setTime(" + this.time + "=>" + newTime + ")");
        }
        this.time = newTime;
    }

    public long currentTimeMillis() {
        return this.time;
    }

    public void incrementTime(int millis) {
        this.setTime(this.time + (long)millis);
    }

    public synchronized void sleep(long delay) throws InterruptedException {
        BlockingTimerTask btt = new BlockingTimerTask();
        if (this.logger.level <= 500) {
            this.logger.log("DirectTimeSource.sleep(" + delay + ")");
        }
        this.selectorManager.getTimer().schedule(btt, delay);
        while (!btt.done) {
            this.wait();
        }
    }

    private class BlockingTimerTask
    extends TimerTask {
        boolean done = false;

        private BlockingTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DirectTimeSource directTimeSource = DirectTimeSource.this;
            synchronized (directTimeSource) {
                this.done = true;
                DirectTimeSource.this.notifyAll();
                Thread.yield();
            }
        }
    }
}

